note

	description:

		"ECF external libraries"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2008, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2012-08-22 12:54:13 -0700 (Wed, 22 Aug 2012) $"
	revision: "$Revision: 89387 $"

class ET_ECF_EXTERNAL_LIBRARY

inherit

	ET_ECF_CONDITIONED

create

	make

feature {NONE} -- Initialization

	make (a_pathname: like pathname)
			-- Create a new external library.
		require
			a_pathname_not_void: a_pathname /= Void
		do
			pathname := a_pathname
		ensure
			pathname_set: pathname = a_pathname
		end

feature -- Access

	pathname: STRING
			-- Pathname

feature -- Element change

	fill_external_libraries (a_system: ET_SYSTEM; a_state: ET_ECF_STATE)
			-- Add to `a_system' the current external library pathname
			-- of conditions satisfy `a_state'.
		require
			a_system_not_void: a_system /= Void
			a_state_not_void: a_state /= Void
		do
			if is_enabled (a_state) then
				a_system.external_library_pathnames.force_last (pathname)
			end
		end

invariant

	pathname_not_void: pathname /= Void

end
