note
	description:
		"[
			EiffelVision toolbar. Can only contain tool bar items.
		]"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2008-12-29 12:27:11 -0800 (Mon, 29 Dec 2008) $"
	revision: "$Revision: 76420 $"

class
	EV_TOOL_BAR

inherit
	EV_PRIMITIVE
		undefine
			is_equal
		redefine
			implementation,
			is_in_default_state,
			is_in_default_state_for_tabs
		end

	EV_DOCKABLE_TARGET
		undefine
			is_equal,
			is_in_default_state
		redefine
			implementation,
			is_in_default_state
		end

	EV_ITEM_LIST [EV_TOOL_BAR_ITEM]
		redefine
			is_in_default_state,
			implementation
		end

create
	default_create

feature {NONE} -- Implementation

	create_implementation
			-- Create implementation of `Current'.
		do
			create {EV_TOOL_BAR_IMP} implementation.make (Current)
		end

feature -- Status report

	has_vertical_button_style: BOOLEAN
			-- Is the `pixmap' displayed vertically above `text' for
			-- all buttons contained in `Current'? If `False', then
			-- the `pixmap' is displayed to left of `text'.
		require
			not_destroyed: not is_destroyed
		do
			Result := implementation.has_vertical_button_style
		ensure
			bridge_ok: equal (Result, implementation.has_vertical_button_style)
		end

	is_vertical: BOOLEAN
			-- Are items in toolbar vertical orientated?
		require
			not_destroyed: not is_destroyed
		do
			Result := implementation.is_vertical
		end

feature -- Status setting

	enable_vertical_button_style
			-- Ensure `has_vertical_button_style' is `True'.
		require
			not_destroyed: not is_destroyed
		do
			implementation.enable_vertical_button_style
		ensure
			vertical_button_style_assigned: has_vertical_button_style
		end

	disable_vertical_button_style
			-- Ensure `has_vertical_button_style' is `False'.
		require
			not_destroyed: not is_destroyed
		do
			implementation.disable_vertical_button_style
		ensure
			vertical_button_style_not_assigned: not has_vertical_button_style
		end

	enable_vertical
			-- Ensure `is_vertical' is `True'.
		require
			not_destroyed: not is_destroyed
		do
			implementation.enable_vertical
		ensure
			is_vertical_assigned: is_vertical
		end

	disable_vertical
			-- Ensure `is_vertical' is `False'.
		require
			not_destroyed: not is_destroyed
		do
			implementation.disable_vertical
		ensure
			is_vertical_not_assigned: not is_vertical
		end

feature {NONE} -- Contract support

	is_in_default_state: BOOLEAN
			-- Is `Current' in its default state?
		do
			Result := Precursor {EV_PRIMITIVE} and Precursor {EV_ITEM_LIST} and has_vertical_button_style
		end

	is_in_default_state_for_tabs: BOOLEAN
		do
			Result := not is_tabable_from and not is_tabable_to
		end

feature -- Constract support

	is_parent_recursive (a_tool_bar_item: EV_TOOL_BAR_ITEM): BOOLEAN
			-- Is `a_tool_bar_item' a parent of `Current'?
		do
				-- As we cannot insert an EV_TOOL_BAR into an EV_TOOL_BAR_ITEM,
				-- it cannot be True.
			Result := False
		end

feature {EV_ANY, EV_ANY_I} -- Implementation

	implementation: EV_TOOL_BAR_I;
			-- Platform dependent access.

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class EV_TOOL_BAR

