note

	description: "Description of a top"
	legal: "See notice at end of class.";
	status: "See notice at end of class.";
	date: "$Date: 2008-12-29 12:27:11 -0800 (Mon, 29 Dec 2008) $";
	revision: "$Revision: 76420 $"

deferred class

	TOP_I 

inherit

	SHELL_I

feature -- Access

	icon_name: STRING
			-- Short form of application name to be displayed
			-- by the window manager when application is iconified
		deferred
		end;

feature -- Status report

	is_iconic_state: BOOLEAN
			-- Does application start in iconic state?
		deferred
		end

	is_maximized_state: BOOLEAN
			-- Does application start in maximized state?
		deferred
		end

feature -- Status setting

	set_iconic_state
			-- Set start state of the application to be iconic.
		deferred
		end;

	set_normal_state
			-- Set start state of the application to be normal.
		deferred
		end;

	set_maximized_state
			-- Set start state of the application to be maximized.
		deferred
		end;

feature -- Element change

	set_icon_name (a_name: STRING)
			-- Set `icon_name' to `a_name'.
		require
			not_a_name_void: a_name /= Void
		deferred
		end;

feature {NONE} -- Implementation

	oui_top: TOP;
			-- Keep track of the oui widget
			-- Useful when calling 'delete_window_action'

	delete_window_action
			-- Called when base window has been destroyed
		do
			oui_top.delete_window_action
		end;

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class TOP_I

