note
	description: "Define Variable of type INTEGER"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	author: "$Author: manus $"
	date: "$Date: 2008-12-29 12:27:11 -0800 (Mon, 29 Dec 2008) $"
	revision: "$Revision: 76420 $"
	history: "$History: oci_define_integer.e $"

class
	OCI_DEFINE_INTEGER

inherit
	OCI_DEFINE
	
	PLATFORM
		undefine
			is_equal
		end

create
	make

feature {NONE} -- Initialization

	make
		do
			make_variable (Sqlt_int, Integer_bytes)
		end

feature -- Access

	value: INTEGER_REF
			-- Current value of define variable
		local
			integer_value: INTEGER
		do
			($integer_value).memory_copy (buffer, Integer_bytes)
			create Result
			Result.set_item (integer_value)
		end
	
	valid_data_type_and_size (type: INTEGER_16; size: INTEGER): BOOLEAN
			-- Are `type' and `size' valid values for `data_type' and `data_size' ?
		do
			Result := type = Sqlt_int and size = Integer_bytes
		end
	
note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class OCI_DEFINE_INTEGER
