/*
 * Code for class PATH
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pa2605.h"
#include "eif_built_in.h"
#include "eif_eiffel.h"
#include "eif_path_name.h"
#include <ctype.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F3496_44071
static int inline_F3496_44071 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	EIF_BOOLEAN Result = EIF_FALSE;
#ifdef EIF_WINDOWS
		/* To check this, we use `CreateFileW' to open both file, and then using the information
		 * returned by `GetFileInformationByHandle' we can check whether or not they are indeed
		 * the same.
		 * Note: it is important to use the W version of CreateFileW because arguments
		 * are Unicode, not ASCII. */
	BY_HANDLE_FILE_INFORMATION l_path1_info, l_path2_info;
	HANDLE l_path2_file = CreateFileW ((LPCWSTR) arg2, GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	HANDLE l_path1_file = CreateFileW ((LPCWSTR) arg1, GENERIC_READ, FILE_SHARE_READ, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if ((l_path2_file == INVALID_HANDLE_VALUE) || (l_path1_file == INVALID_HANDLE_VALUE)) {
			/* We do not need the handles anymore, simply close them. Since Microsoft
			 * API accepts INVALID_HANDLE_VALUE we don't check the validity of arguments. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
	} else {
		BOOL success = GetFileInformationByHandle (l_path2_file, &l_path2_info);
		success = success && GetFileInformationByHandle (l_path1_file, &l_path1_info);
			/* We do not need the handles anymore, simply close them. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
		if (success) {
				/* Check that `path2' and `path1' do not represent the same file. */
			if
				((l_path2_info.dwVolumeSerialNumber == l_path1_info.dwVolumeSerialNumber) &&
				(l_path2_info.nFileIndexLow == l_path1_info.nFileIndexLow) &&
				(l_path2_info.nFileIndexHigh == l_path1_info.nFileIndexHigh))
			{
				Result = EIF_TRUE;
			}
		}
	}
#else
	struct stat buf1, buf2;
	int status;
	#ifdef HAS_LSTAT
		status = lstat(arg1, &buf1);
		if (status == 0) {
				/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
			 	 * to ensure the validity of the link. */
			if ((buf1.st_mode & S_IFLNK) == S_IFLNK) {
				status = stat (arg1, &buf1);
			}
		}
		
		if (status == 0) {
			status = lstat(arg2, &buf2);
			if (status == 0) {
					/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
				 	 * to ensure the validity of the link. */
				if ((buf2.st_mode & S_IFLNK) == S_IFLNK) {
					status = stat (arg2, &buf2);
				}
			}
		}
	#else
		status = stat (arg1, &buf1);
		if (status == 0) {
			status = stat (arg2, &buf2);
		}
	#endif
	if (status == 0) {
			/* Both files are present, check they represent the same one. */
		if ((buf1.st_dev == buf2.st_dev) && (buf1.st_ino == buf2.st_ino)) {
			Result = EIF_TRUE;
		}
	}
#endif
return Result;
	;
}
#define INLINE_F3496_44071
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PATH}.make_empty */
void F3496_44010 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("make_empty", 3495, Current, 0, 0, 44707);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_non_attached_type(3701));
	F3693_46679(RTCV(tr1));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(3);
	F3496_44057(Current);
	RTHOOK(4);
	RTLE;
	RTEE;
}

/* {PATH}.make_current */
void F3496_44011 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("make_current", 3495, Current, 0, 0, 44708);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_non_attached_type(3701));
	ti4_1 = F3496_44056(Current);
	F3697_46844(RTCV(tr1), ti4_1);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	tr1 = *(EIF_REFERENCE *)(Current);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R38206[Dtype(tr1)-3701])(RTCV(tr1), (EIF_CHARACTER_8) '.');
	RTHOOK(3);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(Current);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R38206[Dtype(tr1)-3701])(RTCV(tr1), (EIF_CHARACTER_8) '\000');
	}
	RTHOOK(5);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(6);
	F3496_44057(Current);
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_string */
void F3496_44012 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	
	RTEAA("make_from_string", 3495, Current, 0, 1, 44709);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_non_attached_type(3701));
	ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R37945[Dtype(arg1)-3694])(RTCV(arg1));
	ti4_2 = F3496_44056(Current);
	F3697_46844(RTCV(tr1), (EIF_INTEGER_32) (ti4_1 * ti4_2));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R37925[Dtype(arg1)-3695])(RTCV(arg1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(Current);
		F3496_44065(Current, tr1, arg1, (EIF_CHARACTER_8) '\000');
		RTHOOK(4);
		F3496_44058(Current);
	} else {
		RTHOOK(5);
		*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	}
	RTHOOK(6);
	F3496_44057(Current);
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_storage */
void F3496_44014 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	
	RTEAA("make_from_storage", 3495, Current, 0, 1, 44711);
	RTGC;
	RTHOOK(1);
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	RTHOOK(2);
	F3496_44058(Current);
	RTHOOK(3);
	F3496_44057(Current);
	RTHOOK(4);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_normalized_storage */
void F3496_44015 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	
	RTEAA("make_from_normalized_storage", 3495, Current, 0, 1, 44712);
	RTGC;
	RTHOOK(1);
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	RTHOOK(2);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(3);
	F3496_44057(Current);
	RTHOOK(4);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_pointer */
void F3496_44016 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,loc1);
	RTLR(2,tr1);
	
	RTEAA("make_from_pointer", 3495, Current, 2, 1, 44713);
	RTGC;
	RTHOOK(1);
	loc2 = F2277_25535(Current, arg1);
	RTHOOK(2);
	loc2 -= (EIF_INTEGER_32) (loc2 % F3496_44056(Current));
	RTHOOK(3);
	tr1 = RTLNS(2423, 2423, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F2424_26982(RTCV(tr1), arg1, loc2);
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(4);
	tr1 = F2424_26989(RTCV(loc1), ((EIF_INTEGER_32) 1L), loc2);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(5);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F1354_17936(RTCV(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(6);
		F3496_44058(Current);
	}
	RTHOOK(7);
	F3496_44057(Current);
	RTHOOK(8);
	RTLE;
	RTEE;
}

/* {PATH}.is_current_symbol */
EIF_BOOLEAN F3496_44017 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("is_current_symbol", 3495, Current, 0, 0, 44714);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
	if ((EIF_BOOLEAN)(ti4_1 == F3496_44056(Current))) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_BOOLEAN) F3496_44068(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_parent_symbol */
EIF_BOOLEAN F3496_44018 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("is_parent_symbol", 3495, Current, 0, 0, 44715);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
	if ((EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (((EIF_INTEGER_32) 2L) * F3496_44056(Current)))) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = F3496_44068(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = F3496_44056(Current);
		Result = F3496_44068(Current, tr1, (EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) + ti4_1), (EIF_CHARACTER_8) '.');
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_empty */
EIF_BOOLEAN F3496_44020 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("is_empty", 3495, Current, 0, 0, 44717);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	Result = F1354_17936(RTCV(tr1));
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_relative */
EIF_BOOLEAN F3496_44021 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("is_relative", 3495, Current, 0, 0, 44718);
	RTGC;
	RTHOOK(1);
	Result = F3496_44022(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN) !Result;
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_absolute */
EIF_BOOLEAN F3496_44022 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("is_absolute", 3495, Current, 1, 0, 44719);
	RTGC;
	RTHOOK(1);
	loc1 = F3496_44062(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN) (loc1 > ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			RTHOOK(4);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F3496_44056(Current);
			tc1 = F3496_44038(Current);
			Result = F3496_44068(Current, tr1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ti4_1) + ((EIF_INTEGER_32) 1L)), tc1);
		} else {
			RTHOOK(5);
			RTHOOK(6);
			RTLE;
			RTEE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		}
	}
	RTHOOK(7);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_same_file_as */
EIF_BOOLEAN F3496_44024 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,loc2);
	RTLR(3,arg1);
	
	RTEAA("is_same_file_as", 3495, Current, 2, 1, 44721);
	RTGC;
	RTHOOK(1);
	loc1 = F3496_44053(Current);
	RTHOOK(2);
	loc2 = F3496_44053(RTCV(arg1));
	RTHOOK(3);
	tp1 = *(EIF_POINTER *)(RTCV(loc1)+ _PTROFF_0_1_0_1_0_0_);
	tp2 = *(EIF_POINTER *)(RTCV(loc2)+ _PTROFF_0_1_0_1_0_0_);
	Result = EIF_TEST (inline_F3496_44071(tp1, tp2));
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.has_extension */
EIF_BOOLEAN F3496_44025 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	
	RTEAA("has_extension", 3495, Current, 1, 1, 44722);
	RTGC;
	RTHOOK(1);
	Result = '\0';
	tr1 = F3496_44029(Current);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		tb1 = F3693_46719(RTCV(loc1), arg1);
		Result = tb1;
	}
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.root */
EIF_REFERENCE F3496_44026 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	
	RTEAA("root", 3495, Current, 1, 0, 44723);
	RTGC;
	RTHOOK(1);
	loc1 = F3496_44062(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN)(loc1 != ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			RTHOOK(4);
			tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F3496_44015(RTCV(tr1), *(EIF_REFERENCE *)(Current));
			RTHOOK(5);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) tr1;
		} else {
			RTHOOK(6);
			tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R37986[Dtype(tr2)-3695])(RTCV(tr2), ((EIF_INTEGER_32) 1L), loc1);
			F3496_44015(RTCV(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		}
	}
	RTHOOK(7);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.parent */
EIF_REFERENCE F3496_44027 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,loc3);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,Result);
	
	RTEAA("parent", 3495, Current, 3, 0, 44724);
	RTGC;
	RTHOOK(1);
	loc1 = F3496_44063(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		tr1 = F3496_44026(Current);
		loc3 = tr1;
		if (EIF_TEST(loc3)) {
			RTHOOK(4);
			RTHOOK(5);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) loc3;
		} else {
			RTHOOK(6);
			tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F3496_44011(RTCV(tr1));
			RTHOOK(7);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) tr1;
		}
	} else {
		RTHOOK(8);
		if ((EIF_BOOLEAN)(loc1 == F3496_44056(Current))) {
			RTHOOK(9);
			tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F3496_44056(Current);
			tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R37986[Dtype(tr2)-3695])(RTCV(tr2), ((EIF_INTEGER_32) 1L), ti4_1);
			F3496_44015(RTCV(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		} else {
			RTHOOK(10);
			loc2 = F3496_44062(Current);
			RTHOOK(11);
			if ((EIF_BOOLEAN) (loc1 <= loc2)) {
				RTHOOK(12);
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
				if ((EIF_BOOLEAN)(loc2 == ti4_1)) {
					RTHOOK(13);
					RTHOOK(14);
					RTLE;
					RTEE;
					return (EIF_REFERENCE) Current;
				} else {
					RTHOOK(15);
					tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
					tr2 = *(EIF_REFERENCE *)(Current);
					tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R37986[Dtype(tr2)-3695])(RTCV(tr2), ((EIF_INTEGER_32) 1L), loc2);
					F3496_44015(RTCV(tr1), tr2);
					Result = (EIF_REFERENCE) tr1;
				}
			} else {
				RTHOOK(16);
				tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = F3496_44056(Current);
				tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R37986[Dtype(tr2)-3695])(RTCV(tr2), ((EIF_INTEGER_32) 1L), (EIF_INTEGER_32) (loc1 - ti4_1));
				F3496_44015(RTCV(tr1), tr2);
				Result = (EIF_REFERENCE) tr1;
			}
		}
	}
	RTHOOK(17);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.entry */
EIF_REFERENCE F3496_44028 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,tr3);
	RTLR(4,Result);
	
	RTEAA("entry", 3495, Current, 2, 0, 44725);
	RTGC;
	RTHOOK(1);
	loc1 = F3496_44063(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		loc2 = F3496_44062(Current);
		RTHOOK(4);
		if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
			RTHOOK(5);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				RTHOOK(6);
				tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr2 = *(EIF_REFERENCE *)(Current);
				tr3 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr3) + O38065[Dtype(tr3)-3696]);
				tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R37986[Dtype(tr2)-3695])(RTCV(tr2), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F3496_44015(RTCV(tr1), tr2);
				Result = (EIF_REFERENCE) tr1;
			}
		} else {
			RTHOOK(7);
			Result = (EIF_REFERENCE) Current;
		}
	} else {
		RTHOOK(8);
		loc2 = F3496_44062(Current);
		RTHOOK(9);
		if ((EIF_BOOLEAN) (loc1 <= loc2)) {
			RTHOOK(10);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				RTHOOK(11);
				tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr2 = *(EIF_REFERENCE *)(Current);
				tr3 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr3) + O38065[Dtype(tr3)-3696]);
				tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R37986[Dtype(tr2)-3695])(RTCV(tr2), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F3496_44015(RTCV(tr1), tr2);
				Result = (EIF_REFERENCE) tr1;
			}
		} else {
			RTHOOK(12);
			tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			tr3 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr3) + O38065[Dtype(tr3)-3696]);
			tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R37986[Dtype(tr2)-3695])(RTCV(tr2), (EIF_INTEGER_32) (loc1 + ((EIF_INTEGER_32) 1L)), ti4_1);
			F3496_44015(RTCV(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		}
	}
	RTHOOK(13);
	tb1 = '\0';
	if ((EIF_BOOLEAN)(Result != NULL)) {
		tb2 = '\01';
		tb3 = '\01';
		tb4 = F3496_44020(RTCV(Result));
		if (!tb4) {
			tb4 = F3496_44017(RTCV(Result));
			tb3 = tb4;
		}
		if (!tb3) {
			tb3 = F3496_44018(RTCV(Result));
			tb2 = tb3;
		}
		tb1 = tb2;
	}
	if (tb1) {
		RTHOOK(14);
		RTHOOK(15);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) NULL;
	}
	RTHOOK(16);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.extension */
EIF_REFERENCE F3496_44029 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_CHARACTER_32 tw1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc4);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	
	RTEAA("extension", 3495, Current, 4, 0, 44726);
	RTGC;
	RTHOOK(1);
	tr1 = F3496_44028(Current);
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		RTHOOK(2);
		loc1 = F3496_44051(RTCV(loc4));
		RTHOOK(3);
		loc3 = *(EIF_INTEGER_32 *)(RTCV(loc1)+ _LNGOFF_1_0_0_2_);
		RTHOOK(4);
		tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '.';
		loc2 = F3695_46785(RTCV(loc1), tw1, loc3);
		RTHOOK(5);
		if ((EIF_BOOLEAN) ((EIF_BOOLEAN)(loc2 != ((EIF_INTEGER_32) 0L)) && (EIF_BOOLEAN)(loc2 != loc3))) {
			RTHOOK(6);
			tr1 = F3696_46837(RTCV(loc1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), loc3);
			RTHOOK(7);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) tr1;
		}
	}
	RTHOOK(8);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) 0;
}

/* {PATH}.components */
EIF_REFERENCE F3496_44030 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc1);
	RTLR(4,tr2);
	
	RTEAA("components", 3495, Current, 3, 0, 44727);
	RTGC;
	RTHOOK(1);
	{
		static EIF_TYPE_INDEX typarr0[] = {3495,2340,3495,0xFFFF};
		EIF_TYPE_INDEX typres0;
		static EIF_TYPE_INDEX typcache0 = INVALID_DTYPE;
		
		typres0 = (typcache0 != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), 2340, typarr0)));
		tr1 = RTLNS(typres0, 2340, _OBJSIZ_1_1_0_1_0_0_0_0_);
	}
	F2341_26136(RTCV(tr1), ((EIF_INTEGER_32) 10L));
	Result = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	loc3 = F3496_44062(Current);
	RTHOOK(3);
	if ((EIF_BOOLEAN) (loc3 > ((EIF_INTEGER_32) 0L))) {
		RTHOOK(4);
		tr1 = RTLNS(3701, 3701, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F3697_46844(RTCV(tr1), loc3);
		loc1 = (EIF_REFERENCE) tr1;
		RTHOOK(5);
		tr1 = *(EIF_REFERENCE *)(Current);
		F3702_47091(RTCV(loc1), tr1, ((EIF_INTEGER_32) 1L), loc3);
		RTHOOK(6);
		tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F3496_44015(RTCV(tr1), loc1);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16643[Dtype(Result)-1510])(RTCV(Result), tr1);
		RTHOOK(7);
		loc3++;
	} else {
		RTHOOK(8);
		loc3 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}
	RTHOOK(9);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
	if ((EIF_BOOLEAN) (loc3 <= ti4_1)) {
		RTHOOK(10);
		loc2 = (EIF_INTEGER_32) loc3;
		RTHOOK(11);
		loc3 = F3496_44064(Current, loc2);
		for (;;) {
			RTHOOK(12);
			if ((EIF_BOOLEAN)(loc3 == ((EIF_INTEGER_32) 0L))) break;
			RTHOOK(13);
			tr1 = RTLNS(3701, 3701, _OBJSIZ_1_1_0_3_0_0_0_0_);
			F3697_46844(RTCV(tr1), (EIF_INTEGER_32) (loc3 - loc2));
			loc1 = (EIF_REFERENCE) tr1;
			RTHOOK(14);
			tr1 = *(EIF_REFERENCE *)(Current);
			F3702_47091(RTCV(loc1), tr1, loc2, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
			RTHOOK(15);
			tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F3496_44015(RTCV(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16643[Dtype(Result)-1510])(RTCV(Result), tr1);
			RTHOOK(16);
			loc2 = F3496_44056(Current);
			loc2 = (EIF_INTEGER_32) (EIF_INTEGER_32) (loc3 + loc2);
			RTHOOK(17);
			loc3 = F3496_44064(Current, loc2);
		}
		RTHOOK(18);
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
		if ((EIF_BOOLEAN) (loc2 <= ti4_1)) {
			RTHOOK(19);
			tr1 = RTLNS(3701, 3701, _OBJSIZ_1_1_0_3_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O38065[Dtype(tr2)-3696]);
			F3697_46844(RTCV(tr1), (EIF_INTEGER_32) (ti4_1 - loc2));
			loc1 = (EIF_REFERENCE) tr1;
			RTHOOK(20);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O38065[Dtype(tr2)-3696]);
			F3702_47091(RTCV(loc1), tr1, loc2, ti4_1);
			RTHOOK(21);
			tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F3496_44015(RTCV(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16643[Dtype(Result)-1510])(RTCV(Result), tr1);
		}
	}
	RTHOOK(22);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.absolute_path */
EIF_REFERENCE F3496_44031 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	
	RTEAA("absolute_path", 3495, Current, 0, 0, 44728);
	RTGC;
	RTHOOK(1);
	tr1 = F2282_25620(RTCV(RTOUCR(31,F3496_44061,(Current))));
	Result = F3496_44032(Current, tr1);
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.absolute_path_in */
EIF_REFERENCE F3496_44032 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(8);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLR(5,tr2);
	RTLR(6,tr3);
	RTLR(7,loc2);
	
	RTEAA("absolute_path_in", 3495, Current, 2, 1, 44729);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F1354_17936(RTCV(tr1));
	if (tb1) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) arg1;
	} else {
		RTHOOK(4);
		if (F3496_44022(Current)) {
			RTHOOK(5);
			RTHOOK(6);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) Current;
		} else {
			RTHOOK(7);
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
				RTHOOK(8);
				tr1 = F3496_44026(Current);
				loc1 = tr1;
				if (EIF_TEST(loc1)) {
					RTHOOK(9);
					tb1 = '\0';
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(RTCV(loc1));
					ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
					if ((EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 4L))) {
						tr1 = *(EIF_REFERENCE *)(RTCV(arg1));
						ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
						tb2 = (EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L));
					}
					if (tb2) {
						tb2 = '\0';
						tr1 = *(EIF_REFERENCE *)(RTCV(loc1));
						tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(tr1)-2066])(RTCV(tr1), ((EIF_INTEGER_32) 1L)));
						tr1 = *(EIF_REFERENCE *)(RTCV(arg1));
						tc2 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(tr1)-2066])(RTCV(tr1), ((EIF_INTEGER_32) 1L)));
						if ((EIF_BOOLEAN)(tc1 == tc2)) {
							tr1 = *(EIF_REFERENCE *)(RTCV(loc1));
							tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(tr1)-2066])(RTCV(tr1), ((EIF_INTEGER_32) 3L)));
							tr1 = *(EIF_REFERENCE *)(RTCV(arg1));
							tc2 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(tr1)-2066])(RTCV(tr1), ((EIF_INTEGER_32) 3L)));
							tb2 = (EIF_BOOLEAN)(tc1 == tc2);
						}
						tb1 = tb2;
					}
					if (tb1) {
						RTHOOK(10);
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
					} else {
						RTHOOK(11);
						Result = (EIF_REFERENCE) loc1;
					}
					RTHOOK(12);
					tr1 = *(EIF_REFERENCE *)(RTCV(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tr3 = *(EIF_REFERENCE *)(RTCV(loc1));
					ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr3) + O38065[Dtype(tr3)-3696]);
					tr3 = *(EIF_REFERENCE *)(Current);
					ti4_2 = *(EIF_INTEGER_32 *)(RTCV(tr3) + O38065[Dtype(tr3)-3696]);
					tc1 = F3496_44038(Current);
					F3496_44067(Current, tr1, tr2, (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)), ti4_2, tc1);
				} else {
					RTHOOK(13);
					tr1 = *(EIF_REFERENCE *)(Current);
					if (F3496_44068(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
						RTHOOK(14);
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
						RTHOOK(15);
						tr1 = F3496_44026(RTCV(Result));
						loc2 = tr1;
						if (EIF_TEST(loc2)) {
							RTHOOK(16);
							Result = (EIF_REFERENCE) loc2;
						}
					} else {
						RTHOOK(17);
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
					}
					RTHOOK(18);
					tr1 = *(EIF_REFERENCE *)(RTCV(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tc1 = F3496_44038(Current);
					F3496_44066(Current, tr1, tr2, tc1);
				}
			} else {
				RTHOOK(19);
				Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
				RTHOOK(20);
				tr1 = *(EIF_REFERENCE *)(RTCV(Result));
				tr2 = *(EIF_REFERENCE *)(Current);
				tc1 = F3496_44038(Current);
				F3496_44066(Current, tr1, tr2, tc1);
			}
			RTHOOK(21);
			F3496_44057(RTCV(Result));
		}
	}
	RTHOOK(22);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.canonical_path */
EIF_REFERENCE F3496_44033 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(8);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,loc4);
	RTLR(3,tr1);
	RTLR(4,loc3);
	RTLR(5,tr2);
	RTLR(6,loc1);
	RTLR(7,loc5);
	
	RTEAA("canonical_path", 3495, Current, 5, 0, 44730);
	RTGC;
	RTHOOK(1);
	loc2 = F3496_44031(Current);
	RTHOOK(2);
	tr1 = F3496_44026(RTCV(loc2));
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		RTHOOK(3);
		tr1 = RTLNSMART(eif_non_attached_type(3701));
		tr2 = *(EIF_REFERENCE *)(RTCV(loc2));
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O38065[Dtype(tr2)-3696]);
		F3697_46844(RTCV(tr1), ti4_1);
		loc3 = (EIF_REFERENCE) tr1;
		RTHOOK(4);
		loc1 = F3496_44030(RTCV(loc2));
		RTHOOK(5);
		F2341_26166(RTCV(loc1));
		RTHOOK(6);
		tr1 = F2341_26140(RTCV(loc1));
		tr1 = *(EIF_REFERENCE *)(RTCV(tr1));
		tc1 = F3496_44038(Current);
		F3496_44066(Current, loc3, tr1, tc1);
		RTHOOK(7);
		(FUNCTION_CAST(void, (EIF_REFERENCE)) R16660[Dtype(loc1)-1510])(RTCV(loc1));
		for (;;) {
			RTHOOK(8);
			tb1 = F2101_23779(RTCV(loc1));
			if (tb1) break;
			RTHOOK(9);
			tr1 = F2341_26140(RTCV(loc1));
			tb2 = F3496_44017(RTCV(tr1));
			if (tb2) {
				RTHOOK(10);
				(FUNCTION_CAST(void, (EIF_REFERENCE)) R16660[Dtype(loc1)-1510])(RTCV(loc1));
			} else {
				RTHOOK(11);
				tr1 = F2341_26140(RTCV(loc1));
				tb2 = F3496_44018(RTCV(tr1));
				if (tb2) {
					RTHOOK(12);
					tb2 = F2069_23715(RTCV(loc1));
					if ((EIF_BOOLEAN) !tb2) {
						RTHOOK(13);
						F2341_26169(RTCV(loc1));
						RTHOOK(14);
						(FUNCTION_CAST(void, (EIF_REFERENCE)) R16660[Dtype(loc1)-1510])(RTCV(loc1));
					}
					RTHOOK(15);
					(FUNCTION_CAST(void, (EIF_REFERENCE)) R16660[Dtype(loc1)-1510])(RTCV(loc1));
				} else {
					RTHOOK(16);
					F2341_26168(RTCV(loc1));
				}
			}
		}
		RTHOOK(17);
		loc5 = F2037_23643(RTCV(loc1));
		for (;;) {
			tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R18077[Dtype(loc5)-1696])(RTCV(loc5));
			if (tb2) break;
			RTHOOK(18);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R18076[Dtype(loc5)-1696])(RTCV(loc5));
			tr1 = *(EIF_REFERENCE *)(RTCV(tr1));
			tc1 = F3496_44038(Current);
			F3496_44066(Current, loc3, tr1, tc1);
			RTHOOK(19);
			(FUNCTION_CAST(void, (EIF_REFERENCE)) R18078[Dtype(loc5)-1696])(RTCV(loc5));
		}
		RTHOOK(20);
		tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F3496_44015(RTCV(tr1), loc3);
		RTHOOK(21);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) tr1;
	} else {
		RTHOOK(22);
		RTHOOK(23);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) loc2;
	}/* NOTREACHED */
	
}

/* {PATH}.hash_code */
EIF_INTEGER_32 F3496_44034 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("hash_code", 3495, Current, 0, 0, 44731);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R35717[Dtype(tr1)-3470])(RTCV(tr1));
	} else {
		RTHOOK(3);
		Result = F3693_46689(RTCV(F3496_44051(Current)));
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.native_string */
EIF_REFERENCE F3496_44035 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,tr1);
	RTLR(1,Current);
	
	RTEAA("native_string", 3495, Current, 0, 0, 44732);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNS(2278, 2278, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F2279_25541(RTCV(tr1), *(EIF_REFERENCE *)(Current));
	RTHOOK(2);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.directory_separator */
EIF_CHARACTER_8 F3496_44038 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("directory_separator", 3495, Current, 0, 0, 44735);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
	} else {
		RTHOOK(4);
		RTHOOK(5);
		RTLE;
		RTEE;
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
	}/* NOTREACHED */
	
}

/* {PATH}.extended */
EIF_REFERENCE F3496_44039 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	
	RTEAA("extended", 3495, Current, 2, 1, 44736);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_non_attached_type(3701));
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O38065[Dtype(tr2)-3696]);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R37945[Dtype(arg1)-3694])(RTCV(arg1));
	ti4_3 = F3496_44056(Current);
	ti4_4 = F3496_44056(Current);
	F3697_46844(RTCV(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R38193[Dtype(loc1)-3701])(RTCV(loc1), *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(loc1) + O38065[Dtype(loc1)-3696]);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(loc1) + O38065[Dtype(loc1)-3696]);
		tb1 = (EIF_BOOLEAN)(F3496_44062(Current) == ti4_1);
	}
	if (tb1) {
		RTHOOK(4);
		F3496_44065(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	} else {
		RTHOOK(5);
		tc1 = F3496_44038(Current);
		F3496_44065(Current, loc1, arg1, tc1);
	}
	RTHOOK(6);
	tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F3496_44014(RTCV(tr1), loc1);
	RTHOOK(7);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.extended_path */
EIF_REFERENCE F3496_44040 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	
	RTEAA("extended_path", 3495, Current, 1, 1, 44737);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_non_attached_type(3701));
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O38065[Dtype(tr2)-3696]);
	tr2 = *(EIF_REFERENCE *)(RTCV(arg1));
	ti4_2 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O38065[Dtype(tr2)-3696]);
	ti4_3 = F3496_44056(Current);
	F3697_46844(RTCV(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ti4_3));
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R38193[Dtype(loc1)-3701])(RTCV(loc1), *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(loc1) + O38065[Dtype(loc1)-3696]);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(loc1) + O38065[Dtype(loc1)-3696]);
		tb1 = (EIF_BOOLEAN)(F3496_44062(Current) == ti4_1);
	}
	if (tb1) {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(RTCV(arg1));
		F3496_44066(Current, loc1, tr1, (EIF_CHARACTER_8) '\000');
	} else {
		RTHOOK(5);
		tr1 = *(EIF_REFERENCE *)(RTCV(arg1));
		tc1 = F3496_44038(Current);
		F3496_44066(Current, loc1, tr1, tc1);
	}
	RTHOOK(6);
	tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F3496_44015(RTCV(tr1), loc1);
	RTHOOK(7);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended */
EIF_REFERENCE F3496_44041 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	
	RTEAA("appended", 3495, Current, 1, 1, 44738);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_non_attached_type(3701));
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O38065[Dtype(tr2)-3696]);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R37945[Dtype(arg1)-3694])(RTCV(arg1));
	ti4_3 = F3496_44056(Current);
	F3697_46844(RTCV(tr1), (EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)));
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R38193[Dtype(loc1)-3701])(RTCV(loc1), *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	F3496_44065(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	RTHOOK(4);
	tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F3496_44014(RTCV(tr1), loc1);
	RTHOOK(5);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended_with_extension */
EIF_REFERENCE F3496_44042 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	
	RTEAA("appended_with_extension", 3495, Current, 2, 1, 44739);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_non_attached_type(3701));
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O38065[Dtype(tr2)-3696]);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R37945[Dtype(arg1)-3694])(RTCV(arg1));
	ti4_3 = F3496_44056(Current);
	ti4_4 = F3496_44056(Current);
	F3697_46844(RTCV(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R38193[Dtype(loc1)-3701])(RTCV(loc1), *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	F3496_44065(Current, loc1, arg1, (EIF_CHARACTER_8) '.');
	RTHOOK(4);
	tr1 = RTLNS(3495, 3495, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F3496_44015(RTCV(tr1), loc1);
	RTHOOK(5);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.same_as */
EIF_BOOLEAN F3496_44043 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,arg1);
	RTLR(1,Current);
	
	RTEAA("same_as", 3495, Current, 0, 1, 44740);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 == NULL)) {
	} else {
		RTHOOK(2);
		if ((EIF_BOOLEAN)(arg1 == Current)) {
			RTHOOK(3);
			RTHOOK(4);
			RTLE;
			RTEE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		} else {
			RTHOOK(5);
			if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
				RTHOOK(6);
				RTHOOK(7);
				RTLE;
				RTEE;
				return (EIF_BOOLEAN) F3496_44046(Current, arg1);
			} else {
				RTHOOK(8);
				RTHOOK(9);
				RTLE;
				RTEE;
				return (EIF_BOOLEAN) F3496_44047(Current, arg1);
			}
		}
	}
	RTHOOK(10);
	RTLE;
	RTEE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_less */
EIF_BOOLEAN F3496_44044 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,tr2);
	
	RTEAA("is_less", 3495, Current, 0, 1, 44741);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCV(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R19887[Dtype(tr1)-1903])(RTCV(tr1), tr2);
	} else {
		RTHOOK(3);
		tr1 = F3696_46834(RTCV(F3496_44051(Current)));
		tr2 = F3496_44051(RTCV(arg1));
		tr2 = F3696_46834(RTCV(tr2));
		Result = F3695_46800(RTCV(tr1), tr2);
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_equal */
EIF_BOOLEAN F3496_44045 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	
	
	RTEAA("is_equal", 3495, Current, 0, 1, 44742);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_BOOLEAN) F3496_44043(Current, arg1);
}

/* {PATH}.is_case_sensitive_equal */
EIF_BOOLEAN F3496_44046 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	
	RTEAA("is_case_sensitive_equal", 3495, Current, 0, 1, 44743);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCV(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11[Dtype(tr1)-0])(RTCV(tr1), tr2);
	}
	RTHOOK(5);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_case_insensitive_equal */
EIF_BOOLEAN F3496_44047 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	
	RTEAA("is_case_insensitive_equal", 3495, Current, 0, 1, 44744);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		RTHOOK(4);
		tr1 = F3496_44051(Current);
		tr2 = F3496_44051(RTCV(arg1));
		Result = F3695_46796(RTCV(tr1), tr2);
	}
	RTHOOK(5);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.copy */
void F3496_44048 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	
	RTEAA("copy", 3495, Current, 0, 1, 44745);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 != Current)) {
		RTHOOK(2);
		eif_builtin_ANY_standard_copy (Current, arg1);
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(RTCV(arg1));
		tr1 = (EIF_REFERENCE) eif_builtin_ANY_twin (tr1);
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	}
	RTHOOK(4);
	RTLE;
	RTEE;
}

/* {PATH}.out */
EIF_REFERENCE F3496_44049 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("out", 3495, Current, 0, 0, 44746);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_REFERENCE) F3496_44050(Current);
}

/* {PATH}.utf_8_name */
EIF_REFERENCE F3496_44050 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	struct eif_ex_283 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, 309);
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,Result);
	
	RTEAA("utf_8_name", 3495, Current, 1, 0, 44747);
	RTGC;
	RTHOOK(1);
	tr1 = F3496_44051(Current);
	Result = F310_6693(RTCV(loc1), tr1);
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.name */
EIF_REFERENCE F3496_44051 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	struct eif_ex_283 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, 309);
	RTLI(6);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLR(4,tr2);
	RTLR(5,Result);
	
	RTEAA("name", 3495, Current, 2, 0, 44748);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_1_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) loc2;
	} else {
		RTHOOK(4);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			RTHOOK(5);
			tr1 = RTLNS(3695, 3695, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr2 = F310_6735(RTCV(loc1), *(EIF_REFERENCE *)(Current));
			F3695_46774(RTCV(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		} else {
			RTHOOK(6);
			tr1 = RTLNS(3695, 3695, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr2 = F310_6708(RTCV(loc1), *(EIF_REFERENCE *)(Current));
			F3695_46774(RTCV(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		}
		RTHOOK(7);
		RTAR(Current, Result);
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) Result;
	}
	RTHOOK(8);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.to_pointer */
EIF_REFERENCE F3496_44053 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	
	RTEAA("to_pointer", 3495, Current, 1, 0, 44750);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNS(2423, 2423, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O38065[Dtype(tr2)-3696]);
	ti4_2 = F3496_44056(Current);
	F2424_26978(RTCV(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) - ((EIF_INTEGER_32) 1L)));
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	F2424_27002(RTCV(loc1), *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	tr1 = *(EIF_REFERENCE *)(RTCV(loc1));
	RTHOOK(4);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.storage */
EIF_REFERENCE F3496_44055 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current);
}


/* {PATH}.unit_size */
EIF_INTEGER_32 F3496_44056 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("unit_size", 3495, Current, 0, 0, 44753);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	} else {
		RTHOOK(4);
		RTHOOK(5);
		RTLE;
		RTEE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}/* NOTREACHED */
	
}

/* {PATH}.reset_internal_data */
void F3496_44057 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("reset_internal_data", 3495, Current, 0, 0, 44754);
	RTHOOK(1);
	*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
	RTHOOK(2);
	RTEE;
}

/* {PATH}.normalize */
void F3496_44058 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc4 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc5 = (EIF_INTEGER_32) 0;
	EIF_BOOLEAN loc6 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc7 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc8 = (EIF_BOOLEAN) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(2);
	RTLR(0,loc1);
	RTLR(1,Current);
	
	RTEAA("normalize", 3495, Current, 8, 0, 44755);
	RTGC;
	RTHOOK(1);
	loc1 = *(EIF_REFERENCE *)(Current);
	RTHOOK(2);
	loc4 = *(EIF_INTEGER_32 *)(RTCV(loc1) + O38065[Dtype(loc1)-3696]);
	RTHOOK(3);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		RTHOOK(4);
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		RTHOOK(5);
		if ((EIF_BOOLEAN) (loc4 >= ((EIF_INTEGER_32) 10L))) {
			RTHOOK(6);
			tb1 = '\01';
			tb2 = '\0';
			if (F3496_44068(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '/')) {
				tb3 = '\01';
				if (!F3496_44068(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/')) {
					tb3 = F3496_44068(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\');
				}
				tb2 = tb3;
			}
			if (!(tb2)) {
				tb2 = '\0';
				if (F3496_44068(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
					tb3 = '\01';
					if (!F3496_44068(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\')) {
						tb3 = F3496_44068(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/');
					}
					tb2 = tb3;
				}
				tb1 = tb2;
			}
			if (tb1) {
				RTHOOK(7);
				tb1 = '\0';
				if ((EIF_BOOLEAN) !F3496_44068(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '/')) {
					tb1 = (EIF_BOOLEAN) !F3496_44068(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
				}
				if (tb1) {
					RTHOOK(8);
					loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 5L);
					RTHOOK(9);
					loc8 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				}
			}
		}
		RTHOOK(10);
		loc3 = (EIF_INTEGER_32) loc2;
		RTHOOK(11);
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			RTHOOK(12);
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			RTHOOK(13);
			if (loc6) {
				RTHOOK(14);
				loc7 = '\0';
				if ((EIF_BOOLEAN) !F3496_44068(Current, loc1, loc2, (EIF_CHARACTER_8) '\\')) {
					loc7 = (EIF_BOOLEAN) !F3496_44068(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				}
				RTHOOK(15);
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				RTHOOK(16);
				if (F3496_44068(Current, loc1, loc2, (EIF_CHARACTER_8) '/')) {
					RTHOOK(17);
					tc1 = (EIF_CHARACTER_8) '\\';
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R16652[Dtype(loc1)-2066])(RTCV(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc2);
					RTHOOK(18);
					loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				} else {
					RTHOOK(19);
					loc6 = F3496_44068(Current, loc1, loc2, (EIF_CHARACTER_8) '\\');
				}
			}
			RTHOOK(20);
			if (loc7) {
				RTHOOK(21);
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					RTHOOK(22);
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(loc1)-2066])(RTCV(loc1), loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R16652[Dtype(loc1)-2066])(RTCV(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
					RTHOOK(23);
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(loc1)-2066])(RTCV(loc1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L))));
					ti4_1 = (EIF_INTEGER_32) (loc3 + ((EIF_INTEGER_32) 1L));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R16652[Dtype(loc1)-2066])(RTCV(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &ti4_1);
				}
				RTHOOK(24);
				loc3 += ((EIF_INTEGER_32) 2L);
			}
			RTHOOK(25);
			loc2 += ((EIF_INTEGER_32) 2L);
		}
	} else {
		RTHOOK(26);
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		RTHOOK(27);
		loc3 = (EIF_INTEGER_32) loc2;
		RTHOOK(28);
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			RTHOOK(29);
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			RTHOOK(30);
			if (loc6) {
				RTHOOK(31);
				loc7 = F3496_44068(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
				RTHOOK(32);
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				RTHOOK(33);
				loc6 = F3496_44068(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
			}
			RTHOOK(34);
			if (loc7) {
				RTHOOK(35);
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					RTHOOK(36);
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(loc1)-2066])(RTCV(loc1), loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R16652[Dtype(loc1)-2066])(RTCV(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
				}
				RTHOOK(37);
				loc3++;
			}
			RTHOOK(38);
			loc2++;
		}
	}
	RTHOOK(39);
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		RTHOOK(40);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R38079[Dtype(loc1)-3699])(RTCV(loc1), (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
	}
	RTHOOK(41);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(42);
	if (loc8) {
		RTHOOK(43);
		loc5 = F3496_44062(Current);
		RTHOOK(44);
		if ((EIF_BOOLEAN)(loc5 == ((EIF_INTEGER_32) 0L))) {
			RTHOOK(45);
			ti4_1 = F3496_44056(Current);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R38211[Dtype(loc1)-3701])(RTCV(loc1), ti4_1);
		}
	}
	RTHOOK(46);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(loc1) + O38065[Dtype(loc1)-3696]);
	ti4_2 = F3496_44056(Current);
	tc1 = F3496_44038(Current);
	if (F3496_44068(Current, loc1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), tc1)) {
		RTHOOK(47);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(loc1) + O38065[Dtype(loc1)-3696]);
		if ((EIF_BOOLEAN) (F3496_44062(Current) < ti4_1)) {
			RTHOOK(48);
			ti4_1 = F3496_44056(Current);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R38213[Dtype(loc1)-3701])(RTCV(loc1), ti4_1);
		}
	}
	RTHOOK(49);
	RTLE;
	RTEE;
}

/* {PATH}.internal_name */
EIF_REFERENCE F3496_44059 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_1_);
}


/* {PATH}.env */
static EIF_REFERENCE F3496_44061_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
#define Result RTOTRR
	RTOUDR(31)

	RTLI(2);
	RTLR(0,tr1);
	RTLR(1,Current);
	
	RTEAA("env", 3495, Current, 0, 0, 44758);
	RTGC;
	RTOTP;
	RTHOOK(1);
	tr1 = RTLNS(2281, 2281, _OBJSIZ_0_0_0_1_0_0_0_0_);
	Result = (EIF_REFERENCE) tr1;
	RTOTE;
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F3496_44061 (EIF_REFERENCE Current)
{
	GTCX
	return RTOUCR(31,F3496_44061_body,(Current));
}

/* {PATH}.root_end_position */
EIF_INTEGER_32 F3496_44062 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_CHARACTER_8 loc1 = (EIF_CHARACTER_8) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("root_end_position", 3495, Current, 2, 0, 44759);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F1354_17936(RTCV(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(2);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			RTHOOK(3);
			tb1 = '\0';
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
			if ((EIF_BOOLEAN)(ti4_1 == F3496_44056(Current))) {
				tr1 = *(EIF_REFERENCE *)(Current);
				tb1 = F3496_44068(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\');
			}
			if (tb1) {
				RTHOOK(4);
				RTHOOK(5);
				RTLE;
				RTEE;
				return (EIF_INTEGER_32) F3496_44056(Current);
			} else {
				RTHOOK(6);
				tb1 = '\0';
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
				if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L))) {
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(tr1)-2066])(RTCV(tr1), ((EIF_INTEGER_32) 2L)));
					if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000')) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(tr1)-2066])(RTCV(tr1), ((EIF_INTEGER_32) 4L)));
						tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
					}
					tb1 = tb2;
				}
				if (tb1) {
					RTHOOK(7);
					tr1 = *(EIF_REFERENCE *)(Current);
					loc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(tr1)-2066])(RTCV(tr1), ((EIF_INTEGER_32) 1L)));
					loc1 = (EIF_CHARACTER_8) tolower(loc1);
					RTHOOK(8);
					tb1 = '\0';
					if ((EIF_BOOLEAN) ((EIF_BOOLEAN) (loc1 >= (EIF_CHARACTER_8) 'a') && (EIF_BOOLEAN) (loc1 <= (EIF_CHARACTER_8) 'z'))) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(tr1)-2066])(RTCV(tr1), ((EIF_INTEGER_32) 3L)));
						tb1 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) ':');
					}
					if (tb1) {
						RTHOOK(9);
						tb1 = '\0';
						tr1 = *(EIF_REFERENCE *)(Current);
						ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
						if ((EIF_BOOLEAN) (ti4_1 >= (EIF_INTEGER_32) (((EIF_INTEGER_32) 3L) * F3496_44056(Current)))) {
							tr1 = *(EIF_REFERENCE *)(Current);
							tb1 = F3496_44068(Current, tr1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTHOOK(10);
							RTHOOK(11);
							RTLE;
							RTEE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 6L);
						} else {
							RTHOOK(12);
							RTHOOK(13);
							RTLE;
							RTEE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 4L);
						}
					} else {
						RTHOOK(14);
						tb1 = '\0';
						if ((EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\')) {
							tr1 = *(EIF_REFERENCE *)(Current);
							tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(tr1)-2066])(RTCV(tr1), ((EIF_INTEGER_32) 3L)));
							tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTHOOK(15);
							Result = F3496_44056(Current);
						} else {
							RTHOOK(16);
							tb1 = '\0';
							tb2 = '\0';
							tb3 = '\0';
							tr1 = *(EIF_REFERENCE *)(Current);
							ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
							if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 10L))) {
								tb3 = (EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb3) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(tr1)-2066])(RTCV(tr1), ((EIF_INTEGER_32) 3L)));
								tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb2) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(tr1)-2066])(RTCV(tr1), ((EIF_INTEGER_32) 5L)));
								tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
							}
							if (tb1) {
								RTHOOK(17);
								loc2 = F3496_44064(Current, ((EIF_INTEGER_32) 7L));
								RTHOOK(18);
								tb1 = '\0';
								if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
									tr1 = *(EIF_REFERENCE *)(Current);
									ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
									tb1 = (EIF_BOOLEAN) ((EIF_INTEGER_32) (loc2 + F3496_44056(Current)) <= ti4_1);
								}
								if (tb1) {
									RTHOOK(19);
									ti4_1 = F3496_44056(Current);
									loc2 = F3496_44064(Current, (EIF_INTEGER_32) (loc2 + ti4_1));
									RTHOOK(20);
									if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
										RTHOOK(21);
										RTHOOK(22);
										RTLE;
										RTEE;
										return (EIF_INTEGER_32) (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L));
									} else {
										RTHOOK(23);
										tr1 = *(EIF_REFERENCE *)(Current);
										Result = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
									}
								}
							}
						}
					}
				}
			}
		} else {
			RTHOOK(24);
			tr1 = *(EIF_REFERENCE *)(Current);
			tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(tr1)-2066])(RTCV(tr1), ((EIF_INTEGER_32) 1L)));
			if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '/')) {
				RTHOOK(25);
				RTHOOK(26);
				RTLE;
				RTEE;
				return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
		}
	}
	RTHOOK(27);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.end_position_of_last_directory_separator */
EIF_INTEGER_32 F3496_44063 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("end_position_of_last_directory_separator", 3495, Current, 0, 0, 44760);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F1354_17936(RTCV(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = *(EIF_INTEGER_32 *)(RTCV(tr1) + O38065[Dtype(tr1)-3696]);
		ti4_1 = F3496_44056(Current);
		Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result - ti4_1) + ((EIF_INTEGER_32) 1L));
		RTHOOK(3);
		if ((EIF_BOOLEAN) (Result >= ((EIF_INTEGER_32) 1L))) {
			for (;;) {
				RTHOOK(4);
				tb1 = '\01';
				if (!(EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L))) {
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = F3496_44038(Current);
					tb1 = F3496_44068(Current, tr1, Result, tc1);
				}
				if (tb1) break;
				RTHOOK(5);
				Result -= F3496_44056(Current);
			}
		}
		RTHOOK(6);
		if ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 0L))) {
			RTHOOK(7);
			RTHOOK(8);
			RTLE;
			RTEE;
			return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
		} else {
			RTHOOK(9);
			ti4_1 = F3496_44056(Current);
			Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result + ti4_1) - ((EIF_INTEGER_32) 1L));
		}
	}
	RTHOOK(10);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.next_directory_separator */
EIF_INTEGER_32 F3496_44064 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_CHARACTER_8 loc3 = (EIF_CHARACTER_8) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_BOOLEAN tb1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,loc4);
	
	RTEAA("next_directory_separator", 3495, Current, 4, 1, 44761);
	RTGC;
	RTHOOK(1);
	loc2 = F3496_44056(Current);
	RTHOOK(2);
	loc3 = F3496_44038(Current);
	RTHOOK(3);
	Result = (EIF_INTEGER_32) arg1;
	RTHOOK(4);
	loc4 = *(EIF_REFERENCE *)(Current);
	RTHOOK(5);
	loc1 = *(EIF_INTEGER_32 *)(RTCV(loc4) + O38065[Dtype(loc4)-3696]);
	for (;;) {
		RTHOOK(6);
		tb1 = '\01';
		if (!(EIF_BOOLEAN) ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L)) || (EIF_BOOLEAN) (Result > loc1))) {
			tb1 = F3496_44068(Current, loc4, Result, loc3);
		}
		if (tb1) break;
		RTHOOK(7);
		Result += loc2;
	}
	RTHOOK(8);
	if ((EIF_BOOLEAN) (Result > loc1)) {
		RTHOOK(9);
		RTHOOK(10);
		RTLE;
		RTEE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	}
	RTHOOK(11);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.internal_append_into */
void F3496_44065 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	RTEX;
	struct eif_ex_283 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_CHARACTER_32 tw1;
	EIF_CHARACTER_32 tw2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, 309);
	RTLI(4);
	RTLR(0,arg2);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,loc1);
	
	RTEAA("internal_append_into", 3495, Current, 1, 3, 44762);
	RTGC;
	RTHOOK(1);
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R37925[Dtype(arg2)-3695])(RTCV(arg2));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(2);
		tb1 = '\0';
		if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
			tb2 = F1354_17936(RTCV(arg1));
			tb1 = (EIF_BOOLEAN) !tb2;
		}
		if (tb1) {
			RTHOOK(3);
			tb1 = '\0';
			ti4_1 = *(EIF_INTEGER_32 *)(RTCV(arg1) + O38065[Dtype(arg1)-3696]);
			ti4_2 = F3496_44056(Current);
			if ((EIF_BOOLEAN) !F3496_44068(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg3)) {
				tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R37911[Dtype(arg2)-3695])(RTCV(arg2), ((EIF_INTEGER_32) 1L));
				tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '/';
				tb1 = (EIF_BOOLEAN)(tw1 != tw2);
			}
			if (tb1) {
				RTHOOK(4);
				if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
					RTHOOK(5);
					tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R37911[Dtype(arg2)-3695])(RTCV(arg2), ((EIF_INTEGER_32) 1L));
					tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '\\';
					if ((EIF_BOOLEAN)(tw1 != tw2)) {
						RTHOOK(6);
						(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R38206[Dtype(arg1)-3701])(RTCV(arg1), arg3);
						RTHOOK(7);
						(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R38206[Dtype(arg1)-3701])(RTCV(arg1), (EIF_CHARACTER_8) '\000');
					}
				} else {
					RTHOOK(8);
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R38206[Dtype(arg1)-3701])(RTCV(arg1), arg3);
				}
			}
		}
		RTHOOK(9);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			RTHOOK(10);
			F310_6722(RTCV(loc1), arg2, arg1);
		} else {
			RTHOOK(11);
			F310_6697(RTCV(loc1), arg2, arg1);
		}
	}
	RTHOOK(12);
	RTLE;
	RTEE;
}

/* {PATH}.internal_path_append_into */
void F3496_44066 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	
	RTEAA("internal_path_append_into", 3495, Current, 0, 3, 44763);
	RTGC;
	RTHOOK(1);
	tb1 = '\0';
	if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
		tb2 = F1354_17936(RTCV(arg1));
		tb1 = (EIF_BOOLEAN) !tb2;
	}
	if (tb1) {
		RTHOOK(2);
		tb1 = '\0';
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(arg1) + O38065[Dtype(arg1)-3696]);
		ti4_2 = F3496_44056(Current);
		if ((EIF_BOOLEAN) !F3496_44068(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg3)) {
			tb1 = (EIF_BOOLEAN) !F3496_44068(Current, arg2, ((EIF_INTEGER_32) 1L), arg3);
		}
		if (tb1) {
			RTHOOK(3);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R38206[Dtype(arg1)-3701])(RTCV(arg1), arg3);
			RTHOOK(4);
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
				RTHOOK(5);
				(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R38206[Dtype(arg1)-3701])(RTCV(arg1), (EIF_CHARACTER_8) '\000');
			}
		}
	}
	RTHOOK(6);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R38193[Dtype(arg1)-3701])(RTCV(arg1), arg2);
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {PATH}.internal_path_append_substring_into */
void F3496_44067 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_CHARACTER_8 arg5)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	
	RTEAA("internal_path_append_substring_into", 3495, Current, 0, 5, 44764);
	RTGC;
	RTHOOK(1);
	tb1 = '\0';
	if ((EIF_BOOLEAN)(arg5 != (EIF_CHARACTER_8) '\000')) {
		tb2 = F1354_17936(RTCV(arg1));
		tb1 = (EIF_BOOLEAN) !tb2;
	}
	if (tb1) {
		RTHOOK(2);
		tb1 = '\0';
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(arg1) + O38065[Dtype(arg1)-3696]);
		ti4_2 = F3496_44056(Current);
		if ((EIF_BOOLEAN) !F3496_44068(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg5)) {
			tb1 = (EIF_BOOLEAN) !F3496_44068(Current, arg2, arg3, arg5);
		}
		if (tb1) {
			RTHOOK(3);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R38206[Dtype(arg1)-3701])(RTCV(arg1), arg5);
			RTHOOK(4);
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
				RTHOOK(5);
				(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R38206[Dtype(arg1)-3701])(RTCV(arg1), (EIF_CHARACTER_8) '\000');
			}
		}
	}
	RTHOOK(6);
	F3702_47091(RTCV(arg1), arg2, arg3, arg4);
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {PATH}.is_character */
EIF_BOOLEAN F3496_44068 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_INTEGER_32 arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	RTEX;
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,arg1);
	RTLR(1,Current);
	
	RTEAA("is_character", 3495, Current, 0, 3, 44765);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		RTHOOK(2);
		Result = '\0';
		tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(arg1)-2066])(RTCV(arg1), arg2));
		if ((EIF_BOOLEAN)(tc1 == arg3)) {
			tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(arg1)-2066])(RTCV(arg1), (EIF_INTEGER_32) (arg2 + ((EIF_INTEGER_32) 1L))));
			Result = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
		}
	} else {
		RTHOOK(3);
		tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20638[Dtype(arg1)-2066])(RTCV(arg1), arg2));
		Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tc1 == arg3);
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.c_same_files */
EIF_BOOLEAN F3496_44071 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("c_same_files", 3495, Current, 0, 2, 44768);
	Result = EIF_TEST(inline_F3496_44071 ((EIF_POINTER) arg1, (EIF_POINTER) arg2));
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

void EIF_Minit2605 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
