/*
 * Code for class PROCESS_UNIX_OS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pr1103.h"
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include "eif_process.h"
#include <signal.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F1214_17372
static void inline_F1214_17372 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	{
  int rc;
  rc = dup2(arg1, arg2);
  if (rc < 0) {
	    eraise(Strerror(errno), EN_SYS);
  }
}
	;
}
#define INLINE_F1214_17372
#endif
#ifndef INLINE_F1214_17373
static void inline_F1214_17373 (EIF_INTEGER_32 arg1)
{
	{
	 int rc;
	  rc = close(arg1);
	  if (rc != 0) {
	    eraise(Strerror(errno), EN_SYS);
	  }
}
	;
}
#define INLINE_F1214_17373
#endif
#ifndef INLINE_F1214_17376
static void inline_F1214_17376 (void)
{
	{
	setpgid (0, 0);
}
	;
}
#define INLINE_F1214_17376
#endif
#ifndef INLINE_F1214_17390
static void inline_F1214_17390 (EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	{
				  char ** arguments;
 				  arguments = (char **) arg1;
				  arguments[arg2] = (char *) arg3;
				}
	;
}
#define INLINE_F1214_17390
#endif
#ifndef INLINE_F1214_17388
static void inline_F1214_17388 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	{
				  int max_descriptors;
				  int k, rc;
  				  if (arg4 == EIF_TRUE) {
				    max_descriptors = getdtablesize();
					for (k = 3; k < max_descriptors; k++) {
					    rc = fcntl(k, F_SETFD, 1);
					    if (rc == -1 && errno != EBADF) {
						      eraise(Strerror(errno), EN_SYS);
					    }
			  	    }
				  }
				  if (arg3 == NULL) {
				    (void) execv((char *) arg1, (char **) arg2);
				  } else {
				    (void) execve((char *) arg1, (char **) arg2, (char **) arg3);
				  }
				  eraise(Strerror(errno), EN_SYS);
				}
	;
}
#define INLINE_F1214_17388
#endif
#ifndef INLINE_F1214_17385
static void inline_F1214_17385 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	{
	int rc;
	rc = kill((pid_t) arg1, (int) arg2);
    if (rc != 0 && errno != ESRCH) {
		eraise(Strerror(errno), EN_SYS);
	}
}
	;
}
#define INLINE_F1214_17385
#endif
#ifndef INLINE_F1214_17387
static void inline_F1214_17387 (EIF_INTEGER_32* arg1)
{
	{
  pid_t pid;
  pid = fork();
  *arg1 = (EIF_INTEGER)pid;
}
	;
}
#define INLINE_F1214_17387
#endif
#ifndef INLINE_F1214_17383
static void inline_F1214_17383 (EIF_POINTER arg1, EIF_POINTER* arg2)
{
	{
	  char *result;
	  result = (char *) malloc((unsigned) (strlen((char *) arg1) + 1));
	  if (result == NULL) {
    	enomem();
	  }
	  strcpy(result, arg1);
	  *arg2 = result;
	}
	;
}
#define INLINE_F1214_17383
#endif
#ifndef INLINE_F1214_17389
static void inline_F1214_17389 (EIF_INTEGER_32 arg1, EIF_POINTER* arg2)
{
	{
	EIF_POINTER result;
	result = (EIF_POINTER) malloc((size_t) (arg1 * sizeof(char *)));
	if (result == NULL) {
		enomem();
	}
	*arg2 = result;
}
	;
}
#define INLINE_F1214_17389
#endif
#ifndef INLINE_F1214_17384
static void inline_F1214_17384 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	{
  int rc;
  int fd[2];
  EIF_INTEGER * read_ptr;
  EIF_INTEGER * write_ptr;
  rc = pipe(fd);
  if (rc != 0) {
    eraise(Strerror(errno), EN_SYS);
  }
  read_ptr = (EIF_INTEGER *) arg1;
  write_ptr = (EIF_INTEGER *) arg2;
  *read_ptr = fd[0];
  *write_ptr = fd[1];
}
	;
}
#define INLINE_F1214_17384
#endif
#ifndef INLINE_F1214_17386
static void inline_F1214_17386 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	{
  pid_t rc;
  int status;
  
  rc = waitpid((pid_t) arg1, &status, (arg2 ? 0 : WNOHANG) | WUNTRACED);
  *(EIF_BOOLEAN *) arg5 = (rc != -1);
  if (rc != -1) {				    
	  if (rc == 0) { /* No process has status to report yet */
	    *(EIF_BOOLEAN *) arg3 = EIF_FALSE;
	  } else { /* Process reported status */
	    *(EIF_BOOLEAN *) arg3 = EIF_TRUE;
	  }
	  *(EIF_INTEGER *) arg4 = (EIF_INTEGER) status;
  }
}
	;
}
#define INLINE_F1214_17386
#endif
#ifndef INLINE_F1214_17391
static void inline_F1214_17391 (EIF_INTEGER_32 arg1)
{
	{
	pid_t pgid = getpgid (arg1);
	tcsetpgrp (1, pgid);
	tcsetpgrp (2, pgid);
}
	;
}
#define INLINE_F1214_17391
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PROCESS_UNIX_OS}.duplicate_file_descriptor */
void F1214_17372 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("duplicate_file_descriptor", 1213, Current, 0, 2, 15060);
	inline_F1214_17372 ((EIF_INTEGER_32) arg1, (EIF_INTEGER_32) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.close_file_descriptor */
void F1214_17373 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("close_file_descriptor", 1213, Current, 0, 1, 15061);
	inline_F1214_17373 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.fork_process */
EIF_INTEGER_32 F1214_17375 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("fork_process", 1213, Current, 0, 0, 15063);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_INTEGER_32) F1214_17380(Current);
}

/* {PROCESS_UNIX_OS}.new_process_group */
void F1214_17376 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("new_process_group", 1213, Current, 0, 0, 15064);
	inline_F1214_17376 ();
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.exec_process */
void F1214_17377 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_BOOLEAN arg3, EIF_POINTER arg4)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_POINTER loc4 = (EIF_POINTER) 0;
	EIF_POINTER loc5 = (EIF_POINTER) 0;
	EIF_POINTER loc6 = (EIF_POINTER) 0;
	EIF_REFERENCE loc7 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg2);
	RTLR(1,Current);
	RTLR(2,loc7);
	RTLR(3,tr1);
	RTLR(4,arg1);
	
	RTEAA("exec_process", 1213, Current, 7, 4, 15065);
	RTGC;
	RTHOOK(1);
	loc2 = F2183_24285(RTCV(arg2));
	RTHOOK(2);
	loc3 = *(EIF_INTEGER_32 *)(RTCV(arg2) + O20906[Dtype(arg2)-2182]);
	RTHOOK(3);
	loc4 = F1214_17382(Current, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)));
	RTHOOK(4);
	tr1 = RTLNS(2278, 2278, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F2279_25539(RTCV(tr1), ((EIF_INTEGER_32) 0L));
	loc7 = (EIF_REFERENCE) tr1;
	RTHOOK(5);
	loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	for (;;) {
		RTHOOK(6);
		if ((EIF_BOOLEAN) (loc1 > loc2)) break;
		RTHOOK(7);
		tr1 = F2183_24279(RTCV(arg2), (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc3 + loc1) - ((EIF_INTEGER_32) 1L)));
		F2279_25553(RTCV(loc7), tr1);
		RTHOOK(8);
		tp1 = F2279_25545(RTCV(loc7));
		loc5 = F1214_17381(Current, tp1);
		RTHOOK(9);
		inline_F1214_17390(loc4, (EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)), loc5);
		RTHOOK(10);
		loc1++;
	}
	RTHOOK(11);
	inline_F1214_17390(loc4, loc2, loc6);
	RTHOOK(12);
	tr1 = RTLNS(2278, 2278, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F2279_25538(RTCV(tr1), arg1);
	loc7 = (EIF_REFERENCE) tr1;
	RTHOOK(13);
	tp1 = F2279_25545(RTCV(loc7));
	inline_F1214_17388(tp1, loc4, arg4, arg3);
	RTHOOK(14);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.terminate_hard */
void F1214_17378 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("terminate_hard", 1213, Current, 0, 1, 15066);
	RTGC;
	RTHOOK(1);
	ti4_1 = RTOUCB(EIF_INTEGER_32,4890,F1213_17335,(Current));
	F1214_17379(Current, ti4_1, arg1);
	RTHOOK(2);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.send_signal */
void F1214_17379 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	
	
	RTEAA("send_signal", 1213, Current, 0, 2, 15067);
	RTHOOK(1);
	inline_F1214_17385(arg2, arg1);
	RTHOOK(2);
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_fork_process */
EIF_INTEGER_32 F1214_17380 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	RTEAA("unix_fork_process", 1213, Current, 0, 0, 15068);
	RTHOOK(1);
	inline_F1214_17387((EIF_INTEGER_32 *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.str_dup */
EIF_POINTER F1214_17381 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	RTEAA("str_dup", 1213, Current, 0, 1, 15069);
	RTHOOK(1);
	inline_F1214_17383(arg1, (EIF_POINTER *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.unix_allocate_arg_memory */
EIF_POINTER F1214_17382 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	RTEAA("unix_allocate_arg_memory", 1213, Current, 0, 1, 15070);
	RTHOOK(1);
	inline_F1214_17389(arg1, (EIF_POINTER *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.c_str_dup */
void F1214_17383 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER* arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("c_str_dup", 1213, Current, 0, 2, 15071);
	inline_F1214_17383 ((EIF_POINTER) arg1, (EIF_POINTER*) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_pipe */
void F1214_17384 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("unix_pipe", 1213, Current, 0, 2, 15072);
	inline_F1214_17384 ((EIF_POINTER) arg1, (EIF_POINTER) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_kill */
void F1214_17385 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("unix_kill", 1213, Current, 0, 2, 15073);
	inline_F1214_17385 ((EIF_INTEGER_32) arg1, (EIF_INTEGER_32) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_waitpid */
void F1214_17386 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("unix_waitpid", 1213, Current, 0, 5, 15074);
	EIF_ENTER_C;
	inline_F1214_17386 ((EIF_INTEGER_32) arg1, (EIF_BOOLEAN) arg2, (EIF_BOOLEAN*) arg3, (EIF_INTEGER_32*) arg4, (EIF_BOOLEAN*) arg5);
	EIF_EXIT_C;
	RTGC;
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.c_unix_fork_process */
void F1214_17387 (EIF_REFERENCE Current, EIF_INTEGER_32* arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("c_unix_fork_process", 1213, Current, 0, 1, 15075);
	inline_F1214_17387 ((EIF_INTEGER_32*) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_exec_process */
void F1214_17388 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("unix_exec_process", 1213, Current, 0, 4, 15076);
	inline_F1214_17388 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.c_unix_allocate_arg_memory */
void F1214_17389 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_POINTER* arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("c_unix_allocate_arg_memory", 1213, Current, 0, 2, 15077);
	inline_F1214_17389 ((EIF_INTEGER_32) arg1, (EIF_POINTER*) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_set_arg_value */
void F1214_17390 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("unix_set_arg_value", 1213, Current, 0, 3, 15078);
	inline_F1214_17390 ((EIF_POINTER) arg1, (EIF_INTEGER_32) arg2, (EIF_POINTER) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.attach_terminals */
void F1214_17391 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("attach_terminals", 1213, Current, 0, 1, 15058);
	inline_F1214_17391 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

void EIF_Minit1103 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
