#ifndef STRING_INDEXER_HPP_
#define STRING_INDEXER_HPP_

#include <map>

namespace maeda {

// ID(Ƚ)
typedef int FeatureID;

static const FeatureID kInvalidFeatureID = -1;


class StringIndexer {
private:

  std::map<std::string, FeatureID> table_;

  std::map<FeatureID, std::string> reverse_;

public:
  FeatureID Add(const std::string &str);

  FeatureID GetID(const std::string &str) const;

  std::string GetStr(const FeatureID feature_id) const;

  void Load(const std::string &filename);

  inline size_t size() const { return table_.size(); }
};

} // maeda


#endif // STRING_INDEXER_HPP_
