#include <iostream>
#include "chu_liu_edmonds.hpp"

using namespace std;

void print_edges(const vector<pair<int, int> >&e) {
  for(size_t i = 0; i < e.size(); i++) {
    cout << e[i].first << " -> " << e[i].second << endl;
  }
  cout << endl;
}

int main(void) {
  //test1
  {
    size_t N = 4;
    vector<int> vs(N, 1);
    vector<vector<double> > s(N, vector<double>(N, -1.0));
    vector<pair<int, int> >es;
    s[0][1] =  9;
    s[0][2] = 10;
    s[0][3] =  9;
    s[1][2] = 20;
    s[1][3] = 11;
    s[2][1] = 30;
    s[2][3] = 30;
    s[3][1] = 11;
    s[3][2] =  0;
    ChuLiuEdmonds(N, s, vs, &es);
    print_edges(es);
  }
  {
    size_t N = 8;
    vector<int> vs(N, 1);
    vector<vector<double> > s(N, vector<double>(N, -1.0));
    vector<pair<int, int> >es;
    s[0][1] =  1;
    s[0][2] =  3;
    s[0][3] =  1;
    s[1][2] =  2;
    s[1][4] =  5;
    s[2][5] = 10;
    s[3][2] =  1;
    s[3][7] =  8;
    s[4][2] = 10;
    s[5][4] = 10;
    s[5][7] = 20;
    s[6][5] = 20;
    s[7][6] = 20;
    ChuLiuEdmonds(N, s, vs, &es);
    print_edges(es);
  }
  {
    size_t N = 4;
    vector<int> vs(N, 1);
    vector<vector<double> > s(N, vector<double>(N, -1.0));
    vector<pair<int, int> >es;
    s[0][1] =  3;
    s[0][2] = 1.5;
    s[0][3] = 1.8;
    s[1][2] = 4.3;
    s[2][3] = 2.2;
    ChuLiuEdmonds(N, s, vs, &es);
    print_edges(es);
  }

}
