
/*
 * DO NOT EDIT THIS FILE BY HAND!
 *
 * All changes will be lost when file gets regenerated.
 *
 * Generated by optgen 0.5 from config file "options.conf"
 *
 * Copyright (c) 2018, Jyri J. Virkki
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef OPTGEN_H
#define OPTGEN_H

#include <stdlib.h>

//
// The following short options are NOT yet taken:
// ab..e.g.ijkl.no..rstu.w.yzABC.E.G..JK.MNOPQR.TU.W.YZ0123456789
//

#define COUNT_OPTIONS 43

// path (-p,--path) PATH : path where scanning will start
#define OPT_path 0

// nodb (--nodb) : deprecated
#define OPT_nodb 1

// stats_file (--stats-file) FILE : save stats to this file
#define OPT_stats_file 2

// minsize (-m,--minsize) SIZE : min size of files to scan
#define OPT_minsize 3

// hidden (--hidden) : include hidden files and dirs in scan
#define OPT_hidden 4

// hdd (-D,--hdd) : deprecated
#define OPT_hdd 5

// ssd (-S,--ssd) : deprecated
#define OPT_ssd 6

// buflimit (--buflimit) NAME : read buffer size cap
#define OPT_buflimit 7

// one_file_system (-X,--one-file-system) : for each path, stay in that filesystem
#define OPT_one_file_system 8

// hardlink_is_unique (-I,--hardlink-is-unique) : ignore hard links as duplicates
#define OPT_hardlink_is_unique 9

// file_count (--file-count) NUM : max estimated number of files to scan
#define OPT_file_count 10

// no_thread_scan (--no-thread-scan) : do scan phase in a single thread
#define OPT_no_thread_scan 11

// pathsep (--pathsep) CHAR : change internal path separator to CHAR
#define OPT_pathsep 12

// firstblocks (--firstblocks) N : max blocks to read in first hash pass
#define OPT_firstblocks 13

// firstblocksize (--firstblocksize) N : size of firstblocks to read
#define OPT_firstblocksize 14

// intblocks (--intblocks) N : blocks to read in intermediate hash
#define OPT_intblocks 15

// blocksize (--blocksize) N : size of regular blocks to read
#define OPT_blocksize 16

// fileblocksize (--fileblocksize) N : size of blocks to read in file compare
#define OPT_fileblocksize 17

// skip_two (--skip-two) : deprecated
#define OPT_skip_two 18

// skip_three (--skip-three) : deprecated
#define OPT_skip_three 19

// cmp_two (--cmp-two) : force direct comparison of two files
#define OPT_cmp_two 20

// cmp_three (--cmp-three) : deprecated
#define OPT_cmp_three 21

// uniques (--uniques) : deprecated
#define OPT_uniques 22

// avg_size (--avg-size) : deprecated
#define OPT_avg_size 23

// no_thread_hash (--no-thread-hash) : obsoleted
#define OPT_no_thread_hash 24

// sort_by (--sort-by) NAME : testing
#define OPT_sort_by 25

// x_nofie (--x-nofie) : testing
#define OPT_x_nofie 26

// cut (-c,--cut) PATHSEG : remove 'PATHSEG' from report paths
#define OPT_cut 27

// format (--format) NAME : report output format (text, csv, json)
#define OPT_format 28

// file (-f,--file) PATH : check this file
#define OPT_file 29

// exclude_path (-x,--exclude-path) PATH : ignore duplicates under this path
#define OPT_exclude_path 30

// link (-L,--link) : create symlinks for deleted files
#define OPT_link 31

// hardlink (-H,--hardlink) : create hard links for deleted files
#define OPT_hardlink 32

// hash (-F,--hash) NAME : specify alternate hash function
#define OPT_hash 33

// verbose (-v,--verbose) : increase verbosity (may be repeated for more)
#define OPT_verbose 34

// verbose_level (-V,--verbose-level) N : set verbosity level to N
#define OPT_verbose_level 35

// quiet (-q,--quiet) : quiet, supress all output except fatal errors
#define OPT_quiet 36

// db (-d,--db) PATH : path to dupd database file
#define OPT_db 37

// help (-h,--help) : show brief usage info
#define OPT_help 38

// no_unique (--no-unique) : ignore unique table even if present, for testing
#define OPT_no_unique 39

// x_small_buffers (--x-small-buffers) : for testing only, not useful otherwise
#define OPT_x_small_buffers 40

// x_testing (--x-testing) : for testing only, not useful otherwise
#define OPT_x_testing 41

// log_only (--log-only) : log only messages at chosen level
#define OPT_log_only 42

// scan: scan starting from the given path
#define COMMAND_scan 1

// refresh: remove deleted files from the database
#define COMMAND_refresh 2

// report: show duplicate report from last scan
#define COMMAND_report 3

// file: based on report, check for duplicates of one file
#define COMMAND_file 4

// uniques: based on report, look for unique files
#define COMMAND_uniques 5

// dups: based on report, look for duplicate files
#define COMMAND_dups 6

// ls: based on report, list info about every file seen
#define COMMAND_ls 7

// rmsh: create shell script to delete all duplicates
#define COMMAND_rmsh 8

// validate: revalidate all duplicates in db
#define COMMAND_validate 9

// help: show brief usage info
#define COMMAND_help 10

// usage: show more extensive documentation
#define COMMAND_usage 11

// man: show more extensive documentation
#define COMMAND_man 12

// license: show license info
#define COMMAND_license 13

// version: show version and exit
#define COMMAND_version 14

// testing: testing only, ignore
#define COMMAND_testing 15

// GLOBAL: 
#define COMMAND_GLOBAL 16

/**
 * Function to parse the arguments.
 *
 * Parameters:
 *   argc    - argv size (as passed to main)
 *   argv    - Arguments (as passed to main)
 *   command - Command (if present) will be stored here
 *   options - Caller-allocated array where option values will be stored
 *
 * Return:
 *   OPTGEN_OK on success
 *   OPTGEN_NONE if no arguments seen
 *   command will be set to OPTGEN_NO_COMMAND if no command given, or
 *     one of the COMMAND_* constants above.
 *   options array has an entry for each OPT_* index for each known option.
 *     The value of each OPT_* entry is one of:
 *       NULL if the option was not seen
 *       string value if the option had a value
 *       for options with no value, a string value of an integer
 *
 * Sample call:
 *
 *   char * options[COUNT_OPTIONS];
 *   int command;
 *
 *   int rv = optgen_parse(argc, argv, &command, options);
 *
 */
int optgen_parse(int argc, char * argv[], int * command, char * options[]);
#define OPTGEN_OK 0
#define OPTGEN_NONE 1
#define OPTGEN_NO_COMMAND -1

/**
 * Convenience function to get count of times an option was specified.
 * For options which take NO arguments but can be repeated multiple times,
 * this function returns the number of times it was seen
 *
 * Parameters:
 *   str - A value from options array
 *
 * Return:
 *
 *   Number of times an option was seen, or zero if none
 *
 */
int opt_count(char * str);

/**
 * Convenience function to return integer value of an option
 *
 * Parameters:
 *   str - A value from options array
 *   def - Default value if none given
 *
 * Return:
 *
 *   Value of option as integer. If NULL, returns default def.
 *
 */
int opt_int(char * str, int def);

/**
 * Convenience function to single char value of an option
 *
 * Parameters:
 *   str - A value from options array
 *   def - Default value if none given
 *
 * Return:
 *
 *   Value of option as char. If NULL, returns default def.
 *
 */
char opt_char(char * str, char def);

/**
 * Convenience function to string value of an option
 *
 * Parameters:
 *   str - A value from options array
 *   def - Default value if none given
 *
 * Return:
 *
 *   Value of option as char *. If NULL, returns default def.
 *
 */
char * opt_string(char * str, char * def);

/**
 * Show help based on command and option descriptions.
 *
 */
void opt_show_help();

// Callbacks need to return one of these values
#define OPTGEN_CALLBACK_OK 0
#define OPTGEN_CALLBACK_FAIL 1

#endif
