#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1323
#define LARGE_STATE_COUNT 355
#define SYMBOL_COUNT 306
#define ALIAS_COUNT 1
#define TOKEN_COUNT 135
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 37
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 238

enum {
  sym_identifier = 1,
  sym_decimal_integer_literal = 2,
  sym_hex_integer_literal = 3,
  sym_octal_integer_literal = 4,
  sym_binary_integer_literal = 5,
  sym_decimal_floating_point_literal = 6,
  sym_hex_floating_point_literal = 7,
  sym_true = 8,
  sym_false = 9,
  sym_character_literal = 10,
  anon_sym_DQUOTE = 11,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 12,
  sym_string_fragment = 13,
  aux_sym__multiline_string_fragment_token1 = 14,
  aux_sym__multiline_string_fragment_token2 = 15,
  aux_sym__escape_sequence_token1 = 16,
  sym_escape_sequence = 17,
  sym_null_literal = 18,
  anon_sym_LPAREN = 19,
  anon_sym_RPAREN = 20,
  anon_sym_AMP = 21,
  anon_sym_EQ = 22,
  anon_sym_PLUS_EQ = 23,
  anon_sym_DASH_EQ = 24,
  anon_sym_STAR_EQ = 25,
  anon_sym_SLASH_EQ = 26,
  anon_sym_AMP_EQ = 27,
  anon_sym_PIPE_EQ = 28,
  anon_sym_CARET_EQ = 29,
  anon_sym_PERCENT_EQ = 30,
  anon_sym_LT_LT_EQ = 31,
  anon_sym_GT_GT_EQ = 32,
  anon_sym_GT_GT_GT_EQ = 33,
  anon_sym_GT = 34,
  anon_sym_LT = 35,
  anon_sym_GT_EQ = 36,
  anon_sym_LT_EQ = 37,
  anon_sym_EQ_EQ = 38,
  anon_sym_BANG_EQ = 39,
  anon_sym_AMP_AMP = 40,
  anon_sym_PIPE_PIPE = 41,
  anon_sym_PLUS = 42,
  anon_sym_DASH = 43,
  anon_sym_STAR = 44,
  anon_sym_SLASH = 45,
  anon_sym_PIPE = 46,
  anon_sym_CARET = 47,
  anon_sym_PERCENT = 48,
  anon_sym_LT_LT = 49,
  anon_sym_GT_GT = 50,
  anon_sym_GT_GT_GT = 51,
  anon_sym_instanceof = 52,
  anon_sym_final = 53,
  anon_sym_DASH_GT = 54,
  anon_sym_COMMA = 55,
  anon_sym_QMARK = 56,
  anon_sym_COLON = 57,
  anon_sym_BANG = 58,
  anon_sym_TILDE = 59,
  anon_sym_PLUS_PLUS = 60,
  anon_sym_DASH_DASH = 61,
  anon_sym_new = 62,
  anon_sym_LBRACK = 63,
  anon_sym_RBRACK = 64,
  anon_sym_DOT = 65,
  anon_sym_class = 66,
  anon_sym_COLON_COLON = 67,
  anon_sym_extends = 68,
  anon_sym_switch = 69,
  anon_sym_LBRACE = 70,
  anon_sym_RBRACE = 71,
  anon_sym_case = 72,
  anon_sym_default = 73,
  anon_sym_SEMI = 74,
  anon_sym_assert = 75,
  anon_sym_do = 76,
  anon_sym_while = 77,
  anon_sym_break = 78,
  anon_sym_continue = 79,
  anon_sym_return = 80,
  anon_sym_yield = 81,
  anon_sym_synchronized = 82,
  anon_sym_throw = 83,
  anon_sym_try = 84,
  anon_sym_catch = 85,
  anon_sym_finally = 86,
  anon_sym_if = 87,
  anon_sym_else = 88,
  anon_sym_for = 89,
  anon_sym_AT = 90,
  anon_sym_open = 91,
  anon_sym_module = 92,
  anon_sym_requires = 93,
  anon_sym_transitive = 94,
  anon_sym_static = 95,
  anon_sym_exports = 96,
  anon_sym_to = 97,
  anon_sym_opens = 98,
  anon_sym_uses = 99,
  anon_sym_provides = 100,
  anon_sym_with = 101,
  anon_sym_package = 102,
  anon_sym_import = 103,
  anon_sym_enum = 104,
  anon_sym_public = 105,
  anon_sym_protected = 106,
  anon_sym_private = 107,
  anon_sym_abstract = 108,
  anon_sym_strictfp = 109,
  anon_sym_native = 110,
  anon_sym_transient = 111,
  anon_sym_volatile = 112,
  anon_sym_sealed = 113,
  anon_sym_non_DASHsealed = 114,
  anon_sym_implements = 115,
  anon_sym_permits = 116,
  anon_sym_record = 117,
  anon_sym_ATinterface = 118,
  anon_sym_interface = 119,
  anon_sym_byte = 120,
  anon_sym_short = 121,
  anon_sym_int = 122,
  anon_sym_long = 123,
  anon_sym_char = 124,
  anon_sym_float = 125,
  anon_sym_double = 126,
  sym_boolean_type = 127,
  sym_void_type = 128,
  anon_sym_DOT_DOT_DOT = 129,
  anon_sym_throws = 130,
  sym_this = 131,
  sym_super = 132,
  sym_line_comment = 133,
  sym_block_comment = 134,
  sym_program = 135,
  sym__literal = 136,
  sym_string_literal = 137,
  sym__string_literal = 138,
  sym__multiline_string_literal = 139,
  sym__multiline_string_fragment = 140,
  sym__escape_sequence = 141,
  sym_expression = 142,
  sym_cast_expression = 143,
  sym_assignment_expression = 144,
  sym_binary_expression = 145,
  sym_instanceof_expression = 146,
  sym_lambda_expression = 147,
  sym_inferred_parameters = 148,
  sym_ternary_expression = 149,
  sym_unary_expression = 150,
  sym_update_expression = 151,
  sym_primary_expression = 152,
  sym_array_creation_expression = 153,
  sym_dimensions_expr = 154,
  sym_parenthesized_expression = 155,
  sym_condition = 156,
  sym_class_literal = 157,
  sym_object_creation_expression = 158,
  sym__unqualified_object_creation_expression = 159,
  sym_field_access = 160,
  sym_array_access = 161,
  sym_method_invocation = 162,
  sym_argument_list = 163,
  sym_method_reference = 164,
  sym_type_arguments = 165,
  sym_wildcard = 166,
  sym__wildcard_bounds = 167,
  sym_dimensions = 168,
  sym_switch_expression = 169,
  sym_switch_block = 170,
  sym_switch_block_statement_group = 171,
  sym_switch_rule = 172,
  sym_switch_label = 173,
  sym_statement = 174,
  sym_block = 175,
  sym_expression_statement = 176,
  sym_labeled_statement = 177,
  sym_assert_statement = 178,
  sym_do_statement = 179,
  sym_break_statement = 180,
  sym_continue_statement = 181,
  sym_return_statement = 182,
  sym_yield_statement = 183,
  sym_synchronized_statement = 184,
  sym_throw_statement = 185,
  sym_try_statement = 186,
  sym_catch_clause = 187,
  sym_catch_formal_parameter = 188,
  sym_catch_type = 189,
  sym_finally_clause = 190,
  sym_try_with_resources_statement = 191,
  sym_resource_specification = 192,
  sym_resource = 193,
  sym_if_statement = 194,
  sym_while_statement = 195,
  sym_for_statement = 196,
  sym_enhanced_for_statement = 197,
  sym__annotation = 198,
  sym_marker_annotation = 199,
  sym_annotation = 200,
  sym_annotation_argument_list = 201,
  sym_element_value_pair = 202,
  sym__element_value = 203,
  sym_element_value_array_initializer = 204,
  sym_declaration = 205,
  sym_module_declaration = 206,
  sym_module_body = 207,
  sym_module_directive = 208,
  sym_requires_module_directive = 209,
  sym_requires_modifier = 210,
  sym_exports_module_directive = 211,
  sym_opens_module_directive = 212,
  sym_uses_module_directive = 213,
  sym_provides_module_directive = 214,
  sym_package_declaration = 215,
  sym_import_declaration = 216,
  sym_asterisk = 217,
  sym_enum_declaration = 218,
  sym_enum_body = 219,
  sym_enum_body_declarations = 220,
  sym_enum_constant = 221,
  sym_class_declaration = 222,
  sym_modifiers = 223,
  sym_type_parameters = 224,
  sym_type_parameter = 225,
  sym_type_bound = 226,
  sym_superclass = 227,
  sym_super_interfaces = 228,
  sym_type_list = 229,
  sym_permits = 230,
  sym_class_body = 231,
  sym_static_initializer = 232,
  sym_constructor_declaration = 233,
  sym__constructor_declarator = 234,
  sym_constructor_body = 235,
  sym_explicit_constructor_invocation = 236,
  sym_scoped_identifier = 237,
  sym_field_declaration = 238,
  sym_record_declaration = 239,
  sym_annotation_type_declaration = 240,
  sym_annotation_type_body = 241,
  sym_annotation_type_element_declaration = 242,
  sym__default_value = 243,
  sym_interface_declaration = 244,
  sym_extends_interfaces = 245,
  sym_interface_body = 246,
  sym_constant_declaration = 247,
  sym__variable_declarator_list = 248,
  sym_variable_declarator = 249,
  sym__variable_declarator_id = 250,
  sym_array_initializer = 251,
  sym__type = 252,
  sym__unannotated_type = 253,
  sym_annotated_type = 254,
  sym_scoped_type_identifier = 255,
  sym_generic_type = 256,
  sym_array_type = 257,
  sym_integral_type = 258,
  sym_floating_point_type = 259,
  sym__method_header = 260,
  sym__method_declarator = 261,
  sym_formal_parameters = 262,
  sym_formal_parameter = 263,
  sym_receiver_parameter = 264,
  sym_spread_parameter = 265,
  sym_throws = 266,
  sym_local_variable_declaration = 267,
  sym_method_declaration = 268,
  sym_compact_constructor_declaration = 269,
  aux_sym_program_repeat1 = 270,
  aux_sym__string_literal_repeat1 = 271,
  aux_sym__multiline_string_literal_repeat1 = 272,
  aux_sym__multiline_string_fragment_repeat1 = 273,
  aux_sym_cast_expression_repeat1 = 274,
  aux_sym_inferred_parameters_repeat1 = 275,
  aux_sym_array_creation_expression_repeat1 = 276,
  aux_sym_array_creation_expression_repeat2 = 277,
  aux_sym_argument_list_repeat1 = 278,
  aux_sym_type_arguments_repeat1 = 279,
  aux_sym_dimensions_repeat1 = 280,
  aux_sym_switch_block_repeat1 = 281,
  aux_sym_switch_block_repeat2 = 282,
  aux_sym_switch_block_statement_group_repeat1 = 283,
  aux_sym_try_statement_repeat1 = 284,
  aux_sym_catch_type_repeat1 = 285,
  aux_sym_resource_specification_repeat1 = 286,
  aux_sym_for_statement_repeat1 = 287,
  aux_sym_for_statement_repeat2 = 288,
  aux_sym_annotation_argument_list_repeat1 = 289,
  aux_sym_element_value_array_initializer_repeat1 = 290,
  aux_sym_module_body_repeat1 = 291,
  aux_sym_requires_module_directive_repeat1 = 292,
  aux_sym_exports_module_directive_repeat1 = 293,
  aux_sym_provides_module_directive_repeat1 = 294,
  aux_sym_enum_body_repeat1 = 295,
  aux_sym_enum_body_declarations_repeat1 = 296,
  aux_sym_modifiers_repeat1 = 297,
  aux_sym_type_parameters_repeat1 = 298,
  aux_sym_type_bound_repeat1 = 299,
  aux_sym_type_list_repeat1 = 300,
  aux_sym_annotation_type_body_repeat1 = 301,
  aux_sym_interface_body_repeat1 = 302,
  aux_sym__variable_declarator_list_repeat1 = 303,
  aux_sym_array_initializer_repeat1 = 304,
  aux_sym_formal_parameters_repeat1 = 305,
  alias_sym_type_identifier = 306,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_decimal_integer_literal] = "decimal_integer_literal",
  [sym_hex_integer_literal] = "hex_integer_literal",
  [sym_octal_integer_literal] = "octal_integer_literal",
  [sym_binary_integer_literal] = "binary_integer_literal",
  [sym_decimal_floating_point_literal] = "decimal_floating_point_literal",
  [sym_hex_floating_point_literal] = "hex_floating_point_literal",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_character_literal] = "character_literal",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "\"\"\"",
  [sym_string_fragment] = "string_fragment",
  [aux_sym__multiline_string_fragment_token1] = "_multiline_string_fragment_token1",
  [aux_sym__multiline_string_fragment_token2] = "_multiline_string_fragment_token2",
  [aux_sym__escape_sequence_token1] = "_escape_sequence_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_null_literal] = "null_literal",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_AMP] = "&",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_final] = "final",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_COMMA] = ",",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_new] = "new",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_extends] = "extends",
  [anon_sym_switch] = "switch",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_SEMI] = ";",
  [anon_sym_assert] = "assert",
  [anon_sym_do] = "do",
  [anon_sym_while] = "while",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_return] = "return",
  [anon_sym_yield] = "yield",
  [anon_sym_synchronized] = "synchronized",
  [anon_sym_throw] = "throw",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_AT] = "@",
  [anon_sym_open] = "open",
  [anon_sym_module] = "module",
  [anon_sym_requires] = "requires",
  [anon_sym_transitive] = "transitive",
  [anon_sym_static] = "static",
  [anon_sym_exports] = "exports",
  [anon_sym_to] = "to",
  [anon_sym_opens] = "opens",
  [anon_sym_uses] = "uses",
  [anon_sym_provides] = "provides",
  [anon_sym_with] = "with",
  [anon_sym_package] = "package",
  [anon_sym_import] = "import",
  [anon_sym_enum] = "enum",
  [anon_sym_public] = "public",
  [anon_sym_protected] = "protected",
  [anon_sym_private] = "private",
  [anon_sym_abstract] = "abstract",
  [anon_sym_strictfp] = "strictfp",
  [anon_sym_native] = "native",
  [anon_sym_transient] = "transient",
  [anon_sym_volatile] = "volatile",
  [anon_sym_sealed] = "sealed",
  [anon_sym_non_DASHsealed] = "non-sealed",
  [anon_sym_implements] = "implements",
  [anon_sym_permits] = "permits",
  [anon_sym_record] = "record",
  [anon_sym_ATinterface] = "@interface",
  [anon_sym_interface] = "interface",
  [anon_sym_byte] = "byte",
  [anon_sym_short] = "short",
  [anon_sym_int] = "int",
  [anon_sym_long] = "long",
  [anon_sym_char] = "char",
  [anon_sym_float] = "float",
  [anon_sym_double] = "double",
  [sym_boolean_type] = "boolean_type",
  [sym_void_type] = "void_type",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_throws] = "throws",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_line_comment] = "line_comment",
  [sym_block_comment] = "block_comment",
  [sym_program] = "program",
  [sym__literal] = "_literal",
  [sym_string_literal] = "string_literal",
  [sym__string_literal] = "_string_literal",
  [sym__multiline_string_literal] = "_multiline_string_literal",
  [sym__multiline_string_fragment] = "multiline_string_fragment",
  [sym__escape_sequence] = "_escape_sequence",
  [sym_expression] = "expression",
  [sym_cast_expression] = "cast_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_instanceof_expression] = "instanceof_expression",
  [sym_lambda_expression] = "lambda_expression",
  [sym_inferred_parameters] = "inferred_parameters",
  [sym_ternary_expression] = "ternary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_primary_expression] = "primary_expression",
  [sym_array_creation_expression] = "array_creation_expression",
  [sym_dimensions_expr] = "dimensions_expr",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_condition] = "condition",
  [sym_class_literal] = "class_literal",
  [sym_object_creation_expression] = "object_creation_expression",
  [sym__unqualified_object_creation_expression] = "_unqualified_object_creation_expression",
  [sym_field_access] = "field_access",
  [sym_array_access] = "array_access",
  [sym_method_invocation] = "method_invocation",
  [sym_argument_list] = "argument_list",
  [sym_method_reference] = "method_reference",
  [sym_type_arguments] = "type_arguments",
  [sym_wildcard] = "wildcard",
  [sym__wildcard_bounds] = "_wildcard_bounds",
  [sym_dimensions] = "dimensions",
  [sym_switch_expression] = "switch_expression",
  [sym_switch_block] = "switch_block",
  [sym_switch_block_statement_group] = "switch_block_statement_group",
  [sym_switch_rule] = "switch_rule",
  [sym_switch_label] = "switch_label",
  [sym_statement] = "statement",
  [sym_block] = "block",
  [sym_expression_statement] = "expression_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_assert_statement] = "assert_statement",
  [sym_do_statement] = "do_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_return_statement] = "return_statement",
  [sym_yield_statement] = "yield_statement",
  [sym_synchronized_statement] = "synchronized_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_catch_formal_parameter] = "catch_formal_parameter",
  [sym_catch_type] = "catch_type",
  [sym_finally_clause] = "finally_clause",
  [sym_try_with_resources_statement] = "try_with_resources_statement",
  [sym_resource_specification] = "resource_specification",
  [sym_resource] = "resource",
  [sym_if_statement] = "if_statement",
  [sym_while_statement] = "while_statement",
  [sym_for_statement] = "for_statement",
  [sym_enhanced_for_statement] = "enhanced_for_statement",
  [sym__annotation] = "_annotation",
  [sym_marker_annotation] = "marker_annotation",
  [sym_annotation] = "annotation",
  [sym_annotation_argument_list] = "annotation_argument_list",
  [sym_element_value_pair] = "element_value_pair",
  [sym__element_value] = "_element_value",
  [sym_element_value_array_initializer] = "element_value_array_initializer",
  [sym_declaration] = "declaration",
  [sym_module_declaration] = "module_declaration",
  [sym_module_body] = "module_body",
  [sym_module_directive] = "module_directive",
  [sym_requires_module_directive] = "requires_module_directive",
  [sym_requires_modifier] = "requires_modifier",
  [sym_exports_module_directive] = "exports_module_directive",
  [sym_opens_module_directive] = "opens_module_directive",
  [sym_uses_module_directive] = "uses_module_directive",
  [sym_provides_module_directive] = "provides_module_directive",
  [sym_package_declaration] = "package_declaration",
  [sym_import_declaration] = "import_declaration",
  [sym_asterisk] = "asterisk",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_body_declarations] = "enum_body_declarations",
  [sym_enum_constant] = "enum_constant",
  [sym_class_declaration] = "class_declaration",
  [sym_modifiers] = "modifiers",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_bound] = "type_bound",
  [sym_superclass] = "superclass",
  [sym_super_interfaces] = "super_interfaces",
  [sym_type_list] = "type_list",
  [sym_permits] = "permits",
  [sym_class_body] = "class_body",
  [sym_static_initializer] = "static_initializer",
  [sym_constructor_declaration] = "constructor_declaration",
  [sym__constructor_declarator] = "_constructor_declarator",
  [sym_constructor_body] = "constructor_body",
  [sym_explicit_constructor_invocation] = "explicit_constructor_invocation",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_field_declaration] = "field_declaration",
  [sym_record_declaration] = "record_declaration",
  [sym_annotation_type_declaration] = "annotation_type_declaration",
  [sym_annotation_type_body] = "annotation_type_body",
  [sym_annotation_type_element_declaration] = "annotation_type_element_declaration",
  [sym__default_value] = "_default_value",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_interfaces] = "extends_interfaces",
  [sym_interface_body] = "interface_body",
  [sym_constant_declaration] = "constant_declaration",
  [sym__variable_declarator_list] = "_variable_declarator_list",
  [sym_variable_declarator] = "variable_declarator",
  [sym__variable_declarator_id] = "_variable_declarator_id",
  [sym_array_initializer] = "array_initializer",
  [sym__type] = "_type",
  [sym__unannotated_type] = "_unannotated_type",
  [sym_annotated_type] = "annotated_type",
  [sym_scoped_type_identifier] = "scoped_type_identifier",
  [sym_generic_type] = "generic_type",
  [sym_array_type] = "array_type",
  [sym_integral_type] = "integral_type",
  [sym_floating_point_type] = "floating_point_type",
  [sym__method_header] = "_method_header",
  [sym__method_declarator] = "_method_declarator",
  [sym_formal_parameters] = "formal_parameters",
  [sym_formal_parameter] = "formal_parameter",
  [sym_receiver_parameter] = "receiver_parameter",
  [sym_spread_parameter] = "spread_parameter",
  [sym_throws] = "throws",
  [sym_local_variable_declaration] = "local_variable_declaration",
  [sym_method_declaration] = "method_declaration",
  [sym_compact_constructor_declaration] = "compact_constructor_declaration",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym__string_literal_repeat1] = "_string_literal_repeat1",
  [aux_sym__multiline_string_literal_repeat1] = "_multiline_string_literal_repeat1",
  [aux_sym__multiline_string_fragment_repeat1] = "_multiline_string_fragment_repeat1",
  [aux_sym_cast_expression_repeat1] = "cast_expression_repeat1",
  [aux_sym_inferred_parameters_repeat1] = "inferred_parameters_repeat1",
  [aux_sym_array_creation_expression_repeat1] = "array_creation_expression_repeat1",
  [aux_sym_array_creation_expression_repeat2] = "array_creation_expression_repeat2",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_dimensions_repeat1] = "dimensions_repeat1",
  [aux_sym_switch_block_repeat1] = "switch_block_repeat1",
  [aux_sym_switch_block_repeat2] = "switch_block_repeat2",
  [aux_sym_switch_block_statement_group_repeat1] = "switch_block_statement_group_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_catch_type_repeat1] = "catch_type_repeat1",
  [aux_sym_resource_specification_repeat1] = "resource_specification_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_for_statement_repeat2] = "for_statement_repeat2",
  [aux_sym_annotation_argument_list_repeat1] = "annotation_argument_list_repeat1",
  [aux_sym_element_value_array_initializer_repeat1] = "element_value_array_initializer_repeat1",
  [aux_sym_module_body_repeat1] = "module_body_repeat1",
  [aux_sym_requires_module_directive_repeat1] = "requires_module_directive_repeat1",
  [aux_sym_exports_module_directive_repeat1] = "exports_module_directive_repeat1",
  [aux_sym_provides_module_directive_repeat1] = "provides_module_directive_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_enum_body_declarations_repeat1] = "enum_body_declarations_repeat1",
  [aux_sym_modifiers_repeat1] = "modifiers_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_type_bound_repeat1] = "type_bound_repeat1",
  [aux_sym_type_list_repeat1] = "type_list_repeat1",
  [aux_sym_annotation_type_body_repeat1] = "annotation_type_body_repeat1",
  [aux_sym_interface_body_repeat1] = "interface_body_repeat1",
  [aux_sym__variable_declarator_list_repeat1] = "_variable_declarator_list_repeat1",
  [aux_sym_array_initializer_repeat1] = "array_initializer_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_decimal_integer_literal] = sym_decimal_integer_literal,
  [sym_hex_integer_literal] = sym_hex_integer_literal,
  [sym_octal_integer_literal] = sym_octal_integer_literal,
  [sym_binary_integer_literal] = sym_binary_integer_literal,
  [sym_decimal_floating_point_literal] = sym_decimal_floating_point_literal,
  [sym_hex_floating_point_literal] = sym_hex_floating_point_literal,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_character_literal] = sym_character_literal,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [sym_string_fragment] = sym_string_fragment,
  [aux_sym__multiline_string_fragment_token1] = aux_sym__multiline_string_fragment_token1,
  [aux_sym__multiline_string_fragment_token2] = aux_sym__multiline_string_fragment_token2,
  [aux_sym__escape_sequence_token1] = aux_sym__escape_sequence_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_null_literal] = sym_null_literal,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_synchronized] = anon_sym_synchronized,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_open] = anon_sym_open,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_requires] = anon_sym_requires,
  [anon_sym_transitive] = anon_sym_transitive,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_exports] = anon_sym_exports,
  [anon_sym_to] = anon_sym_to,
  [anon_sym_opens] = anon_sym_opens,
  [anon_sym_uses] = anon_sym_uses,
  [anon_sym_provides] = anon_sym_provides,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_strictfp] = anon_sym_strictfp,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_transient] = anon_sym_transient,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_sealed] = anon_sym_sealed,
  [anon_sym_non_DASHsealed] = anon_sym_non_DASHsealed,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_permits] = anon_sym_permits,
  [anon_sym_record] = anon_sym_record,
  [anon_sym_ATinterface] = anon_sym_ATinterface,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_char] = anon_sym_char,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_double] = anon_sym_double,
  [sym_boolean_type] = sym_boolean_type,
  [sym_void_type] = sym_void_type,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_throws] = anon_sym_throws,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_line_comment] = sym_line_comment,
  [sym_block_comment] = sym_block_comment,
  [sym_program] = sym_program,
  [sym__literal] = sym__literal,
  [sym_string_literal] = sym_string_literal,
  [sym__string_literal] = sym__string_literal,
  [sym__multiline_string_literal] = sym__multiline_string_literal,
  [sym__multiline_string_fragment] = sym__multiline_string_fragment,
  [sym__escape_sequence] = sym__escape_sequence,
  [sym_expression] = sym_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_instanceof_expression] = sym_instanceof_expression,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_inferred_parameters] = sym_inferred_parameters,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_array_creation_expression] = sym_array_creation_expression,
  [sym_dimensions_expr] = sym_dimensions_expr,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_condition] = sym_condition,
  [sym_class_literal] = sym_class_literal,
  [sym_object_creation_expression] = sym_object_creation_expression,
  [sym__unqualified_object_creation_expression] = sym__unqualified_object_creation_expression,
  [sym_field_access] = sym_field_access,
  [sym_array_access] = sym_array_access,
  [sym_method_invocation] = sym_method_invocation,
  [sym_argument_list] = sym_argument_list,
  [sym_method_reference] = sym_method_reference,
  [sym_type_arguments] = sym_type_arguments,
  [sym_wildcard] = sym_wildcard,
  [sym__wildcard_bounds] = sym__wildcard_bounds,
  [sym_dimensions] = sym_dimensions,
  [sym_switch_expression] = sym_switch_expression,
  [sym_switch_block] = sym_switch_block,
  [sym_switch_block_statement_group] = sym_switch_block_statement_group,
  [sym_switch_rule] = sym_switch_rule,
  [sym_switch_label] = sym_switch_label,
  [sym_statement] = sym_statement,
  [sym_block] = sym_block,
  [sym_expression_statement] = sym_expression_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_assert_statement] = sym_assert_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_yield_statement] = sym_yield_statement,
  [sym_synchronized_statement] = sym_synchronized_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_catch_formal_parameter] = sym_catch_formal_parameter,
  [sym_catch_type] = sym_catch_type,
  [sym_finally_clause] = sym_finally_clause,
  [sym_try_with_resources_statement] = sym_try_with_resources_statement,
  [sym_resource_specification] = sym_resource_specification,
  [sym_resource] = sym_resource,
  [sym_if_statement] = sym_if_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_enhanced_for_statement] = sym_enhanced_for_statement,
  [sym__annotation] = sym__annotation,
  [sym_marker_annotation] = sym_marker_annotation,
  [sym_annotation] = sym_annotation,
  [sym_annotation_argument_list] = sym_annotation_argument_list,
  [sym_element_value_pair] = sym_element_value_pair,
  [sym__element_value] = sym__element_value,
  [sym_element_value_array_initializer] = sym_element_value_array_initializer,
  [sym_declaration] = sym_declaration,
  [sym_module_declaration] = sym_module_declaration,
  [sym_module_body] = sym_module_body,
  [sym_module_directive] = sym_module_directive,
  [sym_requires_module_directive] = sym_requires_module_directive,
  [sym_requires_modifier] = sym_requires_modifier,
  [sym_exports_module_directive] = sym_exports_module_directive,
  [sym_opens_module_directive] = sym_opens_module_directive,
  [sym_uses_module_directive] = sym_uses_module_directive,
  [sym_provides_module_directive] = sym_provides_module_directive,
  [sym_package_declaration] = sym_package_declaration,
  [sym_import_declaration] = sym_import_declaration,
  [sym_asterisk] = sym_asterisk,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_body_declarations] = sym_enum_body_declarations,
  [sym_enum_constant] = sym_enum_constant,
  [sym_class_declaration] = sym_class_declaration,
  [sym_modifiers] = sym_modifiers,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_bound] = sym_type_bound,
  [sym_superclass] = sym_superclass,
  [sym_super_interfaces] = sym_super_interfaces,
  [sym_type_list] = sym_type_list,
  [sym_permits] = sym_permits,
  [sym_class_body] = sym_class_body,
  [sym_static_initializer] = sym_static_initializer,
  [sym_constructor_declaration] = sym_constructor_declaration,
  [sym__constructor_declarator] = sym__constructor_declarator,
  [sym_constructor_body] = sym_constructor_body,
  [sym_explicit_constructor_invocation] = sym_explicit_constructor_invocation,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_field_declaration] = sym_field_declaration,
  [sym_record_declaration] = sym_record_declaration,
  [sym_annotation_type_declaration] = sym_annotation_type_declaration,
  [sym_annotation_type_body] = sym_annotation_type_body,
  [sym_annotation_type_element_declaration] = sym_annotation_type_element_declaration,
  [sym__default_value] = sym__default_value,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_interfaces] = sym_extends_interfaces,
  [sym_interface_body] = sym_interface_body,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym__variable_declarator_list] = sym__variable_declarator_list,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym__variable_declarator_id] = sym__variable_declarator_id,
  [sym_array_initializer] = sym_array_initializer,
  [sym__type] = sym__type,
  [sym__unannotated_type] = sym__unannotated_type,
  [sym_annotated_type] = sym_annotated_type,
  [sym_scoped_type_identifier] = sym_scoped_type_identifier,
  [sym_generic_type] = sym_generic_type,
  [sym_array_type] = sym_array_type,
  [sym_integral_type] = sym_integral_type,
  [sym_floating_point_type] = sym_floating_point_type,
  [sym__method_header] = sym__method_header,
  [sym__method_declarator] = sym__method_declarator,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_formal_parameter] = sym_formal_parameter,
  [sym_receiver_parameter] = sym_receiver_parameter,
  [sym_spread_parameter] = sym_spread_parameter,
  [sym_throws] = sym_throws,
  [sym_local_variable_declaration] = sym_local_variable_declaration,
  [sym_method_declaration] = sym_method_declaration,
  [sym_compact_constructor_declaration] = sym_compact_constructor_declaration,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym__string_literal_repeat1] = aux_sym__string_literal_repeat1,
  [aux_sym__multiline_string_literal_repeat1] = aux_sym__multiline_string_literal_repeat1,
  [aux_sym__multiline_string_fragment_repeat1] = aux_sym__multiline_string_fragment_repeat1,
  [aux_sym_cast_expression_repeat1] = aux_sym_cast_expression_repeat1,
  [aux_sym_inferred_parameters_repeat1] = aux_sym_inferred_parameters_repeat1,
  [aux_sym_array_creation_expression_repeat1] = aux_sym_array_creation_expression_repeat1,
  [aux_sym_array_creation_expression_repeat2] = aux_sym_array_creation_expression_repeat2,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_dimensions_repeat1] = aux_sym_dimensions_repeat1,
  [aux_sym_switch_block_repeat1] = aux_sym_switch_block_repeat1,
  [aux_sym_switch_block_repeat2] = aux_sym_switch_block_repeat2,
  [aux_sym_switch_block_statement_group_repeat1] = aux_sym_switch_block_statement_group_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_catch_type_repeat1] = aux_sym_catch_type_repeat1,
  [aux_sym_resource_specification_repeat1] = aux_sym_resource_specification_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_for_statement_repeat2] = aux_sym_for_statement_repeat2,
  [aux_sym_annotation_argument_list_repeat1] = aux_sym_annotation_argument_list_repeat1,
  [aux_sym_element_value_array_initializer_repeat1] = aux_sym_element_value_array_initializer_repeat1,
  [aux_sym_module_body_repeat1] = aux_sym_module_body_repeat1,
  [aux_sym_requires_module_directive_repeat1] = aux_sym_requires_module_directive_repeat1,
  [aux_sym_exports_module_directive_repeat1] = aux_sym_exports_module_directive_repeat1,
  [aux_sym_provides_module_directive_repeat1] = aux_sym_provides_module_directive_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_enum_body_declarations_repeat1] = aux_sym_enum_body_declarations_repeat1,
  [aux_sym_modifiers_repeat1] = aux_sym_modifiers_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_type_bound_repeat1] = aux_sym_type_bound_repeat1,
  [aux_sym_type_list_repeat1] = aux_sym_type_list_repeat1,
  [aux_sym_annotation_type_body_repeat1] = aux_sym_annotation_type_body_repeat1,
  [aux_sym_interface_body_repeat1] = aux_sym_interface_body_repeat1,
  [aux_sym__variable_declarator_list_repeat1] = aux_sym__variable_declarator_list_repeat1,
  [aux_sym_array_initializer_repeat1] = aux_sym_array_initializer_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_octal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_character_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__multiline_string_fragment_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiline_string_fragment_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_null_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_synchronized] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_requires] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transitive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exports] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_to] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_opens] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uses] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_provides] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sealed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_non_DASHsealed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_permits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_record] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATinterface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_char] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double] = {
    .visible = true,
    .named = false,
  },
  [sym_boolean_type] = {
    .visible = true,
    .named = true,
  },
  [sym_void_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throws] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__multiline_string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__multiline_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym__escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instanceof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_inferred_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_array_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dimensions_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_class_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_object_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__unqualified_object_creation_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym_array_access] = {
    .visible = true,
    .named = true,
  },
  [sym_method_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_method_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [sym__wildcard_bounds] = {
    .visible = false,
    .named = true,
  },
  [sym_dimensions] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block_statement_group] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_label] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yield_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_synchronized_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_type] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_try_with_resources_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_resource_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_resource] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_enhanced_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_marker_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_element_value_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__element_value] = {
    .visible = false,
    .named = true,
  },
  [sym_element_value_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module_body] = {
    .visible = true,
    .named = true,
  },
  [sym_module_directive] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_requires_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_requires_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_exports_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_opens_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_uses_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_provides_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_package_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body_declarations] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_superclass] = {
    .visible = true,
    .named = true,
  },
  [sym_super_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_type_list] = {
    .visible = true,
    .named = true,
  },
  [sym_permits] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_static_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_body] = {
    .visible = true,
    .named = true,
  },
  [sym_explicit_constructor_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_record_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_body] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_element_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__default_value] = {
    .visible = false,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_list] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_id] = {
    .visible = false,
    .named = true,
  },
  [sym_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__unannotated_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_annotated_type] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_integral_type] = {
    .visible = true,
    .named = true,
  },
  [sym_floating_point_type] = {
    .visible = true,
    .named = true,
  },
  [sym__method_header] = {
    .visible = false,
    .named = true,
  },
  [sym__method_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_receiver_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_throws] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_compact_constructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiline_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiline_string_fragment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cast_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inferred_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_creation_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_creation_expression_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_statement_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_catch_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_resource_specification_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_element_value_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_requires_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_exports_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_provides_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_bound_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_type_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_declarator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_array = 3,
  field_body = 4,
  field_condition = 5,
  field_consequence = 6,
  field_constructor = 7,
  field_declarator = 8,
  field_dimensions = 9,
  field_element = 10,
  field_field = 11,
  field_index = 12,
  field_init = 13,
  field_interfaces = 14,
  field_key = 15,
  field_left = 16,
  field_modifiers = 17,
  field_module = 18,
  field_modules = 19,
  field_name = 20,
  field_object = 21,
  field_operand = 22,
  field_operator = 23,
  field_package = 24,
  field_parameters = 25,
  field_permits = 26,
  field_provided = 27,
  field_provider = 28,
  field_resources = 29,
  field_right = 30,
  field_scope = 31,
  field_superclass = 32,
  field_type = 33,
  field_type_arguments = 34,
  field_type_parameters = 35,
  field_update = 36,
  field_value = 37,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_array] = "array",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declarator] = "declarator",
  [field_dimensions] = "dimensions",
  [field_element] = "element",
  [field_field] = "field",
  [field_index] = "index",
  [field_init] = "init",
  [field_interfaces] = "interfaces",
  [field_key] = "key",
  [field_left] = "left",
  [field_modifiers] = "modifiers",
  [field_module] = "module",
  [field_modules] = "modules",
  [field_name] = "name",
  [field_object] = "object",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_package] = "package",
  [field_parameters] = "parameters",
  [field_permits] = "permits",
  [field_provided] = "provided",
  [field_provider] = "provider",
  [field_resources] = "resources",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_superclass] = "superclass",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 3},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 8, .length = 1},
  [11] = {.index = 9, .length = 2},
  [12] = {.index = 11, .length = 1},
  [13] = {.index = 12, .length = 2},
  [15] = {.index = 14, .length = 3},
  [16] = {.index = 17, .length = 2},
  [17] = {.index = 19, .length = 2},
  [18] = {.index = 17, .length = 2},
  [19] = {.index = 19, .length = 2},
  [20] = {.index = 21, .length = 2},
  [21] = {.index = 23, .length = 2},
  [22] = {.index = 25, .length = 1},
  [23] = {.index = 26, .length = 1},
  [24] = {.index = 27, .length = 2},
  [25] = {.index = 29, .length = 2},
  [26] = {.index = 31, .length = 2},
  [27] = {.index = 31, .length = 2},
  [28] = {.index = 33, .length = 3},
  [29] = {.index = 36, .length = 2},
  [30] = {.index = 21, .length = 2},
  [31] = {.index = 38, .length = 2},
  [32] = {.index = 38, .length = 2},
  [33] = {.index = 33, .length = 3},
  [34] = {.index = 36, .length = 2},
  [36] = {.index = 40, .length = 2},
  [37] = {.index = 42, .length = 3},
  [38] = {.index = 45, .length = 2},
  [39] = {.index = 45, .length = 2},
  [40] = {.index = 47, .length = 2},
  [41] = {.index = 49, .length = 2},
  [43] = {.index = 51, .length = 3},
  [44] = {.index = 54, .length = 2},
  [45] = {.index = 56, .length = 1},
  [46] = {.index = 57, .length = 2},
  [47] = {.index = 59, .length = 3},
  [48] = {.index = 62, .length = 3},
  [49] = {.index = 59, .length = 3},
  [50] = {.index = 62, .length = 3},
  [51] = {.index = 65, .length = 3},
  [52] = {.index = 65, .length = 3},
  [53] = {.index = 68, .length = 2},
  [54] = {.index = 68, .length = 2},
  [55] = {.index = 70, .length = 3},
  [56] = {.index = 73, .length = 3},
  [57] = {.index = 76, .length = 3},
  [58] = {.index = 79, .length = 3},
  [59] = {.index = 82, .length = 2},
  [60] = {.index = 82, .length = 2},
  [61] = {.index = 84, .length = 2},
  [62] = {.index = 84, .length = 2},
  [64] = {.index = 86, .length = 3},
  [65] = {.index = 89, .length = 2},
  [66] = {.index = 91, .length = 3},
  [67] = {.index = 91, .length = 3},
  [69] = {.index = 94, .length = 2},
  [70] = {.index = 96, .length = 3},
  [71] = {.index = 96, .length = 3},
  [72] = {.index = 99, .length = 2},
  [73] = {.index = 101, .length = 2},
  [74] = {.index = 103, .length = 1},
  [75] = {.index = 104, .length = 2},
  [76] = {.index = 106, .length = 3},
  [78] = {.index = 109, .length = 3},
  [79] = {.index = 112, .length = 3},
  [80] = {.index = 115, .length = 3},
  [81] = {.index = 112, .length = 3},
  [82] = {.index = 115, .length = 3},
  [84] = {.index = 118, .length = 2},
  [85] = {.index = 120, .length = 2},
  [86] = {.index = 122, .length = 4},
  [87] = {.index = 126, .length = 4},
  [88] = {.index = 130, .length = 5},
  [89] = {.index = 135, .length = 6},
  [90] = {.index = 141, .length = 4},
  [91] = {.index = 145, .length = 4},
  [92] = {.index = 149, .length = 4},
  [93] = {.index = 153, .length = 4},
  [94] = {.index = 157, .length = 4},
  [95] = {.index = 161, .length = 4},
  [96] = {.index = 165, .length = 2},
  [97] = {.index = 167, .length = 3},
  [98] = {.index = 170, .length = 1},
  [99] = {.index = 171, .length = 2},
  [100] = {.index = 173, .length = 1},
  [101] = {.index = 174, .length = 4},
  [102] = {.index = 178, .length = 4},
  [103] = {.index = 182, .length = 3},
  [104] = {.index = 185, .length = 3},
  [105] = {.index = 188, .length = 2},
  [106] = {.index = 188, .length = 2},
  [107] = {.index = 190, .length = 4},
  [108] = {.index = 190, .length = 4},
  [109] = {.index = 194, .length = 3},
  [110] = {.index = 194, .length = 3},
  [111] = {.index = 197, .length = 3},
  [112] = {.index = 200, .length = 3},
  [113] = {.index = 203, .length = 3},
  [114] = {.index = 206, .length = 3},
  [115] = {.index = 209, .length = 3},
  [116] = {.index = 212, .length = 3},
  [117] = {.index = 215, .length = 2},
  [118] = {.index = 217, .length = 2},
  [119] = {.index = 217, .length = 2},
  [120] = {.index = 219, .length = 4},
  [121] = {.index = 223, .length = 5},
  [122] = {.index = 228, .length = 6},
  [123] = {.index = 234, .length = 3},
  [124] = {.index = 237, .length = 5},
  [125] = {.index = 242, .length = 4},
  [126] = {.index = 120, .length = 2},
  [127] = {.index = 246, .length = 5},
  [128] = {.index = 251, .length = 5},
  [129] = {.index = 256, .length = 5},
  [130] = {.index = 261, .length = 5},
  [131] = {.index = 266, .length = 4},
  [132] = {.index = 270, .length = 2},
  [133] = {.index = 272, .length = 1},
  [134] = {.index = 273, .length = 2},
  [135] = {.index = 275, .length = 2},
  [136] = {.index = 277, .length = 1},
  [137] = {.index = 277, .length = 1},
  [138] = {.index = 278, .length = 2},
  [139] = {.index = 280, .length = 1},
  [140] = {.index = 280, .length = 1},
  [141] = {.index = 56, .length = 1},
  [142] = {.index = 281, .length = 3},
  [143] = {.index = 284, .length = 5},
  [144] = {.index = 289, .length = 4},
  [145] = {.index = 293, .length = 3},
  [146] = {.index = 293, .length = 3},
  [147] = {.index = 296, .length = 4},
  [148] = {.index = 300, .length = 4},
  [149] = {.index = 304, .length = 4},
  [150] = {.index = 308, .length = 4},
  [151] = {.index = 312, .length = 4},
  [152] = {.index = 316, .length = 4},
  [153] = {.index = 320, .length = 4},
  [154] = {.index = 324, .length = 4},
  [155] = {.index = 328, .length = 3},
  [156] = {.index = 331, .length = 3},
  [157] = {.index = 334, .length = 4},
  [158] = {.index = 338, .length = 5},
  [159] = {.index = 343, .length = 3},
  [160] = {.index = 343, .length = 3},
  [161] = {.index = 346, .length = 6},
  [162] = {.index = 352, .length = 4},
  [163] = {.index = 356, .length = 1},
  [164] = {.index = 357, .length = 2},
  [165] = {.index = 359, .length = 2},
  [166] = {.index = 361, .length = 1},
  [167] = {.index = 362, .length = 2},
  [168] = {.index = 364, .length = 2},
  [169] = {.index = 366, .length = 2},
  [170] = {.index = 368, .length = 3},
  [171] = {.index = 371, .length = 3},
  [172] = {.index = 374, .length = 2},
  [173] = {.index = 374, .length = 2},
  [174] = {.index = 376, .length = 3},
  [175] = {.index = 379, .length = 4},
  [176] = {.index = 379, .length = 4},
  [177] = {.index = 383, .length = 5},
  [178] = {.index = 388, .length = 5},
  [179] = {.index = 393, .length = 5},
  [180] = {.index = 398, .length = 5},
  [181] = {.index = 403, .length = 5},
  [182] = {.index = 408, .length = 4},
  [183] = {.index = 412, .length = 2},
  [184] = {.index = 414, .length = 3},
  [185] = {.index = 417, .length = 3},
  [186] = {.index = 420, .length = 3},
  [187] = {.index = 423, .length = 3},
  [188] = {.index = 426, .length = 3},
  [189] = {.index = 429, .length = 5},
  [190] = {.index = 434, .length = 4},
  [191] = {.index = 438, .length = 4},
  [192] = {.index = 442, .length = 2},
  [193] = {.index = 442, .length = 2},
  [194] = {.index = 442, .length = 2},
  [195] = {.index = 442, .length = 2},
  [196] = {.index = 444, .length = 1},
  [197] = {.index = 444, .length = 1},
  [198] = {.index = 444, .length = 1},
  [199] = {.index = 444, .length = 1},
  [200] = {.index = 445, .length = 2},
  [201] = {.index = 447, .length = 6},
  [202] = {.index = 453, .length = 3},
  [203] = {.index = 456, .length = 4},
  [204] = {.index = 460, .length = 4},
  [205] = {.index = 464, .length = 4},
  [206] = {.index = 468, .length = 4},
  [207] = {.index = 472, .length = 4},
  [208] = {.index = 476, .length = 5},
  [209] = {.index = 481, .length = 5},
  [210] = {.index = 486, .length = 1},
  [211] = {.index = 486, .length = 1},
  [212] = {.index = 487, .length = 3},
  [213] = {.index = 490, .length = 2},
  [214] = {.index = 487, .length = 3},
  [215] = {.index = 487, .length = 3},
  [216] = {.index = 487, .length = 3},
  [217] = {.index = 492, .length = 1},
  [218] = {.index = 492, .length = 1},
  [219] = {.index = 493, .length = 2},
  [220] = {.index = 495, .length = 2},
  [221] = {.index = 493, .length = 2},
  [222] = {.index = 493, .length = 2},
  [223] = {.index = 493, .length = 2},
  [224] = {.index = 497, .length = 2},
  [225] = {.index = 499, .length = 1},
  [226] = {.index = 500, .length = 3},
  [227] = {.index = 503, .length = 3},
  [228] = {.index = 506, .length = 3},
  [229] = {.index = 509, .length = 5},
  [230] = {.index = 514, .length = 5},
  [231] = {.index = 519, .length = 5},
  [232] = {.index = 524, .length = 3},
  [233] = {.index = 527, .length = 3},
  [234] = {.index = 530, .length = 4},
  [235] = {.index = 534, .length = 4},
  [236] = {.index = 538, .length = 6},
  [237] = {.index = 544, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_arguments, 0, .inherited = true},
  [3] =
    {field_operand, 1},
    {field_operator, 0},
  [5] =
    {field_name, 1},
  [6] =
    {field_arguments, 1},
    {field_name, 0},
  [8] =
    {field_name, 0},
  [9] =
    {field_dimensions, 1},
    {field_element, 0},
  [11] =
    {field_declarator, 0},
  [12] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [14] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
  [17] =
    {field_arguments, 2},
    {field_type, 1},
  [19] =
    {field_dimensions, 2},
    {field_type, 1},
  [21] =
    {field_body, 2},
    {field_name, 1},
  [23] =
    {field_body, 2},
    {field_condition, 1},
  [25] =
    {field_body, 2},
  [26] =
    {field_body, 1},
  [27] =
    {field_body, 2},
    {field_resources, 1},
  [29] =
    {field_condition, 1},
    {field_consequence, 2},
  [31] =
    {field_arguments, 2},
    {field_name, 1},
  [33] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [36] =
    {field_body, 2},
    {field_parameters, 0},
  [38] =
    {field_field, 2},
    {field_object, 0},
  [40] =
    {field_left, 0},
    {field_right, 2},
  [42] =
    {field_arguments, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
  [45] =
    {field_dimensions, 1},
    {field_name, 0},
  [47] =
    {field_declarator, 1, .inherited = true},
    {field_type, 0},
  [49] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [51] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
  [54] =
    {field_type, 1},
    {field_value, 3},
  [56] =
    {field_type, 1},
  [57] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [59] =
    {field_dimensions, 2},
    {field_type, 1},
    {field_value, 3},
  [62] =
    {field_dimensions, 2},
    {field_dimensions, 3},
    {field_type, 1},
  [65] =
    {field_arguments, 3},
    {field_type, 2},
    {field_type_arguments, 1},
  [68] =
    {field_dimensions, 3},
    {field_type, 2},
  [70] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [73] =
    {field_body, 3},
    {field_name, 1},
    {field_superclass, 2},
  [76] =
    {field_body, 3},
    {field_interfaces, 2},
    {field_name, 1},
  [79] =
    {field_body, 3},
    {field_name, 1},
    {field_permits, 2},
  [82] =
    {field_name, 2},
    {field_scope, 0},
  [84] =
    {field_body, 3},
    {field_name, 2},
  [86] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [89] =
    {field_body, 3},
    {field_name, 1},
  [91] =
    {field_arguments, 3},
    {field_name, 2},
    {field_object, 0},
  [94] =
    {field_left, 0},
    {field_right, 3},
  [96] =
    {field_left, 0},
    {field_name, 3},
    {field_right, 2},
  [99] =
    {field_array, 0},
    {field_index, 2},
  [101] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1},
  [103] =
    {field_declarator, 1},
  [104] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [106] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_value, 2},
  [109] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [112] =
    {field_dimensions, 3},
    {field_type, 2},
    {field_value, 4},
  [115] =
    {field_dimensions, 3},
    {field_dimensions, 4},
    {field_type, 2},
  [118] =
    {field_body, 1},
    {field_name, 0},
  [120] =
    {field_name, 0},
    {field_parameters, 1},
  [122] =
    {field_body, 1},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [126] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0},
  [130] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [135] =
    {field_body, 1},
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [141] =
    {field_body, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [145] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [149] =
    {field_body, 4},
    {field_name, 1},
    {field_permits, 3},
    {field_type_parameters, 2},
  [153] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_superclass, 2},
  [157] =
    {field_body, 4},
    {field_name, 1},
    {field_permits, 3},
    {field_superclass, 2},
  [161] =
    {field_body, 4},
    {field_interfaces, 2},
    {field_name, 1},
    {field_permits, 3},
  [165] =
    {field_body, 1},
    {field_condition, 3},
  [167] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [170] =
    {field_init, 1},
  [171] =
    {field_init, 0, .inherited = true},
    {field_init, 1, .inherited = true},
  [173] =
    {field_modifiers, 0},
  [174] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [178] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_parameters, 2},
  [182] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [185] =
    {field_body, 4},
    {field_name, 1},
    {field_permits, 3},
  [188] =
    {field_field, 4},
    {field_object, 0},
  [190] =
    {field_arguments, 4},
    {field_name, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [194] =
    {field_left, 0},
    {field_name, 4},
    {field_right, 3},
  [197] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [200] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [203] =
    {field_body, 4},
    {field_name, 2},
    {field_superclass, 3},
  [206] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 2},
  [209] =
    {field_body, 4},
    {field_name, 2},
    {field_permits, 3},
  [212] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [215] =
    {field_body, 4},
    {field_name, 2},
  [217] =
    {field_body, 4},
    {field_name, 3},
  [219] =
    {field_body, 2},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [223] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [228] =
    {field_body, 2},
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [234] =
    {field_name, 1},
    {field_parameters, 2},
    {field_type_parameters, 0},
  [237] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1},
    {field_type_parameters, 0},
  [242] =
    {field_body, 2},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [246] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [251] =
    {field_body, 5},
    {field_name, 1},
    {field_permits, 4},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [256] =
    {field_body, 5},
    {field_interfaces, 3},
    {field_name, 1},
    {field_permits, 4},
    {field_type_parameters, 2},
  [261] =
    {field_body, 5},
    {field_interfaces, 3},
    {field_name, 1},
    {field_permits, 4},
    {field_superclass, 2},
  [266] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
    {field_value, 3},
  [270] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [272] =
    {field_body, 5},
  [273] =
    {field_body, 5},
    {field_init, 2},
  [275] =
    {field_key, 0},
    {field_value, 2},
  [277] =
    {field_module, 1},
  [278] =
    {field_modifiers, 0, .inherited = true},
    {field_modifiers, 1, .inherited = true},
  [280] =
    {field_package, 1},
  [281] =
    {field_arguments, 1},
    {field_body, 2},
    {field_name, 0},
  [284] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [289] =
    {field_body, 5},
    {field_name, 1},
    {field_permits, 4},
    {field_type_parameters, 2},
  [293] =
    {field_arguments, 5},
    {field_name, 4},
    {field_object, 0},
  [296] =
    {field_body, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [300] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [304] =
    {field_body, 5},
    {field_name, 2},
    {field_permits, 4},
    {field_type_parameters, 3},
  [308] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_superclass, 3},
  [312] =
    {field_body, 5},
    {field_name, 2},
    {field_permits, 4},
    {field_superclass, 3},
  [316] =
    {field_body, 5},
    {field_interfaces, 3},
    {field_name, 2},
    {field_permits, 4},
  [320] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [324] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_parameters, 3},
  [328] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [331] =
    {field_body, 5},
    {field_name, 2},
    {field_permits, 4},
  [334] =
    {field_body, 3},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [338] =
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_parameters, 3, .inherited = true},
    {field_type, 2},
    {field_type_parameters, 0},
  [343] =
    {field_dimensions, 2},
    {field_name, 0},
    {field_parameters, 1},
  [346] =
    {field_body, 6},
    {field_interfaces, 4},
    {field_name, 1},
    {field_permits, 5},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [352] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
    {field_value, 4},
  [356] =
    {field_body, 4},
  [357] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [359] =
    {field_body, 6},
    {field_update, 4},
  [361] =
    {field_update, 1},
  [362] =
    {field_update, 0, .inherited = true},
    {field_update, 1, .inherited = true},
  [364] =
    {field_body, 6},
    {field_condition, 3},
  [366] =
    {field_body, 6},
    {field_init, 2},
  [368] =
    {field_body, 6},
    {field_init, 2},
    {field_update, 4},
  [371] =
    {field_body, 6},
    {field_condition, 3},
    {field_init, 2},
  [374] =
    {field_modifiers, 1, .inherited = true},
    {field_module, 2},
  [376] =
    {field_arguments, 2},
    {field_body, 3},
    {field_name, 1},
  [379] =
    {field_arguments, 6},
    {field_name, 5},
    {field_object, 0},
    {field_type_arguments, 4},
  [383] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [388] =
    {field_body, 6},
    {field_name, 2},
    {field_permits, 5},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [393] =
    {field_body, 6},
    {field_interfaces, 4},
    {field_name, 2},
    {field_permits, 5},
    {field_type_parameters, 3},
  [398] =
    {field_body, 6},
    {field_interfaces, 4},
    {field_name, 2},
    {field_permits, 5},
    {field_superclass, 3},
  [403] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [408] =
    {field_body, 6},
    {field_name, 2},
    {field_permits, 5},
    {field_type_parameters, 3},
  [412] =
    {field_arguments, 1},
    {field_constructor, 0},
  [414] =
    {field_body, 7},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [417] =
    {field_body, 7},
    {field_condition, 3},
    {field_update, 5},
  [420] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 5},
  [423] =
    {field_body, 7},
    {field_condition, 4},
    {field_init, 2},
  [426] =
    {field_body, 7},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [429] =
    {field_body, 7},
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_type, 2},
    {field_value, 5},
  [434] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [438] =
    {field_body, 7},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
  [442] =
    {field_modules, 3},
    {field_package, 1},
  [444] =
    {field_provided, 1},
  [445] =
    {field_name, 1},
    {field_type, 0},
  [447] =
    {field_body, 7},
    {field_interfaces, 5},
    {field_name, 2},
    {field_permits, 6},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [453] =
    {field_arguments, 2},
    {field_constructor, 1},
    {field_type_arguments, 0},
  [456] =
    {field_body, 8},
    {field_condition, 3},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [460] =
    {field_body, 8},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [464] =
    {field_body, 8},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
  [468] =
    {field_body, 8},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
  [472] =
    {field_body, 8},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [476] =
    {field_body, 8},
    {field_dimensions, 4, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_type, 3},
    {field_value, 6},
  [481] =
    {field_body, 8},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [486] =
    {field_modules, 1},
  [487] =
    {field_modules, 3},
    {field_modules, 4, .inherited = true},
    {field_package, 1},
  [490] =
    {field_modules, 0, .inherited = true},
    {field_modules, 1, .inherited = true},
  [492] =
    {field_provider, 1},
  [493] =
    {field_provided, 1},
    {field_provider, 4, .inherited = true},
  [495] =
    {field_provider, 0, .inherited = true},
    {field_provider, 1, .inherited = true},
  [497] =
    {field_name, 2},
    {field_type, 1},
  [499] =
    {field_value, 1},
  [500] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
  [503] =
    {field_name, 1},
    {field_type, 0},
    {field_value, 4, .inherited = true},
  [506] =
    {field_arguments, 3},
    {field_constructor, 2},
    {field_object, 0},
  [509] =
    {field_body, 9},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [514] =
    {field_body, 9},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [519] =
    {field_body, 9},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
  [524] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
  [527] =
    {field_name, 2},
    {field_type, 1},
    {field_value, 5, .inherited = true},
  [530] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
    {field_value, 5, .inherited = true},
  [534] =
    {field_arguments, 4},
    {field_constructor, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [538] =
    {field_body, 10},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
    {field_update, 8, .inherited = true},
  [544] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
    {field_value, 6, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [2] = {
    [0] = alias_sym_type_identifier,
  },
  [5] = {
    [1] = sym_identifier,
  },
  [7] = {
    [0] = sym_identifier,
  },
  [9] = {
    [0] = sym_identifier,
  },
  [14] = {
    [1] = sym_identifier,
  },
  [18] = {
    [1] = alias_sym_type_identifier,
  },
  [19] = {
    [1] = alias_sym_type_identifier,
  },
  [26] = {
    [1] = sym_identifier,
  },
  [28] = {
    [0] = sym_identifier,
  },
  [29] = {
    [0] = sym_identifier,
  },
  [30] = {
    [1] = sym_identifier,
  },
  [31] = {
    [2] = sym_identifier,
  },
  [35] = {
    [0] = alias_sym_type_identifier,
    [2] = alias_sym_type_identifier,
  },
  [38] = {
    [0] = sym_identifier,
  },
  [42] = {
    [2] = alias_sym_type_identifier,
  },
  [49] = {
    [1] = alias_sym_type_identifier,
  },
  [50] = {
    [1] = alias_sym_type_identifier,
  },
  [52] = {
    [2] = alias_sym_type_identifier,
  },
  [54] = {
    [2] = alias_sym_type_identifier,
  },
  [59] = {
    [0] = sym_identifier,
  },
  [61] = {
    [2] = sym_identifier,
  },
  [63] = {
    [2] = sym_identifier,
  },
  [66] = {
    [2] = sym_identifier,
  },
  [68] = {
    [0] = alias_sym_type_identifier,
    [3] = alias_sym_type_identifier,
  },
  [70] = {
    [3] = sym_identifier,
  },
  [77] = {
    [3] = alias_sym_type_identifier,
  },
  [81] = {
    [2] = alias_sym_type_identifier,
  },
  [82] = {
    [2] = alias_sym_type_identifier,
  },
  [83] = {
    [1] = alias_sym_type_identifier,
  },
  [105] = {
    [4] = sym_identifier,
  },
  [107] = {
    [3] = sym_identifier,
  },
  [109] = {
    [4] = sym_identifier,
  },
  [118] = {
    [3] = sym_identifier,
  },
  [126] = {
    [0] = sym_identifier,
  },
  [136] = {
    [1] = sym_identifier,
  },
  [139] = {
    [1] = sym_identifier,
  },
  [141] = {
    [1] = sym_identifier,
  },
  [145] = {
    [4] = sym_identifier,
  },
  [159] = {
    [0] = sym_identifier,
  },
  [172] = {
    [2] = sym_identifier,
  },
  [175] = {
    [5] = sym_identifier,
  },
  [192] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [193] = {
    [1] = sym_identifier,
  },
  [194] = {
    [3] = sym_identifier,
  },
  [196] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [197] = {
    [1] = sym_identifier,
  },
  [198] = {
    [3] = sym_identifier,
  },
  [210] = {
    [1] = sym_identifier,
  },
  [212] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [214] = {
    [1] = sym_identifier,
  },
  [215] = {
    [3] = sym_identifier,
  },
  [217] = {
    [1] = sym_identifier,
  },
  [219] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [221] = {
    [1] = sym_identifier,
  },
  [222] = {
    [3] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 8,
  [13] = 10,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 14,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 35,
  [38] = 38,
  [39] = 18,
  [40] = 40,
  [41] = 41,
  [42] = 15,
  [43] = 22,
  [44] = 24,
  [45] = 32,
  [46] = 28,
  [47] = 47,
  [48] = 48,
  [49] = 41,
  [50] = 50,
  [51] = 51,
  [52] = 36,
  [53] = 34,
  [54] = 21,
  [55] = 20,
  [56] = 38,
  [57] = 31,
  [58] = 27,
  [59] = 59,
  [60] = 19,
  [61] = 26,
  [62] = 40,
  [63] = 25,
  [64] = 29,
  [65] = 30,
  [66] = 33,
  [67] = 67,
  [68] = 59,
  [69] = 47,
  [70] = 48,
  [71] = 50,
  [72] = 51,
  [73] = 67,
  [74] = 17,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 83,
  [85] = 85,
  [86] = 85,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 88,
  [92] = 88,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 108,
  [110] = 110,
  [111] = 107,
  [112] = 77,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 79,
  [119] = 116,
  [120] = 115,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 124,
  [128] = 128,
  [129] = 125,
  [130] = 130,
  [131] = 128,
  [132] = 132,
  [133] = 126,
  [134] = 132,
  [135] = 135,
  [136] = 117,
  [137] = 137,
  [138] = 113,
  [139] = 121,
  [140] = 137,
  [141] = 123,
  [142] = 122,
  [143] = 143,
  [144] = 135,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 163,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 167,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 161,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 191,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 147,
  [218] = 146,
  [219] = 157,
  [220] = 155,
  [221] = 153,
  [222] = 160,
  [223] = 164,
  [224] = 165,
  [225] = 166,
  [226] = 172,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 178,
  [231] = 231,
  [232] = 204,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 149,
  [248] = 152,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 253,
  [267] = 267,
  [268] = 162,
  [269] = 196,
  [270] = 194,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 360,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 366,
  [368] = 368,
  [369] = 368,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 365,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 377,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 384,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 343,
  [408] = 408,
  [409] = 344,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 378,
  [431] = 431,
  [432] = 375,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 374,
  [438] = 373,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 381,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 417,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 379,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 382,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 416,
  [520] = 423,
  [521] = 435,
  [522] = 412,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 433,
  [550] = 550,
  [551] = 419,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 411,
  [561] = 561,
  [562] = 562,
  [563] = 428,
  [564] = 387,
  [565] = 399,
  [566] = 398,
  [567] = 388,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 545,
  [573] = 557,
  [574] = 574,
  [575] = 440,
  [576] = 459,
  [577] = 460,
  [578] = 578,
  [579] = 555,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 439,
  [584] = 584,
  [585] = 585,
  [586] = 562,
  [587] = 587,
  [588] = 559,
  [589] = 554,
  [590] = 578,
  [591] = 591,
  [592] = 87,
  [593] = 593,
  [594] = 550,
  [595] = 595,
  [596] = 558,
  [597] = 547,
  [598] = 584,
  [599] = 552,
  [600] = 553,
  [601] = 556,
  [602] = 548,
  [603] = 546,
  [604] = 604,
  [605] = 582,
  [606] = 606,
  [607] = 607,
  [608] = 568,
  [609] = 593,
  [610] = 610,
  [611] = 611,
  [612] = 604,
  [613] = 580,
  [614] = 610,
  [615] = 615,
  [616] = 606,
  [617] = 456,
  [618] = 611,
  [619] = 615,
  [620] = 620,
  [621] = 571,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 626,
  [627] = 627,
  [628] = 471,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 637,
  [638] = 638,
  [639] = 639,
  [640] = 640,
  [641] = 637,
  [642] = 642,
  [643] = 634,
  [644] = 644,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 636,
  [652] = 642,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 657,
  [658] = 658,
  [659] = 640,
  [660] = 647,
  [661] = 646,
  [662] = 662,
  [663] = 663,
  [664] = 650,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 669,
  [670] = 670,
  [671] = 404,
  [672] = 408,
  [673] = 673,
  [674] = 674,
  [675] = 411,
  [676] = 419,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 422,
  [683] = 683,
  [684] = 398,
  [685] = 410,
  [686] = 399,
  [687] = 683,
  [688] = 688,
  [689] = 689,
  [690] = 421,
  [691] = 415,
  [692] = 692,
  [693] = 693,
  [694] = 414,
  [695] = 403,
  [696] = 680,
  [697] = 427,
  [698] = 418,
  [699] = 420,
  [700] = 700,
  [701] = 425,
  [702] = 424,
  [703] = 426,
  [704] = 704,
  [705] = 705,
  [706] = 704,
  [707] = 707,
  [708] = 460,
  [709] = 439,
  [710] = 459,
  [711] = 413,
  [712] = 456,
  [713] = 440,
  [714] = 714,
  [715] = 715,
  [716] = 394,
  [717] = 715,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 392,
  [726] = 724,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 733,
  [739] = 739,
  [740] = 740,
  [741] = 735,
  [742] = 742,
  [743] = 734,
  [744] = 744,
  [745] = 410,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 751,
  [756] = 756,
  [757] = 757,
  [758] = 758,
  [759] = 759,
  [760] = 758,
  [761] = 761,
  [762] = 762,
  [763] = 754,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 413,
  [772] = 396,
  [773] = 773,
  [774] = 393,
  [775] = 391,
  [776] = 773,
  [777] = 777,
  [778] = 395,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 780,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 791,
  [792] = 792,
  [793] = 787,
  [794] = 789,
  [795] = 795,
  [796] = 796,
  [797] = 466,
  [798] = 798,
  [799] = 799,
  [800] = 800,
  [801] = 801,
  [802] = 802,
  [803] = 803,
  [804] = 804,
  [805] = 805,
  [806] = 801,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 818,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 833,
  [839] = 705,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 858,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 863,
  [864] = 857,
  [865] = 865,
  [866] = 840,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 865,
  [872] = 872,
  [873] = 870,
  [874] = 874,
  [875] = 837,
  [876] = 876,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 919,
  [920] = 920,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 907,
  [930] = 930,
  [931] = 907,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 947,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 958,
  [959] = 959,
  [960] = 960,
  [961] = 961,
  [962] = 962,
  [963] = 963,
  [964] = 964,
  [965] = 965,
  [966] = 966,
  [967] = 967,
  [968] = 968,
  [969] = 969,
  [970] = 970,
  [971] = 951,
  [972] = 972,
  [973] = 973,
  [974] = 974,
  [975] = 975,
  [976] = 976,
  [977] = 977,
  [978] = 950,
  [979] = 979,
  [980] = 980,
  [981] = 981,
  [982] = 982,
  [983] = 983,
  [984] = 984,
  [985] = 985,
  [986] = 986,
  [987] = 987,
  [988] = 988,
  [989] = 989,
  [990] = 990,
  [991] = 991,
  [992] = 992,
  [993] = 958,
  [994] = 994,
  [995] = 995,
  [996] = 996,
  [997] = 937,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 1002,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 1018,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 1023,
  [1024] = 1024,
  [1025] = 1025,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 1029,
  [1030] = 1030,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 1036,
  [1037] = 1027,
  [1038] = 1027,
  [1039] = 1039,
  [1040] = 1040,
  [1041] = 1005,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 1044,
  [1045] = 1045,
  [1046] = 1046,
  [1047] = 1047,
  [1048] = 1048,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 1071,
  [1072] = 1072,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1014,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 1056,
  [1085] = 1018,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1029,
  [1089] = 1089,
  [1090] = 1050,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1065,
  [1097] = 1097,
  [1098] = 1005,
  [1099] = 1052,
  [1100] = 1100,
  [1101] = 1040,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1093,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 967,
  [1108] = 1108,
  [1109] = 1071,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1082,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1049,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1132,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1139,
  [1140] = 1140,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1144,
  [1145] = 1145,
  [1146] = 1146,
  [1147] = 1147,
  [1148] = 1148,
  [1149] = 1149,
  [1150] = 1150,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 1155,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 1158,
  [1159] = 1159,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1162,
  [1163] = 1163,
  [1164] = 1164,
  [1165] = 1165,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 1174,
  [1175] = 1175,
  [1176] = 1176,
  [1177] = 1177,
  [1178] = 1178,
  [1179] = 1179,
  [1180] = 301,
  [1181] = 1181,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 1196,
  [1197] = 1197,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1201,
  [1202] = 1202,
  [1203] = 1203,
  [1204] = 1204,
  [1205] = 1177,
  [1206] = 1153,
  [1207] = 1207,
  [1208] = 1208,
  [1209] = 1209,
  [1210] = 1139,
  [1211] = 1211,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1214,
  [1215] = 1215,
  [1216] = 1216,
  [1217] = 1217,
  [1218] = 1218,
  [1219] = 1219,
  [1220] = 1220,
  [1221] = 1221,
  [1222] = 1222,
  [1223] = 1223,
  [1224] = 1224,
  [1225] = 1225,
  [1226] = 1226,
  [1227] = 1227,
  [1228] = 1228,
  [1229] = 1229,
  [1230] = 1230,
  [1231] = 1231,
  [1232] = 1232,
  [1233] = 1233,
  [1234] = 1234,
  [1235] = 1235,
  [1236] = 1236,
  [1237] = 1237,
  [1238] = 1238,
  [1239] = 1239,
  [1240] = 1240,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 1243,
  [1244] = 1244,
  [1245] = 1245,
  [1246] = 1246,
  [1247] = 1247,
  [1248] = 1248,
  [1249] = 1249,
  [1250] = 1250,
  [1251] = 1251,
  [1252] = 1252,
  [1253] = 1253,
  [1254] = 1247,
  [1255] = 1255,
  [1256] = 1256,
  [1257] = 1257,
  [1258] = 1252,
  [1259] = 1259,
  [1260] = 1260,
  [1261] = 1261,
  [1262] = 1262,
  [1263] = 1263,
  [1264] = 1264,
  [1265] = 1257,
  [1266] = 1266,
  [1267] = 1267,
  [1268] = 1268,
  [1269] = 1269,
  [1270] = 1270,
  [1271] = 1271,
  [1272] = 1256,
  [1273] = 1259,
  [1274] = 1274,
  [1275] = 1239,
  [1276] = 1276,
  [1277] = 1251,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1280,
  [1281] = 1281,
  [1282] = 1282,
  [1283] = 1283,
  [1284] = 1251,
  [1285] = 1285,
  [1286] = 1286,
  [1287] = 1287,
  [1288] = 1288,
  [1289] = 1289,
  [1290] = 1290,
  [1291] = 1291,
  [1292] = 1292,
  [1293] = 1293,
  [1294] = 1294,
  [1295] = 1295,
  [1296] = 1296,
  [1297] = 1297,
  [1298] = 1298,
  [1299] = 1252,
  [1300] = 1263,
  [1301] = 1301,
  [1302] = 1302,
  [1303] = 1303,
  [1304] = 1261,
  [1305] = 1305,
  [1306] = 1247,
  [1307] = 1307,
  [1308] = 1308,
  [1309] = 1309,
  [1310] = 1310,
  [1311] = 1311,
  [1312] = 1312,
  [1313] = 1313,
  [1314] = 1314,
  [1315] = 1315,
  [1316] = 1316,
  [1317] = 1317,
  [1318] = 1318,
  [1319] = 1295,
  [1320] = 1320,
  [1321] = 1321,
  [1322] = 1322,
};

static inline bool sym_escape_sequence_character_set_1(int32_t c) {
  return (c < 'a'
    ? (c < '?'
      ? (c < '\''
        ? c == '"'
        : c <= '\'')
      : (c <= '?' || c == '\\'))
    : (c <= 'b' || (c < 'r'
      ? (c < 'n'
        ? c == 'f'
        : c <= 'n')
      : (c <= 'r' || (c >= 't' && c <= 'v')))));
}

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 6688
    ? (c < 2984
      ? (c < 2365
        ? (c < 1488
          ? (c < 886
            ? (c < 216
              ? (c < 181
                ? (c < 'a'
                  ? (c >= '$' && c <= '_')
                  : (c <= 'z' || c == 170))
                : (c <= 181 || (c < 192
                  ? c == 186
                  : c <= 214)))
              : (c <= 246 || (c < 748
                ? (c < 710
                  ? (c >= 248 && c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))
                : (c <= 748 || (c < 880
                  ? c == 750
                  : c <= 884)))))
            : (c <= 887 || (c < 931
              ? (c < 904
                ? (c < 895
                  ? (c >= 890 && c <= 893)
                  : (c <= 895 || c == 902))
                : (c <= 906 || (c < 910
                  ? c == 908
                  : c <= 929)))
              : (c <= 1013 || (c < 1329
                ? (c < 1162
                  ? (c >= 1015 && c <= 1153)
                  : c <= 1327)
                : (c <= 1366 || (c < 1376
                  ? c == 1369
                  : c <= 1416)))))))
          : (c <= 1514 || (c < 1994
            ? (c < 1774
              ? (c < 1649
                ? (c < 1568
                  ? (c >= 1519 && c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))
                : (c <= 1747 || (c < 1765
                  ? c == 1749
                  : c <= 1766)))
              : (c <= 1775 || (c < 1810
                ? (c < 1791
                  ? (c >= 1786 && c <= 1788)
                  : (c <= 1791 || c == 1808))
                : (c <= 1839 || (c < 1969
                  ? (c >= 1869 && c <= 1957)
                  : c <= 1969)))))
            : (c <= 2026 || (c < 2112
              ? (c < 2074
                ? (c < 2042
                  ? (c >= 2036 && c <= 2037)
                  : (c <= 2042 || (c >= 2048 && c <= 2069)))
                : (c <= 2074 || (c < 2088
                  ? c == 2084
                  : c <= 2088)))
              : (c <= 2136 || (c < 2185
                ? (c < 2160
                  ? (c >= 2144 && c <= 2154)
                  : c <= 2183)
                : (c <= 2190 || (c < 2308
                  ? (c >= 2208 && c <= 2249)
                  : c <= 2361)))))))))
        : (c <= 2365 || (c < 2703
          ? (c < 2544
            ? (c < 2474
              ? (c < 2437
                ? (c < 2392
                  ? c == 2384
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2451
                  ? (c >= 2447 && c <= 2448)
                  : c <= 2472)))
              : (c <= 2480 || (c < 2510
                ? (c < 2486
                  ? c == 2482
                  : (c <= 2489 || c == 2493))
                : (c <= 2510 || (c < 2527
                  ? (c >= 2524 && c <= 2525)
                  : c <= 2529)))))
            : (c <= 2545 || (c < 2613
              ? (c < 2579
                ? (c < 2565
                  ? c == 2556
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2610
                  ? (c >= 2602 && c <= 2608)
                  : c <= 2611)))
              : (c <= 2614 || (c < 2654
                ? (c < 2649
                  ? (c >= 2616 && c <= 2617)
                  : c <= 2652)
                : (c <= 2654 || (c < 2693
                  ? (c >= 2674 && c <= 2676)
                  : c <= 2701)))))))
          : (c <= 2705 || (c < 2869
            ? (c < 2784
              ? (c < 2741
                ? (c < 2730
                  ? (c >= 2707 && c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2768
                  ? c == 2749
                  : c <= 2768)))
              : (c <= 2785 || (c < 2835
                ? (c < 2821
                  ? c == 2809
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))
                : (c <= 2856 || (c < 2866
                  ? (c >= 2858 && c <= 2864)
                  : c <= 2867)))))
            : (c <= 2873 || (c < 2958
              ? (c < 2929
                ? (c < 2908
                  ? c == 2877
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))
                : (c <= 2929 || (c < 2949
                  ? c == 2947
                  : c <= 2954)))
              : (c <= 2960 || (c < 2972
                ? (c < 2969
                  ? (c >= 2962 && c <= 2965)
                  : c <= 2970)
                : (c <= 2972 || (c < 2979
                  ? (c >= 2974 && c <= 2975)
                  : c <= 2980)))))))))))
      : (c <= 2986 || (c < 4176
        ? (c < 3423
          ? (c < 3218
            ? (c < 3133
              ? (c < 3086
                ? (c < 3024
                  ? (c >= 2990 && c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))
                : (c <= 3088 || (c < 3114
                  ? (c >= 3090 && c <= 3112)
                  : c <= 3129)))
              : (c <= 3133 || (c < 3200
                ? (c < 3165
                  ? (c >= 3160 && c <= 3162)
                  : (c <= 3165 || (c >= 3168 && c <= 3169)))
                : (c <= 3200 || (c < 3214
                  ? (c >= 3205 && c <= 3212)
                  : c <= 3216)))))
            : (c <= 3240 || (c < 3332
              ? (c < 3293
                ? (c < 3253
                  ? (c >= 3242 && c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3313
                  ? (c >= 3296 && c <= 3297)
                  : c <= 3314)))
              : (c <= 3340 || (c < 3389
                ? (c < 3346
                  ? (c >= 3342 && c <= 3344)
                  : c <= 3386)
                : (c <= 3389 || (c < 3412
                  ? c == 3406
                  : c <= 3414)))))))
          : (c <= 3425 || (c < 3749
            ? (c < 3585
              ? (c < 3507
                ? (c < 3461
                  ? (c >= 3450 && c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3520
                  ? c == 3517
                  : c <= 3526)))
              : (c <= 3632 || (c < 3716
                ? (c < 3648
                  ? (c >= 3634 && c <= 3635)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))
                : (c <= 3716 || (c < 3724
                  ? (c >= 3718 && c <= 3722)
                  : c <= 3747)))))
            : (c <= 3749 || (c < 3840
              ? (c < 3776
                ? (c < 3762
                  ? (c >= 3751 && c <= 3760)
                  : (c <= 3763 || c == 3773))
                : (c <= 3780 || (c < 3804
                  ? c == 3782
                  : c <= 3807)))
              : (c <= 3840 || (c < 3976
                ? (c < 3913
                  ? (c >= 3904 && c <= 3911)
                  : c <= 3948)
                : (c <= 3980 || (c < 4159
                  ? (c >= 4096 && c <= 4138)
                  : c <= 4159)))))))))
        : (c <= 4181 || (c < 4992
          ? (c < 4696
            ? (c < 4256
              ? (c < 4206
                ? (c < 4193
                  ? (c >= 4186 && c <= 4189)
                  : (c <= 4193 || (c >= 4197 && c <= 4198)))
                : (c <= 4208 || (c < 4238
                  ? (c >= 4213 && c <= 4225)
                  : c <= 4238)))
              : (c <= 4293 || (c < 4348
                ? (c < 4301
                  ? c == 4295
                  : (c <= 4301 || (c >= 4304 && c <= 4346)))
                : (c <= 4680 || (c < 4688
                  ? (c >= 4682 && c <= 4685)
                  : c <= 4694)))))
            : (c <= 4696 || (c < 4800
              ? (c < 4752
                ? (c < 4704
                  ? (c >= 4698 && c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4792
                  ? (c >= 4786 && c <= 4789)
                  : c <= 4798)))
              : (c <= 4800 || (c < 4824
                ? (c < 4808
                  ? (c >= 4802 && c <= 4805)
                  : c <= 4822)
                : (c <= 4880 || (c < 4888
                  ? (c >= 4882 && c <= 4885)
                  : c <= 4954)))))))
          : (c <= 5007 || (c < 6103
            ? (c < 5873
              ? (c < 5743
                ? (c < 5112
                  ? (c >= 5024 && c <= 5109)
                  : (c <= 5117 || (c >= 5121 && c <= 5740)))
                : (c <= 5759 || (c < 5792
                  ? (c >= 5761 && c <= 5786)
                  : c <= 5866)))
              : (c <= 5880 || (c < 5984
                ? (c < 5919
                  ? (c >= 5888 && c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6016
                  ? (c >= 5998 && c <= 6000)
                  : c <= 6067)))))
            : (c <= 6103 || (c < 6400
              ? (c < 6279
                ? (c < 6176
                  ? c == 6108
                  : (c <= 6264 || (c >= 6272 && c <= 6276)))
                : (c <= 6312 || (c < 6320
                  ? c == 6314
                  : c <= 6389)))
              : (c <= 6430 || (c < 6528
                ? (c < 6512
                  ? (c >= 6480 && c <= 6509)
                  : c <= 6516)
                : (c <= 6571 || (c < 6656
                  ? (c >= 6576 && c <= 6601)
                  : c <= 6678)))))))))))))
    : (c <= 6740 || (c < 43261
      ? (c < 11264
        ? (c < 8064
          ? (c < 7406
            ? (c < 7168
              ? (c < 7043
                ? (c < 6917
                  ? c == 6823
                  : (c <= 6963 || (c >= 6981 && c <= 6988)))
                : (c <= 7072 || (c < 7098
                  ? (c >= 7086 && c <= 7087)
                  : c <= 7141)))
              : (c <= 7203 || (c < 7312
                ? (c < 7258
                  ? (c >= 7245 && c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))
                : (c <= 7354 || (c < 7401
                  ? (c >= 7357 && c <= 7359)
                  : c <= 7404)))))
            : (c <= 7411 || (c < 8008
              ? (c < 7680
                ? (c < 7418
                  ? (c >= 7413 && c <= 7414)
                  : (c <= 7418 || (c >= 7424 && c <= 7615)))
                : (c <= 7957 || (c < 7968
                  ? (c >= 7960 && c <= 7965)
                  : c <= 8005)))
              : (c <= 8013 || (c < 8027
                ? (c < 8025
                  ? (c >= 8016 && c <= 8023)
                  : c <= 8025)
                : (c <= 8027 || (c < 8031
                  ? c == 8029
                  : c <= 8061)))))))
          : (c <= 8116 || (c < 8455
            ? (c < 8160
              ? (c < 8134
                ? (c < 8126
                  ? (c >= 8118 && c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))
                : (c <= 8140 || (c < 8150
                  ? (c >= 8144 && c <= 8147)
                  : c <= 8155)))
              : (c <= 8172 || (c < 8319
                ? (c < 8182
                  ? (c >= 8178 && c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8450
                  ? (c >= 8336 && c <= 8348)
                  : c <= 8450)))))
            : (c <= 8455 || (c < 8490
              ? (c < 8484
                ? (c < 8469
                  ? (c >= 8458 && c <= 8467)
                  : (c <= 8469 || (c >= 8473 && c <= 8477)))
                : (c <= 8484 || (c < 8488
                  ? c == 8486
                  : c <= 8488)))
              : (c <= 8493 || (c < 8517
                ? (c < 8508
                  ? (c >= 8495 && c <= 8505)
                  : c <= 8511)
                : (c <= 8521 || (c < 8579
                  ? c == 8526
                  : c <= 8580)))))))))
        : (c <= 11492 || (c < 12704
          ? (c < 11720
            ? (c < 11631
              ? (c < 11559
                ? (c < 11506
                  ? (c >= 11499 && c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11568
                  ? c == 11565
                  : c <= 11623)))
              : (c <= 11631 || (c < 11696
                ? (c < 11680
                  ? (c >= 11648 && c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))
                : (c <= 11702 || (c < 11712
                  ? (c >= 11704 && c <= 11710)
                  : c <= 11718)))))
            : (c <= 11726 || (c < 12353
              ? (c < 12293
                ? (c < 11736
                  ? (c >= 11728 && c <= 11734)
                  : (c <= 11742 || c == 11823))
                : (c <= 12294 || (c < 12347
                  ? (c >= 12337 && c <= 12341)
                  : c <= 12348)))
              : (c <= 12438 || (c < 12540
                ? (c < 12449
                  ? (c >= 12445 && c <= 12447)
                  : c <= 12538)
                : (c <= 12543 || (c < 12593
                  ? (c >= 12549 && c <= 12591)
                  : c <= 12686)))))))
          : (c <= 12735 || (c < 42786
            ? (c < 42240
              ? (c < 19968
                ? (c < 13312
                  ? (c >= 12784 && c <= 12799)
                  : (c <= 13312 || c == 19903))
                : (c <= 19968 || (c < 42192
                  ? (c >= 40959 && c <= 42124)
                  : c <= 42237)))
              : (c <= 42508 || (c < 42623
                ? (c < 42538
                  ? (c >= 42512 && c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))
                : (c <= 42653 || (c < 42775
                  ? (c >= 42656 && c <= 42725)
                  : c <= 42783)))))
            : (c <= 42888 || (c < 43015
              ? (c < 42965
                ? (c < 42960
                  ? (c >= 42891 && c <= 42954)
                  : (c <= 42961 || c == 42963))
                : (c <= 42969 || (c < 43011
                  ? (c >= 42994 && c <= 43009)
                  : c <= 43013)))
              : (c <= 43018 || (c < 43138
                ? (c < 43072
                  ? (c >= 43020 && c <= 43042)
                  : c <= 43123)
                : (c <= 43187 || (c < 43259
                  ? (c >= 43250 && c <= 43255)
                  : c <= 43259)))))))))))
      : (c <= 43262 || (c < 65345
        ? (c < 43816
          ? (c < 43646
            ? (c < 43494
              ? (c < 43396
                ? (c < 43312
                  ? (c >= 43274 && c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))
                : (c <= 43442 || (c < 43488
                  ? c == 43471
                  : c <= 43492)))
              : (c <= 43503 || (c < 43588
                ? (c < 43520
                  ? (c >= 43514 && c <= 43518)
                  : (c <= 43560 || (c >= 43584 && c <= 43586)))
                : (c <= 43595 || (c < 43642
                  ? (c >= 43616 && c <= 43638)
                  : c <= 43642)))))
            : (c <= 43695 || (c < 43744
              ? (c < 43712
                ? (c < 43701
                  ? c == 43697
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))
                : (c <= 43712 || (c < 43739
                  ? c == 43714
                  : c <= 43741)))
              : (c <= 43754 || (c < 43785
                ? (c < 43777
                  ? (c >= 43762 && c <= 43764)
                  : c <= 43782)
                : (c <= 43790 || (c < 43808
                  ? (c >= 43793 && c <= 43798)
                  : c <= 43814)))))))
          : (c <= 43822 || (c < 64298
            ? (c < 55243
              ? (c < 44032
                ? (c < 43868
                  ? (c >= 43824 && c <= 43866)
                  : (c <= 43881 || (c >= 43888 && c <= 44002)))
                : (c <= 44032 || (c < 55216
                  ? c == 55203
                  : c <= 55238)))
              : (c <= 55291 || (c < 64275
                ? (c < 64112
                  ? (c >= 63744 && c <= 64109)
                  : (c <= 64217 || (c >= 64256 && c <= 64262)))
                : (c <= 64279 || (c < 64287
                  ? c == 64285
                  : c <= 64296)))))
            : (c <= 64310 || (c < 64848
              ? (c < 64323
                ? (c < 64318
                  ? (c >= 64312 && c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64467
                  ? (c >= 64326 && c <= 64433)
                  : c <= 64829)))
              : (c <= 64911 || (c < 65136
                ? (c < 65008
                  ? (c >= 64914 && c <= 64967)
                  : c <= 65019)
                : (c <= 65140 || (c < 65313
                  ? (c >= 65142 && c <= 65276)
                  : c <= 65338)))))))))
        : (c <= 65370 || (c < 66928
          ? (c < 66208
            ? (c < 65549
              ? (c < 65490
                ? (c < 65474
                  ? (c >= 65382 && c <= 65470)
                  : (c <= 65479 || (c >= 65482 && c <= 65487)))
                : (c <= 65495 || (c < 65536
                  ? (c >= 65498 && c <= 65500)
                  : c <= 65547)))
              : (c <= 65574 || (c < 65616
                ? (c < 65596
                  ? (c >= 65576 && c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))
                : (c <= 65629 || (c < 66176
                  ? (c >= 65664 && c <= 65786)
                  : c <= 66204)))))
            : (c <= 66256 || (c < 66504
              ? (c < 66384
                ? (c < 66349
                  ? (c >= 66304 && c <= 66335)
                  : (c <= 66368 || (c >= 66370 && c <= 66377)))
                : (c <= 66421 || (c < 66464
                  ? (c >= 66432 && c <= 66461)
                  : c <= 66499)))
              : (c <= 66511 || (c < 66776
                ? (c < 66736
                  ? (c >= 66560 && c <= 66717)
                  : c <= 66771)
                : (c <= 66811 || (c < 66864
                  ? (c >= 66816 && c <= 66855)
                  : c <= 66915)))))))
          : (c <= 66938 || (c < 67506
            ? (c < 67003
              ? (c < 66967
                ? (c < 66956
                  ? (c >= 66940 && c <= 66954)
                  : (c <= 66962 || (c >= 66964 && c <= 66965)))
                : (c <= 66977 || (c < 66995
                  ? (c >= 66979 && c <= 66993)
                  : c <= 67001)))
              : (c <= 67004 || (c < 67424
                ? (c < 67392
                  ? (c >= 67072 && c <= 67382)
                  : c <= 67413)
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67880)))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 880
            ? (c < 192
              ? (c < 170
                ? (c < '_'
                  ? (c >= '$' && c <= 'Z')
                  : (c <= '_' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 214 || (c < 736
                ? (c < 248
                  ? (c >= 216 && c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 750
                  ? c == 748
                  : c <= 750)))))
            : (c <= 884 || (c < 910
              ? (c < 902
                ? (c < 890
                  ? (c >= 886 && c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 908
                  ? (c >= 904 && c <= 906)
                  : c <= 908)))
              : (c <= 929 || (c < 1162
                ? (c < 1015
                  ? (c >= 931 && c <= 1013)
                  : c <= 1153)
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67880)))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 750
            ? (c < 186
              ? (c < 'a'
                ? (c < 'A'
                  ? c == '$'
                  : (c <= 'Z' || c == '_'))
                : (c <= 'z' || (c < 181
                  ? c == 170
                  : c <= 181)))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1162
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67880)))))))))))))));
}

static inline bool sym_identifier_character_set_4(int32_t c) {
  return (c < 6400
    ? (c < 2979
      ? (c < 2365
        ? (c < 1376
          ? (c < 750
            ? (c < 186
              ? (c < '_'
                ? (c < '0'
                  ? c == '$'
                  : (c <= '9' || (c >= 'A' && c <= 'Z')))
                : (c <= '_' || (c < 170
                  ? (c >= 'a' && c <= 'z')
                  : (c <= 170 || c == 181))))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1162
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1749
              ? (c < 1632
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1641 || (c < 1649
                  ? (c >= 1646 && c <= 1647)
                  : c <= 1747)))
              : (c <= 1749 || (c < 1808
                ? (c < 1774
                  ? (c >= 1765 && c <= 1766)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1984 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2185
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : (c <= 2154 || (c >= 2160 && c <= 2183)))
                : (c <= 2190 || (c < 2308
                  ? (c >= 2208 && c <= 2249)
                  : c <= 2361)))))))))
        : (c <= 2365 || (c < 2703
          ? (c < 2534
            ? (c < 2474
              ? (c < 2417
                ? (c < 2392
                  ? c == 2384
                  : (c <= 2401 || (c >= 2406 && c <= 2415)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : (c <= 2448 || (c >= 2451 && c <= 2472)))))
              : (c <= 2480 || (c < 2510
                ? (c < 2486
                  ? c == 2482
                  : (c <= 2489 || c == 2493))
                : (c <= 2510 || (c < 2527
                  ? (c >= 2524 && c <= 2525)
                  : c <= 2529)))))
            : (c <= 2545 || (c < 2613
              ? (c < 2579
                ? (c < 2565
                  ? c == 2556
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2610
                  ? (c >= 2602 && c <= 2608)
                  : c <= 2611)))
              : (c <= 2614 || (c < 2662
                ? (c < 2649
                  ? (c >= 2616 && c <= 2617)
                  : (c <= 2652 || c == 2654))
                : (c <= 2671 || (c < 2693
                  ? (c >= 2674 && c <= 2676)
                  : c <= 2701)))))))
          : (c <= 2705 || (c < 2866
            ? (c < 2784
              ? (c < 2741
                ? (c < 2730
                  ? (c >= 2707 && c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2768
                  ? c == 2749
                  : c <= 2768)))
              : (c <= 2785 || (c < 2831
                ? (c < 2809
                  ? (c >= 2790 && c <= 2799)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2947
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2929
                  ? (c >= 2918 && c <= 2927)
                  : c <= 2929)))
              : (c <= 2947 || (c < 2969
                ? (c < 2958
                  ? (c >= 2949 && c <= 2954)
                  : (c <= 2960 || (c >= 2962 && c <= 2965)))
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 3872
        ? (c < 3406
          ? (c < 3205
            ? (c < 3114
              ? (c < 3046
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3055 || (c < 3086
                  ? (c >= 3077 && c <= 3084)
                  : (c <= 3088 || (c >= 3090 && c <= 3112)))))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3200
                  ? (c >= 3174 && c <= 3183)
                  : c <= 3200)))))
            : (c <= 3212 || (c < 3296
              ? (c < 3253
                ? (c < 3218
                  ? (c >= 3214 && c <= 3216)
                  : (c <= 3240 || (c >= 3242 && c <= 3251)))
                : (c <= 3257 || (c < 3293
                  ? c == 3261
                  : c <= 3294)))
              : (c <= 3297 || (c < 3342
                ? (c < 3313
                  ? (c >= 3302 && c <= 3311)
                  : (c <= 3314 || (c >= 3332 && c <= 3340)))
                : (c <= 3344 || (c < 3389
                  ? (c >= 3346 && c <= 3386)
                  : c <= 3389)))))))
          : (c <= 3406 || (c < 3664
            ? (c < 3507
              ? (c < 3450
                ? (c < 3423
                  ? (c >= 3412 && c <= 3414)
                  : (c <= 3425 || (c >= 3430 && c <= 3439)))
                : (c <= 3455 || (c < 3482
                  ? (c >= 3461 && c <= 3478)
                  : c <= 3505)))
              : (c <= 3515 || (c < 3585
                ? (c < 3520
                  ? c == 3517
                  : (c <= 3526 || (c >= 3558 && c <= 3567)))
                : (c <= 3632 || (c < 3648
                  ? (c >= 3634 && c <= 3635)
                  : c <= 3654)))))
            : (c <= 3673 || (c < 3762
              ? (c < 3724
                ? (c < 3716
                  ? (c >= 3713 && c <= 3714)
                  : (c <= 3716 || (c >= 3718 && c <= 3722)))
                : (c <= 3747 || (c < 3751
                  ? c == 3749
                  : c <= 3760)))
              : (c <= 3763 || (c < 3792
                ? (c < 3776
                  ? c == 3773
                  : (c <= 3780 || c == 3782))
                : (c <= 3801 || (c < 3840
                  ? (c >= 3804 && c <= 3807)
                  : c <= 3840)))))))))
        : (c <= 3881 || (c < 4802
          ? (c < 4295
            ? (c < 4193
              ? (c < 4096
                ? (c < 3913
                  ? (c >= 3904 && c <= 3911)
                  : (c <= 3948 || (c >= 3976 && c <= 3980)))
                : (c <= 4138 || (c < 4176
                  ? (c >= 4159 && c <= 4169)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))
              : (c <= 4193 || (c < 4238
                ? (c < 4206
                  ? (c >= 4197 && c <= 4198)
                  : (c <= 4208 || (c >= 4213 && c <= 4225)))
                : (c <= 4238 || (c < 4256
                  ? (c >= 4240 && c <= 4249)
                  : c <= 4293)))))
            : (c <= 4295 || (c < 4698
              ? (c < 4682
                ? (c < 4304
                  ? c == 4301
                  : (c <= 4346 || (c >= 4348 && c <= 4680)))
                : (c <= 4685 || (c < 4696
                  ? (c >= 4688 && c <= 4694)
                  : c <= 4696)))
              : (c <= 4701 || (c < 4786
                ? (c < 4746
                  ? (c >= 4704 && c <= 4744)
                  : (c <= 4749 || (c >= 4752 && c <= 4784)))
                : (c <= 4789 || (c < 4800
                  ? (c >= 4792 && c <= 4798)
                  : c <= 4800)))))))
          : (c <= 4805 || (c < 5919
            ? (c < 5112
              ? (c < 4888
                ? (c < 4824
                  ? (c >= 4808 && c <= 4822)
                  : (c <= 4880 || (c >= 4882 && c <= 4885)))
                : (c <= 4954 || (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : c <= 5109)))
              : (c <= 5117 || (c < 5792
                ? (c < 5743
                  ? (c >= 5121 && c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))
                : (c <= 5866 || (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : c <= 5905)))))
            : (c <= 5937 || (c < 6112
              ? (c < 6016
                ? (c < 5984
                  ? (c >= 5952 && c <= 5969)
                  : (c <= 5996 || (c >= 5998 && c <= 6000)))
                : (c <= 6067 || (c < 6108
                  ? c == 6103
                  : c <= 6108)))
              : (c <= 6121 || (c < 6279
                ? (c < 6176
                  ? (c >= 6160 && c <= 6169)
                  : (c <= 6264 || (c >= 6272 && c <= 6276)))
                : (c <= 6312 || (c < 6320
                  ? c == 6314
                  : c <= 6389)))))))))))))
    : (c <= 6430 || (c < 43216
      ? (c < 8490
        ? (c < 7968
          ? (c < 7086
            ? (c < 6784
              ? (c < 6576
                ? (c < 6512
                  ? (c >= 6470 && c <= 6509)
                  : (c <= 6516 || (c >= 6528 && c <= 6571)))
                : (c <= 6601 || (c < 6656
                  ? (c >= 6608 && c <= 6617)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6793 || (c < 6981
                ? (c < 6823
                  ? (c >= 6800 && c <= 6809)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7043
                  ? (c >= 6992 && c <= 7001)
                  : c <= 7072)))))
            : (c <= 7141 || (c < 7401
              ? (c < 7296
                ? (c < 7232
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7241 || (c >= 7245 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))
              : (c <= 7404 || (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))))))
          : (c <= 8005 || (c < 8160
            ? (c < 8064
              ? (c < 8027
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : (c <= 8023 || c == 8025))
                : (c <= 8027 || (c < 8031
                  ? c == 8029
                  : c <= 8061)))
              : (c <= 8116 || (c < 8134
                ? (c < 8126
                  ? (c >= 8118 && c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))
                : (c <= 8140 || (c < 8150
                  ? (c >= 8144 && c <= 8147)
                  : c <= 8155)))))
            : (c <= 8172 || (c < 8455
              ? (c < 8319
                ? (c < 8182
                  ? (c >= 8178 && c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8450
                  ? (c >= 8336 && c <= 8348)
                  : c <= 8450)))
              : (c <= 8455 || (c < 8484
                ? (c < 8469
                  ? (c >= 8458 && c <= 8467)
                  : (c <= 8469 || (c >= 8473 && c <= 8477)))
                : (c <= 8484 || (c < 8488
                  ? c == 8486
                  : c <= 8488)))))))))
        : (c <= 8493 || (c < 12449
          ? (c < 11680
            ? (c < 11506
              ? (c < 8526
                ? (c < 8508
                  ? (c >= 8495 && c <= 8505)
                  : (c <= 8511 || (c >= 8517 && c <= 8521)))
                : (c <= 8526 || (c < 11264
                  ? (c >= 8579 && c <= 8580)
                  : (c <= 11492 || (c >= 11499 && c <= 11502)))))
              : (c <= 11507 || (c < 11568
                ? (c < 11559
                  ? (c >= 11520 && c <= 11557)
                  : (c <= 11559 || c == 11565))
                : (c <= 11623 || (c < 11648
                  ? c == 11631
                  : c <= 11670)))))
            : (c <= 11686 || (c < 11736
              ? (c < 11712
                ? (c < 11696
                  ? (c >= 11688 && c <= 11694)
                  : (c <= 11702 || (c >= 11704 && c <= 11710)))
                : (c <= 11718 || (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : c <= 11734)))
              : (c <= 11742 || (c < 12347
                ? (c < 12293
                  ? c == 11823
                  : (c <= 12294 || (c >= 12337 && c <= 12341)))
                : (c <= 12348 || (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)))))))
          : (c <= 12538 || (c < 42623
            ? (c < 19903
              ? (c < 12704
                ? (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : (c <= 12591 || (c >= 12593 && c <= 12686)))
                : (c <= 12735 || (c < 13312
                  ? (c >= 12784 && c <= 12799)
                  : c <= 13312)))
              : (c <= 19903 || (c < 42240
                ? (c < 40959
                  ? c == 19968
                  : (c <= 42124 || (c >= 42192 && c <= 42237)))
                : (c <= 42508 || (c < 42560
                  ? (c >= 42512 && c <= 42539)
                  : c <= 42606)))))
            : (c <= 42653 || (c < 42965
              ? (c < 42891
                ? (c < 42775
                  ? (c >= 42656 && c <= 42725)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))
                : (c <= 42954 || (c < 42963
                  ? (c >= 42960 && c <= 42961)
                  : c <= 42963)))
              : (c <= 42969 || (c < 43020
                ? (c < 43011
                  ? (c >= 42994 && c <= 43009)
                  : (c <= 43013 || (c >= 43015 && c <= 43018)))
                : (c <= 43042 || (c < 43138
                  ? (c >= 43072 && c <= 43123)
                  : c <= 43187)))))))))))
      : (c <= 43225 || (c < 65296
        ? (c < 43808
          ? (c < 43616
            ? (c < 43471
              ? (c < 43264
                ? (c < 43259
                  ? (c >= 43250 && c <= 43255)
                  : (c <= 43259 || (c >= 43261 && c <= 43262)))
                : (c <= 43301 || (c < 43360
                  ? (c >= 43312 && c <= 43334)
                  : (c <= 43388 || (c >= 43396 && c <= 43442)))))
              : (c <= 43481 || (c < 43584
                ? (c < 43494
                  ? (c >= 43488 && c <= 43492)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43600
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43609)))))
            : (c <= 43638 || (c < 43714
              ? (c < 43701
                ? (c < 43646
                  ? c == 43642
                  : (c <= 43695 || c == 43697))
                : (c <= 43702 || (c < 43712
                  ? (c >= 43705 && c <= 43709)
                  : c <= 43712)))
              : (c <= 43714 || (c < 43777
                ? (c < 43744
                  ? (c >= 43739 && c <= 43741)
                  : (c <= 43754 || (c >= 43762 && c <= 43764)))
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64285
            ? (c < 55203
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 44032
                  ? (c >= 44016 && c <= 44025)
                  : c <= 44032)))
              : (c <= 55203 || (c < 64112
                ? (c < 55243
                  ? (c >= 55216 && c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))
                : (c <= 64217 || (c < 64275
                  ? (c >= 64256 && c <= 64262)
                  : c <= 64279)))))
            : (c <= 64285 || (c < 64326
              ? (c < 64318
                ? (c < 64298
                  ? (c >= 64287 && c <= 64296)
                  : (c <= 64310 || (c >= 64312 && c <= 64316)))
                : (c <= 64318 || (c < 64323
                  ? (c >= 64320 && c <= 64321)
                  : c <= 64324)))
              : (c <= 64433 || (c < 65008
                ? (c < 64848
                  ? (c >= 64467 && c <= 64829)
                  : (c <= 64911 || (c >= 64914 && c <= 64967)))
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65305 || (c < 66816
          ? (c < 65664
            ? (c < 65498
              ? (c < 65474
                ? (c < 65345
                  ? (c >= 65313 && c <= 65338)
                  : (c <= 65370 || (c >= 65382 && c <= 65470)))
                : (c <= 65479 || (c < 65490
                  ? (c >= 65482 && c <= 65487)
                  : c <= 65495)))
              : (c <= 65500 || (c < 65596
                ? (c < 65549
                  ? (c >= 65536 && c <= 65547)
                  : (c <= 65574 || (c >= 65576 && c <= 65594)))
                : (c <= 65597 || (c < 65616
                  ? (c >= 65599 && c <= 65613)
                  : c <= 65629)))))
            : (c <= 65786 || (c < 66432
              ? (c < 66349
                ? (c < 66208
                  ? (c >= 66176 && c <= 66204)
                  : (c <= 66256 || (c >= 66304 && c <= 66335)))
                : (c <= 66368 || (c < 66384
                  ? (c >= 66370 && c <= 66377)
                  : c <= 66421)))
              : (c <= 66461 || (c < 66720
                ? (c < 66504
                  ? (c >= 66464 && c <= 66499)
                  : (c <= 66511 || (c >= 66560 && c <= 66717)))
                : (c <= 66729 || (c < 66776
                  ? (c >= 66736 && c <= 66771)
                  : c <= 66811)))))))
          : (c <= 66855 || (c < 67463
            ? (c < 66979
              ? (c < 66956
                ? (c < 66928
                  ? (c >= 66864 && c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))
                : (c <= 66962 || (c < 66967
                  ? (c >= 66964 && c <= 66965)
                  : c <= 66977)))
              : (c <= 66993 || (c < 67392
                ? (c < 67003
                  ? (c >= 66995 && c <= 67001)
                  : (c <= 67004 || (c >= 67072 && c <= 67382)))
                : (c <= 67413 || (c < 67456
                  ? (c >= 67424 && c <= 67431)
                  : c <= 67461)))))
            : (c <= 67504 || (c < 67647
              ? (c < 67594
                ? (c < 67584
                  ? (c >= 67506 && c <= 67514)
                  : (c <= 67589 || c == 67592))
                : (c <= 67637 || (c < 67644
                  ? (c >= 67639 && c <= 67640)
                  : c <= 67644)))
              : (c <= 67669 || (c < 67828
                ? (c < 67712
                  ? (c >= 67680 && c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67880)))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(70);
      if (lookahead == '!') ADVANCE(193);
      if (lookahead == '"') ADVANCE(103);
      if (lookahead == '%') ADVANCE(180);
      if (lookahead == '&') ADVANCE(139);
      if (lookahead == '\'') ADVANCE(23);
      if (lookahead == '(') ADVANCE(135);
      if (lookahead == ')') ADVANCE(136);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(188);
      if (lookahead == '-') ADVANCE(168);
      if (lookahead == '.') ADVANCE(201);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == '0') ADVANCE(72);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == ';') ADVANCE(206);
      if (lookahead == '<') ADVANCE(157);
      if (lookahead == '=') ADVANCE(141);
      if (lookahead == '>') ADVANCE(154);
      if (lookahead == '?') ADVANCE(189);
      if (lookahead == '@') ADVANCE(208);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == '\\') ADVANCE(44);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == '^') ADVANCE(178);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead == '{') ADVANCE(204);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(205);
      if (lookahead == '~') ADVANCE(194);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(67)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(215);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(193);
      if (lookahead == '"') ADVANCE(103);
      if (lookahead == '%') ADVANCE(179);
      if (lookahead == '&') ADVANCE(138);
      if (lookahead == '\'') ADVANCE(23);
      if (lookahead == '(') ADVANCE(135);
      if (lookahead == ')') ADVANCE(136);
      if (lookahead == '*') ADVANCE(170);
      if (lookahead == '+') ADVANCE(165);
      if (lookahead == ',') ADVANCE(188);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == '0') ADVANCE(72);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == ';') ADVANCE(206);
      if (lookahead == '<') ADVANCE(158);
      if (lookahead == '=') ADVANCE(22);
      if (lookahead == '>') ADVANCE(155);
      if (lookahead == '?') ADVANCE(189);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == '^') ADVANCE(177);
      if (lookahead == '{') ADVANCE(204);
      if (lookahead == '|') ADVANCE(176);
      if (lookahead == '}') ADVANCE(205);
      if (lookahead == '~') ADVANCE(194);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(215);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(192);
      if (lookahead == '"') ADVANCE(103);
      if (lookahead == '&') ADVANCE(137);
      if (lookahead == '\'') ADVANCE(23);
      if (lookahead == '(') ADVANCE(135);
      if (lookahead == ')') ADVANCE(136);
      if (lookahead == '+') ADVANCE(165);
      if (lookahead == ',') ADVANCE(188);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(53);
      if (lookahead == '/') ADVANCE(12);
      if (lookahead == '0') ADVANCE(72);
      if (lookahead == ':') ADVANCE(190);
      if (lookahead == ';') ADVANCE(206);
      if (lookahead == '=') ADVANCE(140);
      if (lookahead == '>') ADVANCE(153);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead == '}') ADVANCE(205);
      if (lookahead == '~') ADVANCE(194);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(215);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '%') ADVANCE(180);
      if (lookahead == '&') ADVANCE(139);
      if (lookahead == '(') ADVANCE(135);
      if (lookahead == ')') ADVANCE(136);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(188);
      if (lookahead == '-') ADVANCE(168);
      if (lookahead == '.') ADVANCE(200);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == ';') ADVANCE(206);
      if (lookahead == '<') ADVANCE(157);
      if (lookahead == '=') ADVANCE(141);
      if (lookahead == '>') ADVANCE(154);
      if (lookahead == '?') ADVANCE(189);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == '^') ADVANCE(178);
      if (lookahead == '{') ADVANCE(204);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(205);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(215);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '%') ADVANCE(179);
      if (lookahead == '&') ADVANCE(138);
      if (lookahead == '(') ADVANCE(135);
      if (lookahead == ')') ADVANCE(136);
      if (lookahead == '*') ADVANCE(170);
      if (lookahead == '+') ADVANCE(165);
      if (lookahead == ',') ADVANCE(188);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(199);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == ';') ADVANCE(206);
      if (lookahead == '<') ADVANCE(158);
      if (lookahead == '=') ADVANCE(22);
      if (lookahead == '>') ADVANCE(155);
      if (lookahead == '?') ADVANCE(189);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == '^') ADVANCE(177);
      if (lookahead == '{') ADVANCE(204);
      if (lookahead == '|') ADVANCE(176);
      if (lookahead == '}') ADVANCE(205);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(215);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(104);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(124);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(116);
      if (lookahead != 0) ADVANCE(123);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(102);
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(109);
      if (lookahead != 0) ADVANCE(110);
      END_STATE();
    case 8:
      if (lookahead == '&') ADVANCE(137);
      if (lookahead == '(') ADVANCE(135);
      if (lookahead == ')') ADVANCE(136);
      if (lookahead == ',') ADVANCE(188);
      if (lookahead == '.') ADVANCE(200);
      if (lookahead == '/') ADVANCE(12);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == ';') ADVANCE(206);
      if (lookahead == '<') ADVANCE(156);
      if (lookahead == '=') ADVANCE(140);
      if (lookahead == '>') ADVANCE(153);
      if (lookahead == '?') ADVANCE(189);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == '{') ADVANCE(204);
      if (lookahead == '|') ADVANCE(174);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(215);
      END_STATE();
    case 9:
      if (lookahead == '\'') ADVANCE(101);
      if (lookahead == '\\') ADVANCE(66);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(9);
      END_STATE();
    case 10:
      if (lookahead == '(') ADVANCE(135);
      if (lookahead == ',') ADVANCE(188);
      if (lookahead == '.') ADVANCE(199);
      if (lookahead == '/') ADVANCE(12);
      if (lookahead == ';') ADVANCE(206);
      if (lookahead == '<') ADVANCE(156);
      if (lookahead == '@') ADVANCE(208);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead == '{') ADVANCE(204);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(215);
      END_STATE();
    case 11:
      if (lookahead == '(') ADVANCE(135);
      if (lookahead == '.') ADVANCE(199);
      if (lookahead == '/') ADVANCE(12);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(215);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(14);
      if (lookahead == '/') ADVANCE(216);
      END_STATE();
    case 13:
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(217);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 14:
      if (lookahead == '*') ADVANCE(13);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(88);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == '_') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(16);
      END_STATE();
    case 17:
      if (lookahead == '.') ADVANCE(211);
      END_STATE();
    case 18:
      if (lookahead == '.') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 19:
      if (lookahead == '/') ADVANCE(12);
      if (lookahead == '<') ADVANCE(156);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(215);
      END_STATE();
    case 20:
      if (lookahead == '0') ADVANCE(100);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(97);
      END_STATE();
    case 21:
      if (lookahead == '=') ADVANCE(162);
      END_STATE();
    case 22:
      if (lookahead == '=') ADVANCE(161);
      END_STATE();
    case 23:
      if (lookahead == '\\') ADVANCE(66);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(9);
      END_STATE();
    case 24:
      if (lookahead == '_') ADVANCE(24);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(75);
      END_STATE();
    case 25:
      if (lookahead == '_') ADVANCE(24);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(73);
      END_STATE();
    case 26:
      if (lookahead == '_') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 27:
      if (lookahead == '_') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(96);
      END_STATE();
    case 28:
      if (lookahead == '_') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(95);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(93);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(39);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(31);
      END_STATE();
    case 31:
      if (lookahead == 'c') ADVANCE(36);
      END_STATE();
    case 32:
      if (lookahead == 'd') ADVANCE(209);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(41);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(29);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(210);
      END_STATE();
    case 37:
      if (lookahead == 'f') ADVANCE(30);
      END_STATE();
    case 38:
      if (lookahead == 'i') ADVANCE(40);
      END_STATE();
    case 39:
      if (lookahead == 'l') ADVANCE(35);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(43);
      END_STATE();
    case 41:
      if (lookahead == 'r') ADVANCE(37);
      END_STATE();
    case 42:
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(33);
      END_STATE();
    case 44:
      if (lookahead == 'u') ADVANCE(46);
      if (lookahead == 'x') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(127);
      if (sym_escape_sequence_character_set_1(lookahead)) ADVANCE(130);
      if (lookahead != 0) ADVANCE(126);
      END_STATE();
    case 45:
      if (lookahead == 'u') ADVANCE(46);
      if (lookahead == 'x') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(132);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 46:
      if (lookahead == '{') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      END_STATE();
    case 47:
      if (lookahead == '}') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 48:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(20);
      if (lookahead == '0') ADVANCE(100);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(97);
      END_STATE();
    case 49:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(89);
      END_STATE();
    case 50:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(86);
      END_STATE();
    case 51:
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(83);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(84);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(88);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(16);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(89);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(73);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(96);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(95);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(93);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 61:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(130);
      END_STATE();
    case 62:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 63:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(93);
      END_STATE();
    case 64:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 65:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(61);
      END_STATE();
    case 66:
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 67:
      if (eof) ADVANCE(70);
      if (lookahead == '!') ADVANCE(193);
      if (lookahead == '"') ADVANCE(103);
      if (lookahead == '%') ADVANCE(180);
      if (lookahead == '&') ADVANCE(139);
      if (lookahead == '\'') ADVANCE(23);
      if (lookahead == '(') ADVANCE(135);
      if (lookahead == ')') ADVANCE(136);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(188);
      if (lookahead == '-') ADVANCE(168);
      if (lookahead == '.') ADVANCE(201);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == '0') ADVANCE(72);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == ';') ADVANCE(206);
      if (lookahead == '<') ADVANCE(157);
      if (lookahead == '=') ADVANCE(141);
      if (lookahead == '>') ADVANCE(154);
      if (lookahead == '?') ADVANCE(189);
      if (lookahead == '@') ADVANCE(208);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == '^') ADVANCE(178);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead == '{') ADVANCE(204);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(205);
      if (lookahead == '~') ADVANCE(194);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(67)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(215);
      END_STATE();
    case 68:
      if (eof) ADVANCE(70);
      if (lookahead == '!') ADVANCE(193);
      if (lookahead == '"') ADVANCE(103);
      if (lookahead == '%') ADVANCE(179);
      if (lookahead == '&') ADVANCE(138);
      if (lookahead == '\'') ADVANCE(23);
      if (lookahead == '(') ADVANCE(135);
      if (lookahead == ')') ADVANCE(136);
      if (lookahead == '*') ADVANCE(170);
      if (lookahead == '+') ADVANCE(165);
      if (lookahead == ',') ADVANCE(188);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(202);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == '0') ADVANCE(72);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == ';') ADVANCE(206);
      if (lookahead == '<') ADVANCE(158);
      if (lookahead == '=') ADVANCE(22);
      if (lookahead == '>') ADVANCE(155);
      if (lookahead == '?') ADVANCE(189);
      if (lookahead == '@') ADVANCE(208);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == '^') ADVANCE(177);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead == '{') ADVANCE(204);
      if (lookahead == '|') ADVANCE(176);
      if (lookahead == '}') ADVANCE(205);
      if (lookahead == '~') ADVANCE(194);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(68)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(215);
      END_STATE();
    case 69:
      if (eof) ADVANCE(70);
      if (lookahead == '!') ADVANCE(193);
      if (lookahead == '"') ADVANCE(103);
      if (lookahead == '%') ADVANCE(179);
      if (lookahead == '&') ADVANCE(138);
      if (lookahead == '\'') ADVANCE(23);
      if (lookahead == '(') ADVANCE(135);
      if (lookahead == ')') ADVANCE(136);
      if (lookahead == '*') ADVANCE(170);
      if (lookahead == '+') ADVANCE(165);
      if (lookahead == ',') ADVANCE(188);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(53);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == '0') ADVANCE(72);
      if (lookahead == ':') ADVANCE(190);
      if (lookahead == ';') ADVANCE(206);
      if (lookahead == '<') ADVANCE(158);
      if (lookahead == '=') ADVANCE(22);
      if (lookahead == '>') ADVANCE(155);
      if (lookahead == '?') ADVANCE(189);
      if (lookahead == '@') ADVANCE(208);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == '^') ADVANCE(177);
      if (lookahead == 'n') ADVANCE(214);
      if (lookahead == '{') ADVANCE(204);
      if (lookahead == '|') ADVANCE(176);
      if (lookahead == '}') ADVANCE(205);
      if (lookahead == '~') ADVANCE(194);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(69)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(74);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(215);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(50);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(71);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(52);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(18);
      if (lookahead == '_') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(49);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(49);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(16);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(83);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(71);
      if (lookahead == '_') ADVANCE(25);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(49);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(49);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(73);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(71);
      if (lookahead == '_') ADVANCE(56);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(49);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(49);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(73);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(71);
      if (lookahead == '_') ADVANCE(24);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(49);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(49);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(75);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(99);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(76);
      if (lookahead == '_') ADVANCE(57);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(81);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(99);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(76);
      if (lookahead == '_') ADVANCE(26);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(81);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(99);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(76);
      if (lookahead == '_') ADVANCE(62);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(81);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(80);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(99);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(76);
      if (lookahead == '_') ADVANCE(62);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(81);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(20);
      if (lookahead == '.') ADVANCE(99);
      if (lookahead == '0') ADVANCE(79);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(76);
      if (lookahead == '_') ADVANCE(62);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(81);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(82);
      if (lookahead == '_') ADVANCE(51);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(83);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(82);
      if (lookahead == '_') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(84);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(85);
      if (lookahead == '_') ADVANCE(50);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(86);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(53);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(49);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(88);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(55);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(89);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(49);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(88);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(63);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(98);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(93);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(63);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(98);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(93);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(59);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(98);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(93);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(95);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(28);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(98);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(93);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(95);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(27);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(96);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(58);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(96);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(20);
      if (lookahead == '0') ADVANCE(92);
      if (lookahead == '_') ADVANCE(63);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(98);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(94);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(93);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(98);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(93);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(91);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_character_literal);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(5);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(105);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == '*') ADVANCE(108);
      if (lookahead == '/') ADVANCE(105);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(110);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '/') ADVANCE(110);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(108);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(108);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(109);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(110);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(110);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '\n') ADVANCE(123);
      if (lookahead == '"') ADVANCE(216);
      if (lookahead != 0) ADVANCE(111);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '"') ADVANCE(14);
      if (lookahead == '*') ADVANCE(112);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead != 0) ADVANCE(113);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '"') ADVANCE(14);
      if (lookahead == '*') ADVANCE(112);
      if (lookahead != 0) ADVANCE(113);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '"') ADVANCE(130);
      if (lookahead == 'u') ADVANCE(117);
      if (lookahead == 'x') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(128);
      if (lookahead == '\'' ||
          lookahead == '?' ||
          lookahead == '\\' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          ('t' <= lookahead && lookahead <= 'v')) ADVANCE(134);
      if (lookahead != 0) ADVANCE(129);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '*') ADVANCE(113);
      if (lookahead == '/') ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(123);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(116);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(123);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '{') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(119);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(123);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '}') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(118);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(123);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(122);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(123);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(134);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(123);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(118);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(123);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(120);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(123);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(123);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token2);
      if (lookahead == '"') ADVANCE(5);
      if (lookahead != 0) ADVANCE(125);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token2);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(125);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(131);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(133);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(123);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(123);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(130);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(131);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(134);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(123);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(123);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(163);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(163);
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(161);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(159);
      if (lookahead == '>') ADVANCE(183);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(159);
      if (lookahead == '>') ADVANCE(184);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(182);
      if (lookahead == '=') ADVANCE(160);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(181);
      if (lookahead == '=') ADVANCE(160);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(195);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(195);
      if (lookahead == '=') ADVANCE(142);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(196);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(196);
      if (lookahead == '=') ADVANCE(143);
      if (lookahead == '>') ADVANCE(187);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(196);
      if (lookahead == '>') ADVANCE(187);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(144);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(14);
      if (lookahead == '/') ADVANCE(216);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(14);
      if (lookahead == '/') ADVANCE(216);
      if (lookahead == '=') ADVANCE(145);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(147);
      if (lookahead == '|') ADVANCE(164);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(164);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(148);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(149);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(150);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(151);
      if (lookahead == '>') ADVANCE(186);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(185);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(152);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(203);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(162);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(17);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(88);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(88);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == 'i') ADVANCE(40);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_non_DASHsealed);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_ATinterface);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(42);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(215);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(212);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(215);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(213);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(215);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(215);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(216);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_block_comment);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'p') ADVANCE(12);
      if (lookahead == 'r') ADVANCE(13);
      if (lookahead == 's') ADVANCE(14);
      if (lookahead == 't') ADVANCE(15);
      if (lookahead == 'u') ADVANCE(16);
      if (lookahead == 'v') ADVANCE(17);
      if (lookahead == 'w') ADVANCE(18);
      if (lookahead == 'y') ADVANCE(19);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(20);
      if (lookahead == 's') ADVANCE(21);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(22);
      if (lookahead == 'r') ADVANCE(23);
      if (lookahead == 'y') ADVANCE(24);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(25);
      if (lookahead == 'h') ADVANCE(26);
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(32);
      if (lookahead == 'x') ADVANCE(33);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'i') ADVANCE(35);
      if (lookahead == 'l') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(38);
      if (lookahead == 'm') ADVANCE(39);
      if (lookahead == 'n') ADVANCE(40);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(42);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(43);
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(45);
      END_STATE();
    case 11:
      if (lookahead == 'p') ADVANCE(46);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      if (lookahead == 'u') ADVANCE(50);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(52);
      if (lookahead == 'h') ADVANCE(53);
      if (lookahead == 't') ADVANCE(54);
      if (lookahead == 'u') ADVANCE(55);
      if (lookahead == 'w') ADVANCE(56);
      if (lookahead == 'y') ADVANCE(57);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(58);
      if (lookahead == 'o') ADVANCE(59);
      if (lookahead == 'r') ADVANCE(60);
      END_STATE();
    case 16:
      if (lookahead == 's') ADVANCE(61);
      END_STATE();
    case 17:
      if (lookahead == 'o') ADVANCE(62);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(63);
      if (lookahead == 'i') ADVANCE(64);
      END_STATE();
    case 19:
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 20:
      if (lookahead == 's') ADVANCE(66);
      END_STATE();
    case 21:
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 22:
      if (lookahead == 'o') ADVANCE(68);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(69);
      END_STATE();
    case 24:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(71);
      if (lookahead == 't') ADVANCE(72);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(73);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(74);
      END_STATE();
    case 28:
      if (lookahead == 'n') ADVANCE(75);
      END_STATE();
    case 29:
      if (lookahead == 'f') ADVANCE(76);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(77);
      END_STATE();
    case 31:
      if (lookahead == 's') ADVANCE(78);
      END_STATE();
    case 32:
      if (lookahead == 'u') ADVANCE(79);
      END_STATE();
    case 33:
      if (lookahead == 'p') ADVANCE(80);
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 34:
      if (lookahead == 'l') ADVANCE(82);
      END_STATE();
    case 35:
      if (lookahead == 'n') ADVANCE(83);
      END_STATE();
    case 36:
      if (lookahead == 'o') ADVANCE(84);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(85);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 39:
      if (lookahead == 'p') ADVANCE(86);
      END_STATE();
    case 40:
      if (lookahead == 's') ADVANCE(87);
      if (lookahead == 't') ADVANCE(88);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(89);
      END_STATE();
    case 42:
      if (lookahead == 'd') ADVANCE(90);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(91);
      END_STATE();
    case 44:
      if (lookahead == 'w') ADVANCE(92);
      END_STATE();
    case 45:
      if (lookahead == 'l') ADVANCE(93);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 47:
      if (lookahead == 'c') ADVANCE(95);
      END_STATE();
    case 48:
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 49:
      if (lookahead == 'i') ADVANCE(97);
      if (lookahead == 'o') ADVANCE(98);
      END_STATE();
    case 50:
      if (lookahead == 'b') ADVANCE(99);
      END_STATE();
    case 51:
      if (lookahead == 'c') ADVANCE(100);
      if (lookahead == 'q') ADVANCE(101);
      if (lookahead == 't') ADVANCE(102);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(103);
      END_STATE();
    case 53:
      if (lookahead == 'o') ADVANCE(104);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'r') ADVANCE(106);
      END_STATE();
    case 55:
      if (lookahead == 'p') ADVANCE(107);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(108);
      END_STATE();
    case 57:
      if (lookahead == 'n') ADVANCE(109);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(110);
      if (lookahead == 'r') ADVANCE(111);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_to);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(112);
      if (lookahead == 'u') ADVANCE(113);
      if (lookahead == 'y') ADVANCE(114);
      END_STATE();
    case 61:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(116);
      if (lookahead == 'l') ADVANCE(117);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(118);
      END_STATE();
    case 64:
      if (lookahead == 't') ADVANCE(119);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 66:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(122);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(123);
      END_STATE();
    case 69:
      if (lookahead == 'a') ADVANCE(124);
      END_STATE();
    case 70:
      if (lookahead == 'e') ADVANCE(125);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 72:
      if (lookahead == 'c') ADVANCE(127);
      END_STATE();
    case 73:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 74:
      if (lookahead == 's') ADVANCE(129);
      END_STATE();
    case 75:
      if (lookahead == 't') ADVANCE(130);
      END_STATE();
    case 76:
      if (lookahead == 'a') ADVANCE(131);
      END_STATE();
    case 77:
      if (lookahead == 'b') ADVANCE(132);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(133);
      END_STATE();
    case 79:
      if (lookahead == 'm') ADVANCE(134);
      END_STATE();
    case 80:
      if (lookahead == 'o') ADVANCE(135);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(136);
      END_STATE();
    case 82:
      if (lookahead == 's') ADVANCE(137);
      END_STATE();
    case 83:
      if (lookahead == 'a') ADVANCE(138);
      END_STATE();
    case 84:
      if (lookahead == 'a') ADVANCE(139);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 86:
      if (lookahead == 'l') ADVANCE(140);
      if (lookahead == 'o') ADVANCE(141);
      END_STATE();
    case 87:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == 'e') ADVANCE(143);
      END_STATE();
    case 89:
      if (lookahead == 'g') ADVANCE(144);
      END_STATE();
    case 90:
      if (lookahead == 'u') ADVANCE(145);
      END_STATE();
    case 91:
      if (lookahead == 'i') ADVANCE(146);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 93:
      if (lookahead == 'l') ADVANCE(147);
      END_STATE();
    case 94:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 95:
      if (lookahead == 'k') ADVANCE(149);
      END_STATE();
    case 96:
      if (lookahead == 'm') ADVANCE(150);
      END_STATE();
    case 97:
      if (lookahead == 'v') ADVANCE(151);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(152);
      if (lookahead == 'v') ADVANCE(153);
      END_STATE();
    case 99:
      if (lookahead == 'l') ADVANCE(154);
      END_STATE();
    case 100:
      if (lookahead == 'o') ADVANCE(155);
      END_STATE();
    case 101:
      if (lookahead == 'u') ADVANCE(156);
      END_STATE();
    case 102:
      if (lookahead == 'u') ADVANCE(157);
      END_STATE();
    case 103:
      if (lookahead == 'l') ADVANCE(158);
      END_STATE();
    case 104:
      if (lookahead == 'r') ADVANCE(159);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(160);
      END_STATE();
    case 106:
      if (lookahead == 'i') ADVANCE(161);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(163);
      END_STATE();
    case 109:
      if (lookahead == 'c') ADVANCE(164);
      END_STATE();
    case 110:
      if (lookahead == 's') ADVANCE(165);
      END_STATE();
    case 111:
      if (lookahead == 'o') ADVANCE(166);
      END_STATE();
    case 112:
      if (lookahead == 'n') ADVANCE(167);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(168);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 115:
      if (lookahead == 's') ADVANCE(169);
      END_STATE();
    case 116:
      if (lookahead == 'd') ADVANCE(170);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(171);
      END_STATE();
    case 118:
      if (lookahead == 'l') ADVANCE(172);
      END_STATE();
    case 119:
      if (lookahead == 'h') ADVANCE(173);
      END_STATE();
    case 120:
      if (lookahead == 'l') ADVANCE(174);
      END_STATE();
    case 121:
      if (lookahead == 'r') ADVANCE(175);
      END_STATE();
    case 122:
      if (lookahead == 'r') ADVANCE(176);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 124:
      if (lookahead == 'k') ADVANCE(178);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_byte);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 127:
      if (lookahead == 'h') ADVANCE(179);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_char);
      END_STATE();
    case 129:
      if (lookahead == 's') ADVANCE(180);
      END_STATE();
    case 130:
      if (lookahead == 'i') ADVANCE(181);
      END_STATE();
    case 131:
      if (lookahead == 'u') ADVANCE(182);
      END_STATE();
    case 132:
      if (lookahead == 'l') ADVANCE(183);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 135:
      if (lookahead == 'r') ADVANCE(184);
      END_STATE();
    case 136:
      if (lookahead == 'n') ADVANCE(185);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 138:
      if (lookahead == 'l') ADVANCE(187);
      END_STATE();
    case 139:
      if (lookahead == 't') ADVANCE(188);
      END_STATE();
    case 140:
      if (lookahead == 'e') ADVANCE(189);
      END_STATE();
    case 141:
      if (lookahead == 'r') ADVANCE(190);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(191);
      END_STATE();
    case 143:
      if (lookahead == 'r') ADVANCE(192);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 145:
      if (lookahead == 'l') ADVANCE(193);
      END_STATE();
    case 146:
      if (lookahead == 'v') ADVANCE(194);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_null_literal);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == 's') ADVANCE(195);
      END_STATE();
    case 149:
      if (lookahead == 'a') ADVANCE(196);
      END_STATE();
    case 150:
      if (lookahead == 'i') ADVANCE(197);
      END_STATE();
    case 151:
      if (lookahead == 'a') ADVANCE(198);
      END_STATE();
    case 152:
      if (lookahead == 'e') ADVANCE(199);
      END_STATE();
    case 153:
      if (lookahead == 'i') ADVANCE(200);
      END_STATE();
    case 154:
      if (lookahead == 'i') ADVANCE(201);
      END_STATE();
    case 155:
      if (lookahead == 'r') ADVANCE(202);
      END_STATE();
    case 156:
      if (lookahead == 'i') ADVANCE(203);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(204);
      END_STATE();
    case 158:
      if (lookahead == 'e') ADVANCE(205);
      END_STATE();
    case 159:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 160:
      if (lookahead == 'i') ADVANCE(207);
      END_STATE();
    case 161:
      if (lookahead == 'c') ADVANCE(208);
      END_STATE();
    case 162:
      if (lookahead == 'r') ADVANCE(209);
      END_STATE();
    case 163:
      if (lookahead == 'c') ADVANCE(210);
      END_STATE();
    case 164:
      if (lookahead == 'h') ADVANCE(211);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 166:
      if (lookahead == 'w') ADVANCE(212);
      END_STATE();
    case 167:
      if (lookahead == 's') ADVANCE(213);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_uses);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_void_type);
      END_STATE();
    case 171:
      if (lookahead == 't') ADVANCE(214);
      END_STATE();
    case 172:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 174:
      if (lookahead == 'd') ADVANCE(216);
      END_STATE();
    case 175:
      if (lookahead == 'a') ADVANCE(217);
      END_STATE();
    case 176:
      if (lookahead == 't') ADVANCE(218);
      END_STATE();
    case 177:
      if (lookahead == 'a') ADVANCE(219);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 181:
      if (lookahead == 'n') ADVANCE(220);
      END_STATE();
    case 182:
      if (lookahead == 'l') ADVANCE(221);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(222);
      END_STATE();
    case 184:
      if (lookahead == 't') ADVANCE(223);
      END_STATE();
    case 185:
      if (lookahead == 'd') ADVANCE(224);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == 'l') ADVANCE(225);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 189:
      if (lookahead == 'm') ADVANCE(226);
      END_STATE();
    case 190:
      if (lookahead == 't') ADVANCE(227);
      END_STATE();
    case 191:
      if (lookahead == 'n') ADVANCE(228);
      END_STATE();
    case 192:
      if (lookahead == 'f') ADVANCE(229);
      END_STATE();
    case 193:
      if (lookahead == 'e') ADVANCE(230);
      END_STATE();
    case 194:
      if (lookahead == 'e') ADVANCE(231);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_opens);
      END_STATE();
    case 196:
      if (lookahead == 'g') ADVANCE(232);
      END_STATE();
    case 197:
      if (lookahead == 't') ADVANCE(233);
      END_STATE();
    case 198:
      if (lookahead == 't') ADVANCE(234);
      END_STATE();
    case 199:
      if (lookahead == 'c') ADVANCE(235);
      END_STATE();
    case 200:
      if (lookahead == 'd') ADVANCE(236);
      END_STATE();
    case 201:
      if (lookahead == 'c') ADVANCE(237);
      END_STATE();
    case 202:
      if (lookahead == 'd') ADVANCE(238);
      END_STATE();
    case 203:
      if (lookahead == 'r') ADVANCE(239);
      END_STATE();
    case 204:
      if (lookahead == 'n') ADVANCE(240);
      END_STATE();
    case 205:
      if (lookahead == 'd') ADVANCE(241);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 207:
      if (lookahead == 'c') ADVANCE(242);
      END_STATE();
    case 208:
      if (lookahead == 't') ADVANCE(243);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 210:
      if (lookahead == 'h') ADVANCE(244);
      END_STATE();
    case 211:
      if (lookahead == 'r') ADVANCE(245);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_throw);
      if (lookahead == 's') ADVANCE(246);
      END_STATE();
    case 213:
      if (lookahead == 'i') ADVANCE(247);
      END_STATE();
    case 214:
      if (lookahead == 'i') ADVANCE(248);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 217:
      if (lookahead == 'c') ADVANCE(249);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 219:
      if (lookahead == 'n') ADVANCE(250);
      END_STATE();
    case 220:
      if (lookahead == 'u') ADVANCE(251);
      END_STATE();
    case 221:
      if (lookahead == 't') ADVANCE(252);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_double);
      END_STATE();
    case 223:
      if (lookahead == 's') ADVANCE(253);
      END_STATE();
    case 224:
      if (lookahead == 's') ADVANCE(254);
      END_STATE();
    case 225:
      if (lookahead == 'y') ADVANCE(255);
      END_STATE();
    case 226:
      if (lookahead == 'e') ADVANCE(256);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 228:
      if (lookahead == 'c') ADVANCE(257);
      END_STATE();
    case 229:
      if (lookahead == 'a') ADVANCE(258);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 232:
      if (lookahead == 'e') ADVANCE(259);
      END_STATE();
    case 233:
      if (lookahead == 's') ADVANCE(260);
      END_STATE();
    case 234:
      if (lookahead == 'e') ADVANCE(261);
      END_STATE();
    case 235:
      if (lookahead == 't') ADVANCE(262);
      END_STATE();
    case 236:
      if (lookahead == 'e') ADVANCE(263);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_record);
      END_STATE();
    case 239:
      if (lookahead == 'e') ADVANCE(264);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_sealed);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 243:
      if (lookahead == 'f') ADVANCE(265);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 245:
      if (lookahead == 'o') ADVANCE(266);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_throws);
      END_STATE();
    case 247:
      if (lookahead == 'e') ADVANCE(267);
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 248:
      if (lookahead == 'l') ADVANCE(269);
      END_STATE();
    case 249:
      if (lookahead == 't') ADVANCE(270);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_boolean_type);
      END_STATE();
    case 251:
      if (lookahead == 'e') ADVANCE(271);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_exports);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 256:
      if (lookahead == 'n') ADVANCE(272);
      END_STATE();
    case 257:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 258:
      if (lookahead == 'c') ADVANCE(274);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_permits);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 262:
      if (lookahead == 'e') ADVANCE(275);
      END_STATE();
    case 263:
      if (lookahead == 's') ADVANCE(276);
      END_STATE();
    case 264:
      if (lookahead == 's') ADVANCE(277);
      END_STATE();
    case 265:
      if (lookahead == 'p') ADVANCE(278);
      END_STATE();
    case 266:
      if (lookahead == 'n') ADVANCE(279);
      END_STATE();
    case 267:
      if (lookahead == 'n') ADVANCE(280);
      END_STATE();
    case 268:
      if (lookahead == 'i') ADVANCE(281);
      END_STATE();
    case 269:
      if (lookahead == 'e') ADVANCE(282);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 272:
      if (lookahead == 't') ADVANCE(283);
      END_STATE();
    case 273:
      if (lookahead == 'o') ADVANCE(284);
      END_STATE();
    case 274:
      if (lookahead == 'e') ADVANCE(285);
      END_STATE();
    case 275:
      if (lookahead == 'd') ADVANCE(286);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_provides);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_requires);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_strictfp);
      END_STATE();
    case 279:
      if (lookahead == 'i') ADVANCE(287);
      END_STATE();
    case 280:
      if (lookahead == 't') ADVANCE(288);
      END_STATE();
    case 281:
      if (lookahead == 'v') ADVANCE(289);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 283:
      if (lookahead == 's') ADVANCE(290);
      END_STATE();
    case 284:
      if (lookahead == 'f') ADVANCE(291);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 287:
      if (lookahead == 'z') ADVANCE(292);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_transient);
      END_STATE();
    case 289:
      if (lookahead == 'e') ADVANCE(293);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    case 292:
      if (lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_transitive);
      END_STATE();
    case 294:
      if (lookahead == 'd') ADVANCE(295);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_synchronized);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 69},
  [2] = {.lex_state = 69},
  [3] = {.lex_state = 69},
  [4] = {.lex_state = 69},
  [5] = {.lex_state = 69},
  [6] = {.lex_state = 69},
  [7] = {.lex_state = 69},
  [8] = {.lex_state = 69},
  [9] = {.lex_state = 69},
  [10] = {.lex_state = 69},
  [11] = {.lex_state = 69},
  [12] = {.lex_state = 69},
  [13] = {.lex_state = 69},
  [14] = {.lex_state = 69},
  [15] = {.lex_state = 69},
  [16] = {.lex_state = 69},
  [17] = {.lex_state = 69},
  [18] = {.lex_state = 69},
  [19] = {.lex_state = 69},
  [20] = {.lex_state = 69},
  [21] = {.lex_state = 69},
  [22] = {.lex_state = 69},
  [23] = {.lex_state = 69},
  [24] = {.lex_state = 69},
  [25] = {.lex_state = 69},
  [26] = {.lex_state = 69},
  [27] = {.lex_state = 69},
  [28] = {.lex_state = 69},
  [29] = {.lex_state = 69},
  [30] = {.lex_state = 69},
  [31] = {.lex_state = 69},
  [32] = {.lex_state = 69},
  [33] = {.lex_state = 69},
  [34] = {.lex_state = 69},
  [35] = {.lex_state = 69},
  [36] = {.lex_state = 69},
  [37] = {.lex_state = 69},
  [38] = {.lex_state = 69},
  [39] = {.lex_state = 69},
  [40] = {.lex_state = 69},
  [41] = {.lex_state = 69},
  [42] = {.lex_state = 69},
  [43] = {.lex_state = 69},
  [44] = {.lex_state = 69},
  [45] = {.lex_state = 69},
  [46] = {.lex_state = 69},
  [47] = {.lex_state = 69},
  [48] = {.lex_state = 69},
  [49] = {.lex_state = 69},
  [50] = {.lex_state = 69},
  [51] = {.lex_state = 69},
  [52] = {.lex_state = 69},
  [53] = {.lex_state = 69},
  [54] = {.lex_state = 69},
  [55] = {.lex_state = 69},
  [56] = {.lex_state = 69},
  [57] = {.lex_state = 69},
  [58] = {.lex_state = 69},
  [59] = {.lex_state = 69},
  [60] = {.lex_state = 69},
  [61] = {.lex_state = 69},
  [62] = {.lex_state = 69},
  [63] = {.lex_state = 69},
  [64] = {.lex_state = 69},
  [65] = {.lex_state = 69},
  [66] = {.lex_state = 69},
  [67] = {.lex_state = 69},
  [68] = {.lex_state = 69},
  [69] = {.lex_state = 69},
  [70] = {.lex_state = 69},
  [71] = {.lex_state = 69},
  [72] = {.lex_state = 69},
  [73] = {.lex_state = 69},
  [74] = {.lex_state = 69},
  [75] = {.lex_state = 68},
  [76] = {.lex_state = 68},
  [77] = {.lex_state = 69},
  [78] = {.lex_state = 69},
  [79] = {.lex_state = 69},
  [80] = {.lex_state = 69},
  [81] = {.lex_state = 69},
  [82] = {.lex_state = 2},
  [83] = {.lex_state = 2},
  [84] = {.lex_state = 2},
  [85] = {.lex_state = 2},
  [86] = {.lex_state = 2},
  [87] = {.lex_state = 69},
  [88] = {.lex_state = 1},
  [89] = {.lex_state = 1},
  [90] = {.lex_state = 1},
  [91] = {.lex_state = 1},
  [92] = {.lex_state = 1},
  [93] = {.lex_state = 1},
  [94] = {.lex_state = 1},
  [95] = {.lex_state = 69},
  [96] = {.lex_state = 69},
  [97] = {.lex_state = 1},
  [98] = {.lex_state = 69},
  [99] = {.lex_state = 1},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 69},
  [102] = {.lex_state = 1},
  [103] = {.lex_state = 1},
  [104] = {.lex_state = 1},
  [105] = {.lex_state = 1},
  [106] = {.lex_state = 1},
  [107] = {.lex_state = 1},
  [108] = {.lex_state = 1},
  [109] = {.lex_state = 1},
  [110] = {.lex_state = 1},
  [111] = {.lex_state = 1},
  [112] = {.lex_state = 69},
  [113] = {.lex_state = 1},
  [114] = {.lex_state = 1},
  [115] = {.lex_state = 1},
  [116] = {.lex_state = 1},
  [117] = {.lex_state = 1},
  [118] = {.lex_state = 69},
  [119] = {.lex_state = 1},
  [120] = {.lex_state = 1},
  [121] = {.lex_state = 1},
  [122] = {.lex_state = 1},
  [123] = {.lex_state = 1},
  [124] = {.lex_state = 1},
  [125] = {.lex_state = 1},
  [126] = {.lex_state = 1},
  [127] = {.lex_state = 1},
  [128] = {.lex_state = 1},
  [129] = {.lex_state = 1},
  [130] = {.lex_state = 69},
  [131] = {.lex_state = 1},
  [132] = {.lex_state = 1},
  [133] = {.lex_state = 1},
  [134] = {.lex_state = 1},
  [135] = {.lex_state = 1},
  [136] = {.lex_state = 1},
  [137] = {.lex_state = 1},
  [138] = {.lex_state = 1},
  [139] = {.lex_state = 1},
  [140] = {.lex_state = 1},
  [141] = {.lex_state = 1},
  [142] = {.lex_state = 1},
  [143] = {.lex_state = 1},
  [144] = {.lex_state = 1},
  [145] = {.lex_state = 69},
  [146] = {.lex_state = 1},
  [147] = {.lex_state = 1},
  [148] = {.lex_state = 1},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 69},
  [151] = {.lex_state = 69},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 1},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 69},
  [157] = {.lex_state = 1},
  [158] = {.lex_state = 69},
  [159] = {.lex_state = 69},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 1},
  [162] = {.lex_state = 1},
  [163] = {.lex_state = 1},
  [164] = {.lex_state = 1},
  [165] = {.lex_state = 1},
  [166] = {.lex_state = 1},
  [167] = {.lex_state = 1},
  [168] = {.lex_state = 69},
  [169] = {.lex_state = 69},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 69},
  [172] = {.lex_state = 1},
  [173] = {.lex_state = 69},
  [174] = {.lex_state = 69},
  [175] = {.lex_state = 69},
  [176] = {.lex_state = 69},
  [177] = {.lex_state = 69},
  [178] = {.lex_state = 1},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 69},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 69},
  [183] = {.lex_state = 69},
  [184] = {.lex_state = 69},
  [185] = {.lex_state = 69},
  [186] = {.lex_state = 69},
  [187] = {.lex_state = 69},
  [188] = {.lex_state = 69},
  [189] = {.lex_state = 69},
  [190] = {.lex_state = 69},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 69},
  [193] = {.lex_state = 69},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 69},
  [198] = {.lex_state = 69},
  [199] = {.lex_state = 69},
  [200] = {.lex_state = 69},
  [201] = {.lex_state = 1},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 69},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 69},
  [207] = {.lex_state = 69},
  [208] = {.lex_state = 69},
  [209] = {.lex_state = 69},
  [210] = {.lex_state = 69},
  [211] = {.lex_state = 69},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 69},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 69},
  [216] = {.lex_state = 69},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 69},
  [228] = {.lex_state = 69},
  [229] = {.lex_state = 69},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 69},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 69},
  [234] = {.lex_state = 69},
  [235] = {.lex_state = 69},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 69},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 69},
  [240] = {.lex_state = 69},
  [241] = {.lex_state = 69},
  [242] = {.lex_state = 69},
  [243] = {.lex_state = 69},
  [244] = {.lex_state = 69},
  [245] = {.lex_state = 69},
  [246] = {.lex_state = 69},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 69},
  [250] = {.lex_state = 69},
  [251] = {.lex_state = 69},
  [252] = {.lex_state = 69},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 69},
  [255] = {.lex_state = 69},
  [256] = {.lex_state = 69},
  [257] = {.lex_state = 69},
  [258] = {.lex_state = 69},
  [259] = {.lex_state = 69},
  [260] = {.lex_state = 69},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 1},
  [263] = {.lex_state = 1},
  [264] = {.lex_state = 69},
  [265] = {.lex_state = 69},
  [266] = {.lex_state = 1},
  [267] = {.lex_state = 69},
  [268] = {.lex_state = 1},
  [269] = {.lex_state = 1},
  [270] = {.lex_state = 1},
  [271] = {.lex_state = 69},
  [272] = {.lex_state = 69},
  [273] = {.lex_state = 69},
  [274] = {.lex_state = 69},
  [275] = {.lex_state = 69},
  [276] = {.lex_state = 69},
  [277] = {.lex_state = 2},
  [278] = {.lex_state = 69},
  [279] = {.lex_state = 69},
  [280] = {.lex_state = 69},
  [281] = {.lex_state = 69},
  [282] = {.lex_state = 69},
  [283] = {.lex_state = 69},
  [284] = {.lex_state = 69},
  [285] = {.lex_state = 69},
  [286] = {.lex_state = 69},
  [287] = {.lex_state = 69},
  [288] = {.lex_state = 69},
  [289] = {.lex_state = 69},
  [290] = {.lex_state = 69},
  [291] = {.lex_state = 69},
  [292] = {.lex_state = 69},
  [293] = {.lex_state = 2},
  [294] = {.lex_state = 69},
  [295] = {.lex_state = 69},
  [296] = {.lex_state = 69},
  [297] = {.lex_state = 69},
  [298] = {.lex_state = 69},
  [299] = {.lex_state = 69},
  [300] = {.lex_state = 69},
  [301] = {.lex_state = 69},
  [302] = {.lex_state = 69},
  [303] = {.lex_state = 69},
  [304] = {.lex_state = 69},
  [305] = {.lex_state = 69},
  [306] = {.lex_state = 69},
  [307] = {.lex_state = 69},
  [308] = {.lex_state = 69},
  [309] = {.lex_state = 69},
  [310] = {.lex_state = 69},
  [311] = {.lex_state = 69},
  [312] = {.lex_state = 69},
  [313] = {.lex_state = 69},
  [314] = {.lex_state = 69},
  [315] = {.lex_state = 69},
  [316] = {.lex_state = 69},
  [317] = {.lex_state = 69},
  [318] = {.lex_state = 69},
  [319] = {.lex_state = 69},
  [320] = {.lex_state = 69},
  [321] = {.lex_state = 69},
  [322] = {.lex_state = 69},
  [323] = {.lex_state = 69},
  [324] = {.lex_state = 69},
  [325] = {.lex_state = 69},
  [326] = {.lex_state = 69},
  [327] = {.lex_state = 69},
  [328] = {.lex_state = 69},
  [329] = {.lex_state = 69},
  [330] = {.lex_state = 69},
  [331] = {.lex_state = 69},
  [332] = {.lex_state = 69},
  [333] = {.lex_state = 69},
  [334] = {.lex_state = 69},
  [335] = {.lex_state = 69},
  [336] = {.lex_state = 69},
  [337] = {.lex_state = 69},
  [338] = {.lex_state = 69},
  [339] = {.lex_state = 69},
  [340] = {.lex_state = 69},
  [341] = {.lex_state = 69},
  [342] = {.lex_state = 69},
  [343] = {.lex_state = 69},
  [344] = {.lex_state = 69},
  [345] = {.lex_state = 69},
  [346] = {.lex_state = 69},
  [347] = {.lex_state = 2},
  [348] = {.lex_state = 2},
  [349] = {.lex_state = 69},
  [350] = {.lex_state = 69},
  [351] = {.lex_state = 69},
  [352] = {.lex_state = 69},
  [353] = {.lex_state = 69},
  [354] = {.lex_state = 69},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 1},
  [361] = {.lex_state = 1},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 3},
  [366] = {.lex_state = 3},
  [367] = {.lex_state = 3},
  [368] = {.lex_state = 3},
  [369] = {.lex_state = 3},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 3},
  [374] = {.lex_state = 3},
  [375] = {.lex_state = 3},
  [376] = {.lex_state = 3},
  [377] = {.lex_state = 3},
  [378] = {.lex_state = 3},
  [379] = {.lex_state = 3},
  [380] = {.lex_state = 3},
  [381] = {.lex_state = 3},
  [382] = {.lex_state = 3},
  [383] = {.lex_state = 3},
  [384] = {.lex_state = 3},
  [385] = {.lex_state = 3},
  [386] = {.lex_state = 3},
  [387] = {.lex_state = 4},
  [388] = {.lex_state = 4},
  [389] = {.lex_state = 3},
  [390] = {.lex_state = 3},
  [391] = {.lex_state = 4},
  [392] = {.lex_state = 1},
  [393] = {.lex_state = 4},
  [394] = {.lex_state = 1},
  [395] = {.lex_state = 4},
  [396] = {.lex_state = 4},
  [397] = {.lex_state = 2},
  [398] = {.lex_state = 10},
  [399] = {.lex_state = 10},
  [400] = {.lex_state = 3},
  [401] = {.lex_state = 4},
  [402] = {.lex_state = 2},
  [403] = {.lex_state = 4},
  [404] = {.lex_state = 4},
  [405] = {.lex_state = 2},
  [406] = {.lex_state = 2},
  [407] = {.lex_state = 1},
  [408] = {.lex_state = 4},
  [409] = {.lex_state = 1},
  [410] = {.lex_state = 4},
  [411] = {.lex_state = 10},
  [412] = {.lex_state = 4},
  [413] = {.lex_state = 4},
  [414] = {.lex_state = 4},
  [415] = {.lex_state = 4},
  [416] = {.lex_state = 4},
  [417] = {.lex_state = 4},
  [418] = {.lex_state = 4},
  [419] = {.lex_state = 10},
  [420] = {.lex_state = 4},
  [421] = {.lex_state = 4},
  [422] = {.lex_state = 4},
  [423] = {.lex_state = 4},
  [424] = {.lex_state = 1},
  [425] = {.lex_state = 1},
  [426] = {.lex_state = 1},
  [427] = {.lex_state = 1},
  [428] = {.lex_state = 0},
  [429] = {.lex_state = 4},
  [430] = {.lex_state = 4},
  [431] = {.lex_state = 4},
  [432] = {.lex_state = 4},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 4},
  [435] = {.lex_state = 4},
  [436] = {.lex_state = 4},
  [437] = {.lex_state = 4},
  [438] = {.lex_state = 4},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 0},
  [441] = {.lex_state = 0},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 0},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 4},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 4},
  [451] = {.lex_state = 4},
  [452] = {.lex_state = 1},
  [453] = {.lex_state = 0},
  [454] = {.lex_state = 4},
  [455] = {.lex_state = 4},
  [456] = {.lex_state = 0},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 1},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 0},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 4},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 1},
  [467] = {.lex_state = 0},
  [468] = {.lex_state = 0},
  [469] = {.lex_state = 4},
  [470] = {.lex_state = 4},
  [471] = {.lex_state = 0},
  [472] = {.lex_state = 4},
  [473] = {.lex_state = 4},
  [474] = {.lex_state = 4},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 4},
  [477] = {.lex_state = 4},
  [478] = {.lex_state = 4},
  [479] = {.lex_state = 4},
  [480] = {.lex_state = 4},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 4},
  [483] = {.lex_state = 4},
  [484] = {.lex_state = 4},
  [485] = {.lex_state = 4},
  [486] = {.lex_state = 4},
  [487] = {.lex_state = 4},
  [488] = {.lex_state = 4},
  [489] = {.lex_state = 4},
  [490] = {.lex_state = 4},
  [491] = {.lex_state = 4},
  [492] = {.lex_state = 4},
  [493] = {.lex_state = 4},
  [494] = {.lex_state = 4},
  [495] = {.lex_state = 4},
  [496] = {.lex_state = 4},
  [497] = {.lex_state = 4},
  [498] = {.lex_state = 4},
  [499] = {.lex_state = 4},
  [500] = {.lex_state = 4},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 4},
  [503] = {.lex_state = 4},
  [504] = {.lex_state = 4},
  [505] = {.lex_state = 4},
  [506] = {.lex_state = 4},
  [507] = {.lex_state = 4},
  [508] = {.lex_state = 4},
  [509] = {.lex_state = 4},
  [510] = {.lex_state = 4},
  [511] = {.lex_state = 4},
  [512] = {.lex_state = 4},
  [513] = {.lex_state = 4},
  [514] = {.lex_state = 4},
  [515] = {.lex_state = 4},
  [516] = {.lex_state = 4},
  [517] = {.lex_state = 4},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 8},
  [520] = {.lex_state = 8},
  [521] = {.lex_state = 4},
  [522] = {.lex_state = 8},
  [523] = {.lex_state = 1},
  [524] = {.lex_state = 1},
  [525] = {.lex_state = 1},
  [526] = {.lex_state = 1},
  [527] = {.lex_state = 1},
  [528] = {.lex_state = 1},
  [529] = {.lex_state = 1},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 1},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 1},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 1},
  [541] = {.lex_state = 1},
  [542] = {.lex_state = 1},
  [543] = {.lex_state = 1},
  [544] = {.lex_state = 1},
  [545] = {.lex_state = 1},
  [546] = {.lex_state = 1},
  [547] = {.lex_state = 1},
  [548] = {.lex_state = 1},
  [549] = {.lex_state = 2},
  [550] = {.lex_state = 1},
  [551] = {.lex_state = 11},
  [552] = {.lex_state = 1},
  [553] = {.lex_state = 1},
  [554] = {.lex_state = 1},
  [555] = {.lex_state = 1},
  [556] = {.lex_state = 1},
  [557] = {.lex_state = 1},
  [558] = {.lex_state = 1},
  [559] = {.lex_state = 1},
  [560] = {.lex_state = 11},
  [561] = {.lex_state = 4},
  [562] = {.lex_state = 1},
  [563] = {.lex_state = 2},
  [564] = {.lex_state = 8},
  [565] = {.lex_state = 11},
  [566] = {.lex_state = 11},
  [567] = {.lex_state = 8},
  [568] = {.lex_state = 1},
  [569] = {.lex_state = 1},
  [570] = {.lex_state = 4},
  [571] = {.lex_state = 1},
  [572] = {.lex_state = 1},
  [573] = {.lex_state = 1},
  [574] = {.lex_state = 1},
  [575] = {.lex_state = 2},
  [576] = {.lex_state = 2},
  [577] = {.lex_state = 2},
  [578] = {.lex_state = 1},
  [579] = {.lex_state = 1},
  [580] = {.lex_state = 1},
  [581] = {.lex_state = 2},
  [582] = {.lex_state = 8},
  [583] = {.lex_state = 2},
  [584] = {.lex_state = 1},
  [585] = {.lex_state = 2},
  [586] = {.lex_state = 1},
  [587] = {.lex_state = 1},
  [588] = {.lex_state = 1},
  [589] = {.lex_state = 1},
  [590] = {.lex_state = 1},
  [591] = {.lex_state = 2},
  [592] = {.lex_state = 1},
  [593] = {.lex_state = 1},
  [594] = {.lex_state = 1},
  [595] = {.lex_state = 2},
  [596] = {.lex_state = 1},
  [597] = {.lex_state = 1},
  [598] = {.lex_state = 1},
  [599] = {.lex_state = 1},
  [600] = {.lex_state = 1},
  [601] = {.lex_state = 1},
  [602] = {.lex_state = 1},
  [603] = {.lex_state = 1},
  [604] = {.lex_state = 1},
  [605] = {.lex_state = 8},
  [606] = {.lex_state = 1},
  [607] = {.lex_state = 1},
  [608] = {.lex_state = 1},
  [609] = {.lex_state = 1},
  [610] = {.lex_state = 1},
  [611] = {.lex_state = 1},
  [612] = {.lex_state = 1},
  [613] = {.lex_state = 1},
  [614] = {.lex_state = 1},
  [615] = {.lex_state = 1},
  [616] = {.lex_state = 1},
  [617] = {.lex_state = 2},
  [618] = {.lex_state = 1},
  [619] = {.lex_state = 1},
  [620] = {.lex_state = 2},
  [621] = {.lex_state = 1},
  [622] = {.lex_state = 1},
  [623] = {.lex_state = 1},
  [624] = {.lex_state = 2},
  [625] = {.lex_state = 1},
  [626] = {.lex_state = 1},
  [627] = {.lex_state = 2},
  [628] = {.lex_state = 2},
  [629] = {.lex_state = 1},
  [630] = {.lex_state = 1},
  [631] = {.lex_state = 1},
  [632] = {.lex_state = 19},
  [633] = {.lex_state = 1},
  [634] = {.lex_state = 1},
  [635] = {.lex_state = 1},
  [636] = {.lex_state = 1},
  [637] = {.lex_state = 1},
  [638] = {.lex_state = 1},
  [639] = {.lex_state = 1},
  [640] = {.lex_state = 1},
  [641] = {.lex_state = 1},
  [642] = {.lex_state = 1},
  [643] = {.lex_state = 1},
  [644] = {.lex_state = 1},
  [645] = {.lex_state = 1},
  [646] = {.lex_state = 1},
  [647] = {.lex_state = 1},
  [648] = {.lex_state = 1},
  [649] = {.lex_state = 1},
  [650] = {.lex_state = 1},
  [651] = {.lex_state = 1},
  [652] = {.lex_state = 1},
  [653] = {.lex_state = 1},
  [654] = {.lex_state = 1},
  [655] = {.lex_state = 1},
  [656] = {.lex_state = 1},
  [657] = {.lex_state = 1},
  [658] = {.lex_state = 1},
  [659] = {.lex_state = 1},
  [660] = {.lex_state = 1},
  [661] = {.lex_state = 1},
  [662] = {.lex_state = 19},
  [663] = {.lex_state = 1},
  [664] = {.lex_state = 1},
  [665] = {.lex_state = 1},
  [666] = {.lex_state = 1},
  [667] = {.lex_state = 1},
  [668] = {.lex_state = 1},
  [669] = {.lex_state = 1},
  [670] = {.lex_state = 1},
  [671] = {.lex_state = 8},
  [672] = {.lex_state = 8},
  [673] = {.lex_state = 1},
  [674] = {.lex_state = 1},
  [675] = {.lex_state = 3},
  [676] = {.lex_state = 3},
  [677] = {.lex_state = 2},
  [678] = {.lex_state = 1},
  [679] = {.lex_state = 19},
  [680] = {.lex_state = 1},
  [681] = {.lex_state = 1},
  [682] = {.lex_state = 8},
  [683] = {.lex_state = 1},
  [684] = {.lex_state = 3},
  [685] = {.lex_state = 8},
  [686] = {.lex_state = 3},
  [687] = {.lex_state = 1},
  [688] = {.lex_state = 1},
  [689] = {.lex_state = 1},
  [690] = {.lex_state = 8},
  [691] = {.lex_state = 8},
  [692] = {.lex_state = 1},
  [693] = {.lex_state = 1},
  [694] = {.lex_state = 8},
  [695] = {.lex_state = 8},
  [696] = {.lex_state = 1},
  [697] = {.lex_state = 8},
  [698] = {.lex_state = 8},
  [699] = {.lex_state = 8},
  [700] = {.lex_state = 19},
  [701] = {.lex_state = 8},
  [702] = {.lex_state = 8},
  [703] = {.lex_state = 8},
  [704] = {.lex_state = 1},
  [705] = {.lex_state = 1},
  [706] = {.lex_state = 1},
  [707] = {.lex_state = 3},
  [708] = {.lex_state = 1},
  [709] = {.lex_state = 1},
  [710] = {.lex_state = 1},
  [711] = {.lex_state = 8},
  [712] = {.lex_state = 1},
  [713] = {.lex_state = 1},
  [714] = {.lex_state = 1},
  [715] = {.lex_state = 3},
  [716] = {.lex_state = 8},
  [717] = {.lex_state = 3},
  [718] = {.lex_state = 3},
  [719] = {.lex_state = 1},
  [720] = {.lex_state = 1},
  [721] = {.lex_state = 1},
  [722] = {.lex_state = 1},
  [723] = {.lex_state = 1},
  [724] = {.lex_state = 1},
  [725] = {.lex_state = 8},
  [726] = {.lex_state = 1},
  [727] = {.lex_state = 1},
  [728] = {.lex_state = 1},
  [729] = {.lex_state = 1},
  [730] = {.lex_state = 1},
  [731] = {.lex_state = 1},
  [732] = {.lex_state = 1},
  [733] = {.lex_state = 3},
  [734] = {.lex_state = 1},
  [735] = {.lex_state = 3},
  [736] = {.lex_state = 1},
  [737] = {.lex_state = 1},
  [738] = {.lex_state = 3},
  [739] = {.lex_state = 1},
  [740] = {.lex_state = 1},
  [741] = {.lex_state = 3},
  [742] = {.lex_state = 3},
  [743] = {.lex_state = 1},
  [744] = {.lex_state = 3},
  [745] = {.lex_state = 3},
  [746] = {.lex_state = 1},
  [747] = {.lex_state = 1},
  [748] = {.lex_state = 1},
  [749] = {.lex_state = 1},
  [750] = {.lex_state = 1},
  [751] = {.lex_state = 3},
  [752] = {.lex_state = 3},
  [753] = {.lex_state = 1},
  [754] = {.lex_state = 3},
  [755] = {.lex_state = 3},
  [756] = {.lex_state = 2},
  [757] = {.lex_state = 1},
  [758] = {.lex_state = 3},
  [759] = {.lex_state = 3},
  [760] = {.lex_state = 3},
  [761] = {.lex_state = 1},
  [762] = {.lex_state = 1},
  [763] = {.lex_state = 3},
  [764] = {.lex_state = 1},
  [765] = {.lex_state = 1},
  [766] = {.lex_state = 2},
  [767] = {.lex_state = 1},
  [768] = {.lex_state = 2},
  [769] = {.lex_state = 2},
  [770] = {.lex_state = 2},
  [771] = {.lex_state = 3},
  [772] = {.lex_state = 3},
  [773] = {.lex_state = 2},
  [774] = {.lex_state = 3},
  [775] = {.lex_state = 3},
  [776] = {.lex_state = 2},
  [777] = {.lex_state = 2},
  [778] = {.lex_state = 3},
  [779] = {.lex_state = 3},
  [780] = {.lex_state = 3},
  [781] = {.lex_state = 1},
  [782] = {.lex_state = 3},
  [783] = {.lex_state = 1},
  [784] = {.lex_state = 1},
  [785] = {.lex_state = 3},
  [786] = {.lex_state = 1},
  [787] = {.lex_state = 1},
  [788] = {.lex_state = 1},
  [789] = {.lex_state = 2},
  [790] = {.lex_state = 1},
  [791] = {.lex_state = 1},
  [792] = {.lex_state = 1},
  [793] = {.lex_state = 1},
  [794] = {.lex_state = 2},
  [795] = {.lex_state = 3},
  [796] = {.lex_state = 1},
  [797] = {.lex_state = 8},
  [798] = {.lex_state = 1},
  [799] = {.lex_state = 1},
  [800] = {.lex_state = 1},
  [801] = {.lex_state = 1},
  [802] = {.lex_state = 6},
  [803] = {.lex_state = 1},
  [804] = {.lex_state = 6},
  [805] = {.lex_state = 1},
  [806] = {.lex_state = 1},
  [807] = {.lex_state = 6},
  [808] = {.lex_state = 1},
  [809] = {.lex_state = 1},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 1},
  [812] = {.lex_state = 1},
  [813] = {.lex_state = 1},
  [814] = {.lex_state = 1},
  [815] = {.lex_state = 1},
  [816] = {.lex_state = 1},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 1},
  [819] = {.lex_state = 1},
  [820] = {.lex_state = 1},
  [821] = {.lex_state = 1},
  [822] = {.lex_state = 1},
  [823] = {.lex_state = 1},
  [824] = {.lex_state = 1},
  [825] = {.lex_state = 1},
  [826] = {.lex_state = 1},
  [827] = {.lex_state = 1},
  [828] = {.lex_state = 1},
  [829] = {.lex_state = 1},
  [830] = {.lex_state = 6},
  [831] = {.lex_state = 1},
  [832] = {.lex_state = 6},
  [833] = {.lex_state = 1},
  [834] = {.lex_state = 1},
  [835] = {.lex_state = 1},
  [836] = {.lex_state = 1},
  [837] = {.lex_state = 1},
  [838] = {.lex_state = 1},
  [839] = {.lex_state = 2},
  [840] = {.lex_state = 1},
  [841] = {.lex_state = 1},
  [842] = {.lex_state = 1},
  [843] = {.lex_state = 1},
  [844] = {.lex_state = 1},
  [845] = {.lex_state = 1},
  [846] = {.lex_state = 1},
  [847] = {.lex_state = 1},
  [848] = {.lex_state = 1},
  [849] = {.lex_state = 1},
  [850] = {.lex_state = 1},
  [851] = {.lex_state = 1},
  [852] = {.lex_state = 1},
  [853] = {.lex_state = 1},
  [854] = {.lex_state = 1},
  [855] = {.lex_state = 1},
  [856] = {.lex_state = 1},
  [857] = {.lex_state = 1},
  [858] = {.lex_state = 1},
  [859] = {.lex_state = 1},
  [860] = {.lex_state = 1},
  [861] = {.lex_state = 1},
  [862] = {.lex_state = 1},
  [863] = {.lex_state = 1},
  [864] = {.lex_state = 1},
  [865] = {.lex_state = 2},
  [866] = {.lex_state = 1},
  [867] = {.lex_state = 1},
  [868] = {.lex_state = 6},
  [869] = {.lex_state = 1},
  [870] = {.lex_state = 2},
  [871] = {.lex_state = 2},
  [872] = {.lex_state = 1},
  [873] = {.lex_state = 2},
  [874] = {.lex_state = 1},
  [875] = {.lex_state = 1},
  [876] = {.lex_state = 1},
  [877] = {.lex_state = 1},
  [878] = {.lex_state = 1},
  [879] = {.lex_state = 1},
  [880] = {.lex_state = 1},
  [881] = {.lex_state = 1},
  [882] = {.lex_state = 1},
  [883] = {.lex_state = 1},
  [884] = {.lex_state = 2},
  [885] = {.lex_state = 1},
  [886] = {.lex_state = 1},
  [887] = {.lex_state = 1},
  [888] = {.lex_state = 1},
  [889] = {.lex_state = 1},
  [890] = {.lex_state = 1},
  [891] = {.lex_state = 1},
  [892] = {.lex_state = 1},
  [893] = {.lex_state = 1},
  [894] = {.lex_state = 1},
  [895] = {.lex_state = 1},
  [896] = {.lex_state = 3},
  [897] = {.lex_state = 1},
  [898] = {.lex_state = 3},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 3},
  [901] = {.lex_state = 8},
  [902] = {.lex_state = 1},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 1},
  [905] = {.lex_state = 1},
  [906] = {.lex_state = 1},
  [907] = {.lex_state = 1},
  [908] = {.lex_state = 3},
  [909] = {.lex_state = 1},
  [910] = {.lex_state = 1},
  [911] = {.lex_state = 1},
  [912] = {.lex_state = 3},
  [913] = {.lex_state = 1},
  [914] = {.lex_state = 1},
  [915] = {.lex_state = 1},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 1},
  [919] = {.lex_state = 1},
  [920] = {.lex_state = 1},
  [921] = {.lex_state = 1},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 1},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 6},
  [926] = {.lex_state = 8},
  [927] = {.lex_state = 1},
  [928] = {.lex_state = 3},
  [929] = {.lex_state = 1},
  [930] = {.lex_state = 1},
  [931] = {.lex_state = 1},
  [932] = {.lex_state = 1},
  [933] = {.lex_state = 1},
  [934] = {.lex_state = 3},
  [935] = {.lex_state = 1},
  [936] = {.lex_state = 7},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 3},
  [940] = {.lex_state = 3},
  [941] = {.lex_state = 3},
  [942] = {.lex_state = 3},
  [943] = {.lex_state = 3},
  [944] = {.lex_state = 3},
  [945] = {.lex_state = 3},
  [946] = {.lex_state = 3},
  [947] = {.lex_state = 3},
  [948] = {.lex_state = 3},
  [949] = {.lex_state = 3},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 1},
  [953] = {.lex_state = 1},
  [954] = {.lex_state = 1},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 1},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 1},
  [961] = {.lex_state = 1},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 1},
  [964] = {.lex_state = 7},
  [965] = {.lex_state = 1},
  [966] = {.lex_state = 1},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 1},
  [969] = {.lex_state = 2},
  [970] = {.lex_state = 1},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 1},
  [973] = {.lex_state = 1},
  [974] = {.lex_state = 1},
  [975] = {.lex_state = 2},
  [976] = {.lex_state = 1},
  [977] = {.lex_state = 1},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 1},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 1},
  [982] = {.lex_state = 8},
  [983] = {.lex_state = 1},
  [984] = {.lex_state = 2},
  [985] = {.lex_state = 1},
  [986] = {.lex_state = 1},
  [987] = {.lex_state = 1},
  [988] = {.lex_state = 8},
  [989] = {.lex_state = 1},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 1},
  [992] = {.lex_state = 1},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 3},
  [996] = {.lex_state = 1},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 1},
  [1002] = {.lex_state = 1},
  [1003] = {.lex_state = 7},
  [1004] = {.lex_state = 1},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 3},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 3},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 1},
  [1023] = {.lex_state = 3},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 3},
  [1026] = {.lex_state = 1},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 3},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 1},
  [1035] = {.lex_state = 1},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 1},
  [1043] = {.lex_state = 3},
  [1044] = {.lex_state = 3},
  [1045] = {.lex_state = 1},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 2},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 2},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 2},
  [1054] = {.lex_state = 3},
  [1055] = {.lex_state = 3},
  [1056] = {.lex_state = 2},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 1},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 1},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 3},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 1},
  [1067] = {.lex_state = 1},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 3},
  [1070] = {.lex_state = 3},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 3},
  [1074] = {.lex_state = 3},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 2},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 3},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 3},
  [1084] = {.lex_state = 2},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 2},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 3},
  [1103] = {.lex_state = 3},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 2},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 2},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 3},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 1},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 1},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 1},
  [1147] = {.lex_state = 2},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 2},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 2},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 0},
  [1163] = {.lex_state = 0},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 3},
  [1167] = {.lex_state = 0},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 3},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 3},
  [1175] = {.lex_state = 2},
  [1176] = {.lex_state = 2},
  [1177] = {.lex_state = 3},
  [1178] = {.lex_state = 0},
  [1179] = {.lex_state = 2},
  [1180] = {.lex_state = 1},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 3},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 0},
  [1185] = {.lex_state = 3},
  [1186] = {.lex_state = 3},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 0},
  [1189] = {.lex_state = 3},
  [1190] = {.lex_state = 0},
  [1191] = {.lex_state = 1},
  [1192] = {.lex_state = 0},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 0},
  [1196] = {.lex_state = 3},
  [1197] = {.lex_state = 3},
  [1198] = {.lex_state = 3},
  [1199] = {.lex_state = 3},
  [1200] = {.lex_state = 0},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 2},
  [1204] = {.lex_state = 3},
  [1205] = {.lex_state = 3},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 3},
  [1208] = {.lex_state = 3},
  [1209] = {.lex_state = 0},
  [1210] = {.lex_state = 0},
  [1211] = {.lex_state = 1},
  [1212] = {.lex_state = 0},
  [1213] = {.lex_state = 0},
  [1214] = {.lex_state = 1},
  [1215] = {.lex_state = 0},
  [1216] = {.lex_state = 0},
  [1217] = {.lex_state = 1},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 0},
  [1220] = {.lex_state = 0},
  [1221] = {.lex_state = 0},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 3},
  [1224] = {.lex_state = 0},
  [1225] = {.lex_state = 3},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 0},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 3},
  [1230] = {.lex_state = 1},
  [1231] = {.lex_state = 1},
  [1232] = {.lex_state = 0},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 3},
  [1235] = {.lex_state = 0},
  [1236] = {.lex_state = 1},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 3},
  [1240] = {.lex_state = 1},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 0},
  [1243] = {.lex_state = 0},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 0},
  [1246] = {.lex_state = 0},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 0},
  [1250] = {.lex_state = 0},
  [1251] = {.lex_state = 1},
  [1252] = {.lex_state = 1},
  [1253] = {.lex_state = 0},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 0},
  [1256] = {.lex_state = 0},
  [1257] = {.lex_state = 0},
  [1258] = {.lex_state = 1},
  [1259] = {.lex_state = 0},
  [1260] = {.lex_state = 0},
  [1261] = {.lex_state = 0},
  [1262] = {.lex_state = 0},
  [1263] = {.lex_state = 0},
  [1264] = {.lex_state = 0},
  [1265] = {.lex_state = 0},
  [1266] = {.lex_state = 0},
  [1267] = {.lex_state = 0},
  [1268] = {.lex_state = 1},
  [1269] = {.lex_state = 0},
  [1270] = {.lex_state = 0},
  [1271] = {.lex_state = 0},
  [1272] = {.lex_state = 0},
  [1273] = {.lex_state = 0},
  [1274] = {.lex_state = 0},
  [1275] = {.lex_state = 3},
  [1276] = {.lex_state = 0},
  [1277] = {.lex_state = 1},
  [1278] = {.lex_state = 0},
  [1279] = {.lex_state = 0},
  [1280] = {.lex_state = 0},
  [1281] = {.lex_state = 1},
  [1282] = {.lex_state = 0},
  [1283] = {.lex_state = 0},
  [1284] = {.lex_state = 1},
  [1285] = {.lex_state = 1},
  [1286] = {.lex_state = 1},
  [1287] = {.lex_state = 1},
  [1288] = {.lex_state = 0},
  [1289] = {.lex_state = 0},
  [1290] = {.lex_state = 0},
  [1291] = {.lex_state = 1},
  [1292] = {.lex_state = 0},
  [1293] = {.lex_state = 1},
  [1294] = {.lex_state = 1},
  [1295] = {.lex_state = 0},
  [1296] = {.lex_state = 0},
  [1297] = {.lex_state = 1},
  [1298] = {.lex_state = 1},
  [1299] = {.lex_state = 1},
  [1300] = {.lex_state = 0},
  [1301] = {.lex_state = 1},
  [1302] = {.lex_state = 1},
  [1303] = {.lex_state = 0},
  [1304] = {.lex_state = 0},
  [1305] = {.lex_state = 0},
  [1306] = {.lex_state = 0},
  [1307] = {.lex_state = 0},
  [1308] = {.lex_state = 0},
  [1309] = {.lex_state = 1},
  [1310] = {.lex_state = 0},
  [1311] = {.lex_state = 0},
  [1312] = {.lex_state = 3},
  [1313] = {.lex_state = 1},
  [1314] = {.lex_state = 0},
  [1315] = {.lex_state = 0},
  [1316] = {.lex_state = 0},
  [1317] = {.lex_state = 0},
  [1318] = {.lex_state = 0},
  [1319] = {.lex_state = 0},
  [1320] = {.lex_state = 0},
  [1321] = {.lex_state = 0},
  [1322] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_decimal_integer_literal] = ACTIONS(1),
    [sym_hex_integer_literal] = ACTIONS(1),
    [sym_octal_integer_literal] = ACTIONS(1),
    [sym_binary_integer_literal] = ACTIONS(1),
    [sym_decimal_floating_point_literal] = ACTIONS(1),
    [sym_hex_floating_point_literal] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_character_literal] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [aux_sym__escape_sequence_token1] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_null_literal] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_final] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_synchronized] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_open] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_requires] = ACTIONS(1),
    [anon_sym_transitive] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_exports] = ACTIONS(1),
    [anon_sym_to] = ACTIONS(1),
    [anon_sym_opens] = ACTIONS(1),
    [anon_sym_uses] = ACTIONS(1),
    [anon_sym_provides] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_strictfp] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_transient] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_sealed] = ACTIONS(1),
    [anon_sym_non_DASHsealed] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_permits] = ACTIONS(1),
    [anon_sym_record] = ACTIONS(1),
    [anon_sym_ATinterface] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_char] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_double] = ACTIONS(1),
    [sym_boolean_type] = ACTIONS(1),
    [sym_void_type] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_throws] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_program] = STATE(1235),
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_switch_label] = STATE(1308),
    [sym_statement] = STATE(5),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_program_repeat1] = STATE(5),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_switch_block_statement_group_repeat1] = STATE(275),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(91),
    [anon_sym_case] = ACTIONS(93),
    [anon_sym_default] = ACTIONS(93),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(570),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_type_arguments] = STATE(1231),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(7),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_explicit_constructor_invocation] = STATE(9),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_LT] = ACTIONS(95),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(97),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(99),
    [sym_super] = ACTIONS(101),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [ts_builtin_sym_end] = ACTIONS(103),
    [sym_identifier] = ACTIONS(105),
    [sym_decimal_integer_literal] = ACTIONS(108),
    [sym_hex_integer_literal] = ACTIONS(108),
    [sym_octal_integer_literal] = ACTIONS(108),
    [sym_binary_integer_literal] = ACTIONS(111),
    [sym_decimal_floating_point_literal] = ACTIONS(111),
    [sym_hex_floating_point_literal] = ACTIONS(108),
    [sym_true] = ACTIONS(108),
    [sym_false] = ACTIONS(108),
    [sym_character_literal] = ACTIONS(111),
    [anon_sym_DQUOTE] = ACTIONS(114),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(117),
    [sym_null_literal] = ACTIONS(108),
    [anon_sym_LPAREN] = ACTIONS(120),
    [anon_sym_PLUS] = ACTIONS(123),
    [anon_sym_DASH] = ACTIONS(123),
    [anon_sym_final] = ACTIONS(126),
    [anon_sym_BANG] = ACTIONS(129),
    [anon_sym_TILDE] = ACTIONS(129),
    [anon_sym_PLUS_PLUS] = ACTIONS(132),
    [anon_sym_DASH_DASH] = ACTIONS(132),
    [anon_sym_new] = ACTIONS(135),
    [anon_sym_class] = ACTIONS(138),
    [anon_sym_switch] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(144),
    [anon_sym_RBRACE] = ACTIONS(103),
    [anon_sym_case] = ACTIONS(147),
    [anon_sym_default] = ACTIONS(126),
    [anon_sym_SEMI] = ACTIONS(149),
    [anon_sym_assert] = ACTIONS(152),
    [anon_sym_do] = ACTIONS(155),
    [anon_sym_while] = ACTIONS(158),
    [anon_sym_break] = ACTIONS(161),
    [anon_sym_continue] = ACTIONS(164),
    [anon_sym_return] = ACTIONS(167),
    [anon_sym_yield] = ACTIONS(170),
    [anon_sym_synchronized] = ACTIONS(173),
    [anon_sym_throw] = ACTIONS(176),
    [anon_sym_try] = ACTIONS(179),
    [anon_sym_if] = ACTIONS(182),
    [anon_sym_for] = ACTIONS(185),
    [anon_sym_AT] = ACTIONS(188),
    [anon_sym_open] = ACTIONS(191),
    [anon_sym_module] = ACTIONS(194),
    [anon_sym_static] = ACTIONS(126),
    [anon_sym_package] = ACTIONS(197),
    [anon_sym_import] = ACTIONS(200),
    [anon_sym_enum] = ACTIONS(203),
    [anon_sym_public] = ACTIONS(126),
    [anon_sym_protected] = ACTIONS(126),
    [anon_sym_private] = ACTIONS(126),
    [anon_sym_abstract] = ACTIONS(126),
    [anon_sym_strictfp] = ACTIONS(126),
    [anon_sym_native] = ACTIONS(126),
    [anon_sym_transient] = ACTIONS(126),
    [anon_sym_volatile] = ACTIONS(126),
    [anon_sym_sealed] = ACTIONS(126),
    [anon_sym_non_DASHsealed] = ACTIONS(206),
    [anon_sym_record] = ACTIONS(209),
    [anon_sym_ATinterface] = ACTIONS(212),
    [anon_sym_interface] = ACTIONS(215),
    [anon_sym_byte] = ACTIONS(218),
    [anon_sym_short] = ACTIONS(218),
    [anon_sym_int] = ACTIONS(218),
    [anon_sym_long] = ACTIONS(218),
    [anon_sym_char] = ACTIONS(218),
    [anon_sym_float] = ACTIONS(221),
    [anon_sym_double] = ACTIONS(221),
    [sym_boolean_type] = ACTIONS(224),
    [sym_void_type] = ACTIONS(224),
    [sym_this] = ACTIONS(227),
    [sym_super] = ACTIONS(230),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(233),
    [anon_sym_case] = ACTIONS(235),
    [anon_sym_default] = ACTIONS(235),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [ts_builtin_sym_end] = ACTIONS(237),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(239),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(10),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_program_repeat1] = STATE(10),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(241),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(11),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(239),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(243),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(245),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(13),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(247),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(249),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(314),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(323),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(1240),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(290),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(341),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(291),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(292),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [21] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(295),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(320),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [23] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(314),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(279),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(287),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [26] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(286),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(284),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [28] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(319),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [29] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(298),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(300),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(297),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(328),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(302),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(306),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(1180),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(329),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(301),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(288),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(341),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(333),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(317),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(323),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(320),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(279),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [45] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(328),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [46] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(319),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [47] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(308),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [48] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(315),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [49] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(317),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [50] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(316),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [51] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(327),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [52] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(329),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [53] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(306),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [54] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(295),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [55] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(292),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [56] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(288),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [57] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(297),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(284),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [59] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(339),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [60] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(291),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [61] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(286),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [62] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(333),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [63] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(287),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [64] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(298),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [65] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(300),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [66] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(302),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [67] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(87),
    [sym_statement] = STATE(338),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [68] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(339),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [69] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(308),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [70] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(315),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [71] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(316),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [72] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(327),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [73] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(338),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [74] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(592),
    [sym_statement] = STATE(290),
    [sym_block] = STATE(276),
    [sym_expression_statement] = STATE(276),
    [sym_labeled_statement] = STATE(276),
    [sym_assert_statement] = STATE(276),
    [sym_do_statement] = STATE(276),
    [sym_break_statement] = STATE(276),
    [sym_continue_statement] = STATE(276),
    [sym_return_statement] = STATE(276),
    [sym_yield_statement] = STATE(276),
    [sym_synchronized_statement] = STATE(276),
    [sym_throw_statement] = STATE(276),
    [sym_try_statement] = STATE(276),
    [sym_try_with_resources_statement] = STATE(276),
    [sym_if_statement] = STATE(276),
    [sym_while_statement] = STATE(276),
    [sym_for_statement] = STATE(276),
    [sym_enhanced_for_statement] = STATE(276),
    [sym__annotation] = STATE(471),
    [sym_marker_annotation] = STATE(471),
    [sym_annotation] = STATE(471),
    [sym_declaration] = STATE(276),
    [sym_module_declaration] = STATE(332),
    [sym_package_declaration] = STATE(332),
    [sym_import_declaration] = STATE(332),
    [sym_enum_declaration] = STATE(332),
    [sym_class_declaration] = STATE(332),
    [sym_modifiers] = STATE(679),
    [sym_record_declaration] = STATE(332),
    [sym_annotation_type_declaration] = STATE(332),
    [sym_interface_declaration] = STATE(332),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(718),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(276),
    [aux_sym_array_creation_expression_repeat1] = STATE(658),
    [aux_sym_modifiers_repeat1] = STATE(428),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_assert] = ACTIONS(37),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_synchronized] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_try] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(63),
    [anon_sym_module] = ACTIONS(65),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_package] = ACTIONS(67),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(71),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(21),
    [anon_sym_strictfp] = ACTIONS(21),
    [anon_sym_native] = ACTIONS(21),
    [anon_sym_transient] = ACTIONS(21),
    [anon_sym_volatile] = ACTIONS(21),
    [anon_sym_sealed] = ACTIONS(21),
    [anon_sym_non_DASHsealed] = ACTIONS(73),
    [anon_sym_record] = ACTIONS(75),
    [anon_sym_ATinterface] = ACTIONS(77),
    [anon_sym_interface] = ACTIONS(79),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [75] = {
    [ts_builtin_sym_end] = ACTIONS(259),
    [sym_identifier] = ACTIONS(261),
    [sym_decimal_integer_literal] = ACTIONS(261),
    [sym_hex_integer_literal] = ACTIONS(261),
    [sym_octal_integer_literal] = ACTIONS(261),
    [sym_binary_integer_literal] = ACTIONS(259),
    [sym_decimal_floating_point_literal] = ACTIONS(259),
    [sym_hex_floating_point_literal] = ACTIONS(261),
    [sym_true] = ACTIONS(261),
    [sym_false] = ACTIONS(261),
    [sym_character_literal] = ACTIONS(259),
    [anon_sym_DQUOTE] = ACTIONS(261),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(259),
    [sym_null_literal] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(259),
    [anon_sym_RPAREN] = ACTIONS(259),
    [anon_sym_AMP] = ACTIONS(261),
    [anon_sym_GT] = ACTIONS(261),
    [anon_sym_LT] = ACTIONS(261),
    [anon_sym_GT_EQ] = ACTIONS(259),
    [anon_sym_LT_EQ] = ACTIONS(259),
    [anon_sym_EQ_EQ] = ACTIONS(259),
    [anon_sym_BANG_EQ] = ACTIONS(259),
    [anon_sym_AMP_AMP] = ACTIONS(259),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_PLUS] = ACTIONS(261),
    [anon_sym_DASH] = ACTIONS(261),
    [anon_sym_STAR] = ACTIONS(259),
    [anon_sym_SLASH] = ACTIONS(261),
    [anon_sym_PIPE] = ACTIONS(261),
    [anon_sym_CARET] = ACTIONS(259),
    [anon_sym_PERCENT] = ACTIONS(259),
    [anon_sym_LT_LT] = ACTIONS(259),
    [anon_sym_GT_GT] = ACTIONS(261),
    [anon_sym_GT_GT_GT] = ACTIONS(259),
    [anon_sym_instanceof] = ACTIONS(261),
    [anon_sym_final] = ACTIONS(261),
    [anon_sym_DASH_GT] = ACTIONS(259),
    [anon_sym_COMMA] = ACTIONS(259),
    [anon_sym_QMARK] = ACTIONS(259),
    [anon_sym_COLON] = ACTIONS(261),
    [anon_sym_BANG] = ACTIONS(261),
    [anon_sym_TILDE] = ACTIONS(259),
    [anon_sym_PLUS_PLUS] = ACTIONS(259),
    [anon_sym_DASH_DASH] = ACTIONS(259),
    [anon_sym_new] = ACTIONS(261),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_RBRACK] = ACTIONS(259),
    [anon_sym_DOT] = ACTIONS(261),
    [anon_sym_class] = ACTIONS(261),
    [anon_sym_COLON_COLON] = ACTIONS(259),
    [anon_sym_switch] = ACTIONS(261),
    [anon_sym_LBRACE] = ACTIONS(259),
    [anon_sym_RBRACE] = ACTIONS(259),
    [anon_sym_case] = ACTIONS(261),
    [anon_sym_default] = ACTIONS(261),
    [anon_sym_SEMI] = ACTIONS(259),
    [anon_sym_assert] = ACTIONS(261),
    [anon_sym_do] = ACTIONS(261),
    [anon_sym_while] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(261),
    [anon_sym_continue] = ACTIONS(261),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_yield] = ACTIONS(261),
    [anon_sym_synchronized] = ACTIONS(261),
    [anon_sym_throw] = ACTIONS(261),
    [anon_sym_try] = ACTIONS(261),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_else] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [anon_sym_open] = ACTIONS(261),
    [anon_sym_module] = ACTIONS(261),
    [anon_sym_static] = ACTIONS(261),
    [anon_sym_package] = ACTIONS(261),
    [anon_sym_import] = ACTIONS(261),
    [anon_sym_enum] = ACTIONS(261),
    [anon_sym_public] = ACTIONS(261),
    [anon_sym_protected] = ACTIONS(261),
    [anon_sym_private] = ACTIONS(261),
    [anon_sym_abstract] = ACTIONS(261),
    [anon_sym_strictfp] = ACTIONS(261),
    [anon_sym_native] = ACTIONS(261),
    [anon_sym_transient] = ACTIONS(261),
    [anon_sym_volatile] = ACTIONS(261),
    [anon_sym_sealed] = ACTIONS(261),
    [anon_sym_non_DASHsealed] = ACTIONS(259),
    [anon_sym_record] = ACTIONS(261),
    [anon_sym_ATinterface] = ACTIONS(259),
    [anon_sym_interface] = ACTIONS(261),
    [anon_sym_byte] = ACTIONS(261),
    [anon_sym_short] = ACTIONS(261),
    [anon_sym_int] = ACTIONS(261),
    [anon_sym_long] = ACTIONS(261),
    [anon_sym_char] = ACTIONS(261),
    [anon_sym_float] = ACTIONS(261),
    [anon_sym_double] = ACTIONS(261),
    [sym_boolean_type] = ACTIONS(261),
    [sym_void_type] = ACTIONS(261),
    [sym_this] = ACTIONS(261),
    [sym_super] = ACTIONS(261),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [76] = {
    [ts_builtin_sym_end] = ACTIONS(263),
    [sym_identifier] = ACTIONS(265),
    [sym_decimal_integer_literal] = ACTIONS(265),
    [sym_hex_integer_literal] = ACTIONS(265),
    [sym_octal_integer_literal] = ACTIONS(265),
    [sym_binary_integer_literal] = ACTIONS(263),
    [sym_decimal_floating_point_literal] = ACTIONS(263),
    [sym_hex_floating_point_literal] = ACTIONS(265),
    [sym_true] = ACTIONS(265),
    [sym_false] = ACTIONS(265),
    [sym_character_literal] = ACTIONS(263),
    [anon_sym_DQUOTE] = ACTIONS(265),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(263),
    [sym_null_literal] = ACTIONS(265),
    [anon_sym_LPAREN] = ACTIONS(263),
    [anon_sym_RPAREN] = ACTIONS(263),
    [anon_sym_AMP] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(265),
    [anon_sym_LT] = ACTIONS(265),
    [anon_sym_GT_EQ] = ACTIONS(263),
    [anon_sym_LT_EQ] = ACTIONS(263),
    [anon_sym_EQ_EQ] = ACTIONS(263),
    [anon_sym_BANG_EQ] = ACTIONS(263),
    [anon_sym_AMP_AMP] = ACTIONS(263),
    [anon_sym_PIPE_PIPE] = ACTIONS(263),
    [anon_sym_PLUS] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(265),
    [anon_sym_STAR] = ACTIONS(263),
    [anon_sym_SLASH] = ACTIONS(265),
    [anon_sym_PIPE] = ACTIONS(265),
    [anon_sym_CARET] = ACTIONS(263),
    [anon_sym_PERCENT] = ACTIONS(263),
    [anon_sym_LT_LT] = ACTIONS(263),
    [anon_sym_GT_GT] = ACTIONS(265),
    [anon_sym_GT_GT_GT] = ACTIONS(263),
    [anon_sym_instanceof] = ACTIONS(265),
    [anon_sym_final] = ACTIONS(265),
    [anon_sym_DASH_GT] = ACTIONS(263),
    [anon_sym_COMMA] = ACTIONS(263),
    [anon_sym_QMARK] = ACTIONS(263),
    [anon_sym_COLON] = ACTIONS(265),
    [anon_sym_BANG] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(263),
    [anon_sym_PLUS_PLUS] = ACTIONS(263),
    [anon_sym_DASH_DASH] = ACTIONS(263),
    [anon_sym_new] = ACTIONS(265),
    [anon_sym_LBRACK] = ACTIONS(263),
    [anon_sym_RBRACK] = ACTIONS(263),
    [anon_sym_DOT] = ACTIONS(265),
    [anon_sym_class] = ACTIONS(265),
    [anon_sym_COLON_COLON] = ACTIONS(263),
    [anon_sym_switch] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(263),
    [anon_sym_RBRACE] = ACTIONS(263),
    [anon_sym_case] = ACTIONS(265),
    [anon_sym_default] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(263),
    [anon_sym_assert] = ACTIONS(265),
    [anon_sym_do] = ACTIONS(265),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(265),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(265),
    [anon_sym_yield] = ACTIONS(265),
    [anon_sym_synchronized] = ACTIONS(265),
    [anon_sym_throw] = ACTIONS(265),
    [anon_sym_try] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(265),
    [anon_sym_else] = ACTIONS(265),
    [anon_sym_for] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_open] = ACTIONS(265),
    [anon_sym_module] = ACTIONS(265),
    [anon_sym_static] = ACTIONS(265),
    [anon_sym_package] = ACTIONS(265),
    [anon_sym_import] = ACTIONS(265),
    [anon_sym_enum] = ACTIONS(265),
    [anon_sym_public] = ACTIONS(265),
    [anon_sym_protected] = ACTIONS(265),
    [anon_sym_private] = ACTIONS(265),
    [anon_sym_abstract] = ACTIONS(265),
    [anon_sym_strictfp] = ACTIONS(265),
    [anon_sym_native] = ACTIONS(265),
    [anon_sym_transient] = ACTIONS(265),
    [anon_sym_volatile] = ACTIONS(265),
    [anon_sym_sealed] = ACTIONS(265),
    [anon_sym_non_DASHsealed] = ACTIONS(263),
    [anon_sym_record] = ACTIONS(265),
    [anon_sym_ATinterface] = ACTIONS(263),
    [anon_sym_interface] = ACTIONS(265),
    [anon_sym_byte] = ACTIONS(265),
    [anon_sym_short] = ACTIONS(265),
    [anon_sym_int] = ACTIONS(265),
    [anon_sym_long] = ACTIONS(265),
    [anon_sym_char] = ACTIONS(265),
    [anon_sym_float] = ACTIONS(265),
    [anon_sym_double] = ACTIONS(265),
    [sym_boolean_type] = ACTIONS(265),
    [sym_void_type] = ACTIONS(265),
    [sym_this] = ACTIONS(265),
    [sym_super] = ACTIONS(265),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [77] = {
    [ts_builtin_sym_end] = ACTIONS(267),
    [sym_identifier] = ACTIONS(269),
    [sym_decimal_integer_literal] = ACTIONS(269),
    [sym_hex_integer_literal] = ACTIONS(269),
    [sym_octal_integer_literal] = ACTIONS(269),
    [sym_binary_integer_literal] = ACTIONS(267),
    [sym_decimal_floating_point_literal] = ACTIONS(267),
    [sym_hex_floating_point_literal] = ACTIONS(269),
    [sym_true] = ACTIONS(269),
    [sym_false] = ACTIONS(269),
    [sym_character_literal] = ACTIONS(267),
    [anon_sym_DQUOTE] = ACTIONS(269),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(267),
    [sym_null_literal] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(267),
    [anon_sym_RPAREN] = ACTIONS(267),
    [anon_sym_AMP] = ACTIONS(269),
    [anon_sym_GT] = ACTIONS(269),
    [anon_sym_LT] = ACTIONS(269),
    [anon_sym_GT_EQ] = ACTIONS(267),
    [anon_sym_LT_EQ] = ACTIONS(267),
    [anon_sym_EQ_EQ] = ACTIONS(267),
    [anon_sym_BANG_EQ] = ACTIONS(267),
    [anon_sym_AMP_AMP] = ACTIONS(267),
    [anon_sym_PIPE_PIPE] = ACTIONS(267),
    [anon_sym_PLUS] = ACTIONS(269),
    [anon_sym_DASH] = ACTIONS(269),
    [anon_sym_STAR] = ACTIONS(267),
    [anon_sym_SLASH] = ACTIONS(269),
    [anon_sym_PIPE] = ACTIONS(269),
    [anon_sym_CARET] = ACTIONS(267),
    [anon_sym_PERCENT] = ACTIONS(267),
    [anon_sym_LT_LT] = ACTIONS(267),
    [anon_sym_GT_GT] = ACTIONS(269),
    [anon_sym_GT_GT_GT] = ACTIONS(267),
    [anon_sym_instanceof] = ACTIONS(269),
    [anon_sym_final] = ACTIONS(269),
    [anon_sym_DASH_GT] = ACTIONS(267),
    [anon_sym_COMMA] = ACTIONS(267),
    [anon_sym_QMARK] = ACTIONS(267),
    [anon_sym_COLON] = ACTIONS(267),
    [anon_sym_BANG] = ACTIONS(269),
    [anon_sym_TILDE] = ACTIONS(267),
    [anon_sym_PLUS_PLUS] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(267),
    [anon_sym_new] = ACTIONS(269),
    [anon_sym_RBRACK] = ACTIONS(267),
    [anon_sym_class] = ACTIONS(269),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_LBRACE] = ACTIONS(267),
    [anon_sym_RBRACE] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_default] = ACTIONS(269),
    [anon_sym_SEMI] = ACTIONS(267),
    [anon_sym_assert] = ACTIONS(269),
    [anon_sym_do] = ACTIONS(269),
    [anon_sym_while] = ACTIONS(269),
    [anon_sym_break] = ACTIONS(269),
    [anon_sym_continue] = ACTIONS(269),
    [anon_sym_return] = ACTIONS(269),
    [anon_sym_yield] = ACTIONS(269),
    [anon_sym_synchronized] = ACTIONS(269),
    [anon_sym_throw] = ACTIONS(269),
    [anon_sym_try] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(269),
    [anon_sym_else] = ACTIONS(269),
    [anon_sym_for] = ACTIONS(269),
    [anon_sym_AT] = ACTIONS(269),
    [anon_sym_open] = ACTIONS(269),
    [anon_sym_module] = ACTIONS(269),
    [anon_sym_static] = ACTIONS(269),
    [anon_sym_package] = ACTIONS(269),
    [anon_sym_import] = ACTIONS(269),
    [anon_sym_enum] = ACTIONS(269),
    [anon_sym_public] = ACTIONS(269),
    [anon_sym_protected] = ACTIONS(269),
    [anon_sym_private] = ACTIONS(269),
    [anon_sym_abstract] = ACTIONS(269),
    [anon_sym_strictfp] = ACTIONS(269),
    [anon_sym_native] = ACTIONS(269),
    [anon_sym_transient] = ACTIONS(269),
    [anon_sym_volatile] = ACTIONS(269),
    [anon_sym_sealed] = ACTIONS(269),
    [anon_sym_non_DASHsealed] = ACTIONS(267),
    [anon_sym_record] = ACTIONS(269),
    [anon_sym_ATinterface] = ACTIONS(267),
    [anon_sym_interface] = ACTIONS(269),
    [anon_sym_byte] = ACTIONS(269),
    [anon_sym_short] = ACTIONS(269),
    [anon_sym_int] = ACTIONS(269),
    [anon_sym_long] = ACTIONS(269),
    [anon_sym_char] = ACTIONS(269),
    [anon_sym_float] = ACTIONS(269),
    [anon_sym_double] = ACTIONS(269),
    [sym_boolean_type] = ACTIONS(269),
    [sym_void_type] = ACTIONS(269),
    [sym_this] = ACTIONS(269),
    [sym_super] = ACTIONS(269),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [78] = {
    [ts_builtin_sym_end] = ACTIONS(271),
    [sym_identifier] = ACTIONS(273),
    [sym_decimal_integer_literal] = ACTIONS(273),
    [sym_hex_integer_literal] = ACTIONS(273),
    [sym_octal_integer_literal] = ACTIONS(273),
    [sym_binary_integer_literal] = ACTIONS(271),
    [sym_decimal_floating_point_literal] = ACTIONS(271),
    [sym_hex_floating_point_literal] = ACTIONS(273),
    [sym_true] = ACTIONS(273),
    [sym_false] = ACTIONS(273),
    [sym_character_literal] = ACTIONS(271),
    [anon_sym_DQUOTE] = ACTIONS(273),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(271),
    [sym_null_literal] = ACTIONS(273),
    [anon_sym_LPAREN] = ACTIONS(271),
    [anon_sym_RPAREN] = ACTIONS(271),
    [anon_sym_AMP] = ACTIONS(273),
    [anon_sym_GT] = ACTIONS(273),
    [anon_sym_LT] = ACTIONS(273),
    [anon_sym_GT_EQ] = ACTIONS(271),
    [anon_sym_LT_EQ] = ACTIONS(271),
    [anon_sym_EQ_EQ] = ACTIONS(271),
    [anon_sym_BANG_EQ] = ACTIONS(271),
    [anon_sym_AMP_AMP] = ACTIONS(271),
    [anon_sym_PIPE_PIPE] = ACTIONS(271),
    [anon_sym_PLUS] = ACTIONS(273),
    [anon_sym_DASH] = ACTIONS(273),
    [anon_sym_STAR] = ACTIONS(271),
    [anon_sym_SLASH] = ACTIONS(273),
    [anon_sym_PIPE] = ACTIONS(273),
    [anon_sym_CARET] = ACTIONS(271),
    [anon_sym_PERCENT] = ACTIONS(271),
    [anon_sym_LT_LT] = ACTIONS(271),
    [anon_sym_GT_GT] = ACTIONS(273),
    [anon_sym_GT_GT_GT] = ACTIONS(271),
    [anon_sym_instanceof] = ACTIONS(273),
    [anon_sym_final] = ACTIONS(273),
    [anon_sym_DASH_GT] = ACTIONS(271),
    [anon_sym_COMMA] = ACTIONS(271),
    [anon_sym_QMARK] = ACTIONS(271),
    [anon_sym_COLON] = ACTIONS(271),
    [anon_sym_BANG] = ACTIONS(273),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_PLUS_PLUS] = ACTIONS(271),
    [anon_sym_DASH_DASH] = ACTIONS(271),
    [anon_sym_new] = ACTIONS(273),
    [anon_sym_RBRACK] = ACTIONS(271),
    [anon_sym_class] = ACTIONS(273),
    [anon_sym_switch] = ACTIONS(273),
    [anon_sym_LBRACE] = ACTIONS(271),
    [anon_sym_RBRACE] = ACTIONS(271),
    [anon_sym_case] = ACTIONS(273),
    [anon_sym_default] = ACTIONS(273),
    [anon_sym_SEMI] = ACTIONS(271),
    [anon_sym_assert] = ACTIONS(273),
    [anon_sym_do] = ACTIONS(273),
    [anon_sym_while] = ACTIONS(273),
    [anon_sym_break] = ACTIONS(273),
    [anon_sym_continue] = ACTIONS(273),
    [anon_sym_return] = ACTIONS(273),
    [anon_sym_yield] = ACTIONS(273),
    [anon_sym_synchronized] = ACTIONS(273),
    [anon_sym_throw] = ACTIONS(273),
    [anon_sym_try] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(273),
    [anon_sym_else] = ACTIONS(273),
    [anon_sym_for] = ACTIONS(273),
    [anon_sym_AT] = ACTIONS(273),
    [anon_sym_open] = ACTIONS(273),
    [anon_sym_module] = ACTIONS(273),
    [anon_sym_static] = ACTIONS(273),
    [anon_sym_package] = ACTIONS(273),
    [anon_sym_import] = ACTIONS(273),
    [anon_sym_enum] = ACTIONS(273),
    [anon_sym_public] = ACTIONS(273),
    [anon_sym_protected] = ACTIONS(273),
    [anon_sym_private] = ACTIONS(273),
    [anon_sym_abstract] = ACTIONS(273),
    [anon_sym_strictfp] = ACTIONS(273),
    [anon_sym_native] = ACTIONS(273),
    [anon_sym_transient] = ACTIONS(273),
    [anon_sym_volatile] = ACTIONS(273),
    [anon_sym_sealed] = ACTIONS(273),
    [anon_sym_non_DASHsealed] = ACTIONS(271),
    [anon_sym_record] = ACTIONS(273),
    [anon_sym_ATinterface] = ACTIONS(271),
    [anon_sym_interface] = ACTIONS(273),
    [anon_sym_byte] = ACTIONS(273),
    [anon_sym_short] = ACTIONS(273),
    [anon_sym_int] = ACTIONS(273),
    [anon_sym_long] = ACTIONS(273),
    [anon_sym_char] = ACTIONS(273),
    [anon_sym_float] = ACTIONS(273),
    [anon_sym_double] = ACTIONS(273),
    [sym_boolean_type] = ACTIONS(273),
    [sym_void_type] = ACTIONS(273),
    [sym_this] = ACTIONS(273),
    [sym_super] = ACTIONS(273),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [79] = {
    [ts_builtin_sym_end] = ACTIONS(275),
    [sym_identifier] = ACTIONS(277),
    [sym_decimal_integer_literal] = ACTIONS(277),
    [sym_hex_integer_literal] = ACTIONS(277),
    [sym_octal_integer_literal] = ACTIONS(277),
    [sym_binary_integer_literal] = ACTIONS(275),
    [sym_decimal_floating_point_literal] = ACTIONS(275),
    [sym_hex_floating_point_literal] = ACTIONS(277),
    [sym_true] = ACTIONS(277),
    [sym_false] = ACTIONS(277),
    [sym_character_literal] = ACTIONS(275),
    [anon_sym_DQUOTE] = ACTIONS(277),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(275),
    [sym_null_literal] = ACTIONS(277),
    [anon_sym_LPAREN] = ACTIONS(275),
    [anon_sym_RPAREN] = ACTIONS(275),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(277),
    [anon_sym_LT] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(275),
    [anon_sym_LT_EQ] = ACTIONS(275),
    [anon_sym_EQ_EQ] = ACTIONS(275),
    [anon_sym_BANG_EQ] = ACTIONS(275),
    [anon_sym_AMP_AMP] = ACTIONS(275),
    [anon_sym_PIPE_PIPE] = ACTIONS(275),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_STAR] = ACTIONS(275),
    [anon_sym_SLASH] = ACTIONS(277),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(275),
    [anon_sym_PERCENT] = ACTIONS(275),
    [anon_sym_LT_LT] = ACTIONS(275),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_GT_GT_GT] = ACTIONS(275),
    [anon_sym_instanceof] = ACTIONS(277),
    [anon_sym_final] = ACTIONS(277),
    [anon_sym_DASH_GT] = ACTIONS(275),
    [anon_sym_COMMA] = ACTIONS(275),
    [anon_sym_QMARK] = ACTIONS(275),
    [anon_sym_COLON] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_PLUS_PLUS] = ACTIONS(275),
    [anon_sym_DASH_DASH] = ACTIONS(275),
    [anon_sym_new] = ACTIONS(277),
    [anon_sym_RBRACK] = ACTIONS(275),
    [anon_sym_class] = ACTIONS(277),
    [anon_sym_switch] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(275),
    [anon_sym_RBRACE] = ACTIONS(275),
    [anon_sym_case] = ACTIONS(277),
    [anon_sym_default] = ACTIONS(277),
    [anon_sym_SEMI] = ACTIONS(275),
    [anon_sym_assert] = ACTIONS(277),
    [anon_sym_do] = ACTIONS(277),
    [anon_sym_while] = ACTIONS(277),
    [anon_sym_break] = ACTIONS(277),
    [anon_sym_continue] = ACTIONS(277),
    [anon_sym_return] = ACTIONS(277),
    [anon_sym_yield] = ACTIONS(277),
    [anon_sym_synchronized] = ACTIONS(277),
    [anon_sym_throw] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(277),
    [anon_sym_if] = ACTIONS(277),
    [anon_sym_else] = ACTIONS(277),
    [anon_sym_for] = ACTIONS(277),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(277),
    [anon_sym_module] = ACTIONS(277),
    [anon_sym_static] = ACTIONS(277),
    [anon_sym_package] = ACTIONS(277),
    [anon_sym_import] = ACTIONS(277),
    [anon_sym_enum] = ACTIONS(277),
    [anon_sym_public] = ACTIONS(277),
    [anon_sym_protected] = ACTIONS(277),
    [anon_sym_private] = ACTIONS(277),
    [anon_sym_abstract] = ACTIONS(277),
    [anon_sym_strictfp] = ACTIONS(277),
    [anon_sym_native] = ACTIONS(277),
    [anon_sym_transient] = ACTIONS(277),
    [anon_sym_volatile] = ACTIONS(277),
    [anon_sym_sealed] = ACTIONS(277),
    [anon_sym_non_DASHsealed] = ACTIONS(275),
    [anon_sym_record] = ACTIONS(277),
    [anon_sym_ATinterface] = ACTIONS(275),
    [anon_sym_interface] = ACTIONS(277),
    [anon_sym_byte] = ACTIONS(277),
    [anon_sym_short] = ACTIONS(277),
    [anon_sym_int] = ACTIONS(277),
    [anon_sym_long] = ACTIONS(277),
    [anon_sym_char] = ACTIONS(277),
    [anon_sym_float] = ACTIONS(277),
    [anon_sym_double] = ACTIONS(277),
    [sym_boolean_type] = ACTIONS(277),
    [sym_void_type] = ACTIONS(277),
    [sym_this] = ACTIONS(277),
    [sym_super] = ACTIONS(277),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [80] = {
    [ts_builtin_sym_end] = ACTIONS(279),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(281),
    [sym_hex_integer_literal] = ACTIONS(281),
    [sym_octal_integer_literal] = ACTIONS(281),
    [sym_binary_integer_literal] = ACTIONS(279),
    [sym_decimal_floating_point_literal] = ACTIONS(279),
    [sym_hex_floating_point_literal] = ACTIONS(281),
    [sym_true] = ACTIONS(281),
    [sym_false] = ACTIONS(281),
    [sym_character_literal] = ACTIONS(279),
    [anon_sym_DQUOTE] = ACTIONS(281),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(279),
    [sym_null_literal] = ACTIONS(281),
    [anon_sym_LPAREN] = ACTIONS(279),
    [anon_sym_RPAREN] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(281),
    [anon_sym_GT] = ACTIONS(281),
    [anon_sym_LT] = ACTIONS(281),
    [anon_sym_GT_EQ] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(279),
    [anon_sym_EQ_EQ] = ACTIONS(279),
    [anon_sym_BANG_EQ] = ACTIONS(279),
    [anon_sym_AMP_AMP] = ACTIONS(279),
    [anon_sym_PIPE_PIPE] = ACTIONS(279),
    [anon_sym_PLUS] = ACTIONS(281),
    [anon_sym_DASH] = ACTIONS(281),
    [anon_sym_STAR] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(281),
    [anon_sym_PIPE] = ACTIONS(281),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_GT_GT] = ACTIONS(281),
    [anon_sym_GT_GT_GT] = ACTIONS(279),
    [anon_sym_instanceof] = ACTIONS(281),
    [anon_sym_final] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(279),
    [anon_sym_COMMA] = ACTIONS(279),
    [anon_sym_QMARK] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_BANG] = ACTIONS(281),
    [anon_sym_TILDE] = ACTIONS(279),
    [anon_sym_PLUS_PLUS] = ACTIONS(279),
    [anon_sym_DASH_DASH] = ACTIONS(279),
    [anon_sym_new] = ACTIONS(281),
    [anon_sym_RBRACK] = ACTIONS(279),
    [anon_sym_class] = ACTIONS(281),
    [anon_sym_switch] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(279),
    [anon_sym_RBRACE] = ACTIONS(279),
    [anon_sym_case] = ACTIONS(281),
    [anon_sym_default] = ACTIONS(281),
    [anon_sym_SEMI] = ACTIONS(279),
    [anon_sym_assert] = ACTIONS(281),
    [anon_sym_do] = ACTIONS(281),
    [anon_sym_while] = ACTIONS(281),
    [anon_sym_break] = ACTIONS(281),
    [anon_sym_continue] = ACTIONS(281),
    [anon_sym_return] = ACTIONS(281),
    [anon_sym_yield] = ACTIONS(281),
    [anon_sym_synchronized] = ACTIONS(281),
    [anon_sym_throw] = ACTIONS(281),
    [anon_sym_try] = ACTIONS(281),
    [anon_sym_if] = ACTIONS(281),
    [anon_sym_else] = ACTIONS(281),
    [anon_sym_for] = ACTIONS(281),
    [anon_sym_AT] = ACTIONS(281),
    [anon_sym_open] = ACTIONS(281),
    [anon_sym_module] = ACTIONS(281),
    [anon_sym_static] = ACTIONS(281),
    [anon_sym_package] = ACTIONS(281),
    [anon_sym_import] = ACTIONS(281),
    [anon_sym_enum] = ACTIONS(281),
    [anon_sym_public] = ACTIONS(281),
    [anon_sym_protected] = ACTIONS(281),
    [anon_sym_private] = ACTIONS(281),
    [anon_sym_abstract] = ACTIONS(281),
    [anon_sym_strictfp] = ACTIONS(281),
    [anon_sym_native] = ACTIONS(281),
    [anon_sym_transient] = ACTIONS(281),
    [anon_sym_volatile] = ACTIONS(281),
    [anon_sym_sealed] = ACTIONS(281),
    [anon_sym_non_DASHsealed] = ACTIONS(279),
    [anon_sym_record] = ACTIONS(281),
    [anon_sym_ATinterface] = ACTIONS(279),
    [anon_sym_interface] = ACTIONS(281),
    [anon_sym_byte] = ACTIONS(281),
    [anon_sym_short] = ACTIONS(281),
    [anon_sym_int] = ACTIONS(281),
    [anon_sym_long] = ACTIONS(281),
    [anon_sym_char] = ACTIONS(281),
    [anon_sym_float] = ACTIONS(281),
    [anon_sym_double] = ACTIONS(281),
    [sym_boolean_type] = ACTIONS(281),
    [sym_void_type] = ACTIONS(281),
    [sym_this] = ACTIONS(281),
    [sym_super] = ACTIONS(281),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [81] = {
    [ts_builtin_sym_end] = ACTIONS(283),
    [sym_identifier] = ACTIONS(285),
    [sym_decimal_integer_literal] = ACTIONS(285),
    [sym_hex_integer_literal] = ACTIONS(285),
    [sym_octal_integer_literal] = ACTIONS(285),
    [sym_binary_integer_literal] = ACTIONS(283),
    [sym_decimal_floating_point_literal] = ACTIONS(283),
    [sym_hex_floating_point_literal] = ACTIONS(285),
    [sym_true] = ACTIONS(285),
    [sym_false] = ACTIONS(285),
    [sym_character_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(285),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(283),
    [sym_null_literal] = ACTIONS(285),
    [anon_sym_LPAREN] = ACTIONS(283),
    [anon_sym_RPAREN] = ACTIONS(283),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_GT] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(285),
    [anon_sym_GT_EQ] = ACTIONS(283),
    [anon_sym_LT_EQ] = ACTIONS(283),
    [anon_sym_EQ_EQ] = ACTIONS(283),
    [anon_sym_BANG_EQ] = ACTIONS(283),
    [anon_sym_AMP_AMP] = ACTIONS(283),
    [anon_sym_PIPE_PIPE] = ACTIONS(283),
    [anon_sym_PLUS] = ACTIONS(285),
    [anon_sym_DASH] = ACTIONS(285),
    [anon_sym_STAR] = ACTIONS(283),
    [anon_sym_SLASH] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_CARET] = ACTIONS(283),
    [anon_sym_PERCENT] = ACTIONS(283),
    [anon_sym_LT_LT] = ACTIONS(283),
    [anon_sym_GT_GT] = ACTIONS(285),
    [anon_sym_GT_GT_GT] = ACTIONS(283),
    [anon_sym_instanceof] = ACTIONS(285),
    [anon_sym_final] = ACTIONS(285),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_COMMA] = ACTIONS(283),
    [anon_sym_QMARK] = ACTIONS(283),
    [anon_sym_COLON] = ACTIONS(283),
    [anon_sym_BANG] = ACTIONS(285),
    [anon_sym_TILDE] = ACTIONS(283),
    [anon_sym_PLUS_PLUS] = ACTIONS(283),
    [anon_sym_DASH_DASH] = ACTIONS(283),
    [anon_sym_new] = ACTIONS(285),
    [anon_sym_RBRACK] = ACTIONS(283),
    [anon_sym_class] = ACTIONS(285),
    [anon_sym_switch] = ACTIONS(285),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_RBRACE] = ACTIONS(283),
    [anon_sym_case] = ACTIONS(285),
    [anon_sym_default] = ACTIONS(285),
    [anon_sym_SEMI] = ACTIONS(283),
    [anon_sym_assert] = ACTIONS(285),
    [anon_sym_do] = ACTIONS(285),
    [anon_sym_while] = ACTIONS(285),
    [anon_sym_break] = ACTIONS(285),
    [anon_sym_continue] = ACTIONS(285),
    [anon_sym_return] = ACTIONS(285),
    [anon_sym_yield] = ACTIONS(285),
    [anon_sym_synchronized] = ACTIONS(285),
    [anon_sym_throw] = ACTIONS(285),
    [anon_sym_try] = ACTIONS(285),
    [anon_sym_if] = ACTIONS(285),
    [anon_sym_else] = ACTIONS(285),
    [anon_sym_for] = ACTIONS(285),
    [anon_sym_AT] = ACTIONS(285),
    [anon_sym_open] = ACTIONS(285),
    [anon_sym_module] = ACTIONS(285),
    [anon_sym_static] = ACTIONS(285),
    [anon_sym_package] = ACTIONS(285),
    [anon_sym_import] = ACTIONS(285),
    [anon_sym_enum] = ACTIONS(285),
    [anon_sym_public] = ACTIONS(285),
    [anon_sym_protected] = ACTIONS(285),
    [anon_sym_private] = ACTIONS(285),
    [anon_sym_abstract] = ACTIONS(285),
    [anon_sym_strictfp] = ACTIONS(285),
    [anon_sym_native] = ACTIONS(285),
    [anon_sym_transient] = ACTIONS(285),
    [anon_sym_volatile] = ACTIONS(285),
    [anon_sym_sealed] = ACTIONS(285),
    [anon_sym_non_DASHsealed] = ACTIONS(283),
    [anon_sym_record] = ACTIONS(285),
    [anon_sym_ATinterface] = ACTIONS(283),
    [anon_sym_interface] = ACTIONS(285),
    [anon_sym_byte] = ACTIONS(285),
    [anon_sym_short] = ACTIONS(285),
    [anon_sym_int] = ACTIONS(285),
    [anon_sym_long] = ACTIONS(285),
    [anon_sym_char] = ACTIONS(285),
    [anon_sym_float] = ACTIONS(285),
    [anon_sym_double] = ACTIONS(285),
    [sym_boolean_type] = ACTIONS(285),
    [sym_void_type] = ACTIONS(285),
    [sym_this] = ACTIONS(285),
    [sym_super] = ACTIONS(285),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [82] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(656),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(628),
    [sym_marker_annotation] = STATE(628),
    [sym_annotation] = STATE(628),
    [sym_modifiers] = STATE(719),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(707),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_formal_parameter] = STATE(1030),
    [sym_receiver_parameter] = STATE(402),
    [sym_spread_parameter] = STATE(1030),
    [aux_sym_array_creation_expression_repeat1] = STATE(681),
    [aux_sym_modifiers_repeat1] = STATE(563),
    [sym_identifier] = ACTIONS(287),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(289),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(291),
    [anon_sym_synchronized] = ACTIONS(291),
    [anon_sym_AT] = ACTIONS(293),
    [anon_sym_open] = ACTIONS(295),
    [anon_sym_module] = ACTIONS(295),
    [anon_sym_static] = ACTIONS(291),
    [anon_sym_public] = ACTIONS(291),
    [anon_sym_protected] = ACTIONS(291),
    [anon_sym_private] = ACTIONS(291),
    [anon_sym_abstract] = ACTIONS(291),
    [anon_sym_strictfp] = ACTIONS(291),
    [anon_sym_native] = ACTIONS(291),
    [anon_sym_transient] = ACTIONS(291),
    [anon_sym_volatile] = ACTIONS(291),
    [anon_sym_sealed] = ACTIONS(291),
    [anon_sym_non_DASHsealed] = ACTIONS(297),
    [anon_sym_record] = ACTIONS(295),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [83] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(656),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(628),
    [sym_marker_annotation] = STATE(628),
    [sym_annotation] = STATE(628),
    [sym_modifiers] = STATE(719),
    [sym__type] = STATE(937),
    [sym__unannotated_type] = STATE(707),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_formal_parameter] = STATE(1030),
    [sym_receiver_parameter] = STATE(402),
    [sym_spread_parameter] = STATE(1030),
    [aux_sym_array_creation_expression_repeat1] = STATE(681),
    [aux_sym_modifiers_repeat1] = STATE(563),
    [sym_identifier] = ACTIONS(299),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(289),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(291),
    [anon_sym_synchronized] = ACTIONS(291),
    [anon_sym_AT] = ACTIONS(293),
    [anon_sym_open] = ACTIONS(295),
    [anon_sym_module] = ACTIONS(295),
    [anon_sym_static] = ACTIONS(291),
    [anon_sym_public] = ACTIONS(291),
    [anon_sym_protected] = ACTIONS(291),
    [anon_sym_private] = ACTIONS(291),
    [anon_sym_abstract] = ACTIONS(291),
    [anon_sym_strictfp] = ACTIONS(291),
    [anon_sym_native] = ACTIONS(291),
    [anon_sym_transient] = ACTIONS(291),
    [anon_sym_volatile] = ACTIONS(291),
    [anon_sym_sealed] = ACTIONS(291),
    [anon_sym_non_DASHsealed] = ACTIONS(297),
    [anon_sym_record] = ACTIONS(295),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [84] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(656),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(628),
    [sym_marker_annotation] = STATE(628),
    [sym_annotation] = STATE(628),
    [sym_modifiers] = STATE(719),
    [sym__type] = STATE(997),
    [sym__unannotated_type] = STATE(707),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_formal_parameter] = STATE(1030),
    [sym_receiver_parameter] = STATE(402),
    [sym_spread_parameter] = STATE(1030),
    [aux_sym_array_creation_expression_repeat1] = STATE(681),
    [aux_sym_modifiers_repeat1] = STATE(563),
    [sym_identifier] = ACTIONS(299),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(289),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(291),
    [anon_sym_synchronized] = ACTIONS(291),
    [anon_sym_AT] = ACTIONS(293),
    [anon_sym_open] = ACTIONS(295),
    [anon_sym_module] = ACTIONS(295),
    [anon_sym_static] = ACTIONS(291),
    [anon_sym_public] = ACTIONS(291),
    [anon_sym_protected] = ACTIONS(291),
    [anon_sym_private] = ACTIONS(291),
    [anon_sym_abstract] = ACTIONS(291),
    [anon_sym_strictfp] = ACTIONS(291),
    [anon_sym_native] = ACTIONS(291),
    [anon_sym_transient] = ACTIONS(291),
    [anon_sym_volatile] = ACTIONS(291),
    [anon_sym_sealed] = ACTIONS(291),
    [anon_sym_non_DASHsealed] = ACTIONS(297),
    [anon_sym_record] = ACTIONS(295),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [85] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(590),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(628),
    [sym_marker_annotation] = STATE(628),
    [sym_annotation] = STATE(628),
    [sym_modifiers] = STATE(726),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(715),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(140),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [aux_sym_modifiers_repeat1] = STATE(563),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(291),
    [anon_sym_SEMI] = ACTIONS(303),
    [anon_sym_synchronized] = ACTIONS(291),
    [anon_sym_AT] = ACTIONS(293),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_static] = ACTIONS(291),
    [anon_sym_public] = ACTIONS(291),
    [anon_sym_protected] = ACTIONS(291),
    [anon_sym_private] = ACTIONS(291),
    [anon_sym_abstract] = ACTIONS(291),
    [anon_sym_strictfp] = ACTIONS(291),
    [anon_sym_native] = ACTIONS(291),
    [anon_sym_transient] = ACTIONS(291),
    [anon_sym_volatile] = ACTIONS(291),
    [anon_sym_sealed] = ACTIONS(291),
    [anon_sym_non_DASHsealed] = ACTIONS(297),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [86] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(578),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(628),
    [sym_marker_annotation] = STATE(628),
    [sym_annotation] = STATE(628),
    [sym_modifiers] = STATE(724),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(717),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [sym_local_variable_declaration] = STATE(137),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [aux_sym_modifiers_repeat1] = STATE(563),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_final] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(291),
    [anon_sym_SEMI] = ACTIONS(307),
    [anon_sym_synchronized] = ACTIONS(291),
    [anon_sym_AT] = ACTIONS(293),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_static] = ACTIONS(291),
    [anon_sym_public] = ACTIONS(291),
    [anon_sym_protected] = ACTIONS(291),
    [anon_sym_private] = ACTIONS(291),
    [anon_sym_abstract] = ACTIONS(291),
    [anon_sym_strictfp] = ACTIONS(291),
    [anon_sym_native] = ACTIONS(291),
    [anon_sym_transient] = ACTIONS(291),
    [anon_sym_volatile] = ACTIONS(291),
    [anon_sym_sealed] = ACTIONS(291),
    [anon_sym_non_DASHsealed] = ACTIONS(297),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [87] = {
    [ts_builtin_sym_end] = ACTIONS(309),
    [sym_identifier] = ACTIONS(311),
    [sym_decimal_integer_literal] = ACTIONS(311),
    [sym_hex_integer_literal] = ACTIONS(311),
    [sym_octal_integer_literal] = ACTIONS(311),
    [sym_binary_integer_literal] = ACTIONS(309),
    [sym_decimal_floating_point_literal] = ACTIONS(309),
    [sym_hex_floating_point_literal] = ACTIONS(311),
    [sym_true] = ACTIONS(311),
    [sym_false] = ACTIONS(311),
    [sym_character_literal] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(309),
    [sym_null_literal] = ACTIONS(311),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_AMP] = ACTIONS(313),
    [anon_sym_GT] = ACTIONS(313),
    [anon_sym_LT] = ACTIONS(313),
    [anon_sym_GT_EQ] = ACTIONS(315),
    [anon_sym_LT_EQ] = ACTIONS(315),
    [anon_sym_EQ_EQ] = ACTIONS(315),
    [anon_sym_BANG_EQ] = ACTIONS(315),
    [anon_sym_AMP_AMP] = ACTIONS(315),
    [anon_sym_PIPE_PIPE] = ACTIONS(315),
    [anon_sym_PLUS] = ACTIONS(317),
    [anon_sym_DASH] = ACTIONS(317),
    [anon_sym_STAR] = ACTIONS(315),
    [anon_sym_SLASH] = ACTIONS(313),
    [anon_sym_PIPE] = ACTIONS(313),
    [anon_sym_CARET] = ACTIONS(315),
    [anon_sym_PERCENT] = ACTIONS(315),
    [anon_sym_LT_LT] = ACTIONS(315),
    [anon_sym_GT_GT] = ACTIONS(313),
    [anon_sym_GT_GT_GT] = ACTIONS(315),
    [anon_sym_instanceof] = ACTIONS(313),
    [anon_sym_final] = ACTIONS(311),
    [anon_sym_QMARK] = ACTIONS(315),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_TILDE] = ACTIONS(309),
    [anon_sym_PLUS_PLUS] = ACTIONS(320),
    [anon_sym_DASH_DASH] = ACTIONS(320),
    [anon_sym_new] = ACTIONS(311),
    [anon_sym_class] = ACTIONS(311),
    [anon_sym_switch] = ACTIONS(311),
    [anon_sym_LBRACE] = ACTIONS(309),
    [anon_sym_RBRACE] = ACTIONS(309),
    [anon_sym_case] = ACTIONS(311),
    [anon_sym_default] = ACTIONS(311),
    [anon_sym_SEMI] = ACTIONS(320),
    [anon_sym_assert] = ACTIONS(311),
    [anon_sym_do] = ACTIONS(311),
    [anon_sym_while] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(311),
    [anon_sym_continue] = ACTIONS(311),
    [anon_sym_return] = ACTIONS(311),
    [anon_sym_yield] = ACTIONS(311),
    [anon_sym_synchronized] = ACTIONS(311),
    [anon_sym_throw] = ACTIONS(311),
    [anon_sym_try] = ACTIONS(311),
    [anon_sym_if] = ACTIONS(311),
    [anon_sym_else] = ACTIONS(311),
    [anon_sym_for] = ACTIONS(311),
    [anon_sym_AT] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_static] = ACTIONS(311),
    [anon_sym_package] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(311),
    [anon_sym_enum] = ACTIONS(311),
    [anon_sym_public] = ACTIONS(311),
    [anon_sym_protected] = ACTIONS(311),
    [anon_sym_private] = ACTIONS(311),
    [anon_sym_abstract] = ACTIONS(311),
    [anon_sym_strictfp] = ACTIONS(311),
    [anon_sym_native] = ACTIONS(311),
    [anon_sym_transient] = ACTIONS(311),
    [anon_sym_volatile] = ACTIONS(311),
    [anon_sym_sealed] = ACTIONS(311),
    [anon_sym_non_DASHsealed] = ACTIONS(309),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_ATinterface] = ACTIONS(309),
    [anon_sym_interface] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(311),
    [anon_sym_short] = ACTIONS(311),
    [anon_sym_int] = ACTIONS(311),
    [anon_sym_long] = ACTIONS(311),
    [anon_sym_char] = ACTIONS(311),
    [anon_sym_float] = ACTIONS(311),
    [anon_sym_double] = ACTIONS(311),
    [sym_boolean_type] = ACTIONS(311),
    [sym_void_type] = ACTIONS(311),
    [sym_this] = ACTIONS(311),
    [sym_super] = ACTIONS(311),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [88] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(569),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(739),
    [sym_marker_annotation] = STATE(739),
    [sym_annotation] = STATE(739),
    [sym_element_value_pair] = STATE(1041),
    [sym__element_value] = STATE(1247),
    [sym_element_value_array_initializer] = STATE(1247),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(323),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(325),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [89] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(657),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym_block] = STATE(1059),
    [sym_expression_statement] = STATE(1059),
    [sym_throw_statement] = STATE(1059),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [90] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(569),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(739),
    [sym_marker_annotation] = STATE(739),
    [sym_annotation] = STATE(739),
    [sym__element_value] = STATE(1068),
    [sym_element_value_array_initializer] = STATE(1068),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(331),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_RBRACE] = ACTIONS(333),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [91] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(569),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(739),
    [sym_marker_annotation] = STATE(739),
    [sym_annotation] = STATE(739),
    [sym_element_value_pair] = STATE(1005),
    [sym__element_value] = STATE(1254),
    [sym_element_value_array_initializer] = STATE(1254),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(323),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [92] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(569),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(739),
    [sym_marker_annotation] = STATE(739),
    [sym_annotation] = STATE(739),
    [sym_element_value_pair] = STATE(1098),
    [sym__element_value] = STATE(1306),
    [sym_element_value_array_initializer] = STATE(1306),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(323),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [93] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(569),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(739),
    [sym_marker_annotation] = STATE(739),
    [sym_annotation] = STATE(739),
    [sym__element_value] = STATE(1129),
    [sym_element_value_array_initializer] = STATE(1129),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_RBRACE] = ACTIONS(339),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [94] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(574),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym_array_initializer] = STATE(1063),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(341),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_RBRACE] = ACTIONS(345),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [95] = {
    [sym_catch_clause] = STATE(96),
    [sym_finally_clause] = STATE(299),
    [aux_sym_try_statement_repeat1] = STATE(96),
    [ts_builtin_sym_end] = ACTIONS(347),
    [sym_identifier] = ACTIONS(349),
    [sym_decimal_integer_literal] = ACTIONS(349),
    [sym_hex_integer_literal] = ACTIONS(349),
    [sym_octal_integer_literal] = ACTIONS(349),
    [sym_binary_integer_literal] = ACTIONS(347),
    [sym_decimal_floating_point_literal] = ACTIONS(347),
    [sym_hex_floating_point_literal] = ACTIONS(349),
    [sym_true] = ACTIONS(349),
    [sym_false] = ACTIONS(349),
    [sym_character_literal] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(347),
    [sym_null_literal] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(349),
    [anon_sym_DASH] = ACTIONS(349),
    [anon_sym_final] = ACTIONS(349),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_TILDE] = ACTIONS(347),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_new] = ACTIONS(349),
    [anon_sym_class] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(347),
    [anon_sym_RBRACE] = ACTIONS(347),
    [anon_sym_case] = ACTIONS(349),
    [anon_sym_default] = ACTIONS(349),
    [anon_sym_SEMI] = ACTIONS(347),
    [anon_sym_assert] = ACTIONS(349),
    [anon_sym_do] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(349),
    [anon_sym_break] = ACTIONS(349),
    [anon_sym_continue] = ACTIONS(349),
    [anon_sym_return] = ACTIONS(349),
    [anon_sym_yield] = ACTIONS(349),
    [anon_sym_synchronized] = ACTIONS(349),
    [anon_sym_throw] = ACTIONS(349),
    [anon_sym_try] = ACTIONS(349),
    [anon_sym_catch] = ACTIONS(351),
    [anon_sym_finally] = ACTIONS(353),
    [anon_sym_if] = ACTIONS(349),
    [anon_sym_else] = ACTIONS(349),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_AT] = ACTIONS(349),
    [anon_sym_open] = ACTIONS(349),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_package] = ACTIONS(349),
    [anon_sym_import] = ACTIONS(349),
    [anon_sym_enum] = ACTIONS(349),
    [anon_sym_public] = ACTIONS(349),
    [anon_sym_protected] = ACTIONS(349),
    [anon_sym_private] = ACTIONS(349),
    [anon_sym_abstract] = ACTIONS(349),
    [anon_sym_strictfp] = ACTIONS(349),
    [anon_sym_native] = ACTIONS(349),
    [anon_sym_transient] = ACTIONS(349),
    [anon_sym_volatile] = ACTIONS(349),
    [anon_sym_sealed] = ACTIONS(349),
    [anon_sym_non_DASHsealed] = ACTIONS(347),
    [anon_sym_record] = ACTIONS(349),
    [anon_sym_ATinterface] = ACTIONS(347),
    [anon_sym_interface] = ACTIONS(349),
    [anon_sym_byte] = ACTIONS(349),
    [anon_sym_short] = ACTIONS(349),
    [anon_sym_int] = ACTIONS(349),
    [anon_sym_long] = ACTIONS(349),
    [anon_sym_char] = ACTIONS(349),
    [anon_sym_float] = ACTIONS(349),
    [anon_sym_double] = ACTIONS(349),
    [sym_boolean_type] = ACTIONS(349),
    [sym_void_type] = ACTIONS(349),
    [sym_this] = ACTIONS(349),
    [sym_super] = ACTIONS(349),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [96] = {
    [sym_catch_clause] = STATE(101),
    [sym_finally_clause] = STATE(278),
    [aux_sym_try_statement_repeat1] = STATE(101),
    [ts_builtin_sym_end] = ACTIONS(355),
    [sym_identifier] = ACTIONS(357),
    [sym_decimal_integer_literal] = ACTIONS(357),
    [sym_hex_integer_literal] = ACTIONS(357),
    [sym_octal_integer_literal] = ACTIONS(357),
    [sym_binary_integer_literal] = ACTIONS(355),
    [sym_decimal_floating_point_literal] = ACTIONS(355),
    [sym_hex_floating_point_literal] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_character_literal] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(355),
    [sym_null_literal] = ACTIONS(357),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_final] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(355),
    [anon_sym_TILDE] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(355),
    [anon_sym_DASH_DASH] = ACTIONS(355),
    [anon_sym_new] = ACTIONS(357),
    [anon_sym_class] = ACTIONS(357),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(355),
    [anon_sym_RBRACE] = ACTIONS(355),
    [anon_sym_case] = ACTIONS(357),
    [anon_sym_default] = ACTIONS(357),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_assert] = ACTIONS(357),
    [anon_sym_do] = ACTIONS(357),
    [anon_sym_while] = ACTIONS(357),
    [anon_sym_break] = ACTIONS(357),
    [anon_sym_continue] = ACTIONS(357),
    [anon_sym_return] = ACTIONS(357),
    [anon_sym_yield] = ACTIONS(357),
    [anon_sym_synchronized] = ACTIONS(357),
    [anon_sym_throw] = ACTIONS(357),
    [anon_sym_try] = ACTIONS(357),
    [anon_sym_catch] = ACTIONS(351),
    [anon_sym_finally] = ACTIONS(353),
    [anon_sym_if] = ACTIONS(357),
    [anon_sym_else] = ACTIONS(357),
    [anon_sym_for] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(357),
    [anon_sym_open] = ACTIONS(357),
    [anon_sym_module] = ACTIONS(357),
    [anon_sym_static] = ACTIONS(357),
    [anon_sym_package] = ACTIONS(357),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_enum] = ACTIONS(357),
    [anon_sym_public] = ACTIONS(357),
    [anon_sym_protected] = ACTIONS(357),
    [anon_sym_private] = ACTIONS(357),
    [anon_sym_abstract] = ACTIONS(357),
    [anon_sym_strictfp] = ACTIONS(357),
    [anon_sym_native] = ACTIONS(357),
    [anon_sym_transient] = ACTIONS(357),
    [anon_sym_volatile] = ACTIONS(357),
    [anon_sym_sealed] = ACTIONS(357),
    [anon_sym_non_DASHsealed] = ACTIONS(355),
    [anon_sym_record] = ACTIONS(357),
    [anon_sym_ATinterface] = ACTIONS(355),
    [anon_sym_interface] = ACTIONS(357),
    [anon_sym_byte] = ACTIONS(357),
    [anon_sym_short] = ACTIONS(357),
    [anon_sym_int] = ACTIONS(357),
    [anon_sym_long] = ACTIONS(357),
    [anon_sym_char] = ACTIONS(357),
    [anon_sym_float] = ACTIONS(357),
    [anon_sym_double] = ACTIONS(357),
    [sym_boolean_type] = ACTIONS(357),
    [sym_void_type] = ACTIONS(357),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [97] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(569),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(739),
    [sym_marker_annotation] = STATE(739),
    [sym_annotation] = STATE(739),
    [sym__element_value] = STATE(1129),
    [sym_element_value_array_initializer] = STATE(1129),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_RBRACE] = ACTIONS(359),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [98] = {
    [sym_catch_clause] = STATE(101),
    [sym_finally_clause] = STATE(296),
    [aux_sym_try_statement_repeat1] = STATE(101),
    [ts_builtin_sym_end] = ACTIONS(361),
    [sym_identifier] = ACTIONS(363),
    [sym_decimal_integer_literal] = ACTIONS(363),
    [sym_hex_integer_literal] = ACTIONS(363),
    [sym_octal_integer_literal] = ACTIONS(363),
    [sym_binary_integer_literal] = ACTIONS(361),
    [sym_decimal_floating_point_literal] = ACTIONS(361),
    [sym_hex_floating_point_literal] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_character_literal] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(361),
    [sym_null_literal] = ACTIONS(363),
    [anon_sym_LPAREN] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(363),
    [anon_sym_final] = ACTIONS(363),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(361),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_new] = ACTIONS(363),
    [anon_sym_class] = ACTIONS(363),
    [anon_sym_switch] = ACTIONS(363),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_RBRACE] = ACTIONS(361),
    [anon_sym_case] = ACTIONS(363),
    [anon_sym_default] = ACTIONS(363),
    [anon_sym_SEMI] = ACTIONS(361),
    [anon_sym_assert] = ACTIONS(363),
    [anon_sym_do] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(363),
    [anon_sym_break] = ACTIONS(363),
    [anon_sym_continue] = ACTIONS(363),
    [anon_sym_return] = ACTIONS(363),
    [anon_sym_yield] = ACTIONS(363),
    [anon_sym_synchronized] = ACTIONS(363),
    [anon_sym_throw] = ACTIONS(363),
    [anon_sym_try] = ACTIONS(363),
    [anon_sym_catch] = ACTIONS(351),
    [anon_sym_finally] = ACTIONS(353),
    [anon_sym_if] = ACTIONS(363),
    [anon_sym_else] = ACTIONS(363),
    [anon_sym_for] = ACTIONS(363),
    [anon_sym_AT] = ACTIONS(363),
    [anon_sym_open] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(363),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_package] = ACTIONS(363),
    [anon_sym_import] = ACTIONS(363),
    [anon_sym_enum] = ACTIONS(363),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(363),
    [anon_sym_strictfp] = ACTIONS(363),
    [anon_sym_native] = ACTIONS(363),
    [anon_sym_transient] = ACTIONS(363),
    [anon_sym_volatile] = ACTIONS(363),
    [anon_sym_sealed] = ACTIONS(363),
    [anon_sym_non_DASHsealed] = ACTIONS(361),
    [anon_sym_record] = ACTIONS(363),
    [anon_sym_ATinterface] = ACTIONS(361),
    [anon_sym_interface] = ACTIONS(363),
    [anon_sym_byte] = ACTIONS(363),
    [anon_sym_short] = ACTIONS(363),
    [anon_sym_int] = ACTIONS(363),
    [anon_sym_long] = ACTIONS(363),
    [anon_sym_char] = ACTIONS(363),
    [anon_sym_float] = ACTIONS(363),
    [anon_sym_double] = ACTIONS(363),
    [sym_boolean_type] = ACTIONS(363),
    [sym_void_type] = ACTIONS(363),
    [sym_this] = ACTIONS(363),
    [sym_super] = ACTIONS(363),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [99] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(569),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(739),
    [sym_marker_annotation] = STATE(739),
    [sym_annotation] = STATE(739),
    [sym__element_value] = STATE(1267),
    [sym_element_value_array_initializer] = STATE(1267),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [100] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(569),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(739),
    [sym_marker_annotation] = STATE(739),
    [sym_annotation] = STATE(739),
    [sym__element_value] = STATE(1228),
    [sym_element_value_array_initializer] = STATE(1228),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [101] = {
    [sym_catch_clause] = STATE(101),
    [aux_sym_try_statement_repeat1] = STATE(101),
    [ts_builtin_sym_end] = ACTIONS(365),
    [sym_identifier] = ACTIONS(367),
    [sym_decimal_integer_literal] = ACTIONS(367),
    [sym_hex_integer_literal] = ACTIONS(367),
    [sym_octal_integer_literal] = ACTIONS(367),
    [sym_binary_integer_literal] = ACTIONS(365),
    [sym_decimal_floating_point_literal] = ACTIONS(365),
    [sym_hex_floating_point_literal] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_character_literal] = ACTIONS(365),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(365),
    [sym_null_literal] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(367),
    [anon_sym_DASH] = ACTIONS(367),
    [anon_sym_final] = ACTIONS(367),
    [anon_sym_BANG] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(365),
    [anon_sym_PLUS_PLUS] = ACTIONS(365),
    [anon_sym_DASH_DASH] = ACTIONS(365),
    [anon_sym_new] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(367),
    [anon_sym_switch] = ACTIONS(367),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_RBRACE] = ACTIONS(365),
    [anon_sym_case] = ACTIONS(367),
    [anon_sym_default] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(365),
    [anon_sym_assert] = ACTIONS(367),
    [anon_sym_do] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_break] = ACTIONS(367),
    [anon_sym_continue] = ACTIONS(367),
    [anon_sym_return] = ACTIONS(367),
    [anon_sym_yield] = ACTIONS(367),
    [anon_sym_synchronized] = ACTIONS(367),
    [anon_sym_throw] = ACTIONS(367),
    [anon_sym_try] = ACTIONS(367),
    [anon_sym_catch] = ACTIONS(369),
    [anon_sym_finally] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_else] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_AT] = ACTIONS(367),
    [anon_sym_open] = ACTIONS(367),
    [anon_sym_module] = ACTIONS(367),
    [anon_sym_static] = ACTIONS(367),
    [anon_sym_package] = ACTIONS(367),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_enum] = ACTIONS(367),
    [anon_sym_public] = ACTIONS(367),
    [anon_sym_protected] = ACTIONS(367),
    [anon_sym_private] = ACTIONS(367),
    [anon_sym_abstract] = ACTIONS(367),
    [anon_sym_strictfp] = ACTIONS(367),
    [anon_sym_native] = ACTIONS(367),
    [anon_sym_transient] = ACTIONS(367),
    [anon_sym_volatile] = ACTIONS(367),
    [anon_sym_sealed] = ACTIONS(367),
    [anon_sym_non_DASHsealed] = ACTIONS(365),
    [anon_sym_record] = ACTIONS(367),
    [anon_sym_ATinterface] = ACTIONS(365),
    [anon_sym_interface] = ACTIONS(367),
    [anon_sym_byte] = ACTIONS(367),
    [anon_sym_short] = ACTIONS(367),
    [anon_sym_int] = ACTIONS(367),
    [anon_sym_long] = ACTIONS(367),
    [anon_sym_char] = ACTIONS(367),
    [anon_sym_float] = ACTIONS(367),
    [anon_sym_double] = ACTIONS(367),
    [sym_boolean_type] = ACTIONS(367),
    [sym_void_type] = ACTIONS(367),
    [sym_this] = ACTIONS(367),
    [sym_super] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [102] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(569),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(739),
    [sym_marker_annotation] = STATE(739),
    [sym_annotation] = STATE(739),
    [sym__element_value] = STATE(1129),
    [sym_element_value_array_initializer] = STATE(1129),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [103] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(629),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym_array_initializer] = STATE(1126),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_RBRACE] = ACTIONS(372),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [104] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(623),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(739),
    [sym_marker_annotation] = STATE(739),
    [sym_annotation] = STATE(739),
    [sym__element_value] = STATE(1228),
    [sym_element_value_array_initializer] = STATE(1228),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [105] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(629),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym_array_initializer] = STATE(1126),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_RBRACE] = ACTIONS(374),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [106] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(629),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym_array_initializer] = STATE(1126),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [107] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(602),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1273),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(400),
    [sym_array_access] = STATE(400),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym_block] = STATE(527),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1273),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(376),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(378),
    [anon_sym_PLUS] = ACTIONS(380),
    [anon_sym_DASH] = ACTIONS(380),
    [anon_sym_BANG] = ACTIONS(382),
    [anon_sym_TILDE] = ACTIONS(382),
    [anon_sym_PLUS_PLUS] = ACTIONS(384),
    [anon_sym_DASH_DASH] = ACTIONS(384),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(386),
    [anon_sym_module] = ACTIONS(386),
    [anon_sym_record] = ACTIONS(386),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [108] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(588),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1273),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(400),
    [sym_array_access] = STATE(400),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym_block] = STATE(542),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1273),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(376),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(378),
    [anon_sym_PLUS] = ACTIONS(380),
    [anon_sym_DASH] = ACTIONS(380),
    [anon_sym_BANG] = ACTIONS(382),
    [anon_sym_TILDE] = ACTIONS(382),
    [anon_sym_PLUS_PLUS] = ACTIONS(384),
    [anon_sym_DASH_DASH] = ACTIONS(384),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(386),
    [anon_sym_module] = ACTIONS(386),
    [anon_sym_record] = ACTIONS(386),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [109] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(559),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym_block] = STATE(542),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [110] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(607),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym_array_initializer] = STATE(1097),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [111] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(548),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym_block] = STATE(527),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [112] = {
    [ts_builtin_sym_end] = ACTIONS(267),
    [sym_identifier] = ACTIONS(269),
    [sym_decimal_integer_literal] = ACTIONS(269),
    [sym_hex_integer_literal] = ACTIONS(269),
    [sym_octal_integer_literal] = ACTIONS(269),
    [sym_binary_integer_literal] = ACTIONS(267),
    [sym_decimal_floating_point_literal] = ACTIONS(267),
    [sym_hex_floating_point_literal] = ACTIONS(269),
    [sym_true] = ACTIONS(269),
    [sym_false] = ACTIONS(269),
    [sym_character_literal] = ACTIONS(267),
    [anon_sym_DQUOTE] = ACTIONS(269),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(267),
    [sym_null_literal] = ACTIONS(269),
    [anon_sym_LPAREN] = ACTIONS(267),
    [anon_sym_PLUS] = ACTIONS(269),
    [anon_sym_DASH] = ACTIONS(269),
    [anon_sym_final] = ACTIONS(269),
    [anon_sym_BANG] = ACTIONS(267),
    [anon_sym_TILDE] = ACTIONS(267),
    [anon_sym_PLUS_PLUS] = ACTIONS(267),
    [anon_sym_DASH_DASH] = ACTIONS(267),
    [anon_sym_new] = ACTIONS(269),
    [anon_sym_class] = ACTIONS(269),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_LBRACE] = ACTIONS(267),
    [anon_sym_RBRACE] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_default] = ACTIONS(269),
    [anon_sym_SEMI] = ACTIONS(267),
    [anon_sym_assert] = ACTIONS(269),
    [anon_sym_do] = ACTIONS(269),
    [anon_sym_while] = ACTIONS(269),
    [anon_sym_break] = ACTIONS(269),
    [anon_sym_continue] = ACTIONS(269),
    [anon_sym_return] = ACTIONS(269),
    [anon_sym_yield] = ACTIONS(269),
    [anon_sym_synchronized] = ACTIONS(269),
    [anon_sym_throw] = ACTIONS(269),
    [anon_sym_try] = ACTIONS(269),
    [anon_sym_catch] = ACTIONS(269),
    [anon_sym_finally] = ACTIONS(269),
    [anon_sym_if] = ACTIONS(269),
    [anon_sym_else] = ACTIONS(269),
    [anon_sym_for] = ACTIONS(269),
    [anon_sym_AT] = ACTIONS(269),
    [anon_sym_open] = ACTIONS(269),
    [anon_sym_module] = ACTIONS(269),
    [anon_sym_static] = ACTIONS(269),
    [anon_sym_package] = ACTIONS(269),
    [anon_sym_import] = ACTIONS(269),
    [anon_sym_enum] = ACTIONS(269),
    [anon_sym_public] = ACTIONS(269),
    [anon_sym_protected] = ACTIONS(269),
    [anon_sym_private] = ACTIONS(269),
    [anon_sym_abstract] = ACTIONS(269),
    [anon_sym_strictfp] = ACTIONS(269),
    [anon_sym_native] = ACTIONS(269),
    [anon_sym_transient] = ACTIONS(269),
    [anon_sym_volatile] = ACTIONS(269),
    [anon_sym_sealed] = ACTIONS(269),
    [anon_sym_non_DASHsealed] = ACTIONS(267),
    [anon_sym_record] = ACTIONS(269),
    [anon_sym_ATinterface] = ACTIONS(267),
    [anon_sym_interface] = ACTIONS(269),
    [anon_sym_byte] = ACTIONS(269),
    [anon_sym_short] = ACTIONS(269),
    [anon_sym_int] = ACTIONS(269),
    [anon_sym_long] = ACTIONS(269),
    [anon_sym_char] = ACTIONS(269),
    [anon_sym_float] = ACTIONS(269),
    [anon_sym_double] = ACTIONS(269),
    [sym_boolean_type] = ACTIONS(269),
    [sym_void_type] = ACTIONS(269),
    [sym_this] = ACTIONS(269),
    [sym_super] = ACTIONS(269),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [113] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(609),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(388),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [114] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(587),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(390),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [115] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(637),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [116] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(615),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [117] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(618),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(396),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [118] = {
    [ts_builtin_sym_end] = ACTIONS(275),
    [sym_identifier] = ACTIONS(277),
    [sym_decimal_integer_literal] = ACTIONS(277),
    [sym_hex_integer_literal] = ACTIONS(277),
    [sym_octal_integer_literal] = ACTIONS(277),
    [sym_binary_integer_literal] = ACTIONS(275),
    [sym_decimal_floating_point_literal] = ACTIONS(275),
    [sym_hex_floating_point_literal] = ACTIONS(277),
    [sym_true] = ACTIONS(277),
    [sym_false] = ACTIONS(277),
    [sym_character_literal] = ACTIONS(275),
    [anon_sym_DQUOTE] = ACTIONS(277),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(275),
    [sym_null_literal] = ACTIONS(277),
    [anon_sym_LPAREN] = ACTIONS(275),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_final] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_PLUS_PLUS] = ACTIONS(275),
    [anon_sym_DASH_DASH] = ACTIONS(275),
    [anon_sym_new] = ACTIONS(277),
    [anon_sym_class] = ACTIONS(277),
    [anon_sym_switch] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(275),
    [anon_sym_RBRACE] = ACTIONS(275),
    [anon_sym_case] = ACTIONS(277),
    [anon_sym_default] = ACTIONS(277),
    [anon_sym_SEMI] = ACTIONS(275),
    [anon_sym_assert] = ACTIONS(277),
    [anon_sym_do] = ACTIONS(277),
    [anon_sym_while] = ACTIONS(277),
    [anon_sym_break] = ACTIONS(277),
    [anon_sym_continue] = ACTIONS(277),
    [anon_sym_return] = ACTIONS(277),
    [anon_sym_yield] = ACTIONS(277),
    [anon_sym_synchronized] = ACTIONS(277),
    [anon_sym_throw] = ACTIONS(277),
    [anon_sym_try] = ACTIONS(277),
    [anon_sym_catch] = ACTIONS(277),
    [anon_sym_finally] = ACTIONS(277),
    [anon_sym_if] = ACTIONS(277),
    [anon_sym_else] = ACTIONS(277),
    [anon_sym_for] = ACTIONS(277),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(277),
    [anon_sym_module] = ACTIONS(277),
    [anon_sym_static] = ACTIONS(277),
    [anon_sym_package] = ACTIONS(277),
    [anon_sym_import] = ACTIONS(277),
    [anon_sym_enum] = ACTIONS(277),
    [anon_sym_public] = ACTIONS(277),
    [anon_sym_protected] = ACTIONS(277),
    [anon_sym_private] = ACTIONS(277),
    [anon_sym_abstract] = ACTIONS(277),
    [anon_sym_strictfp] = ACTIONS(277),
    [anon_sym_native] = ACTIONS(277),
    [anon_sym_transient] = ACTIONS(277),
    [anon_sym_volatile] = ACTIONS(277),
    [anon_sym_sealed] = ACTIONS(277),
    [anon_sym_non_DASHsealed] = ACTIONS(275),
    [anon_sym_record] = ACTIONS(277),
    [anon_sym_ATinterface] = ACTIONS(275),
    [anon_sym_interface] = ACTIONS(277),
    [anon_sym_byte] = ACTIONS(277),
    [anon_sym_short] = ACTIONS(277),
    [anon_sym_int] = ACTIONS(277),
    [anon_sym_long] = ACTIONS(277),
    [anon_sym_char] = ACTIONS(277),
    [anon_sym_float] = ACTIONS(277),
    [anon_sym_double] = ACTIONS(277),
    [sym_boolean_type] = ACTIONS(277),
    [sym_void_type] = ACTIONS(277),
    [sym_this] = ACTIONS(277),
    [sym_super] = ACTIONS(277),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [119] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(619),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(398),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [120] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(641),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_SEMI] = ACTIONS(400),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [121] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(610),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(402),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [122] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(621),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(404),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [123] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(613),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(406),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [124] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(638),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_RBRACK] = ACTIONS(408),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [125] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(606),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(410),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [126] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(635),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_RBRACK] = ACTIONS(412),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [127] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(638),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_RBRACK] = ACTIONS(414),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [128] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(642),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_SEMI] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [129] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [130] = {
    [ts_builtin_sym_end] = ACTIONS(420),
    [sym_identifier] = ACTIONS(422),
    [sym_decimal_integer_literal] = ACTIONS(422),
    [sym_hex_integer_literal] = ACTIONS(422),
    [sym_octal_integer_literal] = ACTIONS(422),
    [sym_binary_integer_literal] = ACTIONS(420),
    [sym_decimal_floating_point_literal] = ACTIONS(420),
    [sym_hex_floating_point_literal] = ACTIONS(422),
    [sym_true] = ACTIONS(422),
    [sym_false] = ACTIONS(422),
    [sym_character_literal] = ACTIONS(420),
    [anon_sym_DQUOTE] = ACTIONS(422),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(420),
    [sym_null_literal] = ACTIONS(422),
    [anon_sym_LPAREN] = ACTIONS(420),
    [anon_sym_PLUS] = ACTIONS(422),
    [anon_sym_DASH] = ACTIONS(422),
    [anon_sym_final] = ACTIONS(422),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_PLUS_PLUS] = ACTIONS(420),
    [anon_sym_DASH_DASH] = ACTIONS(420),
    [anon_sym_new] = ACTIONS(422),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_switch] = ACTIONS(422),
    [anon_sym_LBRACE] = ACTIONS(420),
    [anon_sym_RBRACE] = ACTIONS(420),
    [anon_sym_case] = ACTIONS(422),
    [anon_sym_default] = ACTIONS(422),
    [anon_sym_SEMI] = ACTIONS(420),
    [anon_sym_assert] = ACTIONS(422),
    [anon_sym_do] = ACTIONS(422),
    [anon_sym_while] = ACTIONS(422),
    [anon_sym_break] = ACTIONS(422),
    [anon_sym_continue] = ACTIONS(422),
    [anon_sym_return] = ACTIONS(422),
    [anon_sym_yield] = ACTIONS(422),
    [anon_sym_synchronized] = ACTIONS(422),
    [anon_sym_throw] = ACTIONS(422),
    [anon_sym_try] = ACTIONS(422),
    [anon_sym_catch] = ACTIONS(422),
    [anon_sym_finally] = ACTIONS(422),
    [anon_sym_if] = ACTIONS(422),
    [anon_sym_else] = ACTIONS(422),
    [anon_sym_for] = ACTIONS(422),
    [anon_sym_AT] = ACTIONS(422),
    [anon_sym_open] = ACTIONS(422),
    [anon_sym_module] = ACTIONS(422),
    [anon_sym_static] = ACTIONS(422),
    [anon_sym_package] = ACTIONS(422),
    [anon_sym_import] = ACTIONS(422),
    [anon_sym_enum] = ACTIONS(422),
    [anon_sym_public] = ACTIONS(422),
    [anon_sym_protected] = ACTIONS(422),
    [anon_sym_private] = ACTIONS(422),
    [anon_sym_abstract] = ACTIONS(422),
    [anon_sym_strictfp] = ACTIONS(422),
    [anon_sym_native] = ACTIONS(422),
    [anon_sym_transient] = ACTIONS(422),
    [anon_sym_volatile] = ACTIONS(422),
    [anon_sym_sealed] = ACTIONS(422),
    [anon_sym_non_DASHsealed] = ACTIONS(420),
    [anon_sym_record] = ACTIONS(422),
    [anon_sym_ATinterface] = ACTIONS(420),
    [anon_sym_interface] = ACTIONS(422),
    [anon_sym_byte] = ACTIONS(422),
    [anon_sym_short] = ACTIONS(422),
    [anon_sym_int] = ACTIONS(422),
    [anon_sym_long] = ACTIONS(422),
    [anon_sym_char] = ACTIONS(422),
    [anon_sym_float] = ACTIONS(422),
    [anon_sym_double] = ACTIONS(422),
    [sym_boolean_type] = ACTIONS(422),
    [sym_void_type] = ACTIONS(422),
    [sym_this] = ACTIONS(422),
    [sym_super] = ACTIONS(422),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [131] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(652),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_SEMI] = ACTIONS(424),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [132] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(604),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(426),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [133] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(635),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_RBRACK] = ACTIONS(428),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [134] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(612),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(430),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [135] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(660),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_SEMI] = ACTIONS(432),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [136] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(611),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(434),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [137] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(646),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_SEMI] = ACTIONS(436),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [138] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(593),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(438),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [139] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(614),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [140] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(661),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_SEMI] = ACTIONS(442),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [141] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(580),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(444),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [142] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(571),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(446),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [143] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(649),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_SEMI] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [144] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(647),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_SEMI] = ACTIONS(450),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [145] = {
    [ts_builtin_sym_end] = ACTIONS(452),
    [sym_identifier] = ACTIONS(454),
    [sym_decimal_integer_literal] = ACTIONS(454),
    [sym_hex_integer_literal] = ACTIONS(454),
    [sym_octal_integer_literal] = ACTIONS(454),
    [sym_binary_integer_literal] = ACTIONS(452),
    [sym_decimal_floating_point_literal] = ACTIONS(452),
    [sym_hex_floating_point_literal] = ACTIONS(454),
    [sym_true] = ACTIONS(454),
    [sym_false] = ACTIONS(454),
    [sym_character_literal] = ACTIONS(452),
    [anon_sym_DQUOTE] = ACTIONS(454),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(452),
    [sym_null_literal] = ACTIONS(454),
    [anon_sym_LPAREN] = ACTIONS(452),
    [anon_sym_LT] = ACTIONS(452),
    [anon_sym_PLUS] = ACTIONS(454),
    [anon_sym_DASH] = ACTIONS(454),
    [anon_sym_final] = ACTIONS(454),
    [anon_sym_BANG] = ACTIONS(452),
    [anon_sym_TILDE] = ACTIONS(452),
    [anon_sym_PLUS_PLUS] = ACTIONS(452),
    [anon_sym_DASH_DASH] = ACTIONS(452),
    [anon_sym_new] = ACTIONS(454),
    [anon_sym_class] = ACTIONS(454),
    [anon_sym_switch] = ACTIONS(454),
    [anon_sym_LBRACE] = ACTIONS(452),
    [anon_sym_RBRACE] = ACTIONS(452),
    [anon_sym_case] = ACTIONS(454),
    [anon_sym_default] = ACTIONS(454),
    [anon_sym_SEMI] = ACTIONS(452),
    [anon_sym_assert] = ACTIONS(454),
    [anon_sym_do] = ACTIONS(454),
    [anon_sym_while] = ACTIONS(454),
    [anon_sym_break] = ACTIONS(454),
    [anon_sym_continue] = ACTIONS(454),
    [anon_sym_return] = ACTIONS(454),
    [anon_sym_yield] = ACTIONS(454),
    [anon_sym_synchronized] = ACTIONS(454),
    [anon_sym_throw] = ACTIONS(454),
    [anon_sym_try] = ACTIONS(454),
    [anon_sym_if] = ACTIONS(454),
    [anon_sym_else] = ACTIONS(454),
    [anon_sym_for] = ACTIONS(454),
    [anon_sym_AT] = ACTIONS(454),
    [anon_sym_open] = ACTIONS(454),
    [anon_sym_module] = ACTIONS(454),
    [anon_sym_static] = ACTIONS(454),
    [anon_sym_package] = ACTIONS(454),
    [anon_sym_import] = ACTIONS(454),
    [anon_sym_enum] = ACTIONS(454),
    [anon_sym_public] = ACTIONS(454),
    [anon_sym_protected] = ACTIONS(454),
    [anon_sym_private] = ACTIONS(454),
    [anon_sym_abstract] = ACTIONS(454),
    [anon_sym_strictfp] = ACTIONS(454),
    [anon_sym_native] = ACTIONS(454),
    [anon_sym_transient] = ACTIONS(454),
    [anon_sym_volatile] = ACTIONS(454),
    [anon_sym_sealed] = ACTIONS(454),
    [anon_sym_non_DASHsealed] = ACTIONS(452),
    [anon_sym_record] = ACTIONS(454),
    [anon_sym_ATinterface] = ACTIONS(452),
    [anon_sym_interface] = ACTIONS(454),
    [anon_sym_byte] = ACTIONS(454),
    [anon_sym_short] = ACTIONS(454),
    [anon_sym_int] = ACTIONS(454),
    [anon_sym_long] = ACTIONS(454),
    [anon_sym_char] = ACTIONS(454),
    [anon_sym_float] = ACTIONS(454),
    [anon_sym_double] = ACTIONS(454),
    [sym_boolean_type] = ACTIONS(454),
    [sym_void_type] = ACTIONS(454),
    [sym_this] = ACTIONS(454),
    [sym_super] = ACTIONS(454),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [146] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(545),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [147] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(546),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [148] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(633),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [149] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(659),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [150] = {
    [ts_builtin_sym_end] = ACTIONS(456),
    [sym_identifier] = ACTIONS(458),
    [sym_decimal_integer_literal] = ACTIONS(458),
    [sym_hex_integer_literal] = ACTIONS(458),
    [sym_octal_integer_literal] = ACTIONS(458),
    [sym_binary_integer_literal] = ACTIONS(456),
    [sym_decimal_floating_point_literal] = ACTIONS(456),
    [sym_hex_floating_point_literal] = ACTIONS(458),
    [sym_true] = ACTIONS(458),
    [sym_false] = ACTIONS(458),
    [sym_character_literal] = ACTIONS(456),
    [anon_sym_DQUOTE] = ACTIONS(458),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(456),
    [sym_null_literal] = ACTIONS(458),
    [anon_sym_LPAREN] = ACTIONS(456),
    [anon_sym_LT] = ACTIONS(456),
    [anon_sym_PLUS] = ACTIONS(458),
    [anon_sym_DASH] = ACTIONS(458),
    [anon_sym_final] = ACTIONS(458),
    [anon_sym_BANG] = ACTIONS(456),
    [anon_sym_TILDE] = ACTIONS(456),
    [anon_sym_PLUS_PLUS] = ACTIONS(456),
    [anon_sym_DASH_DASH] = ACTIONS(456),
    [anon_sym_new] = ACTIONS(458),
    [anon_sym_class] = ACTIONS(458),
    [anon_sym_switch] = ACTIONS(458),
    [anon_sym_LBRACE] = ACTIONS(456),
    [anon_sym_RBRACE] = ACTIONS(456),
    [anon_sym_case] = ACTIONS(458),
    [anon_sym_default] = ACTIONS(458),
    [anon_sym_SEMI] = ACTIONS(456),
    [anon_sym_assert] = ACTIONS(458),
    [anon_sym_do] = ACTIONS(458),
    [anon_sym_while] = ACTIONS(458),
    [anon_sym_break] = ACTIONS(458),
    [anon_sym_continue] = ACTIONS(458),
    [anon_sym_return] = ACTIONS(458),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_synchronized] = ACTIONS(458),
    [anon_sym_throw] = ACTIONS(458),
    [anon_sym_try] = ACTIONS(458),
    [anon_sym_if] = ACTIONS(458),
    [anon_sym_else] = ACTIONS(458),
    [anon_sym_for] = ACTIONS(458),
    [anon_sym_AT] = ACTIONS(458),
    [anon_sym_open] = ACTIONS(458),
    [anon_sym_module] = ACTIONS(458),
    [anon_sym_static] = ACTIONS(458),
    [anon_sym_package] = ACTIONS(458),
    [anon_sym_import] = ACTIONS(458),
    [anon_sym_enum] = ACTIONS(458),
    [anon_sym_public] = ACTIONS(458),
    [anon_sym_protected] = ACTIONS(458),
    [anon_sym_private] = ACTIONS(458),
    [anon_sym_abstract] = ACTIONS(458),
    [anon_sym_strictfp] = ACTIONS(458),
    [anon_sym_native] = ACTIONS(458),
    [anon_sym_transient] = ACTIONS(458),
    [anon_sym_volatile] = ACTIONS(458),
    [anon_sym_sealed] = ACTIONS(458),
    [anon_sym_non_DASHsealed] = ACTIONS(456),
    [anon_sym_record] = ACTIONS(458),
    [anon_sym_ATinterface] = ACTIONS(456),
    [anon_sym_interface] = ACTIONS(458),
    [anon_sym_byte] = ACTIONS(458),
    [anon_sym_short] = ACTIONS(458),
    [anon_sym_int] = ACTIONS(458),
    [anon_sym_long] = ACTIONS(458),
    [anon_sym_char] = ACTIONS(458),
    [anon_sym_float] = ACTIONS(458),
    [anon_sym_double] = ACTIONS(458),
    [sym_boolean_type] = ACTIONS(458),
    [sym_void_type] = ACTIONS(458),
    [sym_this] = ACTIONS(458),
    [sym_super] = ACTIONS(458),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [151] = {
    [ts_builtin_sym_end] = ACTIONS(460),
    [sym_identifier] = ACTIONS(462),
    [sym_decimal_integer_literal] = ACTIONS(462),
    [sym_hex_integer_literal] = ACTIONS(462),
    [sym_octal_integer_literal] = ACTIONS(462),
    [sym_binary_integer_literal] = ACTIONS(460),
    [sym_decimal_floating_point_literal] = ACTIONS(460),
    [sym_hex_floating_point_literal] = ACTIONS(462),
    [sym_true] = ACTIONS(462),
    [sym_false] = ACTIONS(462),
    [sym_character_literal] = ACTIONS(460),
    [anon_sym_DQUOTE] = ACTIONS(462),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(460),
    [sym_null_literal] = ACTIONS(462),
    [anon_sym_LPAREN] = ACTIONS(460),
    [anon_sym_LT] = ACTIONS(460),
    [anon_sym_PLUS] = ACTIONS(462),
    [anon_sym_DASH] = ACTIONS(462),
    [anon_sym_final] = ACTIONS(462),
    [anon_sym_BANG] = ACTIONS(460),
    [anon_sym_TILDE] = ACTIONS(460),
    [anon_sym_PLUS_PLUS] = ACTIONS(460),
    [anon_sym_DASH_DASH] = ACTIONS(460),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_class] = ACTIONS(462),
    [anon_sym_switch] = ACTIONS(462),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_RBRACE] = ACTIONS(460),
    [anon_sym_case] = ACTIONS(462),
    [anon_sym_default] = ACTIONS(462),
    [anon_sym_SEMI] = ACTIONS(460),
    [anon_sym_assert] = ACTIONS(462),
    [anon_sym_do] = ACTIONS(462),
    [anon_sym_while] = ACTIONS(462),
    [anon_sym_break] = ACTIONS(462),
    [anon_sym_continue] = ACTIONS(462),
    [anon_sym_return] = ACTIONS(462),
    [anon_sym_yield] = ACTIONS(462),
    [anon_sym_synchronized] = ACTIONS(462),
    [anon_sym_throw] = ACTIONS(462),
    [anon_sym_try] = ACTIONS(462),
    [anon_sym_if] = ACTIONS(462),
    [anon_sym_else] = ACTIONS(462),
    [anon_sym_for] = ACTIONS(462),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_open] = ACTIONS(462),
    [anon_sym_module] = ACTIONS(462),
    [anon_sym_static] = ACTIONS(462),
    [anon_sym_package] = ACTIONS(462),
    [anon_sym_import] = ACTIONS(462),
    [anon_sym_enum] = ACTIONS(462),
    [anon_sym_public] = ACTIONS(462),
    [anon_sym_protected] = ACTIONS(462),
    [anon_sym_private] = ACTIONS(462),
    [anon_sym_abstract] = ACTIONS(462),
    [anon_sym_strictfp] = ACTIONS(462),
    [anon_sym_native] = ACTIONS(462),
    [anon_sym_transient] = ACTIONS(462),
    [anon_sym_volatile] = ACTIONS(462),
    [anon_sym_sealed] = ACTIONS(462),
    [anon_sym_non_DASHsealed] = ACTIONS(460),
    [anon_sym_record] = ACTIONS(462),
    [anon_sym_ATinterface] = ACTIONS(460),
    [anon_sym_interface] = ACTIONS(462),
    [anon_sym_byte] = ACTIONS(462),
    [anon_sym_short] = ACTIONS(462),
    [anon_sym_int] = ACTIONS(462),
    [anon_sym_long] = ACTIONS(462),
    [anon_sym_char] = ACTIONS(462),
    [anon_sym_float] = ACTIONS(462),
    [anon_sym_double] = ACTIONS(462),
    [sym_boolean_type] = ACTIONS(462),
    [sym_void_type] = ACTIONS(462),
    [sym_this] = ACTIONS(462),
    [sym_super] = ACTIONS(462),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [152] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(634),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [153] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(553),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [154] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(631),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [155] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(541),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [156] = {
    [ts_builtin_sym_end] = ACTIONS(464),
    [sym_identifier] = ACTIONS(466),
    [sym_decimal_integer_literal] = ACTIONS(466),
    [sym_hex_integer_literal] = ACTIONS(466),
    [sym_octal_integer_literal] = ACTIONS(466),
    [sym_binary_integer_literal] = ACTIONS(464),
    [sym_decimal_floating_point_literal] = ACTIONS(464),
    [sym_hex_floating_point_literal] = ACTIONS(466),
    [sym_true] = ACTIONS(466),
    [sym_false] = ACTIONS(466),
    [sym_character_literal] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(466),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(464),
    [sym_null_literal] = ACTIONS(466),
    [anon_sym_LPAREN] = ACTIONS(464),
    [anon_sym_LT] = ACTIONS(464),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_DASH] = ACTIONS(466),
    [anon_sym_final] = ACTIONS(466),
    [anon_sym_BANG] = ACTIONS(464),
    [anon_sym_TILDE] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(464),
    [anon_sym_DASH_DASH] = ACTIONS(464),
    [anon_sym_new] = ACTIONS(466),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_switch] = ACTIONS(466),
    [anon_sym_LBRACE] = ACTIONS(464),
    [anon_sym_RBRACE] = ACTIONS(464),
    [anon_sym_case] = ACTIONS(466),
    [anon_sym_default] = ACTIONS(466),
    [anon_sym_SEMI] = ACTIONS(464),
    [anon_sym_assert] = ACTIONS(466),
    [anon_sym_do] = ACTIONS(466),
    [anon_sym_while] = ACTIONS(466),
    [anon_sym_break] = ACTIONS(466),
    [anon_sym_continue] = ACTIONS(466),
    [anon_sym_return] = ACTIONS(466),
    [anon_sym_yield] = ACTIONS(466),
    [anon_sym_synchronized] = ACTIONS(466),
    [anon_sym_throw] = ACTIONS(466),
    [anon_sym_try] = ACTIONS(466),
    [anon_sym_if] = ACTIONS(466),
    [anon_sym_else] = ACTIONS(466),
    [anon_sym_for] = ACTIONS(466),
    [anon_sym_AT] = ACTIONS(466),
    [anon_sym_open] = ACTIONS(466),
    [anon_sym_module] = ACTIONS(466),
    [anon_sym_static] = ACTIONS(466),
    [anon_sym_package] = ACTIONS(466),
    [anon_sym_import] = ACTIONS(466),
    [anon_sym_enum] = ACTIONS(466),
    [anon_sym_public] = ACTIONS(466),
    [anon_sym_protected] = ACTIONS(466),
    [anon_sym_private] = ACTIONS(466),
    [anon_sym_abstract] = ACTIONS(466),
    [anon_sym_strictfp] = ACTIONS(466),
    [anon_sym_native] = ACTIONS(466),
    [anon_sym_transient] = ACTIONS(466),
    [anon_sym_volatile] = ACTIONS(466),
    [anon_sym_sealed] = ACTIONS(466),
    [anon_sym_non_DASHsealed] = ACTIONS(464),
    [anon_sym_record] = ACTIONS(466),
    [anon_sym_ATinterface] = ACTIONS(464),
    [anon_sym_interface] = ACTIONS(466),
    [anon_sym_byte] = ACTIONS(466),
    [anon_sym_short] = ACTIONS(466),
    [anon_sym_int] = ACTIONS(466),
    [anon_sym_long] = ACTIONS(466),
    [anon_sym_char] = ACTIONS(466),
    [anon_sym_float] = ACTIONS(466),
    [anon_sym_double] = ACTIONS(466),
    [sym_boolean_type] = ACTIONS(466),
    [sym_void_type] = ACTIONS(466),
    [sym_this] = ACTIONS(466),
    [sym_super] = ACTIONS(466),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [157] = {
    [sym__literal] = STATE(507),
    [sym_string_literal] = STATE(510),
    [sym__string_literal] = STATE(498),
    [sym__multiline_string_literal] = STATE(498),
    [sym_expression] = STATE(556),
    [sym_cast_expression] = STATE(524),
    [sym_assignment_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_instanceof_expression] = STATE(524),
    [sym_lambda_expression] = STATE(524),
    [sym_inferred_parameters] = STATE(1259),
    [sym_ternary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_primary_expression] = STATE(470),
    [sym_array_creation_expression] = STATE(507),
    [sym_parenthesized_expression] = STATE(507),
    [sym_class_literal] = STATE(507),
    [sym_object_creation_expression] = STATE(507),
    [sym__unqualified_object_creation_expression] = STATE(483),
    [sym_field_access] = STATE(384),
    [sym_array_access] = STATE(384),
    [sym_method_invocation] = STATE(507),
    [sym_method_reference] = STATE(507),
    [sym_switch_expression] = STATE(524),
    [sym__annotation] = STATE(683),
    [sym_marker_annotation] = STATE(683),
    [sym_annotation] = STATE(683),
    [sym__type] = STATE(1266),
    [sym__unannotated_type] = STATE(795),
    [sym_annotated_type] = STATE(797),
    [sym_scoped_type_identifier] = STATE(745),
    [sym_generic_type] = STATE(771),
    [sym_array_type] = STATE(702),
    [sym_integral_type] = STATE(702),
    [sym_floating_point_type] = STATE(702),
    [sym_formal_parameters] = STATE(1259),
    [aux_sym_array_creation_expression_repeat1] = STATE(683),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_new] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(305),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(305),
    [anon_sym_byte] = ACTIONS(81),
    [anon_sym_short] = ACTIONS(81),
    [anon_sym_int] = ACTIONS(81),
    [anon_sym_long] = ACTIONS(81),
    [anon_sym_char] = ACTIONS(81),
    [anon_sym_float] = ACTIONS(83),
    [anon_sym_double] = ACTIONS(83),
    [sym_boolean_type] = ACTIONS(85),
    [sym_void_type] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(89),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [158] = {
    [ts_builtin_sym_end] = ACTIONS(468),
    [sym_identifier] = ACTIONS(470),
    [sym_decimal_integer_literal] = ACTIONS(470),
    [sym_hex_integer_literal] = ACTIONS(470),
    [sym_octal_integer_literal] = ACTIONS(470),
    [sym_binary_integer_literal] = ACTIONS(468),
    [sym_decimal_floating_point_literal] = ACTIONS(468),
    [sym_hex_floating_point_literal] = ACTIONS(470),
    [sym_true] = ACTIONS(470),
    [sym_false] = ACTIONS(470),
    [sym_character_literal] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(470),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(468),
    [sym_null_literal] = ACTIONS(470),
    [anon_sym_LPAREN] = ACTIONS(468),
    [anon_sym_LT] = ACTIONS(468),
    [anon_sym_PLUS] = ACTIONS(470),
    [anon_sym_DASH] = ACTIONS(470),
    [anon_sym_final] = ACTIONS(470),
    [anon_sym_BANG] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(468),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_new] = ACTIONS(470),
    [anon_sym_class] = ACTIONS(470),
    [anon_sym_switch] = ACTIONS(470),
    [anon_sym_LBRACE] = ACTIONS(468),
    [anon_sym_RBRACE] = ACTIONS(468),
    [anon_sym_case] = ACTIONS(470),
    [anon_sym_default] = ACTIONS(470),
    [anon_sym_SEMI] = ACTIONS(468),
    [anon_sym_assert] = ACTIONS(470),
    [anon_sym_do] = ACTIONS(470),
    [anon_sym_while] = ACTIONS(470),
    [anon_sym_break] = ACTIONS(470),
    [anon_sym_continue] = ACTIONS(470),
    [anon_sym_return] = ACTIONS(470),
    [anon_sym_yield] = ACTIONS(470),
    [anon_sym_synchronized] = ACTIONS(470),
    [anon_sym_throw] = ACTIONS(470),
    [anon_sym_try] = ACTIONS(470),
    [anon_sym_if] = ACTIONS(470),
    [anon_sym_else] = ACTIONS(470),
    [anon_sym_for] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(470),
    [anon_sym_open] = ACTIONS(470),
    [anon_sym_module] = ACTIONS(470),
    [anon_sym_static] = ACTIONS(470),
    [anon_sym_package] = ACTIONS(470),
    [anon_sym_import] = ACTIONS(470),
    [anon_sym_enum] = ACTIONS(470),
    [anon_sym_public] = ACTIONS(470),
    [anon_sym_protected] = ACTIONS(470),
    [anon_sym_private] = ACTIONS(470),
    [anon_sym_abstract] = ACTIONS(470),
    [anon_sym_strictfp] = ACTIONS(470),
    [anon_sym_native] = ACTIONS(470),
    [anon_sym_transient] = ACTIONS(470),
    [anon_sym_volatile] = ACTIONS(470),
    [anon_sym_sealed] = ACTIONS(470),
    [anon_sym_non_DASHsealed] = ACTIONS(468),
    [anon_sym_record] = ACTIONS(470),
    [anon_sym_ATinterface] = ACTIONS(468),
    [anon_sym_interface] = ACTIONS(470),
    [anon_sym_byte] = ACTIONS(470),
    [anon_sym_short] = ACTIONS(470),
    [anon_sym_int] = ACTIONS(470),
    [anon_sym_long] = ACTIONS(470),
    [anon_sym_char] = ACTIONS(470),
    [anon_sym_float] = ACTIONS(470),
    [anon_sym_double] = ACTIONS(470),
    [sym_boolean_type] = ACTIONS(470),
    [sym_void_type] = ACTIONS(470),
    [sym_this] = ACTIONS(470),
    [sym_super] = ACTIONS(470),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [159] = {
    [ts_builtin_sym_end] = ACTIONS(472),
    [sym_identifier] = ACTIONS(474),
    [sym_decimal_integer_literal] = ACTIONS(474),
    [sym_hex_integer_literal] = ACTIONS(474),
    [sym_octal_integer_literal] =