---
title: "Run detekt using Command Line Interface"
keywords: cli
sidebar: 
permalink: cli.html
folder: gettingstarted
summary:
---

## Install the cli

There are different ways to install the Command Line Interface (CLI):

### MacOS, with [Homebrew](https://brew.sh/):
```sh
brew install detekt
detekt [options]
```

### Any OS:
```sh
curl -sSLO https://github.com/detekt/detekt/releases/download/v{{ site.detekt_version }}/detekt-cli-{{ site.detekt_version }}.zip
unzip detekt-cli-{{ site.detekt_version }}.zip
./detekt-cli-{{ site.detekt_version }}/bin/detekt-cli --help
```

## Use the cli

detekt will exit with one of the following exit codes:

| Exit code | Description                                                                    |
|-----------|--------------------------------------------------------------------------------|
| 0         | detekt ran normally and maxIssues count was not reached in BuildFailureReport. |
| 1         | An unexpected error occurred                                                   |
| 2         | MaxIssues count was reached in BuildFailureReport.                             |
| 3         | Invalid detekt configuration file detected.                                    |

The following parameters are shown when `--help` is entered.

{% include_relative cli-options.md %}

