/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Conversions;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.Value;
import java.sql.SQLException;

public class ValueBoolean
extends Value {
    boolean value;

    public ValueBoolean() {
    }

    public ValueBoolean(boolean value) {
        this.value = value;
    }

    public ValueBoolean(Object value) {
        this.value = value instanceof Boolean ? (Boolean)value : (value instanceof Number ? (((Number)value).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE) : Boolean.parseBoolean(value.toString()));
    }

    @Override
    int getType() {
        return 22;
    }

    @Override
    void encodeValue(EncodedDataStream dataStream) throws SQLException {
        dataStream.encodeBoolean(this.value);
    }

    @Override
    String getString() {
        return Boolean.toString(this.value);
    }

    @Override
    boolean getBoolean() {
        return this.value;
    }

    @Override
    Object getObject() {
        return this.value;
    }

    @Override
    public byte[] getBytes() {
        return Conversions.toBytes(this.value);
    }

    @Override
    byte getByte() {
        return (byte)(this.value ? 1 : 0);
    }

    @Override
    short getShort() {
        return this.getByte();
    }

    @Override
    int getInt() {
        return this.getByte();
    }

    @Override
    long getLong() {
        return this.getByte();
    }

    @Override
    float getFloat() {
        return this.getByte();
    }

    @Override
    double getDouble() {
        return this.getByte();
    }
}

