/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.NuoDBXAException;
import com.nuodb.jdbc.NuoXid;
import com.nuodb.jdbc.RemConnection;
import com.nuodb.jdbc.RemXAConnection;
import com.nuodb.jdbc.SQLState;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class RemXAResource
implements XAResource {
    private RemXAConnection xaConnection;
    private Xid uniqueTransactionIdentifier;

    public RemXAResource(RemXAConnection xaConn) {
        this.xaConnection = xaConn;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            NuoXid nXid = this.xaConnection.findRecoverXid(xid);
            RemConnection connection = this.xaConnection.getExistingConnection();
            this.checkConnection(connection);
            if (connection.getXaTransState() != 0x4000000 && connection.getXaTransState() != 0) {
                throw new NuoDBXAException(-3, "Invalid state while trying to commit: transaction state: " + connection.getXaTransState());
            }
            if (nXid != null) {
                connection.recoverByCommit(nXid.getNuodbTransId());
            } else {
                if (this.uniqueTransactionIdentifier != xid) {
                    throw new NuoDBXAException(-4, String.format("Xid (%s) is not associated with this connection", xid.toString()));
                }
                connection.commit();
            }
            connection.setInGlobalTx(false);
            this.uniqueTransactionIdentifier = null;
        }
        catch (SQLException exception) {
            throw new NuoDBXAException(-3, exception.getMessage());
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        NuoXid[] xids = (NuoXid[])this.recover(0);
        for (int i = 0; i < xids.length; ++i) {
            if (!xids[i].equals(xid).booleanValue()) continue;
            this.rollback(xids[i]);
            break;
        }
        if (this.uniqueTransactionIdentifier == xid) {
            this.uniqueTransactionIdentifier = null;
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (this.uniqueTransactionIdentifier != xid) {
            throw new NuoDBXAException(-4, String.format("Xid (%s) is not associated with this connection", xid.toString()));
        }
        RemConnection connection = this.xaConnection.getExistingConnection();
        this.checkConnection(connection);
        if (connection.getXaTransState() == flags) {
            return;
        }
        switch (flags) {
            case 0x20000000: {
                this.rollback(xid);
                connection.setXaTransState(0x20000000);
                return;
            }
            case 0x4000000: {
                if (connection.getXaTransState() != 0) {
                    throw new NuoDBXAException(-3, "Invalid state while setting to success: transaction state: " + connection.getXaTransState());
                }
                connection.setXaTransState(0x4000000);
                return;
            }
            case 0x2000000: {
                connection.setXaTransState(0x2000000);
                return;
            }
        }
        throw new NuoDBXAException(-3, String.format("Unknown flags found on XA end call, flags: %d", flags));
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        return xares == this;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        int returnCode;
        if (this.uniqueTransactionIdentifier != xid) {
            throw new NuoDBXAException(-4, String.format("Xid (%s) is not associated with this connection", xid.toString()));
        }
        try {
            RemConnection connection = this.xaConnection.getExistingConnection();
            this.checkConnection(connection);
            if (connection.getXaTransState() != 0x4000000) {
                throw new NuoDBXAException(-3, "Invalid state while trying to prepare: transaction state: " + connection.getXaTransState());
            }
            NuoXid nXid = new NuoXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
            returnCode = connection.prepare(nXid);
            if (returnCode == 3) {
                connection.setInGlobalTx(false);
                this.uniqueTransactionIdentifier = null;
            }
        }
        catch (SQLException exception) {
            if (exception.getSQLState().equals(SQLState.getState(SQLState.XAER_PROTO))) {
                throw new NuoDBXAException(-6, exception.getMessage());
            }
            throw new NuoDBXAException(-3, exception.getMessage());
        }
        return returnCode;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        Xid[] nXids = null;
        try {
            RemConnection connection = this.xaConnection.getConnection();
            nXids = connection.recover();
        }
        catch (SQLException exception) {
            throw new NuoDBXAException(-3, exception.getMessage());
        }
        if (nXids.length > 0) {
            for (int i = 0; i < nXids.length; ++i) {
                this.xaConnection.saveRecoverXid((NuoXid)nXids[i]);
            }
        }
        return nXids;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            NuoXid nXid = this.xaConnection.findRecoverXid(xid);
            RemConnection connection = this.xaConnection.getExistingConnection();
            this.checkConnection(connection);
            if (nXid != null) {
                connection.recoverByRollback(nXid.getNuodbTransId());
            } else if (this.uniqueTransactionIdentifier == null) {
                connection.rollback();
            } else {
                if (this.uniqueTransactionIdentifier != xid) {
                    throw new NuoDBXAException(-4, String.format("Xid (%s) is not associated with this connection", xid.toString()));
                }
                connection.recoverByRollback(0L);
            }
            connection.setInGlobalTx(false);
            this.uniqueTransactionIdentifier = null;
        }
        catch (SQLException exception) {
            throw new NuoDBXAException(-3, exception.getMessage());
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.uniqueTransactionIdentifier == null) {
            this.uniqueTransactionIdentifier = xid;
        } else {
            if (this.uniqueTransactionIdentifier != xid) {
                throw new NuoDBXAException(-4, "NuoDB does not support multiple Xids on a single connection");
            }
            if (flags == 0) {
                throw new NuoDBXAException(-8, "Xid is already started.");
            }
        }
        try {
            RemConnection connection = this.xaConnection.getConnection();
            switch (flags) {
                case 0x8000000: {
                    if (connection.getXaTransState() != 0x2000000) {
                        throw new NuoDBXAException(-3, "Can not resume an XA connection that is not suspended.");
                    }
                    connection.setAutoCommit(false);
                    connection.setInGlobalTx(true);
                    connection.setXaTransState(0);
                    return;
                }
                case 0x200000: {
                    if (connection.getXaTransState() == 0x2000000) {
                        throw new NuoDBXAException(-3, "Can not join a suspended transaction.");
                    }
                    connection.setAutoCommit(false);
                    connection.setInGlobalTx(true);
                    connection.setXaTransState(0);
                    return;
                }
                case 0: {
                    connection.setAutoCommit(false);
                    connection.setInGlobalTx(true);
                    connection.setXaTransState(0);
                    return;
                }
            }
            throw new NuoDBXAException(-3, String.format("Unknown flags found on XA start call, flags: %d", flags));
        }
        catch (SQLException exception) {
            throw new NuoDBXAException(-3, exception.getMessage());
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    private void checkConnection(RemConnection connection) throws XAException {
        if (connection == null) {
            throw new NuoDBXAException(-3, "XA connection was not created");
        }
        try {
            if (connection.isClosed()) {
                throw new NuoDBXAException(-3, "XA connection is closed");
            }
        }
        catch (SQLException exception) {
            throw new NuoDBXAException(-3, exception.getMessage());
        }
    }

    private void closeConnection(RemConnection connection) {
        try {
            if (!connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

