/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.impl.util.ByteUtils;
import com.nuodb.impl.util.StreamUtils;
import com.nuodb.impl.util.StringUtils;
import com.nuodb.jdbc.Blob;
import com.nuodb.jdbc.Clob;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.RemConnection;
import com.nuodb.jdbc.RemEncodedStream;
import com.nuodb.jdbc.RemResultSetMetaData;
import com.nuodb.jdbc.RemStatement;
import com.nuodb.jdbc.SQLState;
import com.nuodb.jdbc.SQLStateException;
import com.nuodb.jdbc.Utils;
import com.nuodb.jdbc.Value;
import com.nuodb.jdbc.ValueArray;
import com.nuodb.jdbc.ValueBlob;
import com.nuodb.jdbc.ValueBoolean;
import com.nuodb.jdbc.ValueByte;
import com.nuodb.jdbc.ValueBytes;
import com.nuodb.jdbc.ValueClob;
import com.nuodb.jdbc.ValueDate;
import com.nuodb.jdbc.ValueDouble;
import com.nuodb.jdbc.ValueInt;
import com.nuodb.jdbc.ValueLong;
import com.nuodb.jdbc.ValueNull;
import com.nuodb.jdbc.ValueNumber;
import com.nuodb.jdbc.ValueShort;
import com.nuodb.jdbc.ValueString;
import com.nuodb.jdbc.ValueTime;
import com.nuodb.jdbc.ValueTimestamp;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;

public class RemPreparedStatement
extends RemStatement
implements PreparedStatement {
    int numberParameters;
    int batchCount;
    boolean generatingKeys;
    Value[] parameters;
    EncodedDataStream batchMessage;
    String[] columnNames;
    RemResultSetMetaData metaData;

    RemPreparedStatement(RemConnection connect, int statementHandle, int count, boolean genKeys) {
        super(connect, statementHandle);
        this.numberParameters = count;
        this.parameters = new Value[this.numberParameters];
        this.generatingKeys = genKeys;
        this.metaData = null;
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.batchMessage == null) {
            this.checkOpen();
            this.batchCount = 0;
            this.batchMessage = new RemEncodedStream(this.connection.protocolVersion);
            this.batchMessage.startMessage(84);
            this.encodeLastTxnIds(this.batchMessage);
            this.batchMessage.encodeInt(this.handle);
        }
        this.putParameters(this.batchMessage);
        ++this.batchCount;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchCount = 0;
        this.batchMessage = null;
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameters = new Value[this.numberParameters];
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public ResultSet executeQuery(String arg0) throws SQLException {
        throw new SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkOpen();
        this.lastResultSet = null;
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(22);
        this.encodeLastTxnIds(dataStream);
        dataStream.encodeInt(this.handle);
        this.putParameters(dataStream);
        this.connection.sendAndReceive(dataStream);
        boolean ret = dataStream.getInt() != 0;
        this.updateRecordsUpdated(dataStream);
        this.updateLastCommitInfo(dataStream, this.generatingKeys);
        return ret;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(23);
        this.encodeLastTxnIds(dataStream);
        dataStream.encodeInt(this.handle);
        this.putParameters(dataStream);
        boolean readColumnNames = true;
        if (this.columnNames != null) {
            dataStream.encodeInt(1);
            readColumnNames = false;
        } else {
            dataStream.encodeInt(0);
        }
        this.connection.sendAndReceive(dataStream);
        this.lastResultSet = this.createResultSet(dataStream, readColumnNames);
        this.columnNames = this.lastResultSet.getColumnNames();
        return this.lastResultSet;
    }

    public String analyzeStatement(int mask) throws SQLException {
        this.checkOpen();
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(71);
        dataStream.encodeInt(this.handle);
        dataStream.encodeInt(mask);
        this.connection.sendAndReceive(dataStream);
        return dataStream.getString();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkOpen();
        this.lastResultSet = null;
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(24);
        this.encodeLastTxnIds(dataStream);
        dataStream.encodeInt(this.handle);
        this.putParameters(dataStream);
        this.connection.sendAndReceive(dataStream);
        this.updateRecordsUpdated(dataStream);
        this.updateLastCommitInfo(dataStream, this.generatingKeys);
        return this.updateCount;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        int[] batchResults = new int[Math.max(1, this.batchCount)];
        if (this.batchMessage == null) {
            return batchResults;
        }
        this.generatedKeys = null;
        this.batchMessage.encodeInt(-1);
        this.batchMessage.encodeInt(this.batchCount);
        this.connection.sendAndReceive(this.batchMessage);
        String batchUpdateMessage = null;
        SQLState batchUpdateState = null;
        SQLException batchUpdateException = null;
        for (int n = 0; n < this.batchCount; ++n) {
            batchResults[n] = this.batchMessage.getInt();
            if (batchResults[n] != -3) continue;
            int stateCode = this.batchMessage.getInt();
            SQLState state = SQLState.getSQLState(stateCode);
            String message = this.batchMessage.getString();
            SQLException exception = SQLStateException.fromStateClass(state.getStateClass()).create(message, state.getState(), stateCode);
            if (batchUpdateException == null) {
                batchUpdateMessage = message;
                batchUpdateState = state;
                batchUpdateException = exception;
                continue;
            }
            batchUpdateException.setNextException(exception);
        }
        this.updateLastCommitInfo(this.batchMessage, this.generatingKeys);
        this.batchMessage = null;
        if (batchUpdateException != null) {
            BatchUpdateException exception = new BatchUpdateException(batchUpdateMessage, batchUpdateState.getState(), batchUpdateState.getCode(), batchResults);
            exception.setNextException(batchUpdateException);
            throw exception;
        }
        return batchResults;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        if (this.lastResultSet != null) {
            return this.lastResultSet.getMetaData();
        }
        return this.metaData;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.setValue(parameterIndex, new ValueArray(x));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setCharacterStream(parameterIndex, (Reader)(x == null ? null : new InputStreamReader(x)), Integer.MAX_VALUE);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, (Reader)(x == null ? null : new InputStreamReader(x)), length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, (Reader)(x == null ? null : new InputStreamReader(x)), length);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setValue(parameterIndex, new ValueNumber(x));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, Integer.MAX_VALUE);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.setBytes(parameterIndex, x == null ? null : ByteUtils.drainStream(x, 512, length));
        }
        catch (IOException e) {
            throw new SQLException("on parameter: " + parameterIndex, e);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        Clob.checkLongValue(length, "parameter: " + parameterIndex);
        try {
            this.setBytes(parameterIndex, x == null ? null : ByteUtils.drainStream(x, 512, (int)length));
        }
        catch (IOException e) {
            throw new SQLException("on parameter: " + parameterIndex, e);
        }
    }

    @Override
    public void setBlob(int parameterIndex, java.sql.Blob x) throws SQLException {
        this.setValue(parameterIndex, x == null ? new ValueNull() : new ValueBlob(x));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBlob(parameterIndex, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SQLException(MessageFormat.format("length {0} is greater than max supported value of {1}", length, Integer.MAX_VALUE));
        }
        try {
            Blob b = this.connection.createBlob();
            b.setBytes(1L, ByteUtils.drainStream(inputStream, 1024, (int)length));
            this.setBlob(parameterIndex, b);
        }
        catch (IOException e) {
            throw new SQLException("on parameter: " + parameterIndex, e);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setValue(parameterIndex, new ValueBoolean(x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setValue(parameterIndex, new ValueByte(x));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setValue(parameterIndex, new ValueBytes(x));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, Integer.MAX_VALUE);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            this.setString(parameterIndex, reader == null ? null : StringUtils.drainStream(reader, length).toString());
        }
        catch (IOException e) {
            throw new SQLException("on parameter: " + parameterIndex, e);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        Clob.checkLongValue(length, "parameter: " + parameterIndex);
        try {
            this.setString(parameterIndex, reader == null ? null : StringUtils.drainStream(reader, (int)length).toString());
        }
        catch (IOException e) {
            throw new SQLException("on parameter: " + parameterIndex, e);
        }
    }

    @Override
    public void setClob(int parameterIndex, java.sql.Clob x) throws SQLException {
        this.setValue(parameterIndex, x == null ? new ValueNull() : new ValueClob(x));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        Clob clob = this.connection.createClob();
        try {
            clob.setString(1L, StreamUtils.drain(reader));
        }
        catch (IOException e) {
            throw new SQLException("Reader problem for parameter: " + parameterIndex, e);
        }
        this.setClob(parameterIndex, clob);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        Clob clob = this.connection.createClob();
        try {
            clob.setString(1L, StreamUtils.drain(reader, length));
        }
        catch (IOException e) {
            throw new SQLException("Reader problem for parameter: " + parameterIndex, e);
        }
        this.setClob(parameterIndex, clob);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setValue(parameterIndex, new ValueDate(x));
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setDate(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setValue(parameterIndex, new ValueDouble(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setValue(parameterIndex, new ValueDouble(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setValue(parameterIndex, new ValueInt(x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setValue(parameterIndex, new ValueLong(x));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setValue(parameterIndex, new ValueNull());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setObject(parameterIndex, x, 0);
        } else if (x instanceof String) {
            this.setObject(parameterIndex, x, 12);
        } else if (x instanceof Integer) {
            this.setObject(parameterIndex, x, 4);
        } else if (x instanceof Long) {
            this.setObject(parameterIndex, x, -5);
        } else if (x instanceof BigDecimal) {
            this.setObject(parameterIndex, x, 2);
        } else if (x instanceof Boolean) {
            this.setObject(parameterIndex, x, 16);
        } else if (x instanceof Byte) {
            this.setObject(parameterIndex, x, -6);
        } else if (x instanceof Short) {
            this.setObject(parameterIndex, x, 5);
        } else if (x instanceof Float) {
            this.setObject(parameterIndex, x, 7);
        } else if (x instanceof Double) {
            this.setObject(parameterIndex, x, 8);
        } else if (x instanceof byte[]) {
            this.setObject(parameterIndex, x, -2);
        } else if (x instanceof Date) {
            this.setObject(parameterIndex, x, 91);
        } else if (x instanceof Time) {
            this.setObject(parameterIndex, x, 92);
        } else if (x instanceof Timestamp) {
            this.setObject(parameterIndex, x, 93);
        } else if (x instanceof java.sql.Clob) {
            this.setObject(parameterIndex, x, 2005);
        } else if (x instanceof java.sql.Blob) {
            this.setObject(parameterIndex, x, 2004);
        } else if (x instanceof Array) {
            this.setObject(parameterIndex, x, 2003);
        } else if (x instanceof Struct) {
            this.setObject(parameterIndex, x, 2002);
        } else if (x instanceof Ref) {
            this.setObject(parameterIndex, x, 2006);
        } else if (x instanceof URL) {
            this.setObject(parameterIndex, x, 70);
        } else if (x instanceof Class) {
            this.setObject(parameterIndex, x, 2000);
        } else if (x instanceof RowId) {
            this.setObject(parameterIndex, x, -8);
        } else if (x instanceof NClob) {
            this.setObject(parameterIndex, x, 2011);
        } else if (x instanceof SQLXML) {
            this.setObject(parameterIndex, x, 2009);
        } else if (x instanceof Date) {
            this.setObject(parameterIndex, x, 91);
        } else {
            this.setObject(parameterIndex, x, 1111);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, null, null);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, scaleOrLength, Long.valueOf(scaleOrLength));
    }

    void setObject(int parameterIndex, Object x, int targetSqlType, Integer scale, Long length) throws SQLException {
        if (x == null) {
            targetSqlType = 0;
        }
        switch (targetSqlType) {
            case -5: {
                this.setValue(parameterIndex, new ValueLong(x));
                break;
            }
            case -3: 
            case -2: {
                this.setValue(parameterIndex, new ValueBytes(x));
                break;
            }
            case 2004: {
                this.setValue(parameterIndex, new ValueBlob((java.sql.Blob)x));
                break;
            }
            case 16: {
                this.setValue(parameterIndex, new ValueBoolean(x));
                break;
            }
            case 2005: {
                this.setValue(parameterIndex, new ValueClob((java.sql.Clob)x));
                break;
            }
            case 91: {
                this.setValue(parameterIndex, new ValueDate(x));
                break;
            }
            case 93: {
                this.setValue(parameterIndex, new ValueTimestamp(x));
                break;
            }
            case 92: {
                this.setValue(parameterIndex, new ValueTime(x));
                break;
            }
            case 2: 
            case 3: {
                this.setValue(parameterIndex, new ValueNumber(x, scale));
                break;
            }
            case 7: 
            case 8: {
                this.setValue(parameterIndex, new ValueDouble(x));
                break;
            }
            case 6: {
                this.setValue(parameterIndex, new ValueDouble(x));
                break;
            }
            case 4: {
                this.setValue(parameterIndex, new ValueInt(x));
                break;
            }
            case 5: {
                this.setValue(parameterIndex, new ValueShort(x));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setValue(parameterIndex, new ValueString(x));
                break;
            }
            case 0: {
                this.setValue(parameterIndex, new ValueNull());
                break;
            }
            default: {
                throw new SQLFeatureNotSupportedException(String.format("setObject() with type %d is not supported", targetSqlType));
            }
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setValue(parameterIndex, new ValueShort(x));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setValue(parameterIndex, new ValueString(x));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setValue(parameterIndex, new ValueTime(x));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setValue(parameterIndex, new ValueTimestamp(x));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Utils.notYetImplemented();
    }

    void setValue(int parameterIndex, Value value) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.numberParameters) {
            throw new SQLException("invalid parameter index (" + String.valueOf(parameterIndex) + ")");
        }
        this.parameters[parameterIndex - 1] = value;
    }

    void putParameters(EncodedDataStream dataStream) throws SQLException {
        dataStream.encodeInt(this.numberParameters);
        for (int n = 0; n < this.numberParameters; ++n) {
            if (this.parameters[n] == null) {
                dataStream.encodeNull();
                continue;
            }
            this.parameters[n].encodeValue(dataStream);
        }
    }
}

