/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import com.nuodb.impl.util.Env;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;

public class LoaderUtil {
    private static final String PLUGIN_PACKAGE_NAME = "com.nuodb.agent.plugin.";
    private static ClassLoader jarLoader = null;
    private static ClassLoader customLoader = null;

    public static void setCustomClassLoader(ClassLoader loader) {
        customLoader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T> T getInstance(String className, Class<T> interfaceType, Object ... params) {
        Constructor<?>[] constructors;
        Class<?> c = null;
        try {
            c = customLoader != null ? Class.forName(className, true, customLoader) : Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                c = Class.forName(PLUGIN_PACKAGE_NAME + className);
            }
            catch (ClassNotFoundException c2) {
                Class<LoaderUtil> clazz = LoaderUtil.class;
                // MONITORENTER : com.nuodb.impl.util.LoaderUtil.class
                if (jarLoader == null) {
                    jarLoader = LoaderUtil.setupJarLoader();
                }
                // MONITOREXIT : clazz
                try {
                    c = Class.forName(className, true, jarLoader);
                }
                catch (ClassNotFoundException c3) {
                    throw new IllegalArgumentException("Unknown class: " + className);
                }
            }
        }
        if (!interfaceType.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class is not of specified type");
        }
        Class[] classes = new Class[params.length];
        int i = 0;
        for (Object o : params) {
            classes[i++] = o.getClass();
        }
        Constructor<?>[] constructorArray = constructors = c.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            Class<?>[] types = constructor.getParameterTypes();
            if (types.length == classes.length) {
                boolean matches = true;
                for (i = 0; i < types.length; ++i) {
                    if (types[i].isAssignableFrom(classes[i])) continue;
                    matches = false;
                    break;
                }
                if (matches) {
                    try {
                        return interfaceType.cast(constructor.newInstance(params));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Cannot construct instance: " + e.getMessage(), e);
                    }
                }
            }
            ++n2;
        }
        throw new IllegalArgumentException("No valid constructor available");
    }

    private static ClassLoader setupJarLoader() {
        URL[] urls = new URL[]{};
        File parent = Env.getContainingDirectory(LoaderUtil.class).getParentFile();
        File pluginDir = new File(parent, "plugin");
        File agentPluginDir = new File(pluginDir, "agent");
        if (agentPluginDir.exists() && agentPluginDir.isDirectory() && agentPluginDir.canRead()) {
            HashSet<URL> jarSet = new HashSet<URL>();
            LoaderUtil.gatherURLs(agentPluginDir, jarSet);
            urls = jarSet.toArray(urls);
        }
        return URLClassLoader.newInstance(urls);
    }

    private static void gatherURLs(File dir, Set<URL> urls) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory() && file.canRead()) {
                LoaderUtil.gatherURLs(file, urls);
                continue;
            }
            if (!file.getName().endsWith(".jar") || !file.canRead()) continue;
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }
}

