/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import java.awt.Font;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;

public class DisplayResultSet {
    ResultSet resultSet;
    ResultSetMetaData metaData;
    ColumnData[] columnData;
    String[] headers;
    Vector<String[]> rows;
    int numberColumns;
    int dupSuppresionColumns;
    Font headerFont;
    Font detailFont;

    public DisplayResultSet(ResultSet rset, int dupSuppresionCols) throws SQLException {
        this.init(rset, dupSuppresionCols);
    }

    public DisplayResultSet(Font hdrFont, Font dtailFont, ResultSet rset, int dupSuppresionCols) throws SQLException {
        this.headerFont = hdrFont;
        this.detailFont = dtailFont;
        this.init(rset, dupSuppresionCols);
    }

    protected void init(ResultSet rset, int dupSuppresionCols) throws SQLException {
        this.resultSet = rset;
        this.dupSuppresionColumns = dupSuppresionCols;
        this.metaData = this.resultSet.getMetaData();
        this.numberColumns = this.metaData.getColumnCount();
        this.headers = new String[this.numberColumns];
        this.columnData = new ColumnData[this.numberColumns];
        this.rows = new Vector();
        for (int n = 0; n < this.numberColumns; ++n) {
            this.columnData[n] = new ColumnData();
            this.headers[n] = this.metaData.getColumnLabel(n + 1);
            int length = this.headers[n].length();
            this.columnData[n].headerWidth = length + 1;
            this.columnData[n].rightAdjust = this.rightAdjust(n);
        }
        this.getData();
    }

    public boolean rightAdjust(int column) throws SQLException {
        int type = this.metaData.getColumnType(column + 1);
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public void getData() throws SQLException {
        while (this.resultSet.next()) {
            String[] row = new String[this.numberColumns];
            this.rows.addElement(row);
            for (int n = 0; n < this.numberColumns; ++n) {
                String value = this.resultSet.getString(n + 1);
                if (value == null) {
                    value = "";
                }
                row[n] = value;
                int length = this.computeWidth(value);
                ColumnData data = this.columnData[n];
                data.dataWidth = Math.max(data.dataWidth, length);
                data.width = Math.max(data.dataWidth, data.headerWidth);
            }
        }
    }

    private int computeWidth(String value) {
        int max = 0;
        int start = 0;
        int position = 0;
        int length = value.length();
        while (position < length) {
            char c;
            if ((c = value.charAt(position++)) != '\n') continue;
            max = Math.max(max, position - start);
            start = position;
        }
        return Math.max(max, position - start);
    }

    public void display(PrintStream outputStream) throws IOException {
        String[] priorRow = null;
        for (String[] row : this.rows) {
            this.pad(0, ' ', outputStream);
            boolean skip = true;
            for (int column = 0; column < this.numberColumns; ++column) {
                ColumnData data = this.columnData[column];
                String string = row[column];
                if (skip && column < this.dupSuppresionColumns && priorRow != null && priorRow[column].equals(string)) {
                    this.pad(data.width + 1, ' ', outputStream);
                    continue;
                }
                skip = false;
                int length = string.length();
                int fill = (data.width - data.dataWidth) / 2;
                if (data.rightAdjust) {
                    fill += data.dataWidth - length;
                }
                this.pad(fill, ' ', outputStream);
                outputStream.print(string);
                this.pad(data.width - length - fill + 1, ' ', outputStream);
            }
            priorRow = row;
            outputStream.print('\n');
        }
    }

    public void display(StringBuffer outputStream) {
        String[] priorRow = null;
        int lineStart = 0;
        for (String[] row : this.rows) {
            this.pad(0, ' ', outputStream);
            boolean skip = true;
            for (int column = 0; column < this.numberColumns; ++column) {
                ColumnData data = this.columnData[column];
                String string = row[column];
                if (skip && column < this.dupSuppresionColumns && priorRow != null && priorRow[column].equals(string)) {
                    this.pad(data.width + 1, ' ', outputStream);
                    continue;
                }
                skip = false;
                int length = string.length();
                int fill = (data.width - data.dataWidth) / 2;
                if (data.rightAdjust) {
                    fill += data.dataWidth - length;
                }
                this.pad(fill, ' ', outputStream);
                if (string.indexOf(10) >= 0) {
                    int position = 0;
                    int start = 0;
                    char[] characters = string.toCharArray();
                    int indent = outputStream.length() - lineStart;
                    int len = string.length();
                    while (position < len) {
                        if (characters[position++] != '\n') continue;
                        outputStream.append(characters, start, position - start - 1);
                        outputStream.append('\n');
                        this.pad(indent, ' ', outputStream);
                        start = position;
                        lineStart = outputStream.length();
                    }
                    outputStream.append(characters, start, position - start - 1);
                } else {
                    outputStream.append(string);
                }
                this.pad(data.width - length - fill + 1, ' ', outputStream);
            }
            priorRow = row;
            outputStream.append('\n');
            lineStart = outputStream.length();
        }
    }

    public void displayHeader(PrintStream outputStream) throws IOException {
        int length;
        ColumnData data;
        int column;
        this.pad(1, ' ', outputStream);
        for (column = 0; column < this.numberColumns; ++column) {
            data = this.columnData[column];
            length = this.headers[column].length();
            int fill = data.width - length;
            int left = fill / 2;
            this.pad(left, ' ', outputStream);
            outputStream.print(this.headers[column]);
            this.pad(fill - left + 1, ' ', outputStream);
        }
        outputStream.print('\n');
        for (column = 0; column < this.numberColumns; ++column) {
            data = this.columnData[column];
            length = this.headers[column].length();
            this.pad(data.width, '-', outputStream);
            this.pad(1, ' ', outputStream);
        }
        outputStream.print('\n');
    }

    public void displayHeader(StringBuffer outputStream) {
        int length;
        ColumnData data;
        int column;
        this.pad(1, ' ', outputStream);
        for (column = 0; column < this.numberColumns; ++column) {
            data = this.columnData[column];
            length = this.headers[column].length();
            int fill = data.width - length;
            int left = fill / 2;
            this.pad(left, ' ', outputStream);
            outputStream.append(this.headers[column]);
            this.pad(fill - left + 1, ' ', outputStream);
        }
        outputStream.append('\n');
        for (column = 0; column < this.numberColumns; ++column) {
            data = this.columnData[column];
            length = this.headers[column].length();
            this.pad(data.width, '-', outputStream);
            this.pad(1, ' ', outputStream);
        }
        outputStream.append('\n');
    }

    protected void pad(int count, char c, PrintStream outputStream) throws IOException {
        for (int n = 0; n < count; ++n) {
            outputStream.print(c);
        }
    }

    protected void pad(int count, char c, StringBuffer outputStream) {
        for (int n = 0; n < count; ++n) {
            outputStream.append(c);
        }
    }

    class ColumnData {
        int headerWidth;
        int headerLines;
        int dataWidth;
        int width;
        boolean rightAdjust;

        ColumnData() {
        }
    }
}

