/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import com.nuodb.impl.net.CryptoInputStream;
import com.nuodb.impl.net.CryptoOutputStream;
import com.nuodb.impl.util.LengthUnit;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;

public class DataStream
implements Iterable<Segment> {
    private static final ThreadLocal<CharsetEncoder> encoder;
    public int totalLength;
    protected DataSegment firstSegment;
    protected DataSegment currentSegment;
    protected int available;
    protected ByteBuffer capturedString;
    protected int capturedLength;
    protected int[] codePoints;
    protected byte[] byteRemaining;
    static char[] base64Digits;
    static char[] base64Lookup;
    static final int DEFAULT_SEGMENT_SIZE = 1024;
    public static final int DEFAULT_STRING_SIZE = 512;
    static final byte[] utf8Flags;
    static final char[] utf8Lengths;
    static final char[] utf8Values;

    public void reset() {
        this.totalLength = 0;
        if (this.firstSegment != null) {
            this.firstSegment.reset();
            this.currentSegment = this.firstSegment;
        }
        this.available = this.firstSegment == null || this.firstSegment.buffer == null ? 0 : this.firstSegment.buffer.length;
    }

    public final void write(byte[] b, int offset, int length) {
        int off = offset;
        int len = length;
        while (len > 0) {
            if (this.available == 0) {
                this.extend(len);
            }
            int l = Math.min(this.available, len);
            System.arraycopy(b, off, this.currentSegment.buffer, this.currentSegment.length, l);
            this.currentSegment.length += l;
            off += l;
            len -= l;
            this.totalLength += l;
            this.available -= l;
        }
    }

    public final void write(String string) {
        this.captureString(string);
        this.writeCapturedString();
    }

    public final void write(int b) {
        if (this.available == 0) {
            this.extend(1);
        }
        this.currentSegment.buffer[this.currentSegment.length++] = (byte)b;
        ++this.totalLength;
        --this.available;
    }

    private void allocate(int len) {
        if (this.firstSegment == null) {
            this.firstSegment = this.currentSegment = new DataSegment(len);
        } else if (this.firstSegment.buffer == null || this.firstSegment.buffer.length < len) {
            this.firstSegment.allocate(len);
        }
        this.currentSegment = this.firstSegment;
        this.firstSegment.next = null;
        this.totalLength = 0;
        this.available = this.currentSegment.buffer.length;
    }

    private void extend(int length) {
        if (this.firstSegment == null) {
            this.firstSegment = this.currentSegment = new DataSegment(length);
        } else if (this.currentSegment.buffer == null) {
            this.currentSegment.allocate(length);
        } else {
            DataSegment newSegment;
            this.currentSegment.next = newSegment = new DataSegment(length);
            this.currentSegment = newSegment;
        }
        this.available = this.currentSegment.buffer.length;
    }

    protected void writeCapturedString() {
        for (int n = 0; n < this.capturedLength; ++n) {
            this.write(this.capturedString.get(n));
        }
    }

    protected int captureString(String string) {
        try {
            CharsetEncoder enc = encoder.get();
            this.capturedString = enc.encode(CharBuffer.wrap(string));
            this.capturedLength = this.capturedString.limit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.capturedLength;
    }

    public String getString(byte[] source, int sourceOffset, int length) {
        if (this.codePoints == null || this.codePoints.length < length) {
            this.codePoints = new int[Math.max(length, 512)];
        }
        if (this.byteRemaining != null) {
            byte[] newSource = new byte[this.byteRemaining.length + source.length - sourceOffset];
            System.arraycopy(this.byteRemaining, 0, newSource, 0, this.byteRemaining.length);
            System.arraycopy(source, sourceOffset, newSource, this.byteRemaining.length, source.length - sourceOffset);
            source = newSource;
            sourceOffset = 0;
            this.byteRemaining = null;
        }
        int offset = sourceOffset;
        int count = 0;
        while (offset - sourceOffset < length) {
            int len;
            int b = 0xFF & source[offset++];
            int code = utf8Values[b];
            if (offset + len - 1 > source.length) {
                int byteRemainingLen = source.length - --offset;
                this.byteRemaining = new byte[byteRemainingLen];
                System.arraycopy(source, source.length - byteRemainingLen, this.byteRemaining, 0, byteRemainingLen);
                return new String(this.codePoints, 0, count);
            }
            for (len = utf8Lengths[b]; len > 1; --len) {
                code = code << 6 | source[offset++] & 0x3F;
            }
            this.codePoints[count++] = code;
        }
        return new String(this.codePoints, 0, count);
    }

    public void getMessage(CryptoInputStream stream) throws IOException {
        this.getMessage(stream, null);
    }

    public void getMessage(CryptoInputStream stream, Long maxLength) throws IOException {
        int lengthRead;
        this.reset();
        int length = stream.readLength();
        if (maxLength != null && (long)length > maxLength) {
            LengthUnit lengthUnit = LengthUnit.getBestLengthUnit((long)length - maxLength);
            throw new IOException(String.format("Received message %d%s exceeds maximum allowed size of %d%s", LengthUnit.BYTES.convert(length, lengthUnit), lengthUnit.getCode(), LengthUnit.BYTES.convert(maxLength, lengthUnit), lengthUnit.getCode()));
        }
        if (length > this.available) {
            if (this.firstSegment != null) {
                this.firstSegment.zap();
            }
            this.available = 0;
            this.extend(length);
        }
        for (int offset = 0; offset < length; offset += lengthRead) {
            lengthRead = this.firstSegment.read(stream, length - offset);
            if (lengthRead != -1) continue;
            throw new IOException("End of stream reached");
        }
        this.totalLength = length;
    }

    public void setData(byte[] data, int offset, int length) {
        this.allocate(length);
        System.arraycopy(data, offset, this.firstSegment.buffer, 0, length);
        this.totalLength = length;
        this.available = this.firstSegment.buffer.length - this.firstSegment.length;
    }

    public int setBase64(char[] data, int offset, int length) {
        this.allocate((length + 2) * 3 / 4);
        byte[] buffer = this.firstSegment.buffer;
        int in = offset;
        int out = 0;
        int bitsRemaining = 0;
        int bits = 0;
        for (int n = 0; n < length; ++n) {
            char c = data[in++];
            char digit = base64Lookup[c];
            if (c == '=') {
                if (bitsRemaining > 0) {
                    buffer[out++] = (byte)(bits << 6 - bitsRemaining);
                    bitsRemaining = 0;
                }
            } else if (digit != '\u00ff') {
                bits = bits << 6 | digit;
                bitsRemaining += 6;
            }
            if (bitsRemaining < 8) continue;
            buffer[out++] = (byte)(bits >> (bitsRemaining -= 8));
        }
        this.totalLength = this.firstSegment.length = out;
        this.available = this.firstSegment.buffer.length - this.firstSegment.length;
        return out;
    }

    public void putBase64(OutputStream outputStream) throws IOException {
        int n;
        int bitsRemaining = 0;
        int bits = 0;
        int length = 0;
        int out = 0;
        DataSegment segment = this.firstSegment;
        while (segment != null) {
            length += segment.length;
            n = 0;
            while (n < segment.length) {
                if (bitsRemaining < 6) {
                    bits = bits << 8 | segment.buffer[n++] & 0xFF;
                    bitsRemaining += 8;
                }
                while (bitsRemaining >= 6) {
                    int digit = bits >> (bitsRemaining -= 6) & 0x3F;
                    char c = base64Digits[digit];
                    ++out;
                    outputStream.write(c);
                }
            }
            segment = segment.next;
        }
        int mod = length % 3;
        if (mod > 0) {
            outputStream.write(base64Digits[bits << 6 - bitsRemaining & 0x3F]);
            for (n = 3; n > mod; --n) {
                outputStream.write(61);
            }
        }
    }

    public void send(CryptoOutputStream stream) throws IOException {
        try {
            stream.writeLength(this.totalLength);
            DataSegment segment = this.firstSegment;
            while (segment != null) {
                stream.write(segment.buffer, 0, segment.length);
                segment = segment.next;
            }
            stream.flush();
        }
        finally {
            this.reset();
        }
    }

    public String readString() {
        if (this.firstSegment.next != null) {
            throw new IllegalStateException("DataStream is multi-buffer");
        }
        return this.getString(this.firstSegment.buffer, 0, this.firstSegment.length);
    }

    public byte[] getBuffer() {
        if (this.firstSegment.next == null) {
            return this.firstSegment.buffer;
        }
        byte[] buffer = new byte[this.totalLength];
        int position = 0;
        DataSegment segment = this.firstSegment;
        while (segment != null) {
            System.arraycopy(segment.buffer, 0, buffer, position, segment.length);
            position += segment.length;
            segment = segment.next;
        }
        return buffer;
    }

    @Override
    public Iterator<Segment> iterator() {
        return new IterateSegments(this.firstSegment);
    }

    static {
        int n;
        encoder = new ThreadLocal<CharsetEncoder>(){

            @Override
            protected CharsetEncoder initialValue() {
                Charset utf8 = Charset.forName("UTF8");
                return utf8.newEncoder();
            }
        };
        utf8Flags = new byte[]{0, 0, -64, -32, -16, -8, -4};
        utf8Lengths = new char[]{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
        utf8Values = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\u0000', '\u0001', '\u0002', '\u0003', '\u0000', '\u0001', '\u0000', '\u0001'};
        base64Lookup = new char[256];
        base64Digits = new char[64];
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        for (n = 0; n < base64Lookup.length; ++n) {
            DataStream.base64Lookup[n] = 255;
        }
        for (n = 0; n < 64; ++n) {
            char c = alphabet.charAt(n);
            DataStream.base64Lookup[c] = (char)n;
            DataStream.base64Digits[n] = c;
        }
    }

    public class IterateSegments
    implements Iterator<Segment> {
        DataSegment nextSegment;

        IterateSegments(DataSegment firstSegment) {
            this.nextSegment = firstSegment;
        }

        @Override
        public boolean hasNext() {
            return this.nextSegment != null;
        }

        @Override
        public Segment next() {
            DataSegment segment = this.nextSegment;
            this.nextSegment = segment.next;
            return segment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class DataSegment
    implements Segment {
        int length;
        byte[] buffer;
        DataSegment next;

        DataSegment() {
        }

        DataSegment(int minLength) {
            this.allocate(minLength);
        }

        void reset() {
            this.length = 0;
            this.next = null;
        }

        int read(CryptoInputStream stream, int len) throws IOException {
            int actualLength = stream.read(this.buffer, this.length, Math.min(this.buffer.length - this.length, len));
            if (actualLength < 0) {
                throw new IOException("End of stream reached");
            }
            this.length += actualLength;
            return actualLength;
        }

        void zap() {
            if (this.length > 0) {
                throw new IllegalStateException("DataStream is partially filled");
            }
            this.buffer = null;
        }

        void allocate(int minLength) {
            this.buffer = new byte[Math.max(minLength, 1024)];
        }

        @Override
        public final int getLength() {
            return this.length;
        }

        @Override
        public final byte[] getBuffer() {
            return this.buffer;
        }
    }

    public static interface Segment {
        public int getLength();

        public byte[] getBuffer();
    }
}

