/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Vector;

public class CSVReader
implements Iterator,
Iterable<String[]> {
    Reader reader;
    Vector<String> headers;
    char[] buffer;
    char[] temp;
    int pos;
    int length;
    int numberColumns;
    boolean eol = false;

    public CSVReader(Reader reader) throws IOException {
        String header;
        this.reader = reader;
        this.buffer = new char[1024];
        this.temp = new char[1024];
        this.pos = 0;
        this.length = 0;
        this.headers = new Vector();
        while ((header = this.getNextString()) != null) {
            this.headers.add(header);
        }
        this.numberColumns = this.headers.size();
    }

    public CSVReader(String filename) throws IOException {
        this(new FileReader(filename));
    }

    public CSVReader(InputStream inputStream) throws IOException {
        this(new InputStreamReader(inputStream));
    }

    private String getNextString() throws IOException {
        int out = 0;
        boolean quoted = false;
        block0: while (!this.eol) {
            if (this.pos >= this.length) {
                if (!this.fetchLine()) {
                    return null;
                }
                this.pos = 0;
            }
            while (out == 0 && this.pos < this.length && this.buffer[this.pos] == ' ') {
                ++this.pos;
            }
            while (true) {
                if (this.pos >= this.length) continue block0;
                char c = this.buffer[this.pos++];
                if (out == 0 && c == '\"') {
                    quoted = true;
                    continue;
                }
                if (quoted && c == '\"') {
                    quoted = false;
                    continue;
                }
                if (!quoted && c == ',') {
                    while (out > 0 && this.temp[out - 1] == ' ') {
                        --out;
                    }
                    return new String(this.temp, 0, out);
                }
                if (c == '\n' || c == '\r') {
                    if (quoted) {
                        return null;
                    }
                    this.eol = true;
                    while (this.pos < this.length && (this.buffer[this.pos] == '\r' || this.buffer[this.pos] == '\n')) {
                        ++this.pos;
                    }
                    while (out > 0 && this.temp[out - 1] == ' ') {
                        --out;
                    }
                    return new String(this.temp, 0, out);
                }
                this.temp[out++] = c;
            }
            break;
        }
        return null;
    }

    private boolean fetchLine() throws IOException {
        this.length = this.reader.read(this.buffer);
        if (this.length <= 0) {
            return false;
        }
        this.pos = 0;
        this.eol = false;
        return true;
    }

    @Override
    public Iterator<String[]> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.pos >= this.length) {
                try {
                    if (!this.fetchLine()) {
                        return false;
                    }
                }
                catch (IOException exception) {
                    return false;
                }
            }
            if (this.buffer[this.pos] != '\n' && this.buffer[this.pos] != '\r') {
                return true;
            }
            ++this.pos;
            ++this.pos;
        }
    }

    public Object next() {
        this.eol = false;
        String[] strings = new String[this.numberColumns];
        try {
            for (int n = 0; n < this.numberColumns; ++n) {
                strings[n] = this.getNextString();
            }
        }
        catch (IOException exception) {
            return null;
        }
        return strings;
    }

    @Override
    public void remove() {
    }
}

