/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.stats.metrics;

import com.nuodb.impl.util.Preconditions;
import com.nuodb.stats.metrics.Range;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;
import java.util.Date;

public class RangeImpl
implements Range {
    private long start;
    private long end;

    public RangeImpl() {
    }

    public RangeImpl(long start, long end) {
        this.start = start;
        this.end = end;
        this.assertRange();
    }

    public RangeImpl(Tag encodedMetric) throws XmlException {
        this(encodedMetric.getLongAttribute("Start"), encodedMetric.getLongAttribute("End"));
    }

    private RangeImpl assertRange() {
        Preconditions.checkArgument(this.end >= this.start, "start time must be less than end time: %s", this);
        Preconditions.checkArgument(this.start >= 0L && this.end >= 0L, "invalid negative change: %s", this);
        return this;
    }

    @Override
    public Range encode(Tag element) {
        element.addAttribute("Start", this.start);
        element.addAttribute("End", this.end);
        return this.assertRange();
    }

    @Override
    public Tag toTag() {
        Tag tag = TagFactory.createTag("Range");
        this.encode(tag);
        return tag;
    }

    @Override
    public Range setStart(long timestamp) {
        this.start = timestamp;
        return this;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public Range setEnd(long timestamp) {
        this.end = timestamp;
        return this;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RangeImpl)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        RangeImpl m = (RangeImpl)o;
        return this.start == m.start && this.end == m.end;
    }

    public int hashCode() {
        return 31 * Long.valueOf(this.start).hashCode() + Long.valueOf(this.end).hashCode();
    }

    public String toString() {
        return String.format("Range[%s (long %d), %s (long %d)]", new Date(this.start), this.start, new Date(this.end), this.end);
    }
}

