/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.stats;

import com.nuodb.impl.util.Preconditions;
import com.nuodb.impl.util.StringUtils;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class AlarmDef {
    public static final String WILDCARD_ID = "*";
    final String name;
    final String desc;
    final Severity severity;
    final AlarmAction action;
    final String entityId;
    final EventType eventType;
    final Dimension dimension;
    final long breachDuration;
    final Repeat repeat;
    final String metric;
    final double threshold;
    final Operator operator;
    final AggrFunc aggrFunc;

    public AlarmDef(String alarmName, String alarmDesc, Severity severity, EventType eventType, Dimension dimension, String entityFilter, AlarmAction action) {
        Preconditions.checkArgument(!StringUtils.isBlank(alarmName), "empty name");
        Preconditions.checkArgument(eventType != EventType.StatAlert, "only for domain events");
        this.name = alarmName;
        this.desc = alarmDesc;
        this.action = action;
        this.entityId = StringUtils.isBlank(entityFilter) ? WILDCARD_ID : entityFilter;
        this.severity = severity;
        this.eventType = eventType;
        this.dimension = dimension;
        this.metric = null;
        this.threshold = 0.0;
        this.breachDuration = -1L;
        this.operator = Operator.GE;
        this.aggrFunc = AggrFunc.None;
        this.repeat = Repeat.Reset;
    }

    public AlarmDef(String alarmName, String alarmDesc, Severity severity, EventType type, String metricName, AggrFunc aggrFunc, Dimension dimension, String entityFilter, StatFunc func, int period, TimeUnit unit, Operator op, double threshold, int evalPeriods, TimeUnit evalUnit, AlarmAction action, Repeat continueSignaling) {
        Preconditions.checkArgument(!StringUtils.isBlank(alarmName), "empty name");
        this.name = alarmName;
        this.desc = alarmDesc;
        this.action = action;
        this.dimension = dimension;
        this.entityId = StringUtils.isBlank(entityFilter) ? WILDCARD_ID : entityFilter;
        this.severity = severity;
        this.eventType = type;
        this.metric = metricName;
        this.breachDuration = evalUnit.toMillis(evalPeriods);
        this.repeat = continueSignaling;
        this.threshold = threshold;
        this.operator = op;
        this.aggrFunc = aggrFunc;
        if (this.eventType == EventType.StatAlert) {
            Preconditions.checkArgument(!StringUtils.isBlank(metricName), "empty metricName");
            if (this.dimension == Dimension.Database || this.dimension == Dimension.Domain) {
                Preconditions.checkArgument(this.aggrFunc != AggrFunc.None, "%s: for dimension %s, the aggregation function cannot be %s", alarmName, dimension.name(), this.aggrFunc.name());
            } else {
                Preconditions.checkArgument(this.aggrFunc == AggrFunc.None, "%s: for dimension %s, the aggregation function cannot be %s", alarmName, dimension.name(), this.aggrFunc.name());
            }
        }
    }

    public AlarmDef(Tag tag) throws XmlException {
        this(tag.getAttribute("name"), tag.getAttribute("desc", null), Severity.valueOf(tag.getAttribute("severity")), EventType.valueOf(tag.getAttribute("eventType")), tag.getAttribute("metric", null), AggrFunc.valueOf(tag.getAttribute("aggrFunc", AggrFunc.None.name())), Dimension.valueOf(tag.getAttribute("dimension")), tag.getAttribute("entityid"), StatFunc.last, -1, TimeUnit.MILLISECONDS, Operator.valueOf(tag.getAttribute("operator", Operator.GE.name())), Double.parseDouble(tag.getAttribute("threshold", "0")), (int)tag.getLongAttribute("breachDuration", -1L), TimeUnit.MILLISECONDS, AlarmAction.valueOf(tag.getAttribute("action")), Repeat.valueOf(tag.getAttribute("repeat", Repeat.Reset.name())));
    }

    public Tag toTag() {
        Tag t = TagFactory.createTag("AlarmDef");
        this.encode(t);
        return t;
    }

    public void encode(Tag t) {
        t.setAttribute("name", this.name);
        if (!StringUtils.isBlank(this.desc)) {
            t.setAttribute("desc", this.desc);
        }
        t.setAttribute("action", this.action.name());
        t.setAttribute("entityid", this.entityId);
        t.setAttribute("severity", this.severity.name());
        t.setAttribute("eventType", this.eventType.name());
        t.setAttribute("dimension", this.dimension.name());
        if (this.eventType == EventType.StatAlert) {
            t.setAttribute("repeat", this.repeat.name());
            t.setAttribute("breachDuration", this.breachDuration);
            t.setAttribute("threshold", Double.toString(this.threshold));
            t.setAttribute("aggrFunc", this.aggrFunc.name());
            t.setAttribute("operator", this.operator.name());
            t.setAttribute("metric", this.metric);
        }
    }

    public String getName() {
        return this.name;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public String getDescription() {
        return this.desc;
    }

    public AlarmAction getAction() {
        return this.action;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String getEntityFilter() {
        return this.entityId;
    }

    public String getEntityAsHost() {
        String host = null;
        if (this.entityId != null && !this.entityId.equals(WILDCARD_ID)) {
            int pos;
            if (this.dimension == Dimension.Host) {
                host = this.entityId;
            } else if (this.dimension == Dimension.Node && (pos = this.entityId.lastIndexOf(":")) > 1) {
                host = this.entityId.substring(0, pos);
            }
        }
        return host;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Level asLogLevel() {
        if (this.severity == Severity.Severe || this.severity == Severity.Warning || this.severity == Severity.Info) {
            return Level.parse(this.severity.name().toUpperCase());
        }
        if (this.severity == Severity.Debug) {
            return Level.FINE;
        }
        return Level.SEVERE;
    }

    public boolean isStat() {
        return this.eventType == EventType.StatAlert;
    }

    public boolean matchesEntity(String id) {
        return WILDCARD_ID.equals(this.entityId) || this.entityId.equals(id);
    }

    public String getMetric() {
        return this.metric;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public double getThresold() {
        return this.threshold;
    }

    public AggrFunc getAggrFunc() {
        return this.aggrFunc;
    }

    public long getBreachDuration() {
        return this.breachDuration;
    }

    public Repeat getRepeat() {
        return this.repeat;
    }

    public String toString() {
        return this.toString(this.entityId);
    }

    public String toString(String prettyEntityId) {
        if (this.eventType == EventType.StatAlert) {
            return String.format("Alarm Definition [%s]: type=%s dimension=%s entity=%s metric=%s(%s) %s %.2f %ds (%s, %s)", this.name, this.eventType.name(), this.dimension.name(), prettyEntityId != null ? prettyEntityId : this.entityId, this.metric, this.aggrFunc.name(), this.operator.name(), this.threshold, this.breachDuration / 1000L, this.severity.name(), this.repeat.name());
        }
        return String.format("Alarm Definition [%s]: type=%s dimension=%s entity=%s (%s)", this.name, this.eventType.name(), this.dimension.name(), prettyEntityId != null ? prettyEntityId : this.entityId, this.severity.name());
    }

    public static void encode(Tag tag, Collection<AlarmDef> alarmDefs) {
        if (alarmDefs == null) {
            return;
        }
        for (AlarmDef def : alarmDefs) {
            tag.addChild(def.toTag());
        }
    }

    public static Collection<AlarmDef> decode(Tag tag) throws XmlException {
        HashSet<AlarmDef> result = new HashSet<AlarmDef>();
        if (tag == null || !tag.hasChildren()) {
            return result;
        }
        Iterator<Tag> iter = tag.children();
        while (iter.hasNext()) {
            result.add(new AlarmDef(iter.next()));
        }
        return result;
    }

    static interface Options {
        public Options named(String var1);

        public Options domain();

        public Options database(String var1);

        public Options node(String var1);

        public Options node(String var1, boolean var2);

        public Options peer(String var1);

        public Options peer(String var1, String[] var2);

        public Options metric(String var1, AggrFunc var2);

        public Options event(EventType var1);

        public Options statistic(StatFunc var1, int var2, TimeUnit var3);

        public Options condition(Operator var1, double var2);

        public Options breachPeriod(int var1, TimeUnit var2);

        public Options action(AlarmAction var1, Severity var2, Repeat var3);

        public Options withOptionalDesc(String var1);

        public AlarmDef build();
    }

    public static enum Repeat {
        Reset,
        Continue;

    }

    public static enum AggrFunc {
        None,
        Sum,
        Average;

    }

    public static enum Operator {
        EQ,
        GT,
        GE,
        LT,
        LE,
        NE;

    }

    public static enum StatFunc {
        last;

    }

    public static enum EventType {
        StatAlert,
        NodeJoined,
        NodeLeft,
        NodeFailed,
        PeerJoined,
        PeerLeft,
        DatabaseActive,
        DatabaseInactive,
        DatabaseStarted,
        DatabaseStopped,
        EnforcerFailed,
        EnforcerNodeBackoff,
        EnforcerNodeBackoffMaxRetried,
        ConsensusCommandFailed;

    }

    public static enum Severity {
        Severe,
        Warning,
        Info,
        Debug;

    }

    public static enum Dimension {
        Domain,
        Database,
        Host,
        Node;

    }

    public static enum AlarmAction {
        LogOnly,
        NotifyEvent;

    }
}

