/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.security;

import com.nuodb.impl.util.Base64;
import com.nuodb.impl.util.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.crypto.Cipher;

public class EncryptionUtils {
    private static final String SEP = "-----";

    public static String getHeader(String type) {
        return String.format("%sBEGIN %s%s", SEP, type, SEP);
    }

    public static String getFooter(String type) {
        return String.format("%sEND %s%s", SEP, type, SEP);
    }

    public static String wrap(String s, int width) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i != s.length(); ++i) {
            if (i != 0 && i % width == 0) {
                sb.append("\n");
            }
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    public static String encapsulate(String type, byte[] data, int width) {
        String base64 = Base64.getEncoder().encodeToString(data);
        String wrapped = EncryptionUtils.wrap(base64, width);
        String header = EncryptionUtils.getHeader(type);
        String footer = EncryptionUtils.getFooter(type);
        return header + '\n' + wrapped + '\n' + footer;
    }

    public static String encapsulateAll(String type, Collection<byte[]> dataCollection) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (byte[] data : dataCollection) {
            builder.append(EncryptionUtils.encapsulate(type, data, 64)).append('\n');
        }
        return builder.toString();
    }

    public static String getPemEncodedCerts(Collection<? extends Certificate> certificates) throws IOException, GeneralSecurityException {
        return EncryptionUtils.getPemEncodedKeyAndCerts(null, certificates.toArray(new Certificate[0]));
    }

    public static int unencapsulate(String type, String encapsulated, int offset, OutputStream out) throws IOException {
        String header = EncryptionUtils.getHeader(type);
        String footer = EncryptionUtils.getFooter(type);
        int beginIndex = encapsulated.indexOf(header, offset);
        int endIndex = encapsulated.indexOf(footer, offset);
        if (beginIndex == -1) {
            return -1;
        }
        Preconditions.checkArgument(endIndex != -1, "Unexpected format for base64-encoded data:\n%s", encapsulated);
        StringBuilder base64 = new StringBuilder();
        for (int i = beginIndex + header.length(); i != endIndex; ++i) {
            if (Character.isWhitespace(encapsulated.charAt(i))) continue;
            base64.append(encapsulated.charAt(i));
        }
        out.write(Base64.getDecoder().decode(base64.toString()));
        return endIndex + footer.length();
    }

    public static byte[] unencapsulate(String type, String encapsulated) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Preconditions.checkArgument(EncryptionUtils.unencapsulate(type, encapsulated, 0, out) != -1, "Unexpected format for base64-encoded data:\n%s", encapsulated);
        return out.toByteArray();
    }

    public static List<byte[]> unencapsulateAll(String type, String encapsulated) throws IOException {
        ArrayList<byte[]> allData = new ArrayList<byte[]>();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offset = 0;
        while ((offset = EncryptionUtils.unencapsulate(type, encapsulated, offset, out)) != -1) {
            allData.add(out.toByteArray());
            out.reset();
        }
        return allData;
    }

    public static String getPemEncodedKeyAndCerts(Key privateKey, Certificate ... certChain) throws GeneralSecurityException, IOException {
        StringBuilder sb = new StringBuilder();
        if (privateKey != null && privateKey != null) {
            sb.append(EncryptionUtils.encapsulate("PRIVATE KEY", privateKey.getEncoded(), 64)).append("\n");
        }
        if (certChain != null) {
            for (Certificate cert : certChain) {
                sb.append(EncryptionUtils.encapsulate("CERTIFICATE", cert.getEncoded(), 64)).append("\n");
            }
        }
        return sb.toString().trim();
    }

    public static byte[] transform(byte[] data, Key key, int cipherMode) throws GeneralSecurityException, IOException {
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(cipherMode, key);
        return cipher.doFinal(data);
    }

    public static String getSignedLicense(String data, Key privateKey) throws GeneralSecurityException, IOException {
        byte[] encrypted = EncryptionUtils.transform(data.getBytes(StandardCharsets.UTF_8), privateKey, 1);
        return EncryptionUtils.encapsulate("LICENSE", encrypted, 64);
    }

    public static String verifySignedLicense(String encodedLicense, Certificate certificate) throws GeneralSecurityException, IOException {
        byte[] encrypted = EncryptionUtils.unencapsulate("LICENSE", encodedLicense);
        byte[] decrypted = EncryptionUtils.transform(encrypted, certificate.getPublicKey(), 2);
        return new String(decrypted, StandardCharsets.UTF_8);
    }
}

