/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.net;

import com.nuodb.impl.net.LengthUtil;
import com.nuodb.impl.security.Cipher;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;

public class CryptoInputStream
extends InputStream {
    InputStream stream;
    Cipher cipher;
    byte[] lengthBuffer;

    public CryptoInputStream(InputStream inputStream) {
        this.stream = new BufferedInputStream(inputStream);
        this.lengthBuffer = new byte[4];
    }

    public void setCipher(Cipher encryptionEngine) {
        this.cipher = encryptionEngine;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    @Override
    public int read() throws IOException {
        if (this.cipher == null) {
            return this.stream.read();
        }
        byte[] buffer = new byte[1];
        int ret = this.stream.read(buffer, 0, 1);
        if (ret == -1) {
            return -1;
        }
        try {
            this.cipher.transform(buffer);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        return buffer[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int bytesRead;
        int ret;
        for (bytesRead = 0; bytesRead < length; bytesRead += ret) {
            ret = this.stream.read(b, offset + bytesRead, length - bytesRead);
            if (ret != -1) continue;
            if (bytesRead != 0) break;
            return -1;
        }
        if (this.cipher != null) {
            try {
                this.cipher.transform(b, offset, bytesRead);
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
        }
        return bytesRead;
    }

    public int readLength() throws IOException {
        return LengthUtil.readLength(this.stream, this.lengthBuffer);
    }

    public byte[] readMessage() throws IOException {
        int length = this.readLength();
        byte[] data = new byte[length];
        this.read(data);
        return data;
    }
}

