/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.runtime.launcher.LauncherHelper;
import com.install4j.runtime.launcher.util.LauncherUtil;
import com.install4j.runtime.util.StringUtil;
import java.io.File;
import java.io.IOException;

class NoHelper
implements LauncherHelper {
    NoHelper() {
    }

    static LauncherHelper init() {
        if (!System.getProperty("java.version", "").startsWith("1.6")) {
            try {
                return (LauncherHelper)Class.forName("com.install4j.runtime.launcher.FullLauncherHelper").newInstance();
            }
            catch (Throwable e) {
                System.err.println("could not init LaunchHelper implementation: " + e);
            }
        }
        return new NoHelper();
    }

    @Override
    public void initIntegration() {
    }

    @Override
    public void setUnattended(boolean value) {
    }

    @Override
    public String[] initVariables(Class<?> mainClass, String[] args) {
        return args;
    }

    @Override
    public String replaceVariables(String value) {
        return value;
    }

    @Override
    public String replaceVariables(String value, StringUtil.ReplacementCallback replacementCallback) {
        return StringUtil.replaceVariable(value, replacementCallback);
    }

    private static String quoteDollarSign(String s) {
        return s.replaceAll("\\$", "\\\\\\$");
    }

    @Override
    public void setPosixFilePermissions(File file, String permissions) {
        if (!LauncherUtil.isWindows()) {
            try {
                String filePath = NoHelper.quoteDollarSign(file.getAbsolutePath());
                new ProcessBuilder("chmod", permissions, filePath).start().waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void watchDirectory(File directory, String threadName, Runnable runnable) {
    }

    @Override
    public File getInstallerFile(String fileName) {
        File file = new File(ResourceHelper.getRuntimeDir(), fileName);
        if (file.exists() || !LauncherUtil.isMacOS()) {
            return file;
        }
        return new File(fileName).getAbsoluteFile();
    }

    @Override
    public void exit(int exitCode) {
        System.exit(exitCode);
    }

    @Override
    public long getPid() {
        return LauncherUtil.getPidFromMBean();
    }
}

