/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.install4j.runtime.installer.platform.win32.Common;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class MacosUiHelper {
    public static final int DIALOG_TYPE_OPEN = 1;
    public static final int DIALOG_TYPE_OPEN_MULTIPLE = 2;
    public static final int DIALOG_TYPE_SAVE = 3;
    public static final int DIALOG_TYPE_DIRECTORY = 4;
    public static final int DIALOG_TYPE_FILE_OR_DIRECTORY = 5;
    private static final String URL_FILE_PREFIX = "file:";
    private static final String URL_JAR_PREFIX = "jar:file:";
    private static Executor executor;
    private static Map<Integer, byte[]> iconBytes;

    private static native void disableReordering0();

    private static native void enableReordering0();

    private static native void init0();

    private static native void showAlert0(String var0, String var1, String[] var2, String var3, byte[] var4, int var5, boolean var6, boolean var7, AlertCallback var8);

    public static MacosAlertResult showAlert(final String title, final String message, String[] buttonTitles, String defaultButtonTitle, final String cancelButtonTitle, final int type, Icon icon, final boolean suppressionShown, boolean useSecondaryLoop) {
        List<String> originalButtonTitles = Arrays.asList(buttonTitles);
        ArrayList<String> unorderedButtonTitles = new ArrayList<String>(originalButtonTitles);
        ArrayList<String> reorderedButtonTitles = new ArrayList<String>();
        if (unorderedButtonTitles.remove(defaultButtonTitle)) {
            reorderedButtonTitles.add(defaultButtonTitle);
        }
        if (unorderedButtonTitles.remove(cancelButtonTitle)) {
            reorderedButtonTitles.add(cancelButtonTitle);
        }
        reorderedButtonTitles.addAll(unorderedButtonTitles);
        final byte[] iconBytes = icon != null ? MacosUiHelper.getIconBytes(icon) : MacosUiHelper.getIcon(type);
        SecondaryLoop loop = useSecondaryLoop ? MacosUiHelper.createSecondaryLoop() : null;
        final String[] buttonArray = reorderedButtonTitles.toArray(new String[0]);
        final AlertCallbackImpl callback = new AlertCallbackImpl(reorderedButtonTitles, originalButtonTitles, loop);
        if (loop != null) {
            MacosUiHelper.runWithSecondaryLoop(loop, callback.countDownLatch, new Runnable(){

                @Override
                public void run() {
                    MacosUiHelper.restoreFocus();
                    MacosUiHelper.showAlert0(title, message, buttonArray, cancelButtonTitle, iconBytes, type, suppressionShown, true, callback);
                }
            });
        } else {
            MacosUiHelper.showAlert0(title, message, buttonArray, cancelButtonTitle, iconBytes, type, suppressionShown, false, callback);
            callback.await();
        }
        return callback.getResult();
    }

    private static void restoreFocus() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                }
            });
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        final Window window = MacosUiHelper.getTopLevelWindow();
        if (window != null) {
            final Component focusOwner = window.getFocusOwner();
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    if (focusOwner != null) {
                        focusOwner.requestFocus();
                    }
                    window.removeWindowListener(this);
                }
            });
        }
    }

    private static Window getTopLevelWindow() {
        for (Window window : Window.getWindows()) {
            if (!window.isActive()) continue;
            return window;
        }
        return null;
    }

    private static byte[] getIcon(Integer type) {
        if (Boolean.getBoolean("ejt.deployed") && (type == 1 || type == 3 || type == -1)) {
            return null;
        }
        byte[] bytes = iconBytes.get(type);
        if (bytes == null) {
            JOptionPane optionPane = new JOptionPane();
            CustomOptionPaneUI optionPaneUI = new CustomOptionPaneUI();
            optionPane.setUI(optionPaneUI);
            Icon icon = optionPaneUI.getIconForType(type);
            bytes = MacosUiHelper.getIconBytes(icon);
            if (bytes != null) {
                iconBytes.put(type, bytes);
            }
        }
        return bytes;
    }

    private static byte[] getIconBytes(Icon icon) {
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(new JPanel(), g, 0, 0);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", out);
            return out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static native void showFileChooser0(int var0, String var1, String var2, String var3, String var4, boolean var5, String[][] var6, String[] var7, int var8, boolean[] var9, String[] var10, boolean[] var11, FileSelectionCallback var12);

    public static Result showFileChooser(final int dialogType, final String title, final String currentDirectory, final String approveButtonText, final String defaultSelectedFileName, final boolean fileHidingEnabled, final String[][] suffixes, final String[] descriptions, final int fileFilterIndex, final boolean[] exactNames, final String[] questions, final boolean[] questionPresets) {
        final Result[] results = new Result[1];
        final SecondaryLoop loop = MacosUiHelper.createSecondaryLoop();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        MacosUiHelper.runWithSecondaryLoop(loop, countDownLatch, new Runnable(){

            @Override
            public void run() {
                MacosUiHelper.restoreFocus();
                MacosUiHelper.showFileChooser0(dialogType, title, currentDirectory, approveButtonText, defaultSelectedFileName, fileHidingEnabled, suffixes, descriptions, fileFilterIndex, exactNames, questions, questionPresets, new FileSelectionCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void callback(String[] selectedPath, boolean[] answers) {
                        Result[] resultArray = results;
                        synchronized (results) {
                            results[0] = new Result(selectedPath, answers);
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            loop.exit();
                            countDownLatch.countDown();
                            return;
                        }
                    }
                });
            }
        });
        return results[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runWithSecondaryLoop(SecondaryLoop loop, CountDownLatch countDownLatch, Runnable runnable) {
        MacosUiHelper.disableReordering0();
        try {
            executor.execute(runnable);
            loop.enter();
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        finally {
            MacosUiHelper.enableReordering0();
        }
    }

    private static SecondaryLoop createSecondaryLoop() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
    }

    public static void prepareNonEdtError() {
        MacosUiHelper.getIcon(0);
    }

    public static void initDependencies() {
        new AlertCallbackImpl(Collections.emptyList(), Collections.emptyList(), null);
        MacosUiHelper.init0();
    }

    public static void main(String[] args) {
        MacosAlertResult alertResult = MacosUiHelper.showAlert("Test alert", "Do you really want to exit?\nNext line", new String[]{"Option 1", "Option 2", "Yes", "No"}, "Yes", "No", 0, null, true, false);
        System.err.println("selectedOption = " + alertResult);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("test");
                frame.setBounds(200, 200, 1000, 800);
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
                JDialog dialog = new JDialog(frame);
                dialog.setTitle("Dialog");
                dialog.setModal(true);
                dialog.setBounds(400, 400, 800, 600);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        MacosAlertResult alertResult = MacosUiHelper.showAlert("Test alert", "Do you really want to exit?\nNext line", new String[]{"Option 1", "Option 2", "Yes", "No"}, "Yes", "No", 0, null, true, true);
                        System.err.println("selectedOption = " + alertResult);
                        alertResult = MacosUiHelper.showAlert("Test alert", "Do you really want to exit?\nNext line", new String[]{"Option 1", "Option 2", "Yes", "No"}, "Yes", "No", 0, null, true, false);
                        System.err.println("selectedOption = " + alertResult);
                    }
                });
                dialog.setVisible(true);
                File selectedFile = null;
                try {
                    selectedFile = File.createTempFile("test", ".txt");
                    selectedFile.deleteOnExit();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Result result = MacosUiHelper.showFileChooser(1, "Choose snapshot", selectedFile == null ? null : selectedFile.getParent(), "Translate", selectedFile == null ? null : selectedFile.getName(), true, new String[][]{{"jps"}, {"hprof", "hpz"}, {"test.txt"}}, new String[]{"JProfiler snapshots dasdjhg dhjasgjhdgajhsgd jahgsdj aghjdhgsd", "HPROF snapshots", "test.txt"}, 1, new boolean[]{false, false, true}, new String[]{"Customize options", "Open exported file"}, new boolean[]{false, true});
                System.err.println("result = " + result);
            }
        });
    }

    static {
        Common.init();
        executor = Executors.newSingleThreadExecutor();
        iconBytes = Collections.synchronizedMap(new HashMap());
    }

    public static class MacosAlertResult {
        private int answer;
        private boolean suppressionChecked;

        public MacosAlertResult(int answer, boolean suppressionChecked) {
            this.answer = answer;
            this.suppressionChecked = suppressionChecked;
        }

        public int getAnswer() {
            return this.answer;
        }

        public boolean isSuppressionChecked() {
            return this.suppressionChecked;
        }

        public String toString() {
            return "MacosAlertResult{answer=" + this.answer + ", suppressionChecked=" + this.suppressionChecked + '}';
        }
    }

    private static class AlertCallbackImpl
    implements AlertCallback {
        private MacosAlertResult result;
        private final List<String> reorderedButtonTitles;
        private final List<String> originalButtonTitles;
        private final SecondaryLoop loop;
        private final CountDownLatch countDownLatch = new CountDownLatch(1);

        public AlertCallbackImpl(List<String> reorderedButtonTitles, List<String> originalButtonTitles, SecondaryLoop loop) {
            this.reorderedButtonTitles = reorderedButtonTitles;
            this.originalButtonTitles = originalButtonTitles;
            this.loop = loop;
        }

        public synchronized MacosAlertResult getResult() {
            return this.result;
        }

        @Override
        public synchronized void callback(int answer, boolean suppressionChecked) {
            String selectedButtonTitle = this.reorderedButtonTitles.get(answer);
            int selectedIndex = this.originalButtonTitles.indexOf(selectedButtonTitle);
            this.result = new MacosAlertResult(selectedIndex, suppressionChecked);
            if (this.loop != null) {
                this.loop.exit();
            }
            this.countDownLatch.countDown();
        }

        public void await() {
            try {
                this.countDownLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static class CustomOptionPaneUI
    extends BasicOptionPaneUI {
        private CustomOptionPaneUI() {
        }

        @Override
        protected Icon getIconForType(int messageType) {
            return super.getIconForType(messageType);
        }
    }

    public static class Result {
        private String[] selectedPaths;
        private boolean[] answers;

        public Result(String[] selectedPaths, boolean[] answers) {
            this.selectedPaths = selectedPaths;
            this.answers = answers;
        }

        public String[] getSelectedPaths() {
            return this.selectedPaths;
        }

        public boolean[] getAnswers() {
            return this.answers;
        }

        public String toString() {
            return "Result{selectedPaths=" + Arrays.toString(this.selectedPaths) + ", answers=" + Arrays.toString(this.answers) + '}';
        }
    }

    public static interface FileSelectionCallback {
        public void callback(String[] var1, boolean[] var2);
    }

    public static interface AlertCallback {
        public void callback(int var1, boolean var2);
    }
}

