/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.componentselection;

import com.install4j.runtime.beans.screens.componentselection.IndeterminateStateDisplay;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;

public class ComponentCheckBox
extends JCheckBox
implements IndeterminateStateDisplay {
    private boolean indeterminate;
    private InternalCheckBox indeterminateCheckbox;
    private float alpha;

    public ComponentCheckBox() {
        this.setOpaque(false);
        this.indeterminateCheckbox = new InternalCheckBox();
        this.indeterminateCheckbox.setOpaque(false);
        this.model.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComponentCheckBox.this.indeterminate && !ComponentCheckBox.this.model.isSelected()) {
                    ComponentCheckBox.this.indeterminate = false;
                    ComponentCheckBox.this.setSelected(true);
                }
                ComponentCheckBox.this.indeterminate = false;
            }
        });
        if (InstallerUtil.isMacOS() || GUIHelper.isWindowsLaF() && this.isXP()) {
            this.initDisabled(0.5f);
        } else {
            this.initArmed();
        }
    }

    private void initDisabled(float alpha) {
        this.alpha = alpha;
        this.indeterminateCheckbox.setEnabled(false);
    }

    private void initArmed() {
        this.alpha = 1.0f;
        ButtonModel model = this.indeterminateCheckbox.getModel();
        model.setArmed(true);
        model.setPressed(true);
    }

    private boolean isXP() {
        if (System.getProperty("swing.noxp") != null) {
            return false;
        }
        if (InstallerUtil.isJava9Plus()) {
            return true;
        }
        try {
            Class<?> windowsLafClass = Class.forName("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            Method classicWindowsGetterMethod = windowsLafClass.getMethod("isClassicWindows", new Class[0]);
            return (Boolean)classicWindowsGetterMethod.invoke(null, new Object[0]) == false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setSelected(boolean selected) {
        this.indeterminate = false;
        super.setSelected(selected);
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.indeterminate = indeterminate;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.indeterminate && this.model.isEnabled() && !this.model.isArmed()) {
            Graphics2D graphics = (Graphics2D)g;
            Composite oldComposite = graphics.getComposite();
            graphics.setComposite(AlphaComposite.getInstance(3, this.alpha));
            this.indeterminateCheckbox.setBounds(this.getBounds());
            this.indeterminateCheckbox.paintComponent(g);
            graphics.setComposite(oldComposite);
        }
    }

    private static class InternalCheckBox
    extends JCheckBox {
        public InternalCheckBox() {
            this.setSelected(true);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
        }

        @Override
        public synchronized void addMouseListener(MouseListener l) {
        }
    }
}

