/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.beans.LocalizedExternalFile;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.AllowDirectFieldAccess;
import com.install4j.runtime.beans.formcomponents.DocumentUpdateCaretPosition;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.beans.screens.components.TextSource;
import com.install4j.runtime.installer.frontend.components.HtmlDisplay;
import javax.swing.JComponent;
import javax.swing.JTextPane;

public class HtmlDisplayFormComponent
extends LeadingLabelComponent
implements HtmlDisplay.HtmlTextProvider {
    private TextSource textSource = TextSource.FILE;
    private LocalizedExternalFile displayedTextFile = new LocalizedExternalFile();
    private String displayedText = "";
    private int height = 100;
    private boolean fillVertical = false;
    private String variableName = "";
    private DocumentUpdateCaretPosition documentUpdateCaretPosition = DocumentUpdateCaretPosition.UNCHANGED;
    private HtmlDisplay htmlDisplay;

    @Override
    public TextSource getTextSource() {
        return this.replaceWithTextOverride("textSource", this.textSource, TextSource.class);
    }

    public void setTextSource(TextSource textSource) {
        this.textSource = textSource;
    }

    @Override
    public LocalizedExternalFile getDisplayedTextFile() {
        return this.replaceWithTextOverride("displayedTextFile", this.displayedTextFile, LocalizedExternalFile.class);
    }

    public void setDisplayedTextFile(LocalizedExternalFile displayedTextFile) {
        this.displayedTextFile = displayedTextFile;
    }

    public String getDisplayedText() {
        return HtmlDisplayFormComponent.replaceVariables(this.displayedText);
    }

    @Override
    @AllowDirectFieldAccess
    public String getRawDisplayedText() {
        return this.displayedText;
    }

    public void setDisplayedText(String displayedText) {
        this.displayedText = displayedText;
    }

    public int getHeight() {
        return this.replaceWithTextOverride("height", this.height);
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isFillVertical() {
        return this.replaceWithTextOverride("fillVertical", this.fillVertical);
    }

    public void setFillVertical(boolean fillVertical) {
        this.fillVertical = fillVertical;
    }

    public String getVariableName() {
        return HtmlDisplayFormComponent.replaceVariables(this.variableName);
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public DocumentUpdateCaretPosition getDocumentUpdateCaretPosition() {
        return this.replaceWithTextOverride("documentUpdateCaretPosition", this.documentUpdateCaretPosition, DocumentUpdateCaretPosition.class);
    }

    public void setDocumentUpdateCaretPosition(DocumentUpdateCaretPosition documentUpdateCaretPosition) {
        this.documentUpdateCaretPosition = documentUpdateCaretPosition;
    }

    @Override
    public JComponent createCenterComponent() {
        this.initHtmlDisplay();
        return this.htmlDisplay;
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return true;
    }

    @Override
    public boolean isFillCenterVertical() {
        return this.isFillVertical();
    }

    @Override
    public void formWillActivate() {
        super.formWillActivate();
        this.htmlDisplay.setContext(this.getContext());
        this.updateText();
    }

    public void updateText() {
        this.htmlDisplay.updateText();
    }

    public boolean isAllRead() {
        return this.htmlDisplay.isAllRead();
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.htmlDisplay != null && formEnvironment != null) {
            this.htmlDisplay.getHtmlTextPane().setName(formEnvironment.getId(this));
        }
    }

    private void initHtmlDisplay() {
        this.htmlDisplay = new HtmlDisplay(this, this.getDocumentUpdateCaretPosition().getCaretTarget());
        this.htmlDisplay.setPreferredHeight(this.getHeight());
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        this.initHtmlDisplay();
        this.htmlDisplay.setContext(this.getContext());
        this.htmlDisplay.handleConsole(console);
        return true;
    }

    public JTextPane getTextPane() {
        return this.htmlDisplay.getHtmlTextPane();
    }

    @Override
    public boolean checkCompleted() {
        if (this.getVariableName().length() > 0) {
            this.getContext().setVariable(this.getVariableName(), this.getActualText());
        }
        return super.checkCompleted();
    }

    public String getActualText() {
        return this.htmlDisplay.getActualText();
    }
}

