/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.windows.service;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.windows.WinUser;
import com.install4j.api.windows.service.ServiceAccessException;
import com.install4j.api.windows.service.ServiceAccount;
import com.install4j.api.windows.service.ServiceConfiguration;
import com.install4j.api.windows.service.ServiceException;
import com.install4j.api.windows.service.ServiceNotFoundException;
import com.install4j.api.windows.service.ServiceStartType;
import com.install4j.runtime.beans.actions.services.AbstractControlServiceAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchStringAction;
import com.install4j.runtime.installer.platform.win32.Win32Services;
import com.install4j.runtime.installer.platform.win32.Win32UserInfo;
import com.install4j.runtime.launcher.util.LauncherUtil;

public class WinServices {
    public static void start(final String serviceName, final String ... parameters) throws ServiceException {
        WinServices.checkPrerequisites(serviceName);
        try {
            HelperCommunication.getInstance().fetchObject(ExecutionContext.MAXIMUM, new FetchObjectAction<Void>(){

                @Override
                protected Void fetchValue(Context context) throws Exception {
                    Win32Services.startService(serviceName, parameters);
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            throw WinServices.checkServiceException(e);
        }
    }

    public static void stop(final String serviceName) throws ServiceException {
        Context context = ContextImpl.getCurrentContext();
        final int minimumTimeout = AbstractControlServiceAction.getMinimumStopTimeout(context);
        WinServices.checkPrerequisites(serviceName);
        try {
            HelperCommunication.getInstance().fetchObject(ExecutionContext.MAXIMUM, new FetchObjectAction<Void>(){

                @Override
                protected Void fetchValue(Context context) throws Exception {
                    Win32Services.stopService(serviceName, minimumTimeout);
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            throw WinServices.checkServiceException(e);
        }
    }

    public static void install(final String serviceName, final ServiceConfiguration configuration) throws ServiceException {
        WinServices.checkPrerequisites(serviceName);
        if (configuration == null) {
            throw new IllegalArgumentException("configuration required");
        }
        if (configuration.getBinaryName() == null) {
            throw new IllegalArgumentException("configuration.binaryName required");
        }
        try {
            HelperCommunication.getInstance().fetchObject(ExecutionContext.MAXIMUM, new FetchObjectAction<Void>(){

                @Override
                protected Void fetchValue(Context context) throws Exception {
                    Win32Services.installService(serviceName, null, configuration.getBinaryName());
                    WinServices.changeServiceInt(serviceName, configuration);
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            throw WinServices.checkServiceException(e);
        }
    }

    public static void change(final String serviceName, final ServiceConfiguration configuration) throws ServiceException {
        WinServices.checkPrerequisites(serviceName);
        try {
            HelperCommunication.getInstance().fetchObject(ExecutionContext.MAXIMUM, new FetchObjectAction<Void>(){

                @Override
                protected Void fetchValue(Context context) throws Exception {
                    WinServices.changeServiceInt(serviceName, configuration);
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            throw WinServices.checkServiceException(e);
        }
    }

    public static void uninstall(final String serviceName) throws ServiceException {
        WinServices.checkPrerequisites(serviceName);
        try {
            HelperCommunication.getInstance().fetchObject(ExecutionContext.MAXIMUM, new FetchObjectAction<Void>(){

                @Override
                protected Void fetchValue(Context context) throws Exception {
                    Win32Services.uninstallService(serviceName);
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            throw WinServices.checkServiceException(e);
        }
    }

    public static boolean isRunning(final String serviceName) throws ServiceException {
        WinServices.checkPrerequisites(serviceName);
        try {
            return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.MAXIMUM, new FetchBooleanAction(){

                @Override
                protected boolean fetchValue(Context context) throws Exception {
                    return Win32Services.isRunning(serviceName);
                }
            });
        }
        catch (RuntimeException e) {
            throw WinServices.checkServiceException(e);
        }
    }

    public static ServiceStartType getStartType(final String serviceName) throws ServiceException {
        WinServices.checkPrerequisites(serviceName);
        try {
            return HelperCommunication.getInstance().fetchObject(ExecutionContext.MAXIMUM, new FetchObjectAction<ServiceStartType>(){

                @Override
                protected ServiceStartType fetchValue(Context context) throws Exception {
                    int startType = Win32Services.getStartType(serviceName);
                    switch (startType) {
                        case 2: {
                            return ServiceStartType.AUTO;
                        }
                        case 3: {
                            return ServiceStartType.DEMAND;
                        }
                        case 4: {
                            return ServiceStartType.DISABLED;
                        }
                    }
                    throw new RuntimeException("unknown start type " + startType);
                }
            });
        }
        catch (RuntimeException e) {
            throw WinServices.checkServiceException(e);
        }
    }

    public static String getBinary(final String serviceName) throws ServiceException {
        WinServices.checkPrerequisites(serviceName);
        try {
            return HelperCommunication.getInstance().fetchString(ExecutionContext.MAXIMUM, new FetchStringAction(){

                @Override
                protected String fetchValue(Context context) throws Exception {
                    return Win32Services.getServiceBinary(serviceName);
                }
            });
        }
        catch (RuntimeException e) {
            throw WinServices.checkServiceException(e);
        }
    }

    private static void changeServiceInt(String serviceName, ServiceConfiguration configuration) throws Win32Services.ServiceException {
        int startType = configuration.getStartType() == null ? -1 : configuration.getStartType().intValue;
        String accountName = null;
        String password = null;
        if (configuration.getServiceAccount() != null) {
            if (configuration.getServiceAccount() == ServiceAccount.OTHER) {
                accountName = WinUser.getAccountName(configuration.getOtherAccountName());
                if (accountName == null) {
                    accountName = configuration.getOtherAccountName();
                }
                password = configuration.getOtherAccountPassword();
            } else {
                accountName = configuration.getServiceAccount().getAccountName();
                password = "";
            }
        }
        Win32Services.changeServiceConfig(serviceName, configuration.getDisplayName(), configuration.getBinaryName(), false, startType, configuration.getDependencies(), accountName, password, configuration.getDescription());
        if (Util.isAtLeastWindowsVista() && configuration.getDelayedAutoStart() != null) {
            Win32Services.setDelayedAutoStart(serviceName, configuration.getDelayedAutoStart());
        }
        if (configuration.getRestartOnFailure() != null) {
            Win32Services.setRestartServiceConfig(serviceName, configuration.getRestartOnFailure(), configuration.getRestartMillis(), configuration.getMaxRestarts(), configuration.getResetSeconds());
        }
        if (configuration.getServiceAccount() == ServiceAccount.OTHER) {
            Win32UserInfo.setLsaAccountRight(configuration.getOtherAccountName(), "SeServiceLogonRight", true);
        }
    }

    private static RuntimeException checkServiceException(RuntimeException e) {
        if (e.getCause() instanceof Win32Services.ServiceException) {
            Win32Services.ServiceException serviceException = (Win32Services.ServiceException)e.getCause();
            switch (serviceException.getErrorCode()) {
                case 1060: {
                    throw new ServiceNotFoundException();
                }
                case 5: {
                    throw new ServiceAccessException();
                }
            }
            throw new ServiceException("Win32 error code: " + serviceException.getErrorCode());
        }
        throw e;
    }

    private static void checkPrerequisites(String serviceName) {
        if (!LauncherUtil.isWindows()) {
            throw new ServiceException("only available on Windows");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName required");
        }
    }
}

