/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime.gui;

import com.exe4j.runtime.splash.SplashEngine;
import com.exe4j.runtime.splash.SplashScreenConfig;
import com.exe4j.runtime.splash.TextLineConfig;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import javax.swing.JLabel;

public class AwtSplashScreen
implements SplashEngine.SplashInterface {
    private SplashScreen splashScreen;
    private Font statusFont;
    private Font versionFont;
    private String statusText;
    private Graphics2D graphics2D;

    private AwtSplashScreen() {
        SplashScreenConfig config = SplashEngine.getJavaSplashScreenConfig();
        try {
            if (config.isTextOverlay() && config.getStatusLineConfig() != null && config.getVersionLineConfig() != null) {
                this.splashScreen = SplashScreen.getSplashScreen();
                if (this.splashScreen != null) {
                    FontMetrics fm;
                    Font font;
                    this.statusText = config.getStatusLineConfig().getText();
                    this.graphics2D = this.splashScreen.createGraphics();
                    boolean useDefaultFont = Boolean.getBoolean("install4j.splashScreenDefaultFont");
                    JLabel label = new JLabel();
                    if (useDefaultFont) {
                        font = this.graphics2D.getFont();
                        fm = this.graphics2D.getFontMetrics();
                    } else {
                        font = label.getFont();
                        fm = label.getFontMetrics(font);
                    }
                    this.graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, fm.getFontRenderContext().getAntiAliasingHint() != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
                    this.graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, fm.getFontRenderContext().getAntiAliasingHint());
                    this.graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, fm.getFontRenderContext().getFractionalMetricsHint());
                    this.statusFont = this.createFont(font, config.getStatusLineConfig());
                    this.versionFont = this.createFont(font, config.getVersionLineConfig());
                    this.update();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void update() {
        if (this.splashScreen != null && this.splashScreen.isVisible()) {
            Dimension size = this.splashScreen.getSize();
            this.graphics2D.setComposite(AlphaComposite.Clear);
            this.graphics2D.fillRect(0, 0, size.width, size.height);
            this.graphics2D.setPaintMode();
            SplashScreenConfig config = SplashEngine.getJavaSplashScreenConfig();
            this.drawText(this.statusText, this.statusFont, config.getStatusLineConfig());
            this.drawText(config.getVersionLineConfig().getText(), this.versionFont, config.getVersionLineConfig());
            this.splashScreen.update();
        }
    }

    private void drawText(String text, Font font, TextLineConfig textLineConfig) {
        this.graphics2D.setFont(font);
        this.graphics2D.setColor(new Color(textLineConfig.getFontColorR(), textLineConfig.getFontColorG(), textLineConfig.getFontColorB()));
        this.graphics2D.drawString(text, textLineConfig.getPositionX(), textLineConfig.getPositionY() + this.graphics2D.getFontMetrics().getAscent());
    }

    private Font createFont(Font font, TextLineConfig config) {
        int fontStyle = config.getFontWeight() > 500 ? 1 : 0;
        return font.deriveFont(fontStyle, (int)((double)config.getFontSize() * 1.3));
    }

    @Override
    public synchronized void writeMessage(String message) throws Exception {
        this.statusText = message;
        this.update();
    }

    @Override
    public synchronized void hideScreen() throws Exception {
        if (this.splashScreen == null) {
            this.splashScreen = SplashScreen.getSplashScreen();
        }
        if (this.splashScreen != null) {
            this.splashScreen.close();
        }
    }

    public static class Invoker {
        public static SplashEngine.SplashInterface create() {
            return new AwtSplashScreen();
        }

        public static void hideExternal() {
            SplashScreen splashScreen = SplashScreen.getSplashScreen();
            if (splashScreen != null) {
                splashScreen.close();
            }
        }
    }
}

