/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.sql;

import com.onseven.dbvis.sql.f;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Clob;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class TextData
implements f {
    private String data = "";
    private long length = 0L;
    private long maxLen = -1L;
    private Clob clob;
    private InputStream inputStream;
    private String cachedStr;
    private String encoding;
    private static final Logger LOG = Logger.getLogger(TextData.class.getName());
    private static final int UNDEFINED = 0;
    private static final int CLOB_TYPE = 1;
    private static final int STRING_TYPE = 2;
    private static final int STREAM_TYPE = 3;
    private int type = 0;

    public TextData() {
    }

    public TextData(Clob clob) {
        this.setString(clob);
        this.getData();
    }

    public TextData(String string) {
        this.setString(string);
    }

    public TextData(byte[] byArray) {
        this.setString(new String(byArray));
    }

    public TextData(InputStream inputStream, String string) throws IOException {
        this.setString(inputStream, string);
        this.getData();
    }

    public void setString(Clob clob) {
        this.type = 1;
        this.data = null;
        this.length = -1L;
        this.maxLen = -1L;
        this.clob = clob;
        this.inputStream = null;
        this.cachedStr = null;
    }

    public void setString(String string) {
        this.type = 2;
        this.data = string;
        this.length = string.length();
        this.maxLen = -1L;
        this.clob = null;
        this.inputStream = null;
        this.cachedStr = null;
    }

    private void setString(InputStream inputStream, String string) throws IOException {
        this.type = 3;
        this.data = null;
        this.length = -1L;
        this.maxLen = -1L;
        this.clob = null;
        this.inputStream = inputStream;
        this.cachedStr = null;
        this.encoding = string;
        new InputStreamReader(this.inputStream);
    }

    public void setMaxLength(long l2) {
        this.maxLen = l2;
    }

    public long getLength() {
        if (this.length < 0L && this.type == 1 && this.clob != null) {
            try {
                this.length = this.clob.length();
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "There was an error getting CLOB data", exception);
                this.length = 0L;
            }
        } else if (this.length < 0L) {
            this.getData();
        }
        return this.length;
    }

    public String getData() {
        if (this.data == null && this.type == 1 && this.clob != null) {
            try {
                this.length = this.maxLen > 0L && this.getLength() > this.maxLen ? this.maxLen : this.getLength();
                this.data = this.clob.getSubString(1L, (int)this.length);
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "There was an error getting CLOB data", exception);
                this.data = "";
                this.length = this.data.length();
            }
        } else if (this.data == null && this.type == 3) {
            if (this.inputStream != null) {
                try {
                    int n2;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream, this.encoding));
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    char[] cArray = new char[1024];
                    while ((n2 = bufferedReader.read(cArray, 0, cArray.length)) != -1) {
                        printWriter.write(cArray, 0, n2);
                    }
                    this.data = stringWriter.toString();
                    if (this.data != null) {
                        if (this.maxLen > 0L) {
                            int n3 = Math.min(this.data.length(), (int)this.maxLen);
                            this.data = this.data.substring(0, n3);
                        }
                    } else {
                        this.data = "";
                    }
                    this.length = this.data.length();
                }
                catch (IOException iOException) {}
            }
        } else if (this.data != null && this.maxLen > 0L) {
            this.maxLen = Math.min(this.maxLen, (long)this.data.length());
            this.data = this.data.substring(0, (int)this.maxLen);
        }
        return this.data;
    }

    public Reader getReader() {
        return new StringReader(this.getData());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TextData) {
            TextData textData = (TextData)object;
            return StringUtils.equals((CharSequence)this.data, (CharSequence)textData.data);
        }
        return false;
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 29 * n2 + Objects.hashCode(this.data);
        return n2;
    }

    public String toString() {
        return this.getData();
    }

    public String toString(int n2) {
        if (this.cachedStr != null) {
            return this.cachedStr;
        }
        int n3 = (int)this.getLength();
        if (n3 == 0) {
            return "";
        }
        n3 = Math.min(n3, n2);
        this.cachedStr = this.getData().substring(0, n3);
        return this.cachedStr;
    }

    public long getBytesCount() {
        long l2 = (this.data != null ? this.data.length() : 0) + (this.cachedStr != null ? this.cachedStr.length() : 0);
        long l3 = l2 * 2L + 38L;
        long l4 = l3 % 8L;
        if (l4 != 0L) {
            l3 += l4;
        }
        return l3;
    }
}

