/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EncryptedInputStream;
import com.exasol.jdbc.Header;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class InMessage {
    final EXAConnection connection;
    private EXAInputStream in;
    private ByteArrayInputStream inData;
    private Header header;
    private DebugLog debug;

    public InMessage(DebugLog debugLog, InputStream inputStream, EXAConnection eXAConnection) throws SQLException, IOException {
        this.connection = eXAConnection;
        this.debug = debugLog;
        this.header = new Header(eXAConnection, debugLog, eXAConnection.getNextSerialNumber());
        ((EncryptedInputStream)inputStream).SetMemoryStream(this.header.read_from(inputStream, 0));
        eXAConnection.updateSessionAttributes(this.header.getAttributes());
        EXAInputStream eXAInputStream = new EXAInputStream(inputStream, eXAConnection);
        byte[] byArray = new byte[this.header.getSize()];
        eXAInputStream.read(byArray);
        this.inData = new ByteArrayInputStream(byArray);
        this.in = new EXAInputStream(this.inData, eXAConnection);
    }

    public EXAInputStream getStream() {
        return this.in;
    }

    public Header getHeader() {
        return this.header;
    }
}

