/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.addons;

import de.javasoft.plaf.synthetica.GraphicsUtils;
import de.javasoft.synthetica.addons.Version;
import de.javasoft.util.IVersion;
import de.javasoft.util.OS;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.net.URI;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class SyntheticaAddonsUtilities {
    private static final boolean JAVA5 = System.getProperty("java.version").startsWith("1.5.");

    public static IVersion getVersion() {
        return Version.getInstance();
    }

    public static ImageIcon createAlphaIcon(Icon icon, float f) {
        return SyntheticaAddonsUtilities.createAlphaIcon(null, icon, f);
    }

    public static ImageIcon createAlphaIcon(Component component, Icon icon, float f) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
        graphics2D.setComposite(alphaComposite);
        icon.paintIcon(component, graphics2D, 0, 0);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static Icon resizeIcon(Icon icon, int n, int n2) {
        return new ImageIcon(SyntheticaAddonsUtilities.resizeImage((BufferedImage)GraphicsUtils.iconToImage(null, icon), n, n2));
    }

    public static BufferedImage resizeImage(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, n3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static void openInBrowser(String string) {
        if (JAVA5) {
            try {
                if (OS.getCurrentOS() == OS.Windows) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
                }
                if (OS.getCurrentOS() == OS.Mac) {
                    Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                    Method method = clazz.getDeclaredMethod("openURL", String.class);
                    method.invoke(null, string);
                }
                String[] stringArray = new String[]{"firefox", "mozilla", "netscape", "opera"};
                String string2 = null;
                int n = 0;
                while (n < stringArray.length && string2 == null) {
                    if (Runtime.getRuntime().exec(new String[]{"which", stringArray[n]}).waitFor() == 0) {
                        string2 = stringArray[n];
                    }
                    ++n;
                }
                if (string2 == null) {
                    throw new RuntimeException("Error while opening URL - no supported browser is installed!");
                }
                Runtime.getRuntime().exec(new String[]{string2, string});
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            try {
                Desktop.getDesktop().browse(new URI(string));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static boolean isDefaultTextBackgroundDark() {
        Color color = UIManager.getColor("TextField.background");
        return (double)Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3])[2] < 0.5;
    }

    public static void updateChildrenUI(JComponent jComponent) {
        jComponent.updateUI();
        Component[] componentArray = jComponent.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof JComponent) {
                SyntheticaAddonsUtilities.updateChildrenUI((JComponent)component);
            }
            ++n2;
        }
    }
}

