/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.sort;

import java.math.BigDecimal;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;

public class Comparators {
    public static final NumberComparator numberComparator = new NumberComparator();

    public static <T> Comparator<T> stringValueComparator() {
        return new StringValueComparator();
    }

    private Comparators() {
    }

    public static class NumberComparator
    implements Comparator<Number> {
        private List<Class<?>> integerClasses = Arrays.asList(Integer.class, Short.class, Byte.class, Long.class);
        private List<Class<?>> decimalClasses = Arrays.asList(Float.class, Double.class);

        @Override
        public int compare(Number one, Number other) {
            if (one == null && other == null) {
                return 0;
            }
            if (one == null) {
                return -1;
            }
            if (other == null) {
                return 1;
            }
            if (one instanceof Comparable && one.getClass() == other.getClass()) {
                return ((Comparable)((Object)one)).compareTo(other);
            }
            if (this.areIntegers(one, other)) {
                return this.longCompare(one, other);
            }
            return this.bigCompare(one, other);
        }

        private int bigCompare(Number one, Number other) {
            BigDecimal bigOne = one instanceof BigDecimal ? (BigDecimal)one : new BigDecimal(one.toString());
            BigDecimal bigOther = other instanceof BigDecimal ? (BigDecimal)other : new BigDecimal(other.toString());
            return bigOne.compareTo(bigOther);
        }

        private boolean areDecimals(Number one, Number other) {
            return this.isDecimal(one) && this.isDecimal(other);
        }

        private boolean isDecimal(Number other) {
            return this.decimalClasses.contains(other.getClass());
        }

        private boolean areIntegers(Number one, Number other) {
            return this.isInteger(one) && this.isInteger(other);
        }

        private boolean isInteger(Number one) {
            return this.integerClasses.contains(one.getClass());
        }

        private int longCompare(Number comparable, Number o) {
            long diff = comparable.longValue() - o.longValue();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    }

    public static class StringValueComparator<T>
    implements Comparator<T> {
        private Collator collator;
        private StringValue sv;

        public StringValueComparator() {
            this(null);
        }

        public StringValueComparator(StringValue sv) {
            this(sv, null);
        }

        public StringValueComparator(StringValue sv, Collator collator) {
            if (sv == null) {
                sv = StringValues.TO_STRING;
            }
            this.sv = sv;
            if (collator == null) {
                collator = Collator.getInstance();
            }
            this.collator = collator;
        }

        @Override
        public int compare(T one, T other) {
            if (one == null && other == null) {
                return 0;
            }
            if (one == null) {
                return -1;
            }
            if (other == null) {
                return 1;
            }
            return this.collator.compare(this.sv.getString(one), this.sv.getString(other));
        }
    }
}

