/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.JYSwitchButtonPainter;
import de.javasoft.swing.plaf.basic.BasicJYSwitchButtonUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;

public class SyntheticaJYSwitchButtonUI
extends BasicJYSwitchButtonUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new SyntheticaJYSwitchButtonUI();
    }

    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        Font font = abstractButton.getFont();
        if (font == null || font instanceof UIResource) {
            abstractButton.setFont(UIManager.getFont("Label.font"));
        }
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            SynthStyle synthStyle = SynthLookAndFeel.getStyle(jComponent, Region.CHECK_BOX);
            SynthContext synthContext = new SynthContext(jComponent, Region.CHECK_BOX, synthStyle, jComponent.isEnabled() ? 0 : 8);
            Color color = jComponent.isEnabled() ? jComponent.getForeground() : synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND);
            graphics.setColor(color);
            synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, string, rectangle.x, rectangle.y, ((AbstractButton)jComponent).getDisplayedMnemonicIndex());
        }
    }

    protected void paintBackground(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4) {
        SyntheticaState syntheticaState = this.createState(jComponent, ((AbstractButton)jComponent).isSelected());
        JYSwitchButtonPainter.getInstance().paintBackground(jComponent, syntheticaState, graphics, n, n2, n3, n4);
    }

    protected void paintSwitchBackground(JComponent jComponent, boolean bl, Graphics graphics, int n, int n2, int n3, int n4) {
        JYSwitchButtonPainter.getInstance().paintSwitchBackground(jComponent, this.createState(jComponent, bl), graphics, n, n2, n3, n4);
    }

    protected void paintSwitch(JComponent jComponent, boolean bl, Graphics graphics, int n, int n2, int n3, int n4) {
        JYSwitchButtonPainter.getInstance().paintSwitch(jComponent, this.createState(jComponent, bl), graphics, n, n2, n3, n4);
    }

    private SyntheticaState createState(JComponent jComponent, boolean bl) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        SyntheticaState syntheticaState = new SyntheticaState();
        if (bl) {
            syntheticaState.setState(SyntheticaState.State.SELECTED);
        }
        if (abstractButton.hasFocus()) {
            syntheticaState.setState(SyntheticaState.State.FOCUSED);
        }
        if (abstractButton.getModel().isRollover()) {
            syntheticaState.setState(SyntheticaState.State.HOVER);
        }
        if (!abstractButton.isEnabled()) {
            syntheticaState.setState(SyntheticaState.State.DISABLED);
        }
        return syntheticaState;
    }
}

