/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jytable.renderer;

import de.javasoft.swing.JYTable;
import de.javasoft.swing.jytable.renderer.TableRegion;
import de.javasoft.swing.jytable.sort.SortIconProvider;
import de.javasoft.swing.sort.ISortIconProvider;
import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import org.jdesktop.swingx.renderer.CellContext;

public class TableHeaderCellContext
extends CellContext {
    private TableRegion region;
    private JTableHeader header;
    Icon sortIcon;
    String sortText;
    SortOrder sortOrder;
    ISortIconProvider sortIconProvider;

    public void installContext(JTable component, Object value, int row, int column, boolean selected, boolean focused, boolean expanded, boolean leaf, TableRegion region) {
        this.installComponent(component, region);
        this.installState(value, row, column, selected, focused, expanded, leaf);
        this.checkSortState();
    }

    private void installComponent(JTable component, TableRegion region) {
        this.region = region;
        this.component = component;
        if (component != null) {
            if (TableRegion.TABLE_HEADER == region) {
                this.header = component.getTableHeader();
            } else if (TableRegion.TABLE_SUBHEADER == region && component instanceof JYTable) {
                this.header = (JTableHeader)((JYTable)((Object)component)).getFilterRow();
            }
        }
    }

    private void checkSortState() {
        this.resetSortState();
        if (!this.isValidColumn()) {
            return;
        }
        if (this.isMainHeader()) {
            this.sortIcon = this.getSortIconProvider().getSortIcon(this.component, this.getColumn(), false);
            this.sortText = this.getSortIconProvider().getSortText(this.component, this.getColumn());
        }
        this.sortOrder = this.component instanceof JYTable ? ((JYTable)((Object)this.component)).getSortOrder(this.getColumn()) : SortOrder.UNSORTED;
    }

    private void resetSortState() {
        this.sortIcon = null;
        this.sortText = null;
        this.sortOrder = SortOrder.UNSORTED;
    }

    private boolean isMainHeader() {
        return this.region != TableRegion.TABLE_SUBHEADER;
    }

    private ISortIconProvider getSortIconProvider() {
        if (this.sortIconProvider == null) {
            this.sortIconProvider = new SortIconProvider();
        }
        return this.sortIconProvider;
    }

    protected boolean isValidColumn() {
        if (this.component == null) {
            return false;
        }
        return this.getColumn() >= 0 && this.getColumn() < ((JTable)this.component).getColumnCount();
    }

    public JTableHeader getComponent() {
        return this.header;
    }

    public Icon getSortIcon() {
        return this.sortIcon;
    }

    public String getSortText() {
        String text = this.sortText;
        if (this.hasSortIcon() && text == null) {
            text = " ";
        }
        return text;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public boolean hasSortIcon() {
        return this.sortIcon != null;
    }

    protected Border getBorder() {
        Border border = null;
        if (this.isFocused()) {
            border = this.getFocusBorder();
        }
        if (border == null) {
            border = UIManager.getBorder(this.getUIKey("cellBorder"));
        }
        return border;
    }

    protected Border getFocusBorder() {
        return UIManager.getBorder(this.getUIKey("focusCellBorder"));
    }

    protected Color getForeground() {
        Color color = null;
        if (this.isFocused()) {
            color = this.getFocusForeground();
        }
        return color != null ? color : super.getForeground();
    }

    protected Color getBackground() {
        Color color = null;
        if (this.isFocused()) {
            color = this.getFocusBackground();
        }
        return color != null ? color : super.getBackground();
    }

    protected Color getSelectionBackground() {
        return this.getBackground();
    }

    protected Color getSelectionForeground() {
        return this.getForeground();
    }

    protected Font getFont() {
        if (this.getComponent() == null) {
            return UIManager.getFont(this.getUIKey("font"));
        }
        return this.getComponent().getFont();
    }

    public String getCellRendererName() {
        return String.valueOf(this.getUIPrefix()) + "renderer";
    }

    protected String getUIPrefix() {
        return "TableHeader.";
    }
}

