/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.CompoundEmptyBorder;
import de.javasoft.swing.jydocking.Dockbar;
import de.javasoft.swing.jydocking.DockbarManager;
import de.javasoft.swing.jydocking.DockbarSlidePanel;
import de.javasoft.swing.jydocking.DockingUtility;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.InsetBorder;
import de.javasoft.swing.jydocking.RootWindow;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DockbarLayout {
    private DockbarManager manager;
    private JComponent leftPlacementGuide;
    private JComponent rightPlacementGuide;
    private JComponent bottomPlacementGuide;

    public DockbarLayout(DockbarManager dockbarManager) {
        this.manager = dockbarManager;
    }

    public void layout() {
        this.updateInsets();
        Rectangle rectangle = this.getLayoutArea(this.manager);
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        Dockbar dockbar = this.manager.getLeftBar();
        Dockbar dockbar2 = this.manager.getRightBar();
        Dockbar dockbar3 = this.manager.getBottomBar();
        Dimension dimension = dockbar.getPreferredSize();
        Dimension dimension2 = dockbar2.getPreferredSize();
        Dimension dimension3 = dockbar3.getPreferredSize();
        dockbar.setBounds(rectangle.x, rectangle.y, dimension.width, rectangle.height - dimension3.height);
        dockbar2.setBounds(n - dimension2.width, rectangle.y, dimension2.width, rectangle.height - dimension3.height);
        dockbar3.setBounds(rectangle.x, n2 - dimension3.height, rectangle.width, dimension3.height);
        this.layoutSlidePanel();
    }

    public int getDesiredViewpaneSize() {
        IDockable iDockable = this.manager.getActiveDockable();
        if (iDockable == null) {
            return 0;
        }
        Rectangle rectangle = this.getViewArea(this.manager, iDockable);
        float f = iDockable.getPreviewSize();
        int n = this.manager.getActivePlacement();
        if (n == 2 || n == 4) {
            return (int)((float)rectangle.width * f);
        }
        return (int)((float)rectangle.height * f);
    }

    protected void layoutSlidePanel() {
        DockbarSlidePanel dockbarSlidePanel = this.manager.getSlidePanel();
        IDockable iDockable = this.manager.getActiveDockable();
        if (iDockable == null) {
            dockbarSlidePanel.setBounds(0, 0, 0, 0);
            return;
        }
        int n = this.manager.getActivePlacement();
        int n2 = dockbarSlidePanel.getPrefSize();
        if (n2 == -1) {
            n2 = this.getDesiredViewpaneSize();
        }
        Rectangle rectangle = this.getViewArea(this.manager, iDockable);
        if (n == 2 || n == 4) {
            if (n == 4) {
                rectangle.x = rectangle.x + rectangle.width - n2;
            }
            rectangle.width = n2;
        } else {
            if (n == 3) {
                rectangle.y = rectangle.y + rectangle.height - n2;
            }
            rectangle.height = n2;
        }
        dockbarSlidePanel.setBounds(rectangle);
    }

    private void updateInsets() {
        Insets insets = this.getEmptyInsets();
        boolean bl = this.resetGuideBorders();
        HashSet hashSet = new HashSet(3);
        this.add(hashSet, this.getInsetBorder(2));
        this.add(hashSet, this.getInsetBorder(4));
        this.add(hashSet, this.getInsetBorder(3));
        HashSet hashSet2 = new HashSet(3);
        this.add(hashSet2, this.getCurrentPlacementGuide(2));
        this.add(hashSet2, this.getCurrentPlacementGuide(4));
        this.add(hashSet2, this.getCurrentPlacementGuide(3));
        for (Serializable serializable : hashSet) {
            boolean bl2 = bl = ((CompoundEmptyBorder)serializable).setEmptyInsets(insets) || bl;
        }
        if (bl) {
            for (Serializable serializable : hashSet2) {
                ((JComponent)serializable).revalidate();
            }
        }
    }

    private <T> void add(Set<T> set, T t) {
        if (t != null) {
            set.add(t);
        }
    }

    private boolean resetGuideBorders() {
        boolean bl = this.resetGuide(2);
        bl = this.resetGuide(4) || bl;
        bl = this.resetGuide(3) || bl;
        this.toggleInsetBorder(2);
        this.toggleInsetBorder(4);
        this.toggleInsetBorder(3);
        return bl;
    }

    private boolean resetGuide(int n) {
        InsetBorder insetBorder;
        Border border;
        JComponent jComponent = this.getCurrentPlacementGuide(n);
        JComponent jComponent2 = this.queryPlacementGuide(n);
        boolean bl = false;
        if (DockingUtility.isChanged(jComponent, jComponent2)) {
            bl = true;
            border = jComponent == null ? null : jComponent.getBorder();
            InsetBorder insetBorder2 = insetBorder = border instanceof InsetBorder ? (InsetBorder)border : null;
            if (insetBorder != null) {
                Border border2 = insetBorder.getWrappedBorder();
                jComponent.setBorder(border2);
                insetBorder.togglePlacement(n, false);
            }
        }
        if (jComponent2 == null) {
            return this.setCurrentPlacementGuide(n, jComponent2) || bl;
        }
        border = jComponent2.getBorder();
        if (!(border instanceof InsetBorder)) {
            bl = true;
            insetBorder = InsetBorder.createBorder(border, true, new Insets(-1, -1, -1, -1));
            jComponent2.setBorder(insetBorder);
        }
        insetBorder = (InsetBorder)jComponent2.getBorder();
        insetBorder.clearPlacements();
        return this.setCurrentPlacementGuide(n, jComponent2) || bl;
    }

    private void toggleInsetBorder(int n) {
        InsetBorder insetBorder = this.getInsetBorder(n);
        if (insetBorder != null) {
            insetBorder.togglePlacement(n, true);
        }
    }

    private InsetBorder getInsetBorder(int n) {
        JComponent jComponent = this.getCurrentPlacementGuide(n);
        Border border = jComponent == null ? null : jComponent.getBorder();
        return border instanceof InsetBorder ? (InsetBorder)border : null;
    }

    private Insets getEmptyInsets() {
        return new Insets(0, this.getLeftInset(), this.getBottomInset(), this.getRightInset());
    }

    private int getLeftInset() {
        return this.getDockbarInset(this.manager.getLeftBar());
    }

    private int getRightInset() {
        return this.getDockbarInset(this.manager.getRightBar());
    }

    private int getBottomInset() {
        return this.getDockbarInset(this.manager.getBottomBar());
    }

    private int getDockbarInset(Dockbar dockbar) {
        boolean bl = dockbar.isVisible();
        if (!bl) {
            return 0;
        }
        Dimension dimension = dockbar.getPreferredSize();
        if (dockbar == this.manager.getLeftBar() || dockbar == this.manager.getRightBar()) {
            return dimension.width;
        }
        return dimension.height;
    }

    private JComponent queryPlacementGuide(int n) {
        return this.getPlacementGuide(this.manager, n);
    }

    private JComponent getCurrentPlacementGuide(int n) {
        switch (n) {
            case 2: {
                return this.leftPlacementGuide;
            }
            case 4: {
                return this.rightPlacementGuide;
            }
            case 3: {
                return this.bottomPlacementGuide;
            }
        }
        return null;
    }

    private boolean setCurrentPlacementGuide(int n, JComponent jComponent) {
        boolean bl = this.getCurrentPlacementGuide(n) == jComponent;
        switch (n) {
            case 2: {
                this.leftPlacementGuide = jComponent;
                break;
            }
            case 4: {
                this.rightPlacementGuide = jComponent;
                break;
            }
            case 3: {
                this.bottomPlacementGuide = jComponent;
            }
        }
        return bl;
    }

    public Rectangle getViewArea(DockbarManager dockbarManager, IDockable iDockable) {
        if (dockbarManager == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = dockbarManager.getLeftBar().getBounds();
        Rectangle rectangle2 = dockbarManager.getBottomBar().getBounds();
        Rectangle rectangle3 = dockbarManager.getRightBar().getBounds();
        return new Rectangle(rectangle.x + rectangle.width, rectangle.y, rectangle2.width - rectangle.width - rectangle3.width, rectangle.height);
    }

    public Rectangle getLayoutArea(DockbarManager dockbarManager) {
        RootWindow rootWindow;
        Rectangle rectangle = new Rectangle();
        RootWindow rootWindow2 = rootWindow = dockbarManager == null ? null : dockbarManager.getWindow();
        if (rootWindow == null) {
            return rectangle;
        }
        JLayeredPane jLayeredPane = rootWindow.getLayeredPane();
        JComponent jComponent = this.getPlacementGuide(dockbarManager, 2);
        JComponent jComponent2 = this.getPlacementGuide(dockbarManager, 4);
        JComponent jComponent3 = this.getPlacementGuide(dockbarManager, 3);
        JComponent jComponent4 = this.getPlacementGuide(dockbarManager, 1);
        Rectangle rectangle2 = SwingUtilities.convertRectangle(jComponent.getParent(), jComponent.getBounds(), jLayeredPane);
        Rectangle rectangle3 = SwingUtilities.convertRectangle(jComponent2.getParent(), jComponent2.getBounds(), jLayeredPane);
        Rectangle rectangle4 = SwingUtilities.convertRectangle(jComponent3.getParent(), jComponent3.getBounds(), jLayeredPane);
        Rectangle rectangle5 = SwingUtilities.convertRectangle(jComponent4.getParent(), jComponent4.getBounds(), jLayeredPane);
        int n = rectangle3.x + rectangle3.width;
        int n2 = rectangle4.y + rectangle4.height;
        rectangle.x = rectangle2.x;
        rectangle.y = rectangle5.y;
        rectangle.width = n - rectangle.x;
        rectangle.height = n2 - rectangle.y;
        return rectangle;
    }

    public JComponent getPlacementGuide(DockbarManager dockbarManager, int n) {
        RootWindow rootWindow = dockbarManager == null ? null : dockbarManager.getWindow();
        Container container = rootWindow == null ? null : rootWindow.getContentPane();
        return container instanceof JComponent ? (JComponent)container : null;
    }
}

