/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.JYDockingPort;
import de.javasoft.swing.jydocking.DockingEvent;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockableAcceptor;
import de.javasoft.swing.jydocking.IDockingConstants;
import de.javasoft.swing.jydocking.IDockingEventListener;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.Perspective;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockableComponentWrapper
implements IDockable,
IDockingConstants {
    private JComponent component;
    private String id;
    protected ArrayList<JComponent> dragSources;
    protected ArrayList<IDockingEventListener> dockingListeners;
    private boolean dockingEnabled;
    private boolean active;
    private boolean activeStateLocked;
    private String tabText;
    private Icon dockbarIcon;
    private Icon tabIcon;
    private HashMap<String, Float> regionInset;
    private HashMap<String, Float> siblingSize;
    private HashMap<String, Boolean> territoryBlocked;
    private float dragThreshold;
    private float previewSize;
    private boolean mouseMotionListenersBlockedWhileDragging;
    private IDockableAcceptor dockableAcceptor;

    public DockableComponentWrapper(JComponent jComponent, String string, String string2, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("The 'id' parameter cannot be null.");
        }
        this.component = jComponent;
        this.id = string;
        this.setTabText(string2);
        this.dragSources = new ArrayList(1);
        this.dockingListeners = new ArrayList(1);
        this.initDefaults();
        if (bl) {
            this.getDragSources().add(jComponent);
        }
    }

    private void initDefaults() {
        this.dockingEnabled = true;
        if (this.tabText == null) {
            this.tabText = "-------";
        }
        this.dragThreshold = 4.0f;
        this.previewSize = 0.3f;
        this.mouseMotionListenersBlockedWhileDragging = true;
        this.regionInset = new HashMap();
        this.regionInset.put("NORTH", Float.valueOf(0.25f));
        this.regionInset.put("SOUTH", Float.valueOf(0.25f));
        this.regionInset.put("EAST", Float.valueOf(0.25f));
        this.regionInset.put("WEST", Float.valueOf(0.25f));
        this.siblingSize = new HashMap();
        this.siblingSize.put("NORTH", Float.valueOf(DockingManager.getDefaultSiblingSize()));
        this.siblingSize.put("SOUTH", Float.valueOf(DockingManager.getDefaultSiblingSize()));
        this.siblingSize.put("EAST", Float.valueOf(DockingManager.getDefaultSiblingSize()));
        this.siblingSize.put("WEST", Float.valueOf(DockingManager.getDefaultSiblingSize()));
        this.territoryBlocked = new HashMap();
        this.territoryBlocked.put("NORTH", Boolean.FALSE);
        this.territoryBlocked.put("SOUTH", Boolean.FALSE);
        this.territoryBlocked.put("EAST", Boolean.FALSE);
        this.territoryBlocked.put("WEST", Boolean.FALSE);
        this.territoryBlocked.put("CENTER", Boolean.FALSE);
        this.dockableAcceptor = new IDockableAcceptor(){

            public boolean acceptDockable(IDockable iDockable, String string) {
                IDockingPort iDockingPort = DockableComponentWrapper.this.getDockingPort();
                return (!(iDockingPort instanceof JYDockingPort) || !((JYDockingPort)iDockingPort).isRegionBlocked(string)) && !DockableComponentWrapper.this.isTerritoryBlocked(string);
            }
        };
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public IDockingPort getDockingPort() {
        return DockingManager.getDockingPort(this);
    }

    @Override
    public List<JComponent> getDragSources() {
        return this.dragSources;
    }

    @Override
    public boolean dock(IDockable iDockable, Perspective perspective, String string, float f) {
        return DockingManager.dock(iDockable, this, perspective, string, f);
    }

    @Override
    public void addDockingListener(IDockingEventListener iDockingEventListener) {
        this.dockingListeners.add(iDockingEventListener);
    }

    @Override
    public void removeDockingListener(IDockingEventListener iDockingEventListener) {
        this.dockingListeners.remove(iDockingEventListener);
    }

    @Override
    public List<IDockingEventListener> getDockingListeners() {
        return this.dockingListeners;
    }

    @Override
    public void setDockingEnabled(boolean bl) {
        boolean bl2 = this.isDockingEnabled();
        this.dockingEnabled = bl;
        this.component.firePropertyChange("dockingEnabled", bl2, bl);
    }

    @Override
    public boolean isDockingEnabled() {
        return this.dockingEnabled;
    }

    @Override
    public void setActive(boolean bl) {
        if (!this.isActiveStateLocked() && bl != this.isActive()) {
            boolean bl2 = this.isActive();
            this.active = bl;
            this.component.firePropertyChange("active", bl2, bl);
            this.component.repaint();
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActiveStateLocked(boolean bl) {
        boolean bl2 = this.isActiveStateLocked();
        this.activeStateLocked = bl;
        this.component.firePropertyChange("activeStateLocked", bl2, bl);
    }

    @Override
    public boolean isActiveStateLocked() {
        return this.activeStateLocked;
    }

    @Override
    public void setTabText(String string) {
        this.tabText = string;
    }

    @Override
    public String getTabText() {
        return this.tabText;
    }

    @Override
    public void setDockbarIcon(Icon icon) {
        this.dockbarIcon = icon;
    }

    @Override
    public Icon getDockbarIcon() {
        return this.dockbarIcon;
    }

    @Override
    public void setTabIcon(Icon icon) {
        this.tabIcon = icon;
    }

    @Override
    public Icon getTabIcon() {
        return this.tabIcon;
    }

    @Override
    public void setRegionInset(String string, float f) {
        this.regionInset.put(string, Float.valueOf(f));
    }

    @Override
    public float getRegionInset(String string) {
        Float f = this.regionInset.get(string);
        return f == null ? 0.0f : f.floatValue();
    }

    @Override
    public void setSiblingSize(String string, float f) {
        this.siblingSize.put(string, Float.valueOf(f));
    }

    @Override
    public float getSiblingSize(String string) {
        Float f = this.siblingSize.get(string);
        return f == null ? 0.0f : f.floatValue();
    }

    @Override
    public void setTerritoryBlocked(String string, boolean bl) {
        this.territoryBlocked.put(string, bl);
    }

    @Override
    public boolean isTerritoryBlocked(String string) {
        Boolean bl = this.territoryBlocked.get(string);
        return bl == null ? false : bl;
    }

    @Override
    public void setDragTheshold(float f) {
        float f2 = this.getDragThreshold();
        this.dragThreshold = f;
        this.component.firePropertyChange("dragThreshold", f2, f);
    }

    @Override
    public float getDragThreshold() {
        return this.dragThreshold;
    }

    @Override
    public void setPreviewSize(float f) {
        float f2 = this.getPreviewSize();
        this.previewSize = f;
        this.component.firePropertyChange("previewSize", f2, f);
    }

    @Override
    public float getPreviewSize() {
        return this.previewSize;
    }

    @Override
    public void setMouseMotionListenersBlockedWhileDragging(boolean bl) {
        boolean bl2 = this.isMouseMotionListenersBlockedWhileDragging();
        this.mouseMotionListenersBlockedWhileDragging = bl;
        this.component.firePropertyChange("mouseMotionListenersBlockedWhileDragging", bl2, bl);
    }

    @Override
    public boolean isMouseMotionListenersBlockedWhileDragging() {
        return this.mouseMotionListenersBlockedWhileDragging;
    }

    @Override
    public void setDockableAcceptor(IDockableAcceptor iDockableAcceptor) {
        this.dockableAcceptor = iDockableAcceptor;
    }

    @Override
    public IDockableAcceptor getDockableAcceptor() {
        return this.dockableAcceptor;
    }

    @Override
    public void dockableRegistered(DockingEvent dockingEvent) {
    }

    @Override
    public void dockableUnregistered(DockingEvent dockingEvent) {
    }

    @Override
    public void dockingCanceled(DockingEvent dockingEvent) {
    }

    @Override
    public void dockingCompleted(DockingEvent dockingEvent) {
    }

    @Override
    public void dragStarted(DockingEvent dockingEvent) {
    }

    @Override
    public void dropStarted(DockingEvent dockingEvent) {
    }

    @Override
    public void undockingStarted(DockingEvent dockingEvent) {
    }

    @Override
    public void undockingCompleted(DockingEvent dockingEvent) {
    }
}

