/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import de.javasoft.util.JavaVersion;
import java.awt.Color;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Insets;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.JTextComponent;

public class FormattedTextFieldStyle
extends StyleWrapper {
    private static FormattedTextFieldStyle instance = new FormattedTextFieldStyle();

    private FormattedTextFieldStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(jComponent) == null && ((JTextComponent)jComponent).isEditable()) {
            instance.setStyle(synthStyle);
            return instance;
        }
        FormattedTextFieldStyle formattedTextFieldStyle = new FormattedTextFieldStyle();
        formattedTextFieldStyle.setStyle(synthStyle);
        return formattedTextFieldStyle;
    }

    public Insets getInsets(SynthContext synthContext, Insets insets) {
        Insets insets2 = this.synthStyle.getInsets(synthContext, insets);
        String string = synthContext.getComponent().getName();
        if ("Spinner.formattedTextField".equals(string)) {
            if ((insets2.left > 10 || insets2.right > 10) && (JavaVersion.JAVA7 || JavaVersion.JAVA8) && SyntheticaLookAndFeel.getBoolean("Synthetica.ColorChooserPanel.workaround.enabled", null, true)) {
                this.colorChooserPanelWorkaround(synthContext);
            }
            return synthContext.getComponent().getComponentOrientation().isLeftToRight() ? new Insets(0, 0, 0, insets2.right) : new Insets(0, insets2.right, 0, 0);
        }
        if ("ComboBox.textField".equals(string)) {
            return new Insets(0, 1, 0, 1);
        }
        return insets2;
    }

    private void colorChooserPanelWorkaround(final SynthContext synthContext) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Container container;
                if (synthContext == null) {
                    return;
                }
                JComponent jComponent = synthContext.getComponent();
                if (jComponent != null && jComponent.getParent() != null && (container = jComponent.getParent().getParent()) != null && container.getClass().getName().equals("javax.swing.colorchooser.ColorChooserPanel")) {
                    try {
                        Class<?> clazz = Class.forName("javax.swing.colorchooser.ColorChooserPanel");
                        Field field = clazz.getDeclaredField("slider");
                        field.setAccessible(true);
                        JComponent jComponent2 = (JComponent)field.get(container);
                        jComponent2.setBorder(new EmptyBorder(0, 0, 0, 0));
                        field = clazz.getDeclaredField("diagram");
                        field.setAccessible(true);
                        JComponent jComponent3 = (JComponent)field.get(container);
                        jComponent3.setBorder(new EmptyBorder(0, 0, 0, 0));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
    }

    public Color getColorForState(SynthContext synthContext, ColorType colorType) {
        JComponent jComponent = synthContext.getComponent();
        if (colorType == ColorType.TEXT_FOREGROUND && jComponent.getForeground() instanceof ColorUIResource && !((JTextComponent)jComponent).isEditable()) {
            Color color = SyntheticaLookAndFeel.getColor("Synthetica.formattedTextField.locked.textColor", jComponent);
            return color == null ? super.getColorForState(synthContext, colorType) : color;
        }
        return super.getColorForState(synthContext, colorType);
    }
}

