/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggerUtils {
    public static Handler enableLogger(String string, Level level) {
        Logger logger = Logger.getLogger(string);
        logger.setLevel(level);
        Handler handler = new Handler(){

            @Override
            public void publish(LogRecord logRecord) {
                System.err.print(logRecord.getMessage());
                Object[] objectArray = logRecord.getParameters();
                if (objectArray != null) {
                    if (objectArray.length > 0) {
                        System.err.print("= ");
                    }
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        System.err.print(objectArray[i2]);
                        if (i2 >= objectArray.length - 1) continue;
                        System.err.print(", ");
                    }
                }
                System.err.println();
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        logger.addHandler(handler);
        return handler;
    }

    public static void disableLogger(String string, Handler handler) {
        Logger logger = Logger.getLogger(string);
        logger.setLevel(null);
        logger.removeHandler(handler);
    }
}

