/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util;

import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.column.ColumnMetadata;
import com.jidesoft.thirdparty.prefuse.data.tuple.TupleSet;
import com.jidesoft.thirdparty.prefuse.util.ArrayLib;
import com.jidesoft.thirdparty.prefuse.util.collections.DefaultLiteralComparator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class DataLib {
    public static Object[] toArray(Iterator iterator, String string) {
        Object[] objectArray = new Object[100];
        int n2 = 0;
        while (iterator.hasNext()) {
            if (n2 >= objectArray.length) {
                objectArray = ArrayLib.resize(objectArray, 3 * objectArray.length / 2);
            }
            objectArray[n2] = ((Tuple)iterator.next()).get(string);
            ++n2;
        }
        return ArrayLib.trim(objectArray, n2);
    }

    public static double[] toDoubleArray(Iterator iterator, String string) {
        double[] dArray = new double[100];
        int n2 = 0;
        while (iterator.hasNext()) {
            if (n2 >= dArray.length) {
                dArray = ArrayLib.resize(dArray, 3 * dArray.length / 2);
            }
            dArray[n2] = ((Tuple)iterator.next()).getDouble(string);
            ++n2;
        }
        return ArrayLib.trim(dArray, n2);
    }

    public static Object[] ordinalArray(Iterator iterator, String string) {
        return DataLib.ordinalArray(iterator, string, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Object[] ordinalArray(Iterator iterator, String string, Comparator comparator) {
        HashSet<Object> hashSet = new HashSet<Object>();
        while (iterator.hasNext()) {
            hashSet.add(((Tuple)iterator.next()).get(string));
        }
        Object[] objectArray = hashSet.toArray();
        Arrays.sort(objectArray, comparator);
        return objectArray;
    }

    public static Object[] ordinalArray(TupleSet tupleSet, String string) {
        return DataLib.ordinalArray(tupleSet, string, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Object[] ordinalArray(TupleSet tupleSet, String string, Comparator comparator) {
        if (tupleSet instanceof Table) {
            ColumnMetadata columnMetadata = ((Table)tupleSet).getMetadata(string);
            return columnMetadata.getOrdinalArray();
        }
        return DataLib.ordinalArray(tupleSet.tuples(), string, comparator);
    }

    public static Map ordinalMap(Iterator iterator, String string) {
        return DataLib.ordinalMap(iterator, string, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Map ordinalMap(Iterator iterator, String string, Comparator comparator) {
        Object[] objectArray = DataLib.ordinalArray(iterator, string, comparator);
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            hashMap.put(objectArray[i2], new Integer(i2));
        }
        return hashMap;
    }

    public static Map ordinalMap(TupleSet tupleSet, String string) {
        return DataLib.ordinalMap(tupleSet, string, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Map ordinalMap(TupleSet tupleSet, String string, Comparator comparator) {
        if (tupleSet instanceof Table) {
            ColumnMetadata columnMetadata = ((Table)tupleSet).getMetadata(string);
            return columnMetadata.getOrdinalMap();
        }
        return DataLib.ordinalMap(tupleSet.tuples(), string, comparator);
    }

    public static int count(Iterator iterator, String string) {
        int n2 = 0;
        while (iterator.hasNext()) {
            ++n2;
            iterator.next();
        }
        return n2;
    }

    public static int uniqueCount(Iterator iterator, String string) {
        HashSet<Object> hashSet = new HashSet<Object>();
        while (iterator.hasNext()) {
            hashSet.add(((Tuple)iterator.next()).get(string));
        }
        return hashSet.size();
    }

    public static Tuple min(Iterator iterator, String string) {
        return DataLib.min(iterator, string, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Tuple min(Iterator iterator, String string, Comparator comparator) {
        Tuple tuple = null;
        Object object = null;
        if (iterator.hasNext()) {
            tuple = (Tuple)iterator.next();
            object = tuple.get(string);
        }
        while (iterator.hasNext()) {
            Tuple tuple2 = (Tuple)iterator.next();
            Object object2 = tuple2.get(string);
            if (comparator.compare(object2, object) >= 0) continue;
            tuple = tuple2;
            object = object2;
        }
        return tuple;
    }

    public static Tuple min(TupleSet tupleSet, String string, Comparator comparator) {
        if (tupleSet instanceof Table) {
            Table table = (Table)tupleSet;
            ColumnMetadata columnMetadata = table.getMetadata(string);
            return table.getTuple(columnMetadata.getMinimumRow());
        }
        return DataLib.min(tupleSet.tuples(), string, comparator);
    }

    public static Tuple min(TupleSet tupleSet, String string) {
        return DataLib.min(tupleSet, string, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Tuple max(Iterator iterator, String string) {
        return DataLib.max(iterator, string, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Tuple max(Iterator iterator, String string, Comparator comparator) {
        Tuple tuple = null;
        Object object = null;
        if (iterator.hasNext()) {
            tuple = (Tuple)iterator.next();
            object = tuple.get(string);
        }
        while (iterator.hasNext()) {
            Tuple tuple2 = (Tuple)iterator.next();
            Object object2 = tuple2.get(string);
            if (comparator.compare(object2, object) <= 0) continue;
            tuple = tuple2;
            object = object2;
        }
        return tuple;
    }

    public static Tuple max(TupleSet tupleSet, String string, Comparator comparator) {
        if (tupleSet instanceof Table) {
            Table table = (Table)tupleSet;
            ColumnMetadata columnMetadata = table.getMetadata(string);
            return table.getTuple(columnMetadata.getMaximumRow());
        }
        return DataLib.max(tupleSet.tuples(), string, comparator);
    }

    public static Tuple max(TupleSet tupleSet, String string) {
        return DataLib.max(tupleSet, string, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Tuple median(Iterator iterator, String string) {
        return DataLib.median(iterator, string, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Tuple median(Iterator iterator, String string, Comparator comparator) {
        Object[] objectArray = new Tuple[100];
        int n2 = 0;
        while (iterator.hasNext()) {
            if (n2 >= objectArray.length) {
                objectArray = ArrayLib.resize(objectArray, 3 * objectArray.length / 2);
            }
            objectArray[n2] = (Tuple)iterator.next();
            ++n2;
        }
        ArrayLib.trim(objectArray, n2);
        Object[] objectArray2 = new Object[objectArray.length];
        int[] nArray = new int[objectArray.length];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            nArray[n2] = n2;
            objectArray2[n2] = ((Tuple)objectArray[n2]).get(string);
        }
        ArrayLib.sort(objectArray2, nArray, comparator);
        return (Tuple)objectArray[nArray[nArray.length / 2]];
    }

    public static Tuple median(TupleSet tupleSet, String string, Comparator comparator) {
        if (tupleSet instanceof Table) {
            Table table = (Table)tupleSet;
            ColumnMetadata columnMetadata = table.getMetadata(string);
            return table.getTuple(columnMetadata.getMedianRow());
        }
        return DataLib.median(tupleSet.tuples(), string, comparator);
    }

    public static Tuple median(TupleSet tupleSet, String string) {
        return DataLib.median(tupleSet, string, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static double mean(Iterator iterator, String string) {
        try {
            int n2 = 0;
            double d2 = 0.0;
            while (iterator.hasNext()) {
                d2 += ((Tuple)iterator.next()).getDouble(string);
                ++n2;
            }
            return d2 / (double)n2;
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public static double deviation(Iterator iterator, String string) {
        return DataLib.deviation(iterator, string, DataLib.mean(iterator, string));
    }

    public static double deviation(Iterator iterator, String string, double d2) {
        try {
            int n2 = 0;
            double d3 = 0.0;
            while (iterator.hasNext()) {
                double d4 = ((Tuple)iterator.next()).getDouble(string) - d2;
                d3 += d4 * d4;
                ++n2;
            }
            return Math.sqrt(d3 / (double)n2);
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public static double sum(Iterator iterator, String string) {
        try {
            double d2 = 0.0;
            while (iterator.hasNext()) {
                d2 += ((Tuple)iterator.next()).getDouble(string);
            }
            return d2;
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public static Class inferType(TupleSet tupleSet, String string) {
        if (tupleSet instanceof Table) {
            return ((Table)tupleSet).getColumnType(string);
        }
        Class clazz = null;
        Class clazz2 = null;
        Iterator iterator = tupleSet.tuples();
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            if (clazz == null) {
                clazz = tuple.getColumnType(string);
                continue;
            }
            clazz2 = tuple.getColumnType(string);
            if (clazz.equals(clazz2)) continue;
            if (clazz2.isAssignableFrom(clazz)) {
                clazz = clazz2;
                continue;
            }
            if (clazz.isAssignableFrom(clazz2)) continue;
            throw new IllegalArgumentException("The data field [" + string + "] does not have a consistent type across provided Tuples");
        }
        return clazz;
    }
}

