/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.expression;

import com.jidesoft.thirdparty.prefuse.data.Schema;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.expression.BinaryExpression;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.ExpressionVisitor;
import com.jidesoft.thirdparty.prefuse.data.expression.Predicate;
import com.jidesoft.thirdparty.prefuse.util.TypeLib;
import com.jidesoft.thirdparty.prefuse.util.collections.DefaultLiteralComparator;
import com.jidesoft.thirdparty.prefuse.util.collections.LiteralComparator;
import java.util.Comparator;

public class RangePredicate
extends BinaryExpression
implements Predicate {
    public static final int IN_IN = 0;
    public static final int IN_EX = 1;
    public static final int EX_IN = 2;
    public static final int EX_EX = 3;
    private Expression \u0112;
    private Comparator \u0113;

    public RangePredicate(Expression expression, Expression expression2, Expression expression3) {
        this(0, expression, expression2, expression3, DefaultLiteralComparator.getInstance());
    }

    public RangePredicate(Expression expression, Expression expression2, Expression expression3, Comparator comparator) {
        this(0, expression, expression2, expression3, comparator);
    }

    public RangePredicate(int n2, Expression expression, Expression expression2, Expression expression3) {
        this(n2, expression, expression2, expression3, DefaultLiteralComparator.getInstance());
    }

    public RangePredicate(int n2, Expression expression, Expression expression2, Expression expression3, Comparator comparator) {
        super(n2, 0, 3, expression2, expression3);
        this.\u0112 = expression;
        this.\u0113 = comparator;
    }

    public Expression getMiddleExpression() {
        return this.\u0112;
    }

    public Comparator getComparator() {
        return this.\u0113;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getBoolean(Tuple tuple) {
        int n2;
        Class clazz = this.m_left.getType(tuple.getSchema());
        Class clazz2 = this.m_right.getType(tuple.getSchema());
        Class clazz3 = this.\u0112.getType(tuple.getSchema());
        Class clazz4 = null;
        if (clazz.isAssignableFrom(clazz2)) {
            clazz4 = clazz;
        } else if (clazz2.isAssignableFrom(clazz)) {
            clazz4 = clazz2;
        }
        int n3 = 0;
        if (clazz4 != null && TypeLib.isNumericType(clazz4) && TypeLib.isNumericType(clazz3)) {
            Class clazz5 = TypeLib.getNumericType(clazz4, clazz3);
            if (clazz5 == Integer.TYPE) {
                int n4 = this.m_left.getInt(tuple);
                int n5 = this.m_right.getInt(tuple);
                int n6 = this.\u0112.getInt(tuple);
                n2 = ((LiteralComparator)this.\u0113).compare(n6, n4);
                n3 = ((LiteralComparator)this.\u0113).compare(n6, n5);
            } else if (clazz5 == Long.TYPE) {
                long l2 = this.m_left.getLong(tuple);
                long l3 = this.m_right.getLong(tuple);
                long l4 = this.\u0112.getLong(tuple);
                n2 = ((LiteralComparator)this.\u0113).compare(l4, l2);
                n3 = ((LiteralComparator)this.\u0113).compare(l4, l3);
            } else if (clazz5 == Float.TYPE) {
                float f2 = this.m_left.getFloat(tuple);
                float f3 = this.m_right.getFloat(tuple);
                float f4 = this.\u0112.getFloat(tuple);
                n2 = ((LiteralComparator)this.\u0113).compare(f4, f2);
                n3 = ((LiteralComparator)this.\u0113).compare(f4, f3);
            } else {
                if (clazz5 != Double.TYPE) throw new IllegalStateException();
                double d2 = this.m_left.getDouble(tuple);
                double d3 = this.m_right.getDouble(tuple);
                double d4 = this.\u0112.getDouble(tuple);
                n2 = ((LiteralComparator)this.\u0113).compare(d4, d2);
                n3 = ((LiteralComparator)this.\u0113).compare(d4, d3);
            }
        } else {
            Object object = this.m_left.get(tuple);
            Object object2 = this.m_right.get(tuple);
            Object object3 = this.\u0112.get(tuple);
            n2 = this.\u0113.compare(object3, object);
            n3 = this.\u0113.compare(object3, object2);
        }
        switch (this.m_op) {
            case 0: {
                if (n2 < 0) return false;
                if (n3 > 0) return false;
                return true;
            }
            case 1: {
                if (n2 < 0) return false;
                if (n3 >= 0) return false;
                return true;
            }
            case 2: {
                if (n2 <= 0) return false;
                if (n3 > 0) return false;
                return true;
            }
            case 3: {
                if (n2 <= 0) return false;
                if (n3 >= 0) return false;
                return true;
            }
        }
        throw new IllegalStateException("Unknown operation.");
    }

    @Override
    public Class getType(Schema schema) {
        return Boolean.TYPE;
    }

    @Override
    public Object get(Tuple tuple) {
        return this.getBoolean(tuple) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void visit(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visitExpression(this);
        expressionVisitor.down();
        this.m_left.visit(expressionVisitor);
        expressionVisitor.up();
        expressionVisitor.down();
        this.\u0112.visit(expressionVisitor);
        expressionVisitor.up();
        expressionVisitor.down();
        this.m_right.visit(expressionVisitor);
        expressionVisitor.up();
    }

    @Override
    protected void addChildListeners() {
        super.addChildListeners();
        this.\u0112.addExpressionListener(this);
    }

    @Override
    protected void removeChildListeners() {
        super.removeChildListeners();
        this.\u0112.removeExpressionListener(this);
    }

    public String toString() {
        String string = "?";
        String string2 = "?";
        switch (this.m_op) {
            case 0: {
                string2 = "<=";
                string = "<=";
                break;
            }
            case 1: {
                string = "<=";
                string2 = "<";
                break;
            }
            case 2: {
                string = "<";
                string2 = "<=";
                break;
            }
            case 3: {
                string2 = "<";
                string = "<";
            }
        }
        return '(' + this.m_left.toString() + ' ' + string + ' ' + this.\u0112.toString() + " AND " + this.\u0112.toString() + ' ' + string2 + ' ' + this.m_right.toString() + ')';
    }
}

