/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.column;

import com.jidesoft.thirdparty.prefuse.data.DataReadOnlyException;
import com.jidesoft.thirdparty.prefuse.data.DataTypeException;
import com.jidesoft.thirdparty.prefuse.data.column.AbstractColumn;
import java.util.Arrays;

public class FloatColumn
extends AbstractColumn {
    private float[] \u010a;
    private int \u0109;

    public FloatColumn() {
        this(0, 10, 0.0f);
    }

    public FloatColumn(int n2) {
        this(n2, n2, 0.0f);
    }

    public FloatColumn(int n2, int n3, float f2) {
        super(Float.TYPE, new Float(f2));
        if (n3 < n2) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.\u010a = new float[n3];
        Arrays.fill(this.\u010a, f2);
        this.\u0109 = n2;
    }

    @Override
    public int getRowCount() {
        return this.\u0109;
    }

    @Override
    public void setMaximumRow(int n2) {
        if (n2 > this.\u010a.length) {
            int n3 = Math.max(3 * this.\u010a.length / 2 + 1, n2);
            float[] fArray = new float[n3];
            System.arraycopy(this.\u010a, 0, fArray, 0, this.\u0109);
            Arrays.fill(fArray, this.\u0109, n3, ((Float)this.m_defaultValue).floatValue());
            this.\u010a = fArray;
        }
        this.\u0109 = n2;
    }

    @Override
    public Object get(int n2) {
        return new Float(this.getFloat(n2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object object, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (object == null) throw new DataTypeException("Column does not accept null values");
        if (object instanceof Number) {
            this.setFloat(((Number)object).floatValue(), n2);
            return;
        } else {
            if (!(object instanceof String)) throw new DataTypeException(object.getClass());
            this.setString((String)object, n2);
        }
    }

    @Override
    public float getFloat(int n2) throws DataTypeException {
        if (n2 < 0 || n2 > this.\u0109) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        return this.\u010a[n2];
    }

    @Override
    public void setFloat(float f2, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n2 < 0 || n2 >= this.\u0109) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        float f3 = this.\u010a[n2];
        if (f3 == f2) {
            return;
        }
        this.\u010a[n2] = f2;
        this.fireColumnEvent(n2, f3);
    }

    @Override
    public int getInt(int n2) throws DataTypeException {
        return (int)this.getFloat(n2);
    }

    @Override
    public long getLong(int n2) throws DataTypeException {
        return (long)this.getFloat(n2);
    }

    @Override
    public double getDouble(int n2) throws DataTypeException {
        return this.getFloat(n2);
    }
}

