/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultFocusManager;
import javax.swing.JLayeredPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupWindow {
    protected EventListenerList listenerList = new EventListenerList();
    private JWindow \u010a;
    private Container \u0103;
    private List \u0108 = new Vector();
    private List \u0106 = new Vector();
    private WindowListener \u0104;
    private ComponentListener \u0109;
    private ContainerListener \u0105;
    private MouseListener \u0102;
    private Component \u0107;
    private KeyEventDispatcher \u010b;
    private Component \u0101;

    public PopupWindow(Container container) {
        this.\u0103 = container;
        this.\u0102();
        this.\u0101();
    }

    private void \u0102() {
        Window window = this.\u0104();
        if (window != null) {
            this.\u010a = new JWindow(window);
        }
    }

    public void add(Component component) {
        this.\u0107 = component;
        this.\u0107.addPropertyChangeListener("preferredSize", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PopupWindow.this.\u010a != null) {
                    PopupWindow.this.\u010a.pack();
                }
            }
        });
        if (this.\u010a != null) {
            this.\u010a.getContentPane().add(component);
            this.\u010a.pack();
            this.\u010a.pack();
        }
    }

    public void show(Component component, int n2, int n3) {
        this.\u0101 = component;
        if (this.\u010a == null) {
            this.\u0102();
            if (this.\u010a == null) {
                return;
            }
            this.add(this.\u0107);
        }
        Point point = new Point(n2, n3);
        SwingUtilities.convertPointToScreen(point, component);
        Rectangle rectangle = PortingUtils.getScreenBounds(component);
        Dimension dimension = this.\u0107.getPreferredSize();
        int n4 = point.x + dimension.width;
        int n5 = point.y + dimension.height;
        if (point.x < rectangle.x) {
            point.x = rectangle.x;
        }
        if (n4 > rectangle.width) {
            point.x = rectangle.width - dimension.width;
        }
        if (point.y < rectangle.y) {
            point.y = rectangle.y;
        }
        if (n5 > rectangle.height) {
            point.y = rectangle.height - dimension.height;
        }
        this.\u010a.setLocation(point.x, point.y);
        this.\u010a.setSize(this.\u0107.getPreferredSize());
        this.firePopupMenuWillBecomeVisible();
        this.\u010a.setVisible(true);
        this.\u0105();
        this.\u010b = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    PopupWindow.this.hide();
                    return true;
                }
                return false;
            }
        };
        DefaultFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.\u010b);
    }

    public void hide() {
        if (this.\u0101 != null) {
            this.\u0101.requestFocus();
        }
        this.firePopupMenuWillBecomeInvisible();
        if (this.\u010a != null) {
            this.\u010a.setVisible(false);
        }
        if (this.\u010b != null) {
            DefaultFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.\u010b);
            this.\u010b = null;
        }
        this.\u0103();
        this.\u0106();
    }

    private void \u0101() {
        this.\u0104 = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PopupWindow.this.hide();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                PopupWindow.this.hide();
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                PopupWindow.this.hide();
            }
        };
        this.\u0109 = new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PopupWindow.this.hide();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                PopupWindow.this.hide();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                PopupWindow.this.hide();
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                PopupWindow.this.hide();
            }
        };
        this.\u0105 = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                PopupWindow.this.hide();
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                PopupWindow.this.hide();
            }
        };
        this.\u0102 = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PopupWindow.this.hide();
            }
        };
    }

    private void \u0106() {
        if (this.\u010a != null) {
            this.\u010a.dispose();
            this.\u010a = null;
        }
    }

    private Window \u0104() {
        Container container = this.\u0103;
        if (container == null) {
            return null;
        }
        while (!(container instanceof Window) && container.getParent() != null) {
            container = container.getParent();
        }
        if (container instanceof Window) {
            return (Window)container;
        }
        return null;
    }

    private void \u0105() {
        Container container = this.\u0103;
        while (!(container instanceof Window) && container.getParent() != null) {
            container = container.getParent();
        }
        this.\u0101(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void \u0101(Container container) {
        if (container instanceof Window) {
            ((Window)container).addWindowListener(this.\u0104);
            container.addComponentListener(this.\u0109);
            this.\u0108.add(container);
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            int n2 = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = componentArray[i2];
                if (!component.isVisible() || this.isExcludedComponent(component)) continue;
                component.addMouseListener(this.\u0102);
                this.\u0108.add(component);
                if (!(component instanceof Container)) continue;
                Container container2 = (Container)component;
                if (container2 instanceof JLayeredPane) {
                    container2.addContainerListener(this.\u0105);
                }
                this.\u0101(container2);
            }
        }
    }

    void \u0103() {
        for (Object e2 : this.\u0108) {
            Component component = (Component)e2;
            if (component instanceof Window) {
                ((Window)component).removeWindowListener(this.\u0104);
                component.removeComponentListener(this.\u0109);
            } else {
                component.removeMouseListener(this.\u0102);
            }
            if (!(component instanceof Container) || !(component instanceof JLayeredPane)) continue;
            ((Container)component).removeContainerListener(this.\u0105);
        }
        this.\u0108.clear();
    }

    public boolean isVisible() {
        return this.\u010a != null ? this.\u010a.isVisible() : false;
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(PopupMenuListener.class, popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.remove(PopupMenuListener.class, popupMenuListener);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.listenerList.getListeners(PopupMenuListener.class);
    }

    public void firePopupMenuWillBecomeVisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i2 + 1]).popupMenuWillBecomeVisible(popupMenuEvent);
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i2 + 1]).popupMenuWillBecomeInvisible(popupMenuEvent);
        }
    }

    public void firePopupMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i2 + 1]).popupMenuCanceled(popupMenuEvent);
        }
    }

    public void addAsExcludedComponents(Component component) {
        if (this.\u0106.contains(component)) {
            return;
        }
        this.\u0106.add(component);
    }

    public void removeFromExcludedComponents(Component component) {
        if (!this.\u0106.contains(component)) {
            return;
        }
        this.\u0106.remove(component);
    }

    public boolean isExcludedComponent(Component component) {
        return this.\u0106.contains(component);
    }
}

