/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class AutoResizingTextArea
extends JTextArea {
    public static final int DEFAULT_MAX_ROWS = 20;
    public static final int DEFAULT_MIN_ROWS = 1;
    private int \u0103;
    private int \u0102;
    private A \u0101;

    public AutoResizingTextArea() {
        this(1, 20);
    }

    public AutoResizingTextArea(int n2) {
        this(n2, 20);
    }

    public AutoResizingTextArea(int n2, int n3) {
        this.setMinRows(n2);
        this.setMaxRows(n3);
        this.setRows(n2);
    }

    public AutoResizingTextArea(String string) {
        this();
        this.setText(string);
    }

    public AutoResizingTextArea(int n2, int n3, int n4) {
        this(n2, n3);
        this.setMinRows(n2);
        this.setMaxRows(n3);
        this.setColumns(n4);
    }

    public AutoResizingTextArea(String string, int n2, int n3, int n4) {
        this(n2, n3, n4);
        this.setText(string);
    }

    public AutoResizingTextArea(Document document) {
        this();
        this.setDocument(document);
    }

    public AutoResizingTextArea(Document document, String string, int n2, int n3, int n4) {
        super(document, string, n2, n4);
        this.setMaxRows(n3);
        this.setMinRows(n2);
    }

    @Override
    public void setRows(int n2) {
        int n3 = super.getRows();
        int n4 = this.\u0101(n2);
        super.setRows(n4);
        this.numberOfRowsUpdated(n3, n4);
    }

    protected void numberOfRowsUpdated(int n2, int n3) {
        Container container;
        JScrollPane jScrollPane = this.\u0101();
        if (jScrollPane != null && (container = jScrollPane.getParent()) != null && container instanceof JComponent) {
            JComponent jComponent = (JComponent)container;
            jComponent.revalidate();
        }
    }

    public int getMaxRows() {
        return this.\u0103;
    }

    public void setMaxRows(int n2) {
        this.\u0103 = n2;
        this.setRows(this.\u0101(this.getRows()));
    }

    public int getMinRows() {
        return this.\u0102;
    }

    public void setMinRows(int n2) {
        this.\u0102 = n2;
        this.setRows(this.\u0101(this.getRows()));
    }

    @Override
    public void setDocument(Document document) {
        Document document2 = this.getDocument();
        if (document2 != null && this.\u0101 != null) {
            document2.removeDocumentListener(this.\u0101);
        }
        super.setDocument(document);
        if (document != null) {
            if (this.\u0101 == null) {
                this.\u0101 = new A();
            }
            document.addDocumentListener(this.\u0101);
        }
        this.\u0102();
    }

    private int \u0101(int n2) {
        int n3 = Math.min(this.\u0103, n2);
        n3 = Math.max(this.\u0102, n3);
        return n3;
    }

    private int \u0102(int n2) {
        Insets insets = this.getInsets();
        return n2 * this.getRowHeight() + insets.top + insets.bottom;
    }

    private void \u0102() {
        JScrollPane jScrollPane = this.\u0101();
        if (jScrollPane != null && jScrollPane.getParent() instanceof JComponent) {
            JComponent jComponent = (JComponent)jScrollPane.getParent();
            jComponent.revalidate();
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.getPreferredSize();
        if (this.getMinRows() != 0 && this.getMaxRows() != 0) {
            dimension.height = Math.max(this.\u0102(this.getMinRows()), Math.min(this.\u0102(this.getMaxRows()), dimension.height));
        }
        return dimension;
    }

    private JScrollPane \u0101() {
        Container container = this.getParent();
        if (container != null && container instanceof JViewport) {
            return (JScrollPane)container.getParent();
        }
        return null;
    }

    private class A
    implements DocumentListener {
        private A() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            AutoResizingTextArea.this.\u0102();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            AutoResizingTextArea.this.\u0102();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            AutoResizingTextArea.this.\u0102();
        }
    }
}

