/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.status;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.status.LabelStatusBarItem;
import com.jidesoft.swing.NullLabel;
import com.jidesoft.utils.SystemInfo;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class ResizeStatusBarItem
extends LabelStatusBarItem {
    private boolean \u011b;
    private boolean \u011d = !SystemInfo.isJdk6Above();
    private B \u011c;

    public ResizeStatusBarItem() {
        this("RESIZE");
    }

    public ResizeStatusBarItem(String string) {
        this(string, true);
    }

    public ResizeStatusBarItem(boolean bl) {
        this("RESIZE", bl);
    }

    public ResizeStatusBarItem(String string, boolean bl) {
        super(string);
        this.setPreferredWidth(18);
        this.\u011b = bl;
        this.\u0101(this.getComponent());
    }

    @Override
    protected JLabel createLabel() {
        return new NullLabel(new A());
    }

    private void \u0101(Component component) {
        if (this.\u011b) {
            ResizableMouseInputAdapter resizableMouseInputAdapter = new ResizableMouseInputAdapter();
            component.addMouseListener(resizableMouseInputAdapter);
            component.addMouseMotionListener(resizableMouseInputAdapter);
        }
    }

    @Override
    protected void configureLabel(JLabel jLabel) {
        jLabel.setHorizontalTextPosition(0);
        jLabel.setVerticalTextPosition(0);
    }

    protected boolean isResizable() {
        Container container = this.getTopLevelAncestor();
        boolean bl = true;
        if (container instanceof Frame) {
            bl = ((Frame)container).isResizable() && ((Frame)container).getExtendedState() == 0;
        }
        return bl;
    }

    public void setStopRepaintDuringResizing(boolean bl) {
        this.\u011d = bl;
    }

    class B
    extends EventQueue {
        boolean \u0102;

        B() {
        }

        public synchronized void \u0101(boolean bl) {
            this.\u0102 = bl;
        }

        @Override
        public void dispatchEvent(AWTEvent aWTEvent) {
            if (!(this.\u0102 && aWTEvent.getID() == 800 || this.\u0102 && aWTEvent.getID() == 101)) {
                super.dispatchEvent(aWTEvent);
            }
        }
    }

    public class ResizableMouseInputAdapter
    extends MouseInputAdapter {
        private Rectangle \u0107;
        private int \u0105;
        private int \u0104;
        private int \u0106;
        protected static final int RESIZE_NONE = 0;
        private boolean \u0103 = false;
        private Container \u0102;

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!ResizeStatusBarItem.this.isResizable()) {
                return;
            }
            if (!(mouseEvent.getSource() instanceof JComponent)) {
                return;
            }
            this.\u0102 = ((JComponent)mouseEvent.getSource()).getTopLevelAncestor();
            this.\u0107 = new Rectangle(this.\u0102.getLocationOnScreen(), this.\u0102.getSize());
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
            this.\u0105 = point.x;
            this.\u0104 = point.y;
            this.\u0106 = 16;
            Cursor cursor = Cursor.getDefaultCursor();
            switch (this.\u0106) {
                case 32: {
                    cursor = Cursor.getPredefinedCursor(9);
                    break;
                }
                case 2: {
                    cursor = Cursor.getPredefinedCursor(8);
                    break;
                }
                case 128: {
                    cursor = Cursor.getPredefinedCursor(10);
                    break;
                }
                case 8: {
                    cursor = Cursor.getPredefinedCursor(11);
                    break;
                }
                case 16: {
                    cursor = Cursor.getPredefinedCursor(5);
                    break;
                }
                case 64: {
                    cursor = Cursor.getPredefinedCursor(4);
                    break;
                }
                case 1: {
                    cursor = Cursor.getPredefinedCursor(6);
                    break;
                }
                case 4: {
                    cursor = Cursor.getPredefinedCursor(7);
                }
            }
            Container container = this.\u0102;
            if (container instanceof JFrame) {
                ((JFrame)container).getGlassPane().setVisible(true);
                ((JFrame)container).getGlassPane().setCursor(cursor);
            } else if (container instanceof JApplet) {
                ((JApplet)container).getGlassPane().setVisible(true);
                ((JApplet)container).getGlassPane().setCursor(cursor);
            } else if (container instanceof JWindow) {
                ((JWindow)container).getGlassPane().setVisible(true);
                ((JWindow)container).getGlassPane().setCursor(cursor);
            } else if (container instanceof JDialog) {
                ((JDialog)container).getGlassPane().setVisible(true);
                ((JDialog)container).getGlassPane().setCursor(cursor);
            }
            if (ResizeStatusBarItem.this.\u011d) {
                if (ResizeStatusBarItem.this.\u011c == null) {
                    ResizeStatusBarItem.this.\u011c = new B();
                    Toolkit.getDefaultToolkit().getSystemEventQueue().push(ResizeStatusBarItem.this.\u011c);
                }
                ResizeStatusBarItem.this.\u011c.\u0101(true);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n2;
            int n3;
            if (this.\u0107 == null) {
                return;
            }
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            Component component = (Component)mouseEvent.getSource();
            SwingUtilities.convertPointToScreen(point, component);
            int n4 = this.\u0105 - point.x;
            int n5 = this.\u0104 - point.y;
            Dimension dimension = this.\u0102.getMinimumSize();
            Dimension dimension2 = this.\u0102.getMaximumSize();
            Rectangle rectangle = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            switch (this.\u0106) {
                case 0: {
                    return;
                }
                case 16: {
                    if (this.\u0107.width - n4 < dimension.width) {
                        n4 = this.\u0107.width - dimension.width;
                    } else if (this.\u0107.width - n4 > dimension2.width) {
                        n4 = -(dimension2.width - this.\u0107.width);
                    }
                    if (this.\u0107.x + this.\u0107.width - n4 > rectangle.width) {
                        n4 = this.\u0107.x + this.\u0107.width - rectangle.width;
                    }
                    if (this.\u0107.height - n5 < dimension.height) {
                        n5 = this.\u0107.height - dimension.height;
                    } else if (this.\u0107.height - n5 > dimension2.height) {
                        n5 = -(dimension2.height - this.\u0107.height);
                    }
                    if (this.\u0107.y + this.\u0107.height - n5 > rectangle.height) {
                        n5 = this.\u0107.y + this.\u0107.height - rectangle.height;
                    }
                    n3 = this.\u0107.width - n4;
                    n2 = this.\u0107.height - n5;
                    break;
                }
                default: {
                    return;
                }
            }
            Dimension dimension3 = new Dimension(n3, n2);
            this.\u0102.setSize(dimension3);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!ResizeStatusBarItem.this.isResizable()) {
                return;
            }
            if (ResizeStatusBarItem.this.\u011d) {
                ResizeStatusBarItem.this.\u011c.\u0101(false);
            }
            this.\u0107 = null;
            if (this.\u0103) {
                this.\u0103 = false;
                return;
            }
            if (this.\u0106 != 0) {
                Container container = this.\u0102;
                if (container instanceof JFrame) {
                    ((JFrame)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JFrame)container).getGlassPane().setVisible(false);
                } else if (container instanceof JApplet) {
                    ((JApplet)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JApplet)container).getGlassPane().setVisible(false);
                } else if (container instanceof JWindow) {
                    ((JWindow)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JWindow)container).getGlassPane().setVisible(false);
                } else if (container instanceof JDialog) {
                    ((JDialog)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JDialog)container).getGlassPane().setVisible(false);
                }
                if (ResizeStatusBarItem.this.\u011d) {
                    Dimension dimension = this.\u0102.getSize();
                    --dimension.width;
                    --dimension.height;
                    this.\u0102.setSize(dimension);
                }
                this.\u0105 = 0;
                this.\u0104 = 0;
                this.\u0107 = null;
                this.\u0106 = 0;
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (ResizeStatusBarItem.this.isResizable()) {
                ((Component)mouseEvent.getSource()).setCursor(Cursor.getPredefinedCursor(5));
            } else {
                ((Component)mouseEvent.getSource()).setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ((Component)mouseEvent.getSource()).setCursor(Cursor.getDefaultCursor());
        }
    }

    private class A
    implements Icon {
        private static final int \u0102 = 12;
        private static final int \u0103 = 12;

        @Override
        public int getIconHeight() {
            return 12;
        }

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Object object = UIDefaultsLookup.get("StatusBar.paintResizableIcon");
            boolean bl = ResizeStatusBarItem.this.isResizable();
            if (bl && (!(object instanceof Boolean) || ((Boolean)object).booleanValue())) {
                int n4 = 6;
                int n5 = 6;
                int n6 = 4;
                int n7 = 4;
                int n8 = n4 + n6;
                int n9 = n5 + n7;
                int n10 = n8 + n6;
                int n11 = n9 + n7;
                Color color = graphics.getColor();
                graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                this.\u0101(graphics, n5 + 1, n10 + 1);
                this.\u0101(graphics, n9 + 1, n8 + 1);
                this.\u0101(graphics, n9 + 1, n10 + 1);
                this.\u0101(graphics, n11 + 1, n4 + 1);
                this.\u0101(graphics, n11 + 1, n8 + 1);
                this.\u0101(graphics, n11 + 1, n10 + 1);
                graphics.setColor(UIDefaultsLookup.getColor("controlShadow"));
                this.\u0101(graphics, n5, n10);
                this.\u0101(graphics, n9, n8);
                this.\u0101(graphics, n9, n10);
                this.\u0101(graphics, n11, n4);
                this.\u0101(graphics, n11, n8);
                this.\u0101(graphics, n11, n10);
                graphics.setColor(color);
            }
        }

        private void \u0101(Graphics graphics, int n2, int n3) {
            graphics.fillRect(n2, n3, 2, 2);
        }
    }
}

