/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.Range;
import java.math.BigDecimal;

public class BigDecimalRange
extends AbstractRange<BigDecimal> {
    protected BigDecimal _min;
    protected BigDecimal _max;
    private static final BigDecimal \u0107 = new BigDecimal(2);

    public BigDecimalRange() {
        this(BigDecimal.ZERO, BigDecimal.ONE);
    }

    public BigDecimalRange(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        boolean bl = bigDecimal.compareTo(bigDecimal2) < 0;
        this._min = bl ? bigDecimal : bigDecimal2;
        this._max = bl ? bigDecimal2 : bigDecimal;
    }

    public BigDecimalRange(BigDecimalRange bigDecimalRange) {
        this(bigDecimalRange.getMin(), bigDecimalRange.getMax());
    }

    @Override
    public Range<BigDecimal> copy() {
        return new BigDecimalRange(this);
    }

    @Override
    public double minimum() {
        return this._min.doubleValue();
    }

    @Override
    public double maximum() {
        return this._max.doubleValue();
    }

    public BigDecimal getMin() {
        return this._min;
    }

    public void setMin(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this._min;
        if (bigDecimal2 != null && bigDecimal2.equals(bigDecimal)) {
            return;
        }
        assert (bigDecimal.compareTo(this._max) <= 0);
        this._min = bigDecimal;
        this.firePropertyChange("min", bigDecimal2, bigDecimal);
    }

    public BigDecimal getMax() {
        return this._max;
    }

    public void setMax(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this._max;
        if (bigDecimal2 != null && bigDecimal2.equals(bigDecimal)) {
            return;
        }
        assert (bigDecimal.compareTo(this._min) >= 0);
        this._max = bigDecimal;
        this.firePropertyChange("max", bigDecimal2, bigDecimal);
    }

    @Override
    public double size() {
        return this._max.subtract(this._min).doubleValue();
    }

    @Override
    public BigDecimal lower() {
        return this.getMin();
    }

    @Override
    public void adjust(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        double d2 = this.size();
        if (bigDecimal != null) {
            this.setMin(bigDecimal);
        } else if (bigDecimal2 != null) {
            this.setMin(bigDecimal2.add(new BigDecimal(d2)));
        }
        if (bigDecimal2 != null) {
            this.setMax(bigDecimal2);
        } else if (bigDecimal != null) {
            this.setMin(bigDecimal.add(new BigDecimal(d2)));
        }
    }

    @Override
    public BigDecimal upper() {
        return this.getMax();
    }

    @Override
    public boolean contains(BigDecimal bigDecimal) {
        return bigDecimal != null && bigDecimal.compareTo(this._min) >= 0 && bigDecimal.compareTo(this._max) <= 0;
    }

    public BigDecimalRange stretch(double d2) {
        return this.stretch(d2, d2);
    }

    public BigDecimalRange stretch(double d2, double d3) {
        BigDecimal bigDecimal = this._max.add(this._min).divide(\u0107);
        BigDecimal bigDecimal2 = this._max.subtract(this._min).divide(\u0107);
        return new BigDecimalRange(bigDecimal.subtract(bigDecimal2.multiply(new BigDecimal(d2))), bigDecimal.add(bigDecimal2.multiply(new BigDecimal(d3))));
    }

    @Override
    public Range<BigDecimal> createIntermediate(Range<BigDecimal> range, double d2) {
        throw new UnsupportedOperationException("createIntermediate method is not currently support in BigDecimalRange");
    }

    public boolean equals(Object object) {
        if (object instanceof BigDecimalRange) {
            BigDecimalRange bigDecimalRange = (BigDecimalRange)object;
            return this._min.equals(bigDecimalRange._min) && this._max.equals(bigDecimalRange._max);
        }
        return false;
    }

    public int hashCode() {
        return this._max.multiply(new BigDecimal(29)).add(this._min).intValue();
    }

    public String toString() {
        return String.format("#<BigDecimalRange min=%f max=%f>", this._min, this._max);
    }
}

