/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.gantt.GanttChart;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.gantt.GanttEntryRelation;
import com.jidesoft.grid.Expandable;
import com.jidesoft.plaf.GanttEntryRelationPainter;
import com.jidesoft.range.Range;
import com.jidesoft.scale.ScaleModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.UIManager;

public class BasicGanttEntryRelationPainter
implements GanttEntryRelationPainter {
    private static final String \u0110 = "GanttChart.markInvalidRelations";
    private static final AffineTransform \u010f = AffineTransform.getScaleInstance(-1.0, 1.0);
    private static final boolean \u0105 = false;
    private Stroke \u0103;
    private boolean \u0108;
    private Shape \u0114;
    private Shape \u0102;
    private int \u0106;
    private Stroke \u0107;
    private Paint \u010a;
    private Stroke \u010e;
    private Paint \u0111;
    private Stroke \u0109;
    private Paint \u010d;
    private Paint \u0104;
    private Stroke \u0101;
    private Paint \u0115;
    private Paint \u0112;
    private Insets \u010c;
    private Insets \u010b;

    public BasicGanttEntryRelationPainter(int n2) {
        this(n2, null, null, new Insets(0, 6, 0, 6));
    }

    public BasicGanttEntryRelationPainter(int n2, Shape shape, Shape shape2, Insets insets) {
        this.setConnectToParent(true);
        this.setWidth(n2);
        this.setStartShape(shape);
        this.setEndShape(shape2);
        if (insets == null) {
            throw new IllegalArgumentException("entryPadding should not be null!");
        }
        this.setGroupOffset(insets);
        this.setMilestoneOffset(insets);
        this.setLineStroke(new BasicStroke());
        Object object = UIManager.getDefaults().get("GanttChart.relationLinePaint");
        if (object instanceof Paint) {
            this.setLinePaint((Paint)object);
        } else {
            this.setLinePaint(Color.BLACK);
        }
        this.setInvalidLineStroke(new BasicStroke());
        Object object2 = UIManager.getDefaults().get("GanttChart.invalidLinePaint");
        if (object2 instanceof Paint) {
            this.setInvalidLinePaint((Paint)object2);
        } else {
            this.setInvalidLinePaint(Color.RED);
        }
        this.setStartShapeStroke(new BasicStroke());
        Object object3 = UIManager.getDefaults().get("GanttChart.startShapeOutlinePaint");
        if (object3 instanceof Paint) {
            this.setStartShapeOutlinePaint((Paint)object3);
        } else {
            this.setStartShapeOutlinePaint(Color.BLACK);
        }
        Object object4 = UIManager.getDefaults().get("GanttChart.startShapeFillPaint");
        if (object4 instanceof Paint) {
            this.setStartShapeFillPaint((Paint)object4);
        } else {
            this.setStartShapeFillPaint(Color.BLACK);
        }
        this.setEndShapeStroke(new BasicStroke());
        Object object5 = UIManager.getDefaults().get("GanttChart.endShapeOutlinePaint");
        if (object5 instanceof Paint) {
            this.setEndShapeOutlinePaint((Paint)object5);
        } else {
            this.setEndShapeOutlinePaint(Color.BLACK);
        }
        Object object6 = UIManager.getDefaults().get("GanttChart.endShapeFillPaint");
        if (object6 instanceof Paint) {
            this.setEndShapeFillPaint((Paint)object6);
        } else {
            this.setEndShapeFillPaint(Color.BLACK);
        }
        this.setInvisibleStroke(new BasicStroke(1.0f, 2, 2, 10.0f, new float[]{4.0f, 4.0f}, 0.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintRelation(Graphics graphics, GanttChart<Object, GanttEntry<Object>> ganttChart, GanttEntryRelation<GanttEntry<Object>> ganttEntryRelation, boolean bl, boolean bl2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            Rectangle rectangle;
            int n2 = ganttEntryRelation.getRelationType();
            boolean bl3 = n2 == 4 || n2 == 2;
            boolean bl4 = n2 == 1 || n2 == 2;
            boolean bl5 = this.isRelationValid(ganttChart, ganttEntryRelation);
            int n3 = this.getIndexOf(ganttChart, ganttEntryRelation.getPredecessorEntry());
            int n4 = this.getIndexOf(ganttChart, ganttEntryRelation.getSuccessorEntry());
            if (n3 == -1 && n4 == -1 || n3 == n4 && (ganttChart.getIndexOf(ganttEntryRelation.getPredecessorEntry()) != n3 || ganttChart.getIndexOf(ganttEntryRelation.getSuccessorEntry()) != n4)) {
                return;
            }
            Rectangle rectangle2 = n3 != -1 ? ganttChart.getEntryRect(ganttChart.getEntryAt(n3), n3) : null;
            Rectangle rectangle3 = rectangle = n4 != -1 ? ganttChart.getEntryRect(ganttChart.getEntryAt(n4), n4) : null;
            if (rectangle2 == null && rectangle == null) {
                return;
            }
            if (rectangle2 == null) {
                Point2D point2D = this.getAttachPoint(graphics2D, ganttChart, rectangle, n4, bl4);
                Point2D point2D2 = this.getEndPoint(graphics2D, ganttChart, point2D, bl4, this.getWidth() * 2);
                this.paintLine(graphics2D, new Line2D.Double(point2D, point2D2), bl5, this.getInvisibleStroke(), this.getLinePaint(), this.getInvalidLineStroke(), this.getInvalidLinePaint());
                this.paintShape(graphics2D, ganttChart, point2D, this.transformShape(graphics2D, ganttChart, this.getEndShape(), point2D2.getX() - point2D.getX() >= 0.0), this.getEndShapeStroke(), this.getEndShapeOutlinePaint(), this.getEndShapeFillPaint());
            } else if (rectangle == null) {
                Point2D point2D = this.getAttachPoint(graphics2D, ganttChart, rectangle2, n3, bl3);
                Point2D point2D3 = this.getEndPoint(graphics2D, ganttChart, point2D, bl3, this.getWidth() * 2);
                this.paintLine(graphics2D, new Line2D.Double(point2D, point2D3), bl5, this.getInvisibleStroke(), this.getLinePaint(), this.getInvalidLineStroke(), this.getInvalidLinePaint());
                this.paintShape(graphics2D, ganttChart, point2D, this.transformShape(graphics2D, ganttChart, this.getStartShape(), point2D3.getX() - point2D.getX() >= 0.0), this.getStartShapeStroke(), this.getStartShapeOutlinePaint(), this.getStartShapeFillPaint());
            } else {
                Point2D point2D = this.getAttachPoint(graphics2D, ganttChart, rectangle2, n3, bl3);
                Point2D point2D4 = this.getEndPoint(graphics2D, ganttChart, point2D, bl3, this.getWidth());
                Point2D point2D5 = this.getAttachPoint(graphics2D, ganttChart, rectangle, n4, bl4);
                Point2D point2D6 = this.getEndPoint(graphics2D, ganttChart, point2D5, bl4, this.getWidth());
                boolean bl6 = point2D4.getX() - point2D.getX() >= 0.0;
                Point2D point2D7 = this.getRowBoundaryPoint(graphics2D, ganttChart, rectangle2, n3, point2D4, rectangle, n4, point2D6, n2, bl6);
                boolean bl7 = point2D6.getX() - point2D5.getX() >= 0.0;
                Point2D point2D8 = this.getRowBoundaryPoint(graphics2D, ganttChart, rectangle, n4, point2D6, rectangle2, n3, point2D4, n2, bl7);
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
                generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
                generalPath.lineTo((float)point2D7.getX(), (float)point2D7.getY());
                generalPath.lineTo((float)point2D8.getX(), (float)point2D8.getY());
                generalPath.lineTo((float)point2D6.getX(), (float)point2D6.getY());
                generalPath.lineTo((float)point2D5.getX(), (float)point2D5.getY());
                this.paintLine(graphics2D, generalPath, bl5, this.getLineStroke(), this.getLinePaint(), this.getInvalidLineStroke(), this.getInvalidLinePaint());
                this.paintShape(graphics2D, ganttChart, point2D, this.transformShape(graphics2D, ganttChart, this.getStartShape(), bl6), this.getStartShapeStroke(), this.getStartShapeOutlinePaint(), this.getStartShapeFillPaint());
                this.paintShape(graphics2D, ganttChart, point2D5, this.transformShape(graphics2D, ganttChart, this.getEndShape(), bl7), this.getEndShapeStroke(), this.getEndShapeOutlinePaint(), this.getEndShapeFillPaint());
            }
        }
        finally {
            graphics2D.dispose();
        }
    }

    protected void paintLine(Graphics2D graphics2D, Shape shape, boolean bl, Stroke stroke, Paint paint, Stroke stroke2, Paint paint2) {
        Stroke stroke3 = graphics2D.getStroke();
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(shape);
        if (!bl) {
            graphics2D.setStroke(stroke2);
            graphics2D.setPaint(paint2);
            graphics2D.draw(shape);
        }
        graphics2D.setStroke(stroke3);
    }

    protected boolean isRelationValid(GanttChart<Object, GanttEntry<Object>> ganttChart, GanttEntryRelation<GanttEntry<Object>> ganttEntryRelation) {
        if (!UIManager.getBoolean(\u0110)) {
            return true;
        }
        GanttEntry<Object> ganttEntry = ganttEntryRelation.getPredecessorEntry();
        GanttEntry<Object> ganttEntry2 = ganttEntryRelation.getSuccessorEntry();
        if (ganttEntry == null || ganttEntry2 == null || !this.checkValidRange(ganttEntry.getRange()) || !this.checkValidRange(ganttEntry2.getRange())) {
            return false;
        }
        Range<Object> range = ganttEntry.getRange();
        if (range == null) {
            return false;
        }
        ScaleModel<Object> scaleModel = ganttChart.getScaleArea().getScaleModel();
        switch (ganttEntryRelation.getRelationType()) {
            case 3: {
                return scaleModel.getPosition(range.upper()) <= scaleModel.getPosition(ganttEntry2.getRange().upper());
            }
            case 1: {
                return scaleModel.getPosition(range.upper()) <= scaleModel.getPosition(ganttEntry2.getRange().lower());
            }
            case 4: {
                return scaleModel.getPosition(range.lower()) <= scaleModel.getPosition(ganttEntry2.getRange().upper());
            }
            case 2: {
                return scaleModel.getPosition(range.lower()) <= scaleModel.getPosition(ganttEntry2.getRange().lower());
            }
        }
        return false;
    }

    protected boolean checkValidRange(Range<?> range) {
        return range != null && range.lower() != null && range.upper() != null;
    }

    protected int getIndexOf(GanttChart<Object, GanttEntry<Object>> ganttChart, GanttEntry<Object> ganttEntry) {
        int n2;
        Expandable expandable = ganttEntry;
        do {
            n2 = ganttChart.getIndexOf((GanttEntry<Object>)expandable);
            expandable = expandable.getParent();
        } while (n2 == -1 && this.isConnectToParent() && expandable instanceof GanttEntry && expandable.getParent() != expandable);
        return n2;
    }

    protected void paintShape(Graphics2D graphics2D, GanttChart<Object, GanttEntry<Object>> ganttChart, Point2D point2D, Shape shape, Stroke stroke, Paint paint, Paint paint2) {
        if (shape != null) {
            graphics2D.translate(point2D.getX(), point2D.getY());
            if (paint2 != null) {
                graphics2D.setPaint(paint2);
            }
            graphics2D.fill(shape);
            if (paint != null) {
                if (stroke != null) {
                    graphics2D.setStroke(stroke);
                }
                graphics2D.setPaint(paint);
                graphics2D.draw(shape);
            }
            graphics2D.translate(-point2D.getX(), -point2D.getY());
        }
    }

    protected Shape transformShape(Graphics2D graphics2D, GanttChart<Object, GanttEntry<Object>> ganttChart, Shape shape, boolean bl) {
        if (shape == null) {
            return null;
        }
        if (bl) {
            return shape;
        }
        return \u010f.createTransformedShape(shape);
    }

    protected Point2D getEndPoint(Graphics2D graphics2D, GanttChart<Object, GanttEntry<Object>> ganttChart, Point2D point2D, boolean bl, double d2) {
        Point2D point2D2 = (Point2D)point2D.clone();
        boolean bl2 = ganttChart.getComponentOrientation().isLeftToRight();
        if (bl2 && bl || !bl2 && !bl) {
            point2D2.setLocation(point2D2.getX() - d2, point2D2.getY());
        } else {
            point2D2.setLocation(point2D2.getX() + d2, point2D2.getY());
        }
        return point2D2;
    }

    protected Point2D getRowBoundaryPoint(Graphics2D graphics2D, GanttChart<Object, GanttEntry<Object>> ganttChart, Rectangle rectangle, int n2, Point2D point2D, Rectangle rectangle2, int n3, Point2D point2D2, int n4, boolean bl) {
        Point2D point2D3 = (Point2D)point2D.clone();
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        boolean bl2 = ganttChart.getComponentOrientation().isLeftToRight();
        boolean bl3 = point2D.getX() < point2D2.getX();
        boolean bl4 = point2D.getY() < point2D2.getY();
        boolean bl5 = false;
        boolean bl6 = false;
        switch (n4) {
            case 2: 
            case 3: {
                bl6 = bl3 == bl;
                break;
            }
            case 1: 
            case 4: {
                boolean bl7 = bl5 = bl3 != bl4 && bl4 == bl || bl3 == bl4 && bl3 != bl;
                if (bl2) {
                    bl6 = bl3 && bl;
                    break;
                }
                bl6 = !bl3 && !bl;
                break;
            }
            default: {
                assert (false) : "Unknown relation type: " + n4;
                break;
            }
        }
        if (bl6) {
            d2 = point2D2.getX();
        }
        if (bl5) {
            d3 = bl4 ? (bl6 ? rectangle2.getY() : rectangle.getMaxY() - 1.0) : (bl6 ? rectangle.getY() : rectangle2.getMaxY() - 1.0);
        }
        point2D3.setLocation(d2, d3);
        return point2D3;
    }

    protected Point2D getAttachPoint(Graphics2D graphics2D, GanttChart<Object, GanttEntry<Object>> ganttChart, Rectangle rectangle, int n2, boolean bl) {
        Point point = rectangle.getLocation();
        boolean bl2 = ganttChart.getEntryAt(n2).hasChildren();
        boolean bl3 = rectangle.width <= 1;
        boolean bl4 = ganttChart.getComponentOrientation().isLeftToRight();
        if (bl4 && !bl || !bl4 && bl) {
            point.x += rectangle.width;
            if (bl2) {
                point.x = bl4 ? (point.x += this.getGroupOffSet().right) : (point.x += this.getGroupOffSet().left);
            } else if (bl3) {
                point.x = bl4 ? (point.x += this.getMilestoneOffSet().right) : (point.x += this.getMilestoneOffSet().left);
            }
        } else {
            --point.x;
            if (bl2) {
                point.x = bl4 ? (point.x -= this.getGroupOffSet().left) : (point.x -= this.getGroupOffSet().right);
            } else if (bl3) {
                point.x = bl4 ? (point.x -= this.getMilestoneOffSet().left) : (point.x -= this.getMilestoneOffSet().right);
            }
        }
        point.y = bl2 ? (int)((double)point.y + (double)rectangle.height / 3.0) : (int)((double)point.y + (double)rectangle.height / 2.0);
        return point;
    }

    public void setConnectToParent(boolean bl) {
        this.\u0108 = bl;
    }

    public boolean isConnectToParent() {
        return this.\u0108;
    }

    public Stroke getInvisibleStroke() {
        return this.\u0103;
    }

    public void setInvisibleStroke(Stroke stroke) {
        this.\u0103 = stroke;
    }

    public Shape getStartShape() {
        return this.\u0114;
    }

    public void setStartShape(Shape shape) {
        this.\u0114 = shape;
    }

    public Shape getEndShape() {
        return this.\u0102;
    }

    public void setEndShape(Shape shape) {
        this.\u0102 = shape;
    }

    public int getWidth() {
        return this.\u0106;
    }

    public void setWidth(int n2) {
        this.\u0106 = n2;
    }

    public Stroke getLineStroke() {
        return this.\u0107;
    }

    public void setLineStroke(Stroke stroke) {
        this.\u0107 = stroke;
    }

    public Paint getLinePaint() {
        return this.\u010a;
    }

    public void setLinePaint(Paint paint) {
        this.\u010a = paint;
    }

    public Paint getInvalidLinePaint() {
        return this.\u0111;
    }

    public void setInvalidLinePaint(Paint paint) {
        this.\u0111 = paint;
    }

    public Stroke getInvalidLineStroke() {
        return this.\u010e;
    }

    public void setInvalidLineStroke(Stroke stroke) {
        this.\u010e = stroke;
    }

    public Stroke getStartShapeStroke() {
        return this.\u0109;
    }

    public void setStartShapeStroke(Stroke stroke) {
        this.\u0109 = stroke;
    }

    public Paint getStartShapeOutlinePaint() {
        return this.\u010d;
    }

    public void setStartShapeOutlinePaint(Paint paint) {
        this.\u010d = paint;
    }

    public Paint getStartShapeFillPaint() {
        return this.\u0104;
    }

    public void setStartShapeFillPaint(Paint paint) {
        this.\u0104 = paint;
    }

    public Stroke getEndShapeStroke() {
        return this.\u0101;
    }

    public void setEndShapeStroke(Stroke stroke) {
        this.\u0101 = stroke;
    }

    public Paint getEndShapeOutlinePaint() {
        return this.\u0115;
    }

    public void setEndShapeOutlinePaint(Paint paint) {
        this.\u0115 = paint;
    }

    public Paint getEndShapeFillPaint() {
        return this.\u0112;
    }

    public void setEndShapeFillPaint(Paint paint) {
        this.\u0112 = paint;
    }

    public Insets getGroupOffSet() {
        return this.\u010c;
    }

    public void setGroupOffset(Insets insets) {
        this.\u010c = insets;
    }

    public Insets getMilestoneOffSet() {
        return this.\u010b;
    }

    public void setMilestoneOffset(Insets insets) {
        this.\u010b = insets;
    }
}

