/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AbstractExpandable;
import com.jidesoft.grid.CachedTableModel;
import com.jidesoft.grid.DefaultTableModelWrapper;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.ITreeTableModel;
import com.jidesoft.grid.IndexedRowTableModelWrapper;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperImpl;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.WrappedRow;
import com.jidesoft.grid.WrapperOfIndexdRowTableModelWrapper;
import com.jidesoft.swing.JideSwingUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;

public class TreeTableUtils {
    public static int getChildrenCount(TableModel tableModel, Row row) {
        return TreeTableUtils.getChildren(tableModel, row).size();
    }

    public static int getChildIndex(TableModel tableModel, Row row, Row row2) {
        Row row3 = row;
        while (row3 instanceof WrappedRow) {
            row3 = ((WrappedRow)((Object)row)).getOriginalRow();
        }
        while (row2 instanceof WrappedRow) {
            row2 = ((WrappedRow)((Object)row2)).getOriginalRow();
        }
        if (row2 == null || row3 == null || row2.getParent() != row3) {
            return -1;
        }
        List<Row> list = TreeTableUtils.getChildren(tableModel, row);
        if (row3 != row) {
            ArrayList<Row> arrayList = new ArrayList<Row>();
            for (Row row4 : list) {
                while (row4 instanceof WrappedRow) {
                    row4 = ((WrappedRow)((Object)row4)).getOriginalRow();
                }
                if (!(row4 instanceof Row)) continue;
                arrayList.add(row4);
            }
            list = arrayList;
        }
        return list.indexOf(row2);
    }

    public static Row getChildAt(TableModel tableModel, Row row, int n2) {
        List<Row> list = TreeTableUtils.getChildren(tableModel, row);
        if (n2 < 0 || n2 >= list.size()) {
            return null;
        }
        return list.get(n2);
    }

    public static Row getRow(TableModel tableModel, int n2) {
        if (tableModel instanceof CachedTableModel) {
            return TreeTableUtils.getRow(((CachedTableModel)tableModel).getActualModel(), n2);
        }
        if (tableModel instanceof ITreeTableModel) {
            return ((ITreeTableModel)((Object)tableModel)).getRowAt(n2);
        }
        return null;
    }

    public static List<Row> getChildren(TableModel tableModel, Row row) {
        if (tableModel instanceof CachedTableModel) {
            return TreeTableUtils.getChildren(((CachedTableModel)tableModel).getActualModel(), row);
        }
        ArrayList<Row> arrayList = new ArrayList<Row>();
        if (!(tableModel instanceof ITreeTableModel) || !(row instanceof Expandable)) {
            return arrayList;
        }
        int n2 = ((ITreeTableModel)((Object)tableModel)).getRowIndex(row);
        if (n2 < 0 && !JideSwingUtilities.equals(row, ((ITreeTableModel)((Object)tableModel)).getRoot())) {
            return arrayList;
        }
        int n3 = n2 + TreeTableUtils.getDescendantCount(tableModel, row, false, false);
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            Row row2 = ((ITreeTableModel)((Object)tableModel)).getRowAt(i2);
            if ((!(row instanceof WrappedRow) || !JideSwingUtilities.equals(row2.getParent(), row)) && (row instanceof WrappedRow || row2.getParent() != row)) continue;
            arrayList.add(row2);
        }
        return arrayList;
    }

    public static List<Row> getDescendants(TableModel tableModel, Row row, boolean bl, boolean bl2, boolean bl3) {
        Row row2;
        int n2;
        if (tableModel instanceof CachedTableModel) {
            return TreeTableUtils.getDescendants(((CachedTableModel)tableModel).getActualModel(), row, bl, bl2, bl3);
        }
        ArrayList<Row> arrayList = new ArrayList<Row>();
        if (!(tableModel instanceof ITreeTableModel) || !(row instanceof Expandable)) {
            return arrayList;
        }
        int n3 = ((ITreeTableModel)((Object)tableModel)).getRowIndex(row);
        if (n3 < 0 && row != ((ITreeTableModel)((Object)tableModel)).getRoot()) {
            return arrayList;
        }
        int n4 = n3 + TreeTableUtils.getDescendantCount(tableModel, row, false, false);
        for (n2 = n3 + 1; n2 <= n4; ++n2) {
            row2 = ((ITreeTableModel)((Object)tableModel)).getRowAt(n2);
            if (bl && row2.getParent() != row) continue;
            arrayList.add(row2);
        }
        if (bl3) {
            if (arrayList.size() == 0 && ((Expandable)((Object)row)).isExpandable() && ((Expandable)((Object)row)).hasChildren() && !((Expandable)((Object)row)).isExpanded()) {
                arrayList.addAll(TreeTableUtils.\u0102(tableModel, (Expandable)((Object)row), bl));
            } else if (!bl) {
                for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                    row2 = (Row)arrayList.get(n2);
                    if (!(row2 instanceof Expandable) || !((Expandable)((Object)row2)).isExpandable() || !((Expandable)((Object)row2)).hasChildren() || ((Expandable)((Object)row2)).isExpanded()) continue;
                    List<Row> list = TreeTableUtils.\u0102(tableModel, (Expandable)((Object)row2), false);
                    arrayList.addAll(n2 + 1, list);
                }
            }
        }
        if (bl2) {
            for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                row2 = (Row)arrayList.get(n2);
                if (!(row2 instanceof Expandable) || !((Expandable)((Object)row2)).isExpandable() || !((Expandable)((Object)row2)).hasChildren()) continue;
                arrayList.remove(n2);
            }
        }
        return arrayList;
    }

    private static List<Row> \u0102(TableModel tableModel, Expandable expandable, boolean bl) {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        int n2 = expandable.getChildren().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = expandable.getChildAt(i2);
            if (!(object instanceof Row)) continue;
            if (TreeTableUtils.\u0101(tableModel, object)) {
                arrayList.add((Row)object);
            }
            if (bl || !(object instanceof Expandable) || !((Expandable)object).hasChildren()) continue;
            arrayList.addAll(TreeTableUtils.\u0102(tableModel, (Expandable)object, false));
        }
        return arrayList;
    }

    public static boolean hasDescendant(TableModel tableModel, Row row, boolean bl, boolean bl2) {
        if (tableModel instanceof CachedTableModel) {
            return TreeTableUtils.hasDescendant(((CachedTableModel)tableModel).getActualModel(), row, bl, bl2);
        }
        if (!(tableModel instanceof ITreeTableModel) || !(row instanceof Expandable)) {
            return false;
        }
        if (!bl && bl2) {
            IndexedRowTableModelWrapper indexedRowTableModelWrapper;
            if (tableModel instanceof IExpandableTreeTableModel) {
                return ((Expandable)((Object)row)).hasChildren();
            }
            if (tableModel instanceof DefaultTableModelWrapper) {
                if (((DefaultTableModelWrapper)tableModel)._indexes == null) {
                    return TreeTableUtils.hasDescendant(((DefaultTableModelWrapper)tableModel).getActualModel(), row, bl, bl2);
                }
            } else if (tableModel instanceof WrapperOfIndexdRowTableModelWrapper && (indexedRowTableModelWrapper = ((WrapperOfIndexdRowTableModelWrapper)((Object)tableModel)).getIndexedRowTableModelWrapper()) != null && indexedRowTableModelWrapper.getActualModel() instanceof ITreeTableModel) {
                return TreeTableUtils.hasDescendant(indexedRowTableModelWrapper.getActualModel(), row, bl, bl2);
            }
        }
        int n2 = row != ((ITreeTableModel)((Object)tableModel)).getRoot() ? TreeTableUtils.\u0101(tableModel, row) : tableModel.getRowCount();
        int n3 = 0;
        if (bl) {
            int n4;
            ITreeTableModel iTreeTableModel = (ITreeTableModel)((Object)tableModel);
            int n5 = iTreeTableModel.getRowIndex(row);
            int n6 = tableModel.getRowCount();
            for (int i2 = 0; i2 < n2 && (n4 = n5 + i2 + 1) < n6; ++i2) {
                Row row2 = iTreeTableModel.getRowAt(n4);
                if (!(row2 instanceof Expandable) || !((Expandable)((Object)row2)).hasChildren()) continue;
                ++n3;
            }
        }
        if (n2 - n3 > 0) {
            return true;
        }
        if (!bl2) {
            return false;
        }
        return TreeTableUtils.\u0101(tableModel, (Expandable)((Object)row), !((Expandable)((Object)row)).isExpanded());
    }

    public static int getDescendantCount(TableModel tableModel, Row row, boolean bl, boolean bl2) {
        if (tableModel instanceof CachedTableModel) {
            return TreeTableUtils.getDescendantCount(((CachedTableModel)tableModel).getActualModel(), row, bl, bl2);
        }
        if (!(tableModel instanceof ITreeTableModel) || !(row instanceof Expandable)) {
            return 0;
        }
        int n2 = row != ((ITreeTableModel)((Object)tableModel)).getRoot() ? TreeTableUtils.\u0101(tableModel, row) : tableModel.getRowCount();
        int n3 = 0;
        if (bl) {
            int n4;
            ITreeTableModel iTreeTableModel = (ITreeTableModel)((Object)tableModel);
            int n5 = iTreeTableModel.getRowIndex(row);
            int n6 = tableModel.getRowCount();
            for (int i2 = 0; i2 < n2 && (n4 = n5 + i2 + 1) < n6; ++i2) {
                Row row2 = iTreeTableModel.getRowAt(n4);
                if (!(row2 instanceof Expandable) || !((Expandable)((Object)row2)).hasChildren()) continue;
                ++n3;
            }
        }
        return n2 - n3 + (bl2 ? TreeTableUtils.\u0101(tableModel, (Expandable)((Object)row), !((Expandable)((Object)row)).isExpanded(), bl) : 0);
    }

    private static boolean \u0101(TableModel tableModel, Expandable expandable, boolean bl) {
        if (expandable == null || expandable.getChildren() == null) {
            return false;
        }
        for (Object obj : expandable.getChildren()) {
            if (bl && TreeTableUtils.\u0101(tableModel, obj)) {
                return true;
            }
            if (!(obj instanceof Expandable) || !((Expandable)obj).hasChildren() || !TreeTableUtils.\u0101(tableModel, (Expandable)obj, bl || !((AbstractExpandable)obj).isExpanded())) continue;
            return true;
        }
        return false;
    }

    private static int \u0101(TableModel tableModel, Expandable expandable, boolean bl, boolean bl2) {
        int n2 = 0;
        List<?> list = expandable.getChildren();
        if (list != null) {
            for (Object obj : list) {
                if (obj instanceof Expandable && ((Expandable)obj).hasChildren()) {
                    n2 += TreeTableUtils.\u0101(tableModel, (Expandable)obj, bl || !((AbstractExpandable)obj).isExpanded(), bl2) + (!bl || bl2 ? 0 : 1);
                    continue;
                }
                if (!bl || !TreeTableUtils.\u0101(tableModel, obj)) continue;
                ++n2;
            }
        }
        return n2;
    }

    private static boolean \u0101(TableModel tableModel, Object object) {
        boolean bl = true;
        if (tableModel instanceof TableModelWrapperImpl) {
            TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel, FilterableTreeTableModel.class);
            while (tableModel2 instanceof FilterableTreeTableModel) {
                Boolean bl2;
                Map<Row, Boolean> map = ((FilterableTreeTableModel)tableModel2).\u01e0();
                if (map != null && (bl2 = map.get(object)) != null && !bl2.booleanValue()) {
                    bl = false;
                    break;
                }
                tableModel2 = TableModelWrapperUtils.getActualTableModel(((FilterableTreeTableModel)tableModel2).getActualModel(), FilterableTreeTableModel.class);
            }
        }
        return bl;
    }

    private static int \u0101(TableModel tableModel, Row row) {
        IndexedRowTableModelWrapper indexedRowTableModelWrapper;
        if (tableModel instanceof CachedTableModel) {
            return TreeTableUtils.\u0101(((CachedTableModel)tableModel).getActualModel(), row);
        }
        if (!(tableModel instanceof ITreeTableModel) || !(row instanceof Expandable)) {
            if (tableModel instanceof TableModelWrapper) {
                return TreeTableUtils.\u0101(((TableModelWrapper)((Object)tableModel)).getActualModel(), row);
            }
            return 0;
        }
        if (tableModel instanceof IExpandableTreeTableModel) {
            int n2;
            int n3;
            IExpandableTreeTableModel iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)tableModel);
            while (row instanceof WrappedRow) {
                row = ((WrappedRow)((Object)row)).getOriginalRow();
            }
            int n4 = n3 = iExpandableTreeTableModel.getRowIndex(row);
            while (row instanceof Expandable && ((Expandable)((Object)row)).isExpanded() && (n2 = iExpandableTreeTableModel.getChildCount(row)) > 0) {
                int n5 = 1;
                Row row2 = (Row)iExpandableTreeTableModel.getChild(row, n2 - n5);
                int n6 = iExpandableTreeTableModel.getRowIndex(row2);
                while (n6 == -1 && ++n5 <= n2) {
                    row2 = (Row)((Expandable)((Object)row)).getChildAt(n2 - n5);
                    n6 = iExpandableTreeTableModel.getRowIndex(row2);
                }
                if (n6 == -1) break;
                n4 = n6;
                row = row2;
            }
            return n4 - n3;
        }
        if (tableModel instanceof TableModelWrapper) {
            int n7 = TreeTableUtils.\u0101(((TableModelWrapper)((Object)tableModel)).getActualModel(), row);
            if (n7 <= 0) {
                return 0;
            }
            ITreeTableModel iTreeTableModel = (ITreeTableModel)((Object)tableModel);
            int n8 = iTreeTableModel.getRowIndex(row) + 1;
            int n9 = Math.min(n8 + n7 - 1, tableModel.getRowCount() - 1);
            int n10 = n8;
            int n11 = n9;
            do {
                int n12;
                if (TreeTableUtils.\u0101((Expandable)((Object)row), iTreeTableModel.getRowAt(n12 = (n10 + n11) / 2))) {
                    n10 = n12;
                    continue;
                }
                n11 = n12;
            } while (n11 > n10 + 1);
            if (TreeTableUtils.\u0101((Expandable)((Object)row), iTreeTableModel.getRowAt(n11))) {
                return n11 - n8 + 1;
            }
            if (n10 != n11 && TreeTableUtils.\u0101((Expandable)((Object)row), iTreeTableModel.getRowAt(n10))) {
                return n10 - n8 + 1;
            }
            return n10 - n8;
        }
        if (tableModel instanceof WrapperOfIndexdRowTableModelWrapper && (indexedRowTableModelWrapper = ((WrapperOfIndexdRowTableModelWrapper)((Object)tableModel)).getIndexedRowTableModelWrapper()) != null && indexedRowTableModelWrapper.getActualModel() instanceof ITreeTableModel) {
            int n13 = TreeTableUtils.\u0101(indexedRowTableModelWrapper.getActualModel(), row);
            int n14 = ((ITreeTableModel)((Object)indexedRowTableModelWrapper.getActualModel())).getRowIndex(row);
            int n15 = indexedRowTableModelWrapper.getVisualRowAt(n14 + 1);
            if (n15 < 0) {
                n15 = 0;
                if ((n13 -= indexedRowTableModelWrapper.getActualRowAt(0) - n14 - 1) < 0) {
                    n13 = 0;
                }
            }
            int n16 = Math.min(n15 + n13 - 1, tableModel.getRowCount() - 1);
            return n16 - n15 + 1;
        }
        return 0;
    }

    private static boolean \u0101(Expandable expandable, Row row) {
        Expandable expandable2;
        if (row == null) {
            return false;
        }
        while (expandable instanceof WrappedRow) {
            expandable = ((WrappedRow)((Object)expandable)).getOriginalRow();
        }
        while (row instanceof WrappedRow) {
            row = ((WrappedRow)((Object)row)).getOriginalRow();
        }
        for (expandable2 = row.getParent(); expandable2 != null && expandable2 != expandable; expandable2 = expandable2.getParent()) {
        }
        return expandable2 != null;
    }
}

