/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellSpanTable;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.ITreeTableModel;
import com.jidesoft.grid.RootExpandableRow;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTreeTableModel;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.grid.TreeTableCellRenderer;
import com.jidesoft.grid.TreeTableUtils;
import com.jidesoft.grid.UndoableTableModelEvent;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.DelegateMouseInputListener;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class TreeTable
extends SortableTable {
    private static final String \u11f3 = "TreeTableUI";
    public static final String PROPERTY_SHOW_TREE_LINES = "showTreeLines";
    public static final String PROPERTY_SHOW_LEAF_NODE_TREE_LINES = "showLeafNodeTreeLines";
    public static final String PROPERTY_TREE_LINE_COLOR = "treeLineColor";
    public static final String PROPERTY_DOUBLE_CLICK_ENABLED = "doubleClickEnabled";
    public static final String PROPERTY_EXPANDABLE_COLUMN = "expandableColumn";
    public static final String PROPERTY_SELECT_ROW_WHEN_TOGGLING = "selectRowWhenToggling";
    public static final String CLIENT_PROPERTY_DO_NOT_PAINT_CELL_CONTENT_BACKGROUND = "TreeTable.doNotPaintCellContentBackground";
    private boolean \u11ee = true;
    private boolean \u11e7 = true;
    private boolean \u11ea = false;
    private boolean \u11ec = false;
    private boolean \u11e9 = false;
    private boolean \u11f1 = true;
    private boolean \u11f4 = false;
    private boolean \u11ef = false;
    private Color \u11f8;
    private int \u11f9 = 16;
    private int \u11e6 = 16;
    private TableCellRenderer \u1e01;
    private boolean \u11eb;
    private boolean \u11e8 = true;
    private boolean \u11f0 = true;
    private int \u11f6 = -1;
    private boolean \u1e04 = false;
    private boolean \u1e02 = true;
    private boolean \u11e5 = false;
    private boolean \u11f5 = false;
    private int \u11f7 = 200;
    Row[] \u11ed;
    Map<Row, Integer> \u1e00;
    private Row \u1e03;
    private boolean \u11f2 = false;

    public TreeTable() {
        this.\u0295();
        this.\u0294();
    }

    public TreeTable(int n2, int n3) {
        super(n2, n3);
        this.\u0295();
        this.\u0294();
    }

    public TreeTable(TableModel tableModel) {
        super(tableModel);
        this.\u0295();
        this.\u0294();
    }

    public TreeTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.\u0295();
        this.\u0294();
    }

    public TreeTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.\u0295();
        this.\u0294();
    }

    public TreeTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.\u0295();
        this.\u0294();
    }

    public TreeTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.\u0295();
        this.\u0294();
    }

    private void \u0295() {
        if (!this.\u11eb) {
            Object object;
            this.putClientProperty("AutoResize.highPerformance", false);
            this.setSelectInsertedRows(false);
            boolean bl = false;
            if (SystemInfo.isJdk6Above() && !SystemInfo.isJdk7Above()) {
                object = this.getMouseListeners();
                MouseListener mouseListener = null;
                for (MouseListener mouseListener2 : object) {
                    if (mouseListener2.getClass().getName().indexOf("TableUI") == -1) continue;
                    mouseListener = mouseListener2;
                    this.removeMouseListener(mouseListener2);
                    if (!(mouseListener2 instanceof MouseMotionListener)) break;
                    this.removeMouseMotionListener((MouseMotionListener)((Object)mouseListener2));
                    break;
                }
                if (mouseListener != null && mouseListener instanceof MouseInputListener) {
                    MouseInputListener mouseInputListener = this.createExpandMouseInputListener((MouseInputListener)mouseListener);
                    JideSwingUtilities.insertMouseListener(this, mouseInputListener, 0);
                    JideSwingUtilities.insertMouseMotionListener(this, mouseInputListener, 0);
                    bl = true;
                }
            }
            if (!bl) {
                object = this.createExpandMouseListener();
                JideSwingUtilities.insertMouseListener(this, (MouseListener)object, 0);
                JideSwingUtilities.insertMouseMotionListener(this, (MouseMotionListener)object, 0);
            }
            this.\u1e01 = this.createCellRenderer();
            if (SystemInfo.isJdk6Above()) {
                this.addPropertyChangeListener("dropLocation", new PropertyChangeListener(){
                    private Timer \u0102;

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getNewValue() instanceof JTable.DropLocation) {
                            Row row;
                            int n2 = ((JTable.DropLocation)propertyChangeEvent.getNewValue()).getRow();
                            if (n2 == -1 || propertyChangeEvent.getOldValue() instanceof JTable.DropLocation && ((JTable.DropLocation)propertyChangeEvent.getOldValue()).getRow() == n2) {
                                return;
                            }
                            if (this.\u0102 != null) {
                                this.\u0102.stop();
                            }
                            if ((row = TreeTable.this.getRowAt(n2)) instanceof Expandable && ((Expandable)((Object)row)).isExpandable() && ((Expandable)((Object)row)).hasChildren() && !((Expandable)((Object)row)).isExpanded()) {
                                int n3 = TreeTable.this.getDragExpandDelay();
                                if (n3 > 0) {
                                    this.\u0102 = new Timer(n3, new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent actionEvent) {
                                            TreeTable.this.\u0101((Expandable)((Object)row), true);
                                            \u0102.stop();
                                            \u0102 = null;
                                        }
                                    });
                                    this.\u0102.start();
                                } else {
                                    TreeTable.this.\u0101((Expandable)((Object)row), true);
                                }
                            }
                        }
                    }
                });
            }
            this.\u11eb = true;
        }
    }

    @Override
    public void clearSavedSelections(boolean bl) {
        this.\u11ed = null;
        super.clearSavedSelections(bl);
    }

    @Override
    void \u0281() {
    }

    @Override
    void \u028a() {
        this.\u11ed = this.\u0102(this.\u11ed, TableUtils.saveSelection(this));
    }

    @Override
    void \u0278() {
        TableUtils.\u0101(this, this.\u11ed, false, this.isCompareCurrentSelection(), this.\u1158);
    }

    @Override
    void \u0284() {
        this.\u1e00 = this.\u0101(this.\u1e00, TableUtils.saveTreeTableRowHeights(this));
    }

    @Override
    void \u0276() {
        TableUtils.loadTreeTableRowHeights(this, this.\u1e00);
    }

    @Override
    void \u0101(UndoableTableModelEvent undoableTableModelEvent) {
        if (!(undoableTableModelEvent.getSource() instanceof ITreeTableModel)) {
            return;
        }
        ArrayList<Row> arrayList = new ArrayList<Row>();
        UndoableTableModelEvent.A[] aArray = undoableTableModelEvent.getEdits();
        ITreeTableModel iTreeTableModel = (ITreeTableModel)undoableTableModelEvent.getSource();
        TableUtils.ColumnSelectionRow columnSelectionRow = null;
        for (UndoableTableModelEvent.A a2 : aArray) {
            if (a2.\u0105() >= 0 && columnSelectionRow == null) {
                columnSelectionRow = new TableUtils.ColumnSelectionRow(a2.\u0105());
            }
            arrayList.add(iTreeTableModel.getRowAt(a2.\u0106()));
        }
        if (columnSelectionRow != null) {
            arrayList.add(columnSelectionRow);
        } else {
            arrayList.add(new TableUtils.ColumnSelectionRow(0));
        }
        this.\u11ed = arrayList.toArray(new Row[arrayList.size()]);
    }

    private Map<Row, Integer> \u0101(Map<Row, Integer> map, Map<Row, Integer> map2) {
        if (map == null) {
            return map2;
        }
        if (map2 == null) {
            return map;
        }
        Set<Row> set = map2.keySet();
        for (Row row : map.keySet()) {
            boolean bl = set.contains(row);
            if (!bl) {
                for (Row row2 : set) {
                    if (!this.\u0101(row, row2)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            map2.put(row, map.get(row));
        }
        return map2;
    }

    private Row[] \u0102(Row[] rowArray, Row[] rowArray2) {
        if (rowArray == null || rowArray.length <= 0) {
            return rowArray2;
        }
        if (rowArray2 == null || rowArray2.length <= 0) {
            return rowArray;
        }
        if (rowArray2.length > 20) {
            return rowArray2;
        }
        if (rowArray2.length >= 4 && rowArray2[1] instanceof TableUtils.ColumnSelectionRow && rowArray2[3] instanceof TableUtils.ColumnSelectionRow) {
            return rowArray2;
        }
        ArrayList<Row> arrayList = new ArrayList<Row>();
        for (Row row : rowArray) {
            boolean bl = false;
            if (row instanceof TableUtils.ColumnSelectionRow) continue;
            for (Row row2 : rowArray2) {
                if (!this.\u0101(row, row2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(row);
        }
        Row[] rowArray3 = new Row[rowArray2.length + arrayList.size()];
        System.arraycopy(rowArray2, 0, rowArray3, 0, rowArray2.length - 1);
        int n2 = rowArray2.length - 1;
        int n3 = 0;
        while (n2 < rowArray3.length - 1) {
            rowArray3[n2] = (Row)arrayList.get(n3);
            ++n2;
            ++n3;
        }
        rowArray3[rowArray3.length - 1] = rowArray2[rowArray2.length - 1];
        return rowArray3;
    }

    boolean \u0101(Row row, Row row2) {
        return row == row2;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.\u0294();
        this.\u1e01 = this.createCellRenderer();
    }

    @Override
    public String getActualUIClassID() {
        return \u11f3;
    }

    private void \u0294() {
        if (!this.\u11ea && UIDefaultsLookup.get("TreeTable.showsRootHandles") != null) {
            this.\u11e7 = UIDefaultsLookup.getBoolean("TreeTable.showsRootHandles");
        }
        if (!this.\u11e9 && UIDefaultsLookup.get("Tree.paintLines") != null) {
            this.\u11ec = UIDefaultsLookup.getBoolean("Tree.paintLines");
        }
        if (!this.\u11f4 && UIDefaultsLookup.get("TreeTable.paintLeafNodeLines") != null) {
            this.\u11f1 = UIDefaultsLookup.getBoolean("TreeTable.paintLeafNodeLines");
        }
        if (this.\u11f8 == null || this.\u11f8 instanceof UIResource) {
            this.\u11f8 = UIDefaultsLookup.getColor("Tree.hash");
        }
    }

    protected TableCellRenderer createCellRenderer() {
        return new TreeTableCellRenderer();
    }

    @Override
    protected void muteDefaultKeyStroke() {
        super.muteDefaultKeyStroke();
        this.replaceAction(KeyStroke.getKeyStroke(37, 0));
        this.replaceAction(KeyStroke.getKeyStroke(39, 0));
        this.replaceAction(KeyStroke.getKeyStroke(10, 0));
        this.replaceAction(KeyStroke.getKeyStroke(107, 0), 0);
        this.replaceAction(KeyStroke.getKeyStroke(109, 0), 0);
        this.replaceAction(KeyStroke.getKeyStroke(106, 0), 0);
        this.replaceAction(KeyStroke.getKeyStroke(111, 0), 0);
    }

    private boolean \u0293() {
        if (this.isEditing()) {
            this.requestFocus();
            try {
                if (!this.getCellEditor().stopCellEditing()) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private void \u0296() {
        if (this.isEditing()) {
            this.removeEditor();
        }
    }

    @Override
    public void setModel(TableModel tableModel) {
        this.\u0293();
        this.\u0296();
        super.setModel(tableModel);
    }

    @Override
    void \u027f() {
        super.\u027f();
        this.\u1e00 = null;
    }

    protected void handleMouseEvent(MouseEvent mouseEvent) {
        Row row;
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!this.isExpandable()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.isDoubleClickEnabled() && mouseEvent.getClickCount() == 2 && mouseEvent.getID() == 501) {
            Point point = mouseEvent.getPoint();
            int n2 = this.rowAtPoint(point);
            int n3 = this.columnAtPoint(point);
            Row row2 = this.getRowAt(n2);
            if (n2 != -1 && !this.isCellEditable(n2, n3)) {
                if (row2 instanceof Expandable && ((Expandable)((Object)row2)).isExpanded() && TreeTableUtils.getDescendantCount(this.getModel(), row2, false, false) <= 0) {
                    return;
                }
                if (this.toggleRow(row2)) {
                    mouseEvent.consume();
                }
            }
        } else if (this.isExpandIconVisible() && (row = this.expandableRowAtPoint(mouseEvent.getPoint())) != null && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (mouseEvent.getID() == 501 && this.toggleRow(row)) {
                mouseEvent.consume();
            } else {
                mouseEvent.consume();
            }
        }
    }

    TreePath \u0104(Expandable expandable) {
        ArrayList<Expandable> arrayList = new ArrayList<Expandable>();
        do {
            arrayList.add(0, expandable);
        } while ((expandable = expandable.getParent()) != null);
        return new TreePath(arrayList.toArray());
    }

    protected boolean toggleRow(Row row) {
        return row instanceof Expandable && this.\u0101((Expandable)((Object)row), !((Expandable)((Object)row)).isExpanded());
    }

    public Row getRowAt(int n2) {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel) {
            return ((ITreeTableModel)((Object)tableModel)).getRowAt(TableModelWrapperUtils.getActualRowAt(this.getModel(), n2, IExpandableTreeTableModel.class));
        }
        return null;
    }

    public int getRowIndex(Row row) {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof ITreeTableModel) {
            return TableModelWrapperUtils.getRowAt(this.getModel(), tableModel, ((ITreeTableModel)((Object)tableModel)).getRowIndex(row));
        }
        return -1;
    }

    public boolean expandRow(int n2, boolean bl) {
        Expandable expandable;
        if (!this.\u0293()) {
            return false;
        }
        Row row = this.getRowAt(n2);
        if (row != null && row instanceof Expandable && ((expandable = (Expandable)((Object)row)).hasChildren() && bl && !expandable.isExpanded() || !bl && expandable.isExpanded()) && this.\u0101(expandable, bl)) {
            if (this.isSelectRowWhenToggling()) {
                this.setSelectedRow(row);
            }
            return true;
        }
        return false;
    }

    private boolean \u0101(Expandable expandable, boolean bl) {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel && expandable.isExpanded() != bl) {
            if (!this.\u0293()) {
                return false;
            }
            TreePath treePath = this.\u0104(expandable);
            try {
                if (bl) {
                    this.fireTreeWillExpand(treePath);
                } else {
                    this.fireTreeWillCollapse(treePath);
                }
            }
            catch (ExpandVetoException expandVetoException) {
                return false;
            }
            ((IExpandableTreeTableModel)((Object)tableModel)).expandRow((ExpandableRow)expandable, bl);
            if (this.isSelectRowWhenToggling()) {
                this.setSelectedRow((ExpandableRow)expandable);
            }
            if (bl) {
                this.fireTreeExpanded(treePath);
            } else {
                this.fireTreeCollapsed(treePath);
            }
            return true;
        }
        return false;
    }

    @Override
    void \u0101(TableModelEvent tableModelEvent, boolean bl) {
        super.\u0101(tableModelEvent, bl);
        TableModel tableModel = this.getTreeTableModel();
        if (this.\u1e03 != null && this.\u11ed != null && tableModel instanceof ITreeTableModel) {
            boolean bl2 = false;
            ArrayList<Row> arrayList = new ArrayList<Row>();
            for (Row row : this.\u11ed) {
                Expandable expandable;
                if (row == null) continue;
                for (expandable = row.getParent(); expandable != null && expandable != this.\u1e03; expandable = expandable.getParent()) {
                }
                if (expandable == this.\u1e03) {
                    bl2 = true;
                    continue;
                }
                arrayList.add(row);
            }
            this.\u11ed = arrayList.toArray(new Row[arrayList.size()]);
            if (bl2) {
                int n2 = TableModelWrapperUtils.getRowAt(this.getModel(), tableModel, ((ITreeTableModel)((Object)tableModel)).getRowIndex(this.\u1e03));
                this.getSelectionModel().addSelectionInterval(n2, n2);
            }
        }
        this.\u1e03 = null;
    }

    @Override
    boolean \u0105(TableModelEvent tableModelEvent) {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModelEvent instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent() instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent().getSource() == tableModel && tableModel instanceof IExpandableTreeTableModel) {
            Row row;
            if (tableModelEvent.getType() == 1) {
                Expandable expandable;
                Row row2 = ((IExpandableTreeTableModel)((Object)tableModel)).getRowAt(((CompoundTableModelEvent)tableModelEvent).getOriginalEvent().getFirstRow());
                if (row2 != null && (expandable = row2.getParent()).getChildrenCount() == tableModelEvent.getLastRow() - tableModelEvent.getFirstRow() + 1) {
                    return false;
                }
            } else if (tableModelEvent.getType() == -1 && (row = ((IExpandableTreeTableModel)((Object)tableModel)).getRowAt(((CompoundTableModelEvent)tableModelEvent).getOriginalEvent().getFirstRow() - 1)) instanceof Expandable && !((Expandable)((Object)row)).isExpanded()) {
                this.\u1e03 = row;
                return false;
            }
        }
        return super.\u0105(tableModelEvent);
    }

    public boolean isSelectRowWhenToggling() {
        return this.\u1e04;
    }

    public void setSelectRowWhenToggling(boolean bl) {
        boolean bl2 = this.\u1e04;
        if (this.\u1e04 != bl) {
            this.\u1e04 = bl;
            this.firePropertyChange(PROPERTY_SELECT_ROW_WHEN_TOGGLING, bl2, bl);
        }
    }

    public void setSelectedRow(Row row) {
        if (row == null) {
            this.clearSelection();
        } else {
            TableModel tableModel = this.getTreeTableModel();
            if (tableModel instanceof IExpandableTreeTableModel) {
                boolean bl = false;
                for (Expandable expandable = row.getParent(); expandable != null; expandable = expandable.getParent()) {
                    if (expandable.isExpanded()) continue;
                    expandable.setExpanded(true);
                    bl = true;
                }
                if (bl) {
                    ((IExpandableTreeTableModel)((Object)tableModel)).refresh();
                }
                int n2 = this.getRowIndex(row);
                int n3 = this.getSelectedColumn();
                this.changeSelection(n2, n3 == -1 ? 0 : n3, false, false);
            }
        }
    }

    public void addSelectedRow(Row row) {
        if (row == null) {
            return;
        }
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel) {
            boolean bl = false;
            for (Expandable expandable = row.getParent(); expandable != null; expandable = expandable.getParent()) {
                if (expandable.isExpanded()) continue;
                expandable.setExpanded(true);
                bl = true;
            }
            if (bl) {
                ((IExpandableTreeTableModel)((Object)tableModel)).refresh();
            }
            int n2 = this.getRowIndex(row);
            int n3 = this.getSelectedColumn();
            if (!this.isRowSelected(n2)) {
                this.changeSelection(n2, n3 == -1 ? 0 : n3, true, false);
            }
        }
    }

    public void removeSelectedRow(Row row) {
        int n2;
        if (row == null) {
            return;
        }
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel && (n2 = this.getRowIndex(row)) >= 0 && this.isRowSelected(n2)) {
            int n3 = this.getSelectedColumn();
            this.changeSelection(n2, n3 == -1 ? 0 : n3, true, false);
        }
    }

    public void setSelectedRows(Row[] rowArray) {
        if (rowArray == null || rowArray.length <= 0) {
            this.clearSelection();
            return;
        }
        this.setSelectedRow(rowArray[0]);
        for (int i2 = 1; i2 < rowArray.length; ++i2) {
            this.addSelectedRow(rowArray[i2]);
        }
    }

    public void addSelectedRows(Row[] rowArray) {
        if (rowArray == null || rowArray.length <= 0) {
            return;
        }
        for (Row row : rowArray) {
            this.addSelectedRow(row);
        }
    }

    public void removeSelectedRows(Row[] rowArray) {
        if (rowArray == null || rowArray.length <= 0) {
            return;
        }
        for (Row row : rowArray) {
            this.removeSelectedRow(row);
        }
    }

    public void expandAll() {
        if (this.isExpandAllAllowed()) {
            if (!this.\u0293()) {
                return;
            }
            TableModel tableModel = this.getTreeTableModel();
            if (tableModel instanceof IExpandableTreeTableModel) {
                ((IExpandableTreeTableModel)((Object)tableModel)).expandAll();
                this.revalidate();
                this.repaint();
            }
        }
    }

    public void expandFirstLevel() {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel) {
            if (!this.\u0293()) {
                return;
            }
            ((IExpandableTreeTableModel)((Object)tableModel)).expandFirstLevel();
            this.revalidate();
            this.repaint();
        }
    }

    public void expandNextLevel() {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel) {
            if (!this.\u0293()) {
                return;
            }
            ((IExpandableTreeTableModel)((Object)tableModel)).expandNextLevel();
            this.revalidate();
            this.repaint();
        }
    }

    public void collapseAll() {
        if (this.isExpandAllAllowed()) {
            if (!this.\u0293()) {
                return;
            }
            TableModel tableModel = this.getTreeTableModel();
            if (tableModel instanceof IExpandableTreeTableModel) {
                ((IExpandableTreeTableModel)((Object)tableModel)).collapseAll();
                this.revalidate();
                this.repaint();
            }
        }
    }

    public void collapseFirstLevel() {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel) {
            if (!this.\u0293()) {
                return;
            }
            ((IExpandableTreeTableModel)((Object)tableModel)).collapseFirstLevel();
            this.revalidate();
            this.repaint();
        }
    }

    public void collapseLastLevel() {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel) {
            if (!this.\u0293()) {
                return;
            }
            ((IExpandableTreeTableModel)((Object)tableModel)).collapseLastLevel();
            this.revalidate();
            this.repaint();
        }
    }

    protected Rectangle getCellRect(Point point) {
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            for (int i3 = 0; i3 < this.getColumnCount(); ++i3) {
                Rectangle rectangle = this.getCellRect(i2, i3, true);
                if (!rectangle.contains(point)) continue;
                if (i3 == this.getExpandableColumnViewIndex()) {
                    rectangle.x += this.getIndent();
                    rectangle.width -= this.getIndent();
                }
                return rectangle;
            }
        }
        return null;
    }

    protected Point getCellAt(Point point) {
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            for (int i3 = 0; i3 < this.getColumnCount(); ++i3) {
                Rectangle rectangle = this.getCellRect(i2, i3, true);
                if (!rectangle.contains(point)) continue;
                return new Point(i3, i2);
            }
        }
        return null;
    }

    public TableCellRenderer getActualCellRenderer(int n2, int n3) {
        return super.getCellRenderer(n2, n3);
    }

    @Override
    boolean \u0103(CompoundTableModelEvent compoundTableModelEvent) {
        TableModelEvent tableModelEvent = compoundTableModelEvent.getOriginalEvent();
        return tableModelEvent instanceof CompoundTableModelEvent && (tableModelEvent.getType() == 1 || tableModelEvent.getType() == -1);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        TableModelEvent tableModelEvent2;
        super.tableChanged(tableModelEvent);
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel != null && tableModel.getRowCount() == 0) {
            this.\u1e01 = null;
        }
        if (tableModelEvent instanceof CompoundTableModelEvent) {
            tableModelEvent2 = ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent();
            if (tableModelEvent2 == null) {
                return;
            }
        } else {
            tableModelEvent2 = tableModelEvent;
        }
        if (!(tableModelEvent2 instanceof CompoundTableModelEvent) && (tableModelEvent2 == null || tableModelEvent2.getFirstRow() == -1 && tableModelEvent2.getColumn() == -1 && tableModelEvent2.getType() == 0 || tableModelEvent2.getType() == 0 && tableModelEvent2.getFirstRow() == 0 && tableModelEvent2.getLastRow() == Integer.MAX_VALUE && tableModelEvent2.getColumn() == -1)) {
            this.\u027f();
            this.clearSavedSelections(true);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.\u1e01 = null;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n2, int n3) {
        if (n3 == this.getExpandableColumnViewIndex()) {
            if (this.\u1e01 == null) {
                this.\u1e01 = this.createCellRenderer();
            }
            if (this.\u1e01 instanceof TreeTableCellRenderer) {
                TableCellRenderer tableCellRenderer = this.getActualCellRenderer(n2, n3);
                ((TreeTableCellRenderer)this.\u1e01).setActualCellRenderer(tableCellRenderer);
            }
            return this.\u1e01;
        }
        return this.getActualCellRenderer(n2, n3);
    }

    @Override
    protected Action createDelegateAction(Action action, KeyStroke keyStroke) {
        return new TreeTableAction(action, keyStroke);
    }

    public boolean isCompareCurrentSelection() {
        return this.\u11e5;
    }

    public void setCompareCurrentSelection(boolean bl) {
        this.\u11e5 = bl;
    }

    public boolean isExportCollapsedRowsToExcel() {
        return this.\u11f5;
    }

    public void setExportCollapsedRowsToExcel(boolean bl) {
        this.\u11f5 = bl;
    }

    protected int getIndent(Row row) {
        return this.getIndent();
    }

    public int getDragExpandDelay() {
        return this.\u11f7;
    }

    public void setDragExpandDelay(int n2) {
        this.\u11f7 = n2;
    }

    public boolean isSelectParentRowWhenCollapsing() {
        return this.\u1e02;
    }

    public void setSelectParentRowWhenCollapsing(boolean bl) {
        this.\u1e02 = bl;
    }

    protected MouseInputListener createExpandMouseListener() {
        return new ExpandMouseListener();
    }

    protected MouseInputListener createExpandMouseInputListener(MouseInputListener mouseInputListener) {
        return new DelegateExpandMouseInputListener(mouseInputListener);
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenerList.add(TreeExpansionListener.class, treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenerList.remove(TreeExpansionListener.class, treeExpansionListener);
    }

    public TreeExpansionListener[] getTreeExpansionListeners() {
        return (TreeExpansionListener[])this.listenerList.getListeners(TreeExpansionListener.class);
    }

    public void fireTreeExpanded(TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TreeExpansionListener.class) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeExpansionListener)objectArray[i2 + 1]).treeExpanded(treeExpansionEvent);
        }
    }

    public void fireTreeCollapsed(TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TreeExpansionListener.class) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeExpansionListener)objectArray[i2 + 1]).treeCollapsed(treeExpansionEvent);
        }
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.listenerList.add(TreeWillExpandListener.class, treeWillExpandListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.listenerList.remove(TreeWillExpandListener.class, treeWillExpandListener);
    }

    public TreeWillExpandListener[] getTreeWillExpandListeners() {
        return (TreeWillExpandListener[])this.listenerList.getListeners(TreeWillExpandListener.class);
    }

    public void fireTreeWillExpand(TreePath treePath) throws ExpandVetoException {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TreeWillExpandListener.class) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeWillExpandListener)objectArray[i2 + 1]).treeWillExpand(treeExpansionEvent);
        }
    }

    public void fireTreeWillCollapse(TreePath treePath) throws ExpandVetoException {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TreeWillExpandListener.class) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeWillExpandListener)objectArray[i2 + 1]).treeWillCollapse(treeExpansionEvent);
        }
    }

    public boolean isShowTreeLines() {
        if (LookAndFeelFactory.isLnfInUse("apple.laf.AquaLookAndFeel") || LookAndFeelFactory.isLnfInUse("com.apple.laf.AquaLookAndFeel")) {
            return false;
        }
        return this.\u11ec;
    }

    public void setShowTreeLines(boolean bl) {
        boolean bl2 = this.\u11ec;
        if (bl2 != bl) {
            this.\u11ec = bl;
            this.\u11e9 = true;
            this.firePropertyChange(PROPERTY_SHOW_TREE_LINES, bl2, bl);
            this.repaint();
        }
    }

    public boolean isShowLeafNodeTreeLines() {
        return this.\u11f1;
    }

    public void setShowLeafNodeTreeLines(boolean bl) {
        boolean bl2 = this.\u11f1;
        if (bl2 != bl) {
            this.\u11f1 = bl;
            this.\u11f4 = true;
            this.firePropertyChange(PROPERTY_SHOW_LEAF_NODE_TREE_LINES, bl2, bl);
            this.repaint();
        }
    }

    public boolean isDoubleClickEnabled() {
        return this.\u11ee;
    }

    public void setDoubleClickEnabled(boolean bl) {
        boolean bl2 = this.\u11ee;
        if (bl2 != bl) {
            this.\u11ee = bl;
            this.firePropertyChange(PROPERTY_DOUBLE_CLICK_ENABLED, bl2, bl);
        }
    }

    public Color getTreeLineColor() {
        return this.\u11f8;
    }

    public void setTreeLineColor(Color color) {
        Color color2 = this.\u11f8;
        if (color2 == null || !color2.equals(color)) {
            this.\u11f8 = color;
            this.firePropertyChange(PROPERTY_TREE_LINE_COLOR, color2, this.\u11f8);
        }
    }

    protected TableModel getTreeTableModel() {
        TableModel tableModel = this.getModel();
        while (true) {
            if (tableModel instanceof IExpandableTreeTableModel) {
                return tableModel;
            }
            if (!(tableModel instanceof TableModelWrapper)) break;
            tableModel = ((TableModelWrapper)((Object)tableModel)).getActualModel();
        }
        return null;
    }

    @Override
    protected ISortableTableModel createSortableTableModel(TableModel tableModel) {
        return new SortableTreeTableModel(tableModel);
    }

    public int getIndent() {
        return this.\u11f9;
    }

    public void setIndent(int n2) {
        this.\u11f9 = n2;
        this.repaint();
    }

    public int getLeftMargin() {
        return this.\u11e6;
    }

    public void setLeftMargin(int n2) {
        this.\u11e6 = n2;
    }

    public boolean getShowsRootHandles() {
        return this.\u11e7;
    }

    public void setShowsRootHandles(boolean bl) {
        boolean bl2 = this.\u11e7;
        if (bl2 != bl) {
            this.\u11e7 = bl;
            this.\u11ea = true;
            this.firePropertyChange("showsRootHandles", bl2, this.\u11e7);
            this.invalidate();
        }
    }

    public boolean isExpandAllAllowed() {
        return this.\u11e8;
    }

    public void setExpandAllAllowed(boolean bl) {
        this.\u11e8 = bl;
    }

    public boolean isExpandable() {
        return this.\u11f0;
    }

    public void setExpandable(boolean bl) {
        this.\u11f0 = bl;
    }

    public int getExpandableColumnViewIndex() {
        if (!this.\u11f2) {
            return 0;
        }
        return this.convertColumnIndexToView(this.\u11f6);
    }

    public boolean shouldPaintHorizontalLeg(int n2) {
        int n3;
        Row row = this.getRowAt(n2);
        if (row == null) {
            return false;
        }
        Expandable expandable = row.getParent();
        return !(row instanceof Expandable) || ((Expandable)((Object)row)).hasChildren() || this.isShowLeafNodeTreeLines() || !(expandable instanceof Row) || n2 == (n3 = this.getRowIndex((Row)((Object)expandable)) + TableModelWrapperUtils.getVisibleChildrenCount(this.getModel(), (Row)((Object)expandable)));
    }

    public int getExpandableColumn() {
        return this.\u11f6;
    }

    public void setExpandableColumn(int n2) {
        if (this.\u11f6 != n2) {
            int n3 = this.\u11f6;
            this.\u11f6 = n2;
            this.\u11f2 = this.\u11f6 != -1;
            this.firePropertyChange(PROPERTY_EXPANDABLE_COLUMN, n3, this.\u11f6);
        }
    }

    public int getHorizontalLegPosition(int n2) {
        return n2 / 2;
    }

    public int getVerticalLineStartPosition(int n2) {
        return n2;
    }

    public Row expandableRowAtPoint(Point point) {
        int n2 = this.rowAtPoint(point);
        if (n2 != -1) {
            Row row = this.getRowAt(n2);
            int n3 = this.getExpandableColumnViewIndex();
            if (n3 >= 0 && row != null && row instanceof Expandable && ((Expandable)((Object)row)).hasChildren() && (!((Expandable)((Object)row)).isExpanded() || TreeTableUtils.getDescendantCount(this.getModel(), row, false, false) > 0)) {
                Rectangle rectangle = this.getCellRect(n2, n3, true);
                int n4 = rectangle.x + row.getLevel() * this.getIndent() + (16 - this.getCollapsedIcon().getIconWidth()) / 2 - 1;
                if (!this.getShowsRootHandles()) {
                    n4 -= 16;
                }
                int n5 = n4 + this.getCollapsedIcon().getIconWidth() + 2;
                if (!this.getComponentOrientation().isLeftToRight()) {
                    n4 = rectangle.x + rectangle.width - (n4 - rectangle.x);
                    int n6 = n5 = rectangle.x + rectangle.width - (n5 - rectangle.x);
                    n5 = n4;
                    n4 = n6;
                }
                if (point.x > n4 && point.x < n5 && point.x < rectangle.x + rectangle.width) {
                    return row;
                }
            }
        }
        return null;
    }

    @Override
    public Rectangle getEditorCellRect(int n2, int n3) {
        Rectangle rectangle = super.getCellRect(n2, n3, false);
        if (n3 == this.getExpandableColumnViewIndex() && this.getCellRenderer(n2, n3) instanceof TreeTableCellRenderer) {
            Row row = this.getRowAt(n2);
            int n4 = 0;
            if (row != null) {
                n4 = row.getLevel() * this.getIndent() + this.getLeftMargin();
                if (!this.getShowsRootHandles()) {
                    n4 -= this.getLeftMargin();
                }
            }
            if (this.getComponentOrientation().isLeftToRight()) {
                rectangle.x += n4;
                rectangle.width -= n4;
            } else {
                rectangle.width -= n4;
            }
        }
        return rectangle;
    }

    @Override
    public boolean alwaysCalculateCellRect() {
        return true;
    }

    @Override
    void \u0101(TableCellRenderer tableCellRenderer, int n2, int n3, Component component, boolean bl) {
        super.\u0101(tableCellRenderer, n2, n3, component, bl);
        if (tableCellRenderer instanceof TreeTableCellRenderer) {
            ((TreeTableCellRenderer)tableCellRenderer).releaseCellRenderer();
        }
    }

    public boolean isRespectRenderPreferredHeight() {
        return this.\u11ef;
    }

    public void setRespectRenderPreferredHeight(boolean bl) {
        this.\u11ef = bl;
        this.repaint();
    }

    public boolean shouldDisplayExpandIcon(Row row) {
        TableModel tableModel = this.getModel();
        while (tableModel != null) {
            if (!((tableModel = TableModelWrapperUtils.getActualTableModel(tableModel, FilterableTreeTableModel.class)) instanceof FilterableTreeTableModel)) continue;
            if (!((FilterableTreeTableModel)tableModel).isKeepAllChildren() && ((FilterableTreeTableModel)tableModel).hasFilter() && ((FilterableTreeTableModel)tableModel).isFiltersApplied()) {
                if (TreeTableUtils.hasDescendant(tableModel, row, false, true)) break;
                return false;
            }
            tableModel = ((FilterableTreeTableModel)tableModel).getActualModel();
        }
        return true;
    }

    protected class DelegateExpandMouseInputListener
    extends DelegateMouseInputListener {
        public DelegateExpandMouseInputListener(MouseInputListener mouseInputListener) {
            super(mouseInputListener);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (TreeTable.this.isColumnResizable() && TableUtils.getResizingColumn(TreeTable.this, mouseEvent.getPoint(), TreeTable.this.columnAtPoint(mouseEvent.getPoint())) != null) {
                return;
            }
            TreeTable.this.handleMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                super.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (TreeTable.this._columnResizer != null && TreeTable.this._columnResizer.isResizing()) {
                return;
            }
            TreeTable.this.handleMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                super.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (TreeTable.this._columnResizer != null && TreeTable.this._columnResizer.isResizing()) {
                return;
            }
            TreeTable.this.handleMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                super.mouseDragged(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (TreeTable.this._columnResizer != null && TreeTable.this._columnResizer.isResizing()) {
                return;
            }
            super.mouseMoved(mouseEvent);
        }
    }

    protected class ExpandMouseListener
    extends MouseInputAdapter {
        protected ExpandMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            TreeTable.this.handleMouseEvent(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            TreeTable.this.handleMouseEvent(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            TreeTable.this.handleMouseEvent(mouseEvent);
        }
    }

    protected static class TreeTableAction
    extends CellSpanTable.DelegateAction {
        private static final long \u0103 = 1263872415793628604L;

        public TreeTableAction(Action action, KeyStroke keyStroke) {
            super(action, keyStroke);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreeTable treeTable = (TreeTable)actionEvent.getSource();
            if (!treeTable.isEditing()) {
                switch (this._keyStroke.getKeyCode()) {
                    case 37: 
                    case 109: {
                        if (!treeTable.isExpandable() || !this.expandSelectedRow(treeTable, false, true)) break;
                        return;
                    }
                    case 39: 
                    case 107: {
                        if (!treeTable.isExpandable() || !this.expandSelectedRow(treeTable, true, true)) break;
                        return;
                    }
                    case 106: {
                        if (!treeTable.isExpandable()) break;
                        this.expandAll(treeTable);
                        return;
                    }
                    case 111: {
                        if (!treeTable.isExpandable()) break;
                        this.collapseAll(treeTable);
                        return;
                    }
                    case 10: {
                        if (!this.stopEditing(treeTable)) break;
                        return;
                    }
                }
            }
            super.actionPerformed(actionEvent);
        }

        protected void expandAll(TreeTable treeTable) {
            treeTable.expandAll();
        }

        protected void collapseAll(TreeTable treeTable) {
            treeTable.collapseAll();
        }

        protected boolean expandSelectedRow(TreeTable treeTable, boolean bl, boolean bl2) {
            int n2;
            int n3 = treeTable.getSelectionModel().getLeadSelectionIndex();
            int n4 = n2 = treeTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            CellSpan cellSpan = treeTable.getCellSpanAt(n3, n2);
            if (cellSpan != null) {
                n2 = cellSpan.getColumn();
                n4 = n2 + cellSpan.getColumnSpan() - 1;
            }
            int n5 = treeTable.getExpandableColumnViewIndex();
            if (n3 != -1 && (!bl2 || n2 <= n5 && n4 >= n5)) {
                Expandable expandable;
                Row row;
                boolean bl3 = treeTable.expandRow(n3, bl);
                TableModel tableModel = treeTable.getTreeTableModel();
                if (!bl3 && !bl && tableModel instanceof ITreeTableModel && treeTable.isSelectParentRowWhenCollapsing() && (row = ((ITreeTableModel)((Object)tableModel)).getRowAt(n3)) != null && (expandable = row.getParent()) instanceof Row && !(expandable instanceof RootExpandableRow)) {
                    treeTable.setSelectedRow((Row)((Object)expandable));
                    bl3 = true;
                }
                return bl3;
            }
            return false;
        }

        protected boolean stopEditing(TreeTable treeTable) {
            return treeTable.isEditing() && treeTable.\u0293();
        }

        protected boolean cancelEditing(TreeTable treeTable) {
            if (treeTable.isEditing()) {
                treeTable.\u0296();
                return true;
            }
            return false;
        }
    }
}

