/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.RegexFilter;
import com.jidesoft.filter.WildcardFilter;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.ShrinkSearchableSupport;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.TableSearchable;
import java.beans.PropertyChangeEvent;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class TableShrinkSearchableSupport
extends ShrinkSearchableSupport {
    private FilterableTableModel \u0105;

    public TableShrinkSearchableSupport(Searchable searchable) {
        super(searchable);
        if (this._searchable == null || !(this._searchable instanceof TableSearchable)) {
            throw new IllegalArgumentException("The searchable instance should be TableSearchable for TableShrinkSearchableSupport");
        }
    }

    @Override
    protected boolean needReinstallFilterableModel(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getSource() == this._searchable.getComponent() && propertyChangeEvent.getNewValue() != this.\u0105;
    }

    @Override
    public void installFilterableModel() {
        if (this._searchable.getComponent() instanceof JTable) {
            if (!this._searchable.isSearchableListenerInstalled(this)) {
                this._searchable.addSearchableListener(this);
            }
            this.\u0105 = this.createFilterableTableModel(((JTable)this._searchable.getComponent()).getModel());
            this.\u0105.setAndMode(false);
            this._searchable.getComponent().removePropertyChangeListener("model", this);
            ((JTable)this._searchable.getComponent()).setModel(this.\u0105);
            this._searchable.getComponent().addPropertyChangeListener("model", this);
        }
    }

    protected FilterableTableModel createFilterableTableModel(TableModel tableModel) {
        if (TableModelWrapperUtils.getActualTableModel(tableModel, IExpandableTreeTableModel.class) != null) {
            return new FilterableTreeTableModel(tableModel);
        }
        return new FilterableTableModel(tableModel);
    }

    @Override
    public void uninstallFilterableModel() {
        this._searchable.getComponent().removePropertyChangeListener("model", this);
        if (this.\u0105 != null) {
            this._searchable.removeSearchableListener(this);
            ((JTable)this._searchable.getComponent()).setModel(this.\u0105.getActualModel());
            this.\u0105 = null;
        }
    }

    @Override
    protected void applyFilter(String string) {
        if (this.\u0105 == null) {
            return;
        }
        this.\u0105.clearFilters();
        if (string != null && string.length() > 0) {
            Object object;
            if (this._searchable.isWildcardEnabled() && (object = this._searchable.getWildcardSupport()) != null) {
                string = object.convert(string);
            }
            object = new WildcardFilter(string){
                private static final long \u0420 = 3292118432657792865L;

                @Override
                protected String convertElementToString(Object object) {
                    Object object2 = this.getObjectGrouper() == null ? object : this.getObjectGrouper().getValue(object);
                    String string = TableShrinkSearchableSupport.this.convertElementToString(object2);
                    if (string == null) {
                        string = super.convertElementToString(object);
                    }
                    return string != null ? string : ObjectConverterManager.toString(object2);
                }

                @Override
                protected Pattern createRegexPattern() {
                    return Pattern.compile(this.isBeginWith() ? "^" + this.getPattern() : this.getPattern(), this.isCaseSensitive() ? 0 : 2);
                }
            };
            ((RegexFilter)object).setBeginWith(this._searchable.isFromStart());
            ((RegexFilter)object).setEndWith(false);
            if (((TableSearchable)this._searchable).getMainIndex() == -1) {
                this.\u0105.addFilter((Filter)object);
            } else {
                this.\u0105.addFilter(((TableSearchable)this._searchable).getMainIndex(), (Filter)object);
                for (int n2 : ((TableSearchable)this._searchable).getSearchColumnIndices()) {
                    this.\u0105.addFilter(n2, (Filter)object);
                }
            }
        }
        this.\u0105.setFiltersApplied(true);
    }

    private boolean \u0101() {
        JTable jTable = (JTable)this._searchable.getComponent();
        return ((TableSearchable)this._searchable).getSearchColumnIndices().length == 1 && jTable.getColumnSelectionAllowed() && !jTable.getRowSelectionAllowed();
    }

    private boolean \u0102() {
        JTable jTable = (JTable)this._searchable.getComponent();
        return ((TableSearchable)this._searchable).getSearchColumnIndices().length == 1 && !jTable.getColumnSelectionAllowed() && jTable.getRowSelectionAllowed();
    }

    @Override
    protected int getActualIndexAt(int n2) {
        if (this.\u0105 == null || n2 < 0) {
            return n2;
        }
        if (this.\u0101()) {
            return n2;
        }
        if (this.\u0102()) {
            return this.\u0105.getActualRowAt(n2);
        }
        int n3 = this.\u0105.getColumnCount();
        int n4 = this.\u0105.getActualRowAt(n2 / n3);
        int n5 = n2 % n3;
        if (n4 >= 0) {
            return n4 * n3 + n5;
        }
        return -1;
    }

    @Override
    protected int getVisualIndexAt(int n2) {
        if (this.\u0105 == null || n2 < 0) {
            return n2;
        }
        if (this.\u0101()) {
            return n2;
        }
        if (this.\u0102()) {
            return this.\u0105.getVisualRowAt(n2);
        }
        int n3 = this.\u0105.getColumnCount();
        int n4 = this.\u0105.getActualRowAt(n2 / n3);
        int n5 = n2 % n3;
        if (n4 >= 0) {
            return n4 * n3 + n5;
        }
        return -1;
    }
}

