/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.DefaultMultiTableModel;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.JideTableTransferHandler;
import com.jidesoft.grid.ListSelectionModelGroup;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.MultiTableModelUtils;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.SortableTreeTableModel;
import com.jidesoft.grid.TableAdapter;
import com.jidesoft.grid.TableCustomizer;
import com.jidesoft.grid.TableModelWrapperImpl;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableScrollPanePrintable;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import sun.swing.PrintingStatus;

public class TableScrollPane
extends JideScrollPane
implements TableAdapter {
    protected MultiTableModel _originalTableModel;
    protected MultiTableModel _originalFooterTableModel;
    protected MultiTableModel _originalHeaderTableModel;
    protected JTable _mainTable;
    protected JTable _rowHeaderTable;
    protected JTable _rowFooterTable;
    protected JTable _columnFooterTable;
    protected JTable _rowHeaderColumnFooterTable;
    protected JTable _rowFooterColumnFooterTable;
    protected JTable _columnHeaderTable;
    protected JTable _rowHeaderColumnHeaderTable;
    protected JTable _rowFooterColumnHeaderTable;
    private boolean \u0696;
    private boolean \u068c;
    private TableCustomizer \u068d;
    private boolean \u0693 = false;
    private ListSelectionModelGroup \u0694;
    private ListSelectionModelGroup \u0695;
    private ListSelectionModelGroup \u068f;
    private boolean \u0690 = false;
    private TableModelListener \u068e;
    private Throwable \u0691;
    public static final String TABLE_KEY = "TableScrollPane.TableKey";
    public static final String TABLESCROLLPANE_KEY = "TableScrollPane.Parent";
    public static final String MAIN_TABLE = "TableScrollPane.MainTable";
    public static final String ROWHEADER_TABLE = "TableScrollPane.RowHeaderTable";
    public static final String ROWFOOTER_TABLE = "TableScrollPane.RowFooterTable";
    public static final String COLUMNFOOTER_TABLE = "TableScrollPane.ColumnFooterTable";
    public static final String ROWHEADER_COLUMNFOOTER_TABLE = "TableScrollPane.RowHeaderColumnFooterTable";
    public static final String ROWFOOTER_COLUMNFOOTER_TABLE = "TableScrollPane.RowFooterColumnFooterTable";
    public static final String COLUMNHEADER_TABLE = "TableScrollPane.ColumnHeaderTable";
    public static final String ROWHEADER_COLUMNHEADER_TABLE = "TableScrollPane.RowHeaderColumnHeaderTable";
    public static final String ROWFOOTER_COLUMNHEADER_TABLE = "TableScrollPane.RowFooterColumnHeaderTable";
    public static final String PROPERTY_TABLE_MODEL = "tableModel";
    public static final String AUTO_UPDATE_FOOTER_TABLE_COLUMNS = "TableScrollPane.AutoUpdateFooterTableColumns";
    private static final Logger \u068b;
    private boolean \u0692 = false;
    protected boolean _rowSelectionAllowed = true;
    protected boolean _columnSelectionAllowed = false;
    protected boolean _nonContiguousCellSelectionAllowed = false;
    boolean \u068a = false;

    public TableScrollPane() {
        this((MultiTableModel)new DefaultMultiTableModel(), null, false);
    }

    public TableScrollPane(MultiTableModel multiTableModel) {
        this(multiTableModel, null, false);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2) {
        this(multiTableModel, multiTableModel2, false);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, boolean bl) {
        this(multiTableModel, multiTableModel2, bl, true);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, MultiTableModel multiTableModel3) {
        this(multiTableModel, multiTableModel2, multiTableModel3, false, true);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, MultiTableModel multiTableModel3, boolean bl) {
        this(multiTableModel, multiTableModel2, multiTableModel3, bl, true);
    }

    public TableScrollPane(MultiTableModel multiTableModel, boolean bl) {
        this(multiTableModel, null, bl, true);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, boolean bl, boolean bl2) {
        this(multiTableModel, null, multiTableModel2, bl, 0, bl2);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, MultiTableModel multiTableModel3, boolean bl, boolean bl2) {
        this(multiTableModel, multiTableModel2, multiTableModel3, bl, 0, bl2);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, boolean bl, int n2, boolean bl2) {
        this(multiTableModel, null, multiTableModel2, bl, n2, bl2);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, MultiTableModel multiTableModel3, boolean bl, int n2, boolean bl2) {
        this.setColumnHeadersHeightUnified(true);
        this.setColumnFootersHeightUnified(true);
        this.setSortable(bl);
        this.\u068c = bl2;
        if (multiTableModel == null) {
            throw new IllegalArgumentException("tableModel parameter can not be null.");
        }
        this.\u0102(multiTableModel, n2);
        this.\u0101(multiTableModel3, n2);
        this.\u0103(multiTableModel2, n2);
        TableUtils.unifyTableCellEditing(this.getAllChildTables());
        this.\u0188();
    }

    private void \u017d() {
        JTable[] jTableArray = new JTable[]{this._rowHeaderColumnHeaderTable, this._columnHeaderTable, this._rowFooterColumnHeaderTable};
        JTable[] jTableArray2 = new JTable[]{this._rowHeaderTable, this._mainTable, this._rowFooterTable};
        JTable[] jTableArray3 = new JTable[]{this._rowHeaderColumnFooterTable, this._columnFooterTable, this._rowFooterColumnFooterTable};
        JTable[][] jTableArray4 = new JTable[][]{jTableArray, jTableArray2, jTableArray3};
        TableUtils.unsynchronizeNavigationKeys(jTableArray4);
    }

    private void \u0188() {
        JTable[] jTableArray = new JTable[]{this._rowHeaderColumnHeaderTable, this._columnHeaderTable, this._rowFooterColumnHeaderTable};
        JTable[] jTableArray2 = new JTable[]{this._rowHeaderTable, this._mainTable, this._rowFooterTable};
        JTable[] jTableArray3 = new JTable[]{this._rowHeaderColumnFooterTable, this._columnFooterTable, this._rowFooterColumnFooterTable};
        JTable[][] jTableArray4 = new JTable[][]{jTableArray, jTableArray2, jTableArray3};
        TableUtils.synchronizeNavigationKeys(jTableArray4);
    }

    @Override
    public void setModel(TableModel tableModel) {
        if (tableModel instanceof MultiTableModel) {
            this.setTableModel((MultiTableModel)tableModel);
        }
    }

    public void setTableModel(MultiTableModel multiTableModel) {
        this.\u017d();
        this.\u0102(multiTableModel, 0);
        this.\u0188();
    }

    private void \u0102(MultiTableModel multiTableModel, int n2) {
        MultiTableModel multiTableModel2 = this._originalTableModel;
        if (this._originalTableModel != multiTableModel) {
            TableModel tableModel;
            if (this.\u0690 && (tableModel = SortableTableModel.getSortableModel(this.getMainTable().getModel())) instanceof TableModelWrapperImpl && !TableModelWrapperUtils.\u0101(tableModel, multiTableModel) && !TableModelWrapperUtils.\u0101(multiTableModel, tableModel)) {
                ((TableModelWrapperImpl)tableModel).\u0101(null, false);
            }
            if (this._originalTableModel != null && this.\u068e != null) {
                this._originalTableModel.removeTableModelListener(this.\u068e);
            }
            this._originalTableModel = multiTableModel;
            if (this.\u068e == null) {
                this.\u068e = new TableModelListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void tableChanged(TableModelEvent tableModelEvent) {
                        if (tableModelEvent.getColumn() == -1 && tableModelEvent.getFirstRow() == -1) {
                            try {
                                TableScrollPane.this.\u010a(true);
                                TableScrollPane.this.refreshColumns();
                                TableScrollPane.this.\u010a(false);
                            }
                            catch (Throwable throwable) {
                                TableScrollPane.this.\u010a(false);
                                for (JTable jTable : TableScrollPane.this.\u018c()) {
                                    jTable.setPreferredScrollableViewportSize(jTable.getPreferredSize());
                                    TableScrollPane.this.\u0101(jTable, jTable != TableScrollPane.this.getMainTable() && jTable != TableScrollPane.this.getColumnFooterTable() && jTable != TableScrollPane.this.getColumnHeaderTable());
                                }
                                throw throwable;
                            }
                            for (JTable jTable : TableScrollPane.this.\u018c()) {
                                jTable.setPreferredScrollableViewportSize(jTable.getPreferredSize());
                                TableScrollPane.this.\u0101(jTable, jTable != TableScrollPane.this.getMainTable() && jTable != TableScrollPane.this.getColumnFooterTable() && jTable != TableScrollPane.this.getColumnHeaderTable());
                            }
                        }
                    }
                };
            }
            if (multiTableModel != null) {
                multiTableModel.addTableModelListener(this.\u068e);
                tableModel = this.createSortableTableModel(multiTableModel, this.isSortable());
                if (TableModelWrapperUtils.\u0101(multiTableModel, tableModel)) {
                    tableModel = multiTableModel;
                }
                this.\u0101(tableModel, this.isSortable(), n2, this.\u068c);
                this.firePropertyChange(PROPERTY_TABLE_MODEL, multiTableModel2, multiTableModel);
                this.resynchronizeTablesSelection();
            }
        }
    }

    boolean \u0180() {
        return this.\u0692;
    }

    void \u010a(boolean bl) {
        this.\u0692 = bl;
    }

    protected TableModel createSortableTableModel(MultiTableModel multiTableModel, boolean bl) {
        TableModel tableModel;
        this.\u0690 = false;
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(multiTableModel, IExpandableTreeTableModel.class);
        if (tableModel2 instanceof IExpandableTreeTableModel && bl) {
            SortableTreeTableModel sortableTreeTableModel = TableModelWrapperUtils.getActualTableModel(multiTableModel, SortableTreeTableModel.class);
            if (sortableTreeTableModel instanceof SortableTreeTableModel) {
                tableModel = sortableTreeTableModel;
            } else {
                tableModel = new SortableTreeTableModel(multiTableModel);
                this.\u0690 = true;
            }
        } else {
            TableModel tableModel3 = TableModelWrapperUtils.getActualTableModel(multiTableModel, SortableTableModel.class);
            if (!(tableModel3 instanceof ISortableTableModel) && bl) {
                tableModel = new SortableTableModel(multiTableModel);
                this.\u0690 = true;
            } else {
                tableModel = tableModel3 != null ? tableModel3 : multiTableModel;
            }
        }
        return tableModel;
    }

    public MultiTableModel getTableModel() {
        return this.getModel();
    }

    @Override
    public MultiTableModel getModel() {
        return this._originalTableModel;
    }

    public void setFooterTableModel(MultiTableModel multiTableModel) {
        this.\u017d();
        this.\u0101(multiTableModel, 0);
        this.\u0188();
    }

    private void \u0101(MultiTableModel multiTableModel, int n2) {
        if (multiTableModel != null) {
            this._originalFooterTableModel = multiTableModel;
            this.\u0102(multiTableModel, n2, this.\u068c);
            this.resynchronizeTablesSelection();
        }
    }

    public void setHeaderTableModel(MultiTableModel multiTableModel) {
        this.\u017d();
        this.\u0103(multiTableModel, 0);
        this.\u0188();
    }

    private void \u0103(MultiTableModel multiTableModel, int n2) {
        if (multiTableModel != null) {
            this._originalHeaderTableModel = multiTableModel;
            this.\u0101(multiTableModel, n2, this.\u068c);
            this.resynchronizeTablesSelection();
        }
    }

    public MultiTableModel getFooterTableModel() {
        return this._originalFooterTableModel;
    }

    public boolean isSortable() {
        return this.\u0696;
    }

    public void setSortable(boolean bl) {
        boolean bl2 = this.\u0696;
        if (bl2 != bl) {
            this.\u0696 = bl;
            if (this.getTableModel() != null) {
                this.setTableModel(this.getTableModel());
            }
        }
    }

    private void \u0101(TableModel tableModel, boolean bl, int n2, boolean bl2) {
        if (!(tableModel instanceof MultiTableModel)) {
            throw new IllegalArgumentException("The table model is not an instance of MultiTableModel.");
        }
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        this._mainTable = this.\u0101(tableModel, 0, n2, false, bl);
        this._mainTable.setFocusable(this._mainTable.getColumnCount() != 0);
        this.setViewportView(this._mainTable);
        this._rowHeaderTable = this.\u0101(tableModel, 1, n2, false, bl);
        this._rowHeaderTable.setFocusable(this._rowHeaderTable.getColumnCount() != 0);
        this.\u0102(this._rowHeaderTable, true);
        this.setRowHeaderView(this._rowHeaderTable);
        this.setCorner("UPPER_LEFT_CORNER", this._rowHeaderTable.getTableHeader());
        this._rowHeaderTable.addPropertyChangeListener("tableHeader", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TableScrollPane.this.setCorner("UPPER_LEFT_CORNER", TableScrollPane.this._rowHeaderTable.getTableHeader());
            }
        });
        arrayList.add(this._rowHeaderTable);
        if (MultiTableModelUtils.getColumnCount(tableModel, 1, n2) == 0) {
            JideSwingUtilities.unsynchronizeView(this.getRowHeader(), this.getViewport());
            JideSwingUtilities.unsynchronizeView(this.getViewport(), this.getRowHeader());
        } else {
            JideSwingUtilities.synchronizeView(this.getRowHeader(), this.getViewport(), 1);
            JideSwingUtilities.synchronizeView(this.getViewport(), this.getRowHeader(), 1);
        }
        arrayList.add(this._mainTable);
        this._rowFooterTable = this.\u0101(tableModel, 2, n2, false, bl);
        this._rowFooterTable.setFocusable(this._rowFooterTable.getColumnCount() != 0);
        this.\u0102(this._rowFooterTable, true);
        this.setRowFooterView(this._rowFooterTable);
        this.setCorner("UPPER_RIGHT_CORNER", this._rowFooterTable.getTableHeader());
        this._rowFooterTable.addPropertyChangeListener("tableHeader", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TableScrollPane.this.setCorner("UPPER_RIGHT_CORNER", TableScrollPane.this._rowFooterTable.getTableHeader());
            }
        });
        if (MultiTableModelUtils.getColumnCount(tableModel, 2, n2) == 0) {
            JideSwingUtilities.unsynchronizeView(this.getRowFooter(), this.getViewport());
            JideSwingUtilities.unsynchronizeView(this.getViewport(), this.getRowFooter());
        } else {
            JideSwingUtilities.synchronizeView(this.getRowFooter(), this.getViewport(), 1);
            JideSwingUtilities.synchronizeView(this.getViewport(), this.getRowFooter(), 1);
        }
        arrayList.add(this._rowFooterTable);
        if (bl2 && arrayList.size() > 1) {
            TableUtils.synchronizeTables(arrayList.toArray(new JTable[arrayList.size()]), this.getRowSelectionAllowed(), this.getColumnSelectionAllowed(), this.isNonContiguousCellSelectionAllowed());
        }
        for (JTable jTable : arrayList) {
            this.customizeTable(jTable);
        }
    }

    private void \u0102(TableModel tableModel, int n2, boolean bl) {
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        if (MultiTableModelUtils.getColumnCount(tableModel, 0, n2) != this._mainTable.getColumnCount() && \u068b.isLoggable(Level.FINE)) {
            \u068b.fine("TableScrollPane \" tableModel and footerTableModel must have the same column count.");
        }
        this._columnFooterTable = this.\u0101(tableModel, 0, n2, true, false);
        this.\u0102(this._columnFooterTable, false);
        this.setColumnFooterView(this._columnFooterTable);
        TableUtils.synchronizeTableColumn(this._mainTable, this._columnFooterTable);
        if (MultiTableModelUtils.getColumnCount(tableModel, 1, n2) != 0) {
            this._rowHeaderColumnFooterTable = this.\u0101(tableModel, 1, n2, true, false);
            if (this._rowHeaderTable.getColumnCount() != this._rowHeaderColumnFooterTable.getColumnCount()) {
                throw new IllegalArgumentException("tableModel and footerTableModel must have the same column count.");
            }
            this.\u0102(this._rowHeaderColumnFooterTable, false);
            this.setCorner("LOWER_LEFT_CORNER", this._rowHeaderColumnFooterTable);
            arrayList.add(this._rowHeaderColumnFooterTable);
            TableUtils.synchronizeTableColumn(this._rowHeaderTable, this._rowHeaderColumnFooterTable);
        }
        arrayList.add(this._columnFooterTable);
        if (MultiTableModelUtils.getColumnCount(tableModel, 2, n2) != 0) {
            this._rowFooterColumnFooterTable = this.\u0101(tableModel, 2, n2, true, false);
            if (this._rowFooterColumnFooterTable.getColumnCount() != this._rowFooterTable.getColumnCount()) {
                throw new IllegalArgumentException("tableModel and footerTableModel must have the same column count.");
            }
            this.\u0102(this._rowFooterColumnFooterTable, true);
            this.setCorner("LOWER_RIGHT_CORNER", this._rowFooterColumnFooterTable);
            arrayList.add(this._rowFooterColumnFooterTable);
            TableUtils.synchronizeTableColumn(this._rowFooterTable, this._rowFooterColumnFooterTable);
        }
        if (!this.isAllowMultiSelectionInDifferentTable()) {
            this.\u0186();
        }
        if (bl && arrayList.size() > 1) {
            TableUtils.synchronizeTables(arrayList.toArray(new JTable[arrayList.size()]));
        }
        for (JTable jTable : arrayList) {
            this.customizeTable(jTable);
        }
    }

    private void \u0101(TableModel tableModel, int n2, boolean bl) {
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        if (MultiTableModelUtils.getColumnCount(tableModel, 0, n2) != this._mainTable.getColumnCount() && \u068b.isLoggable(Level.FINE)) {
            \u068b.fine("TableScrollPane \" tableModel and headerTableModel must have the same column count.");
        }
        this._columnHeaderTable = this.\u0101(tableModel, 0, n2, true, false);
        this.\u0102(this._columnHeaderTable, false);
        this.setSubColumnHeaderView(this._columnHeaderTable);
        TableUtils.synchronizeTableColumn(this._mainTable, this._columnHeaderTable);
        if (MultiTableModelUtils.getColumnCount(tableModel, 1, n2) != 0) {
            this._rowHeaderColumnHeaderTable = this.\u0101(tableModel, 1, n2, true, false);
            if (this._rowHeaderTable.getColumnCount() != this._rowHeaderColumnHeaderTable.getColumnCount()) {
                throw new IllegalArgumentException("tableModel and headerTableModel must have the same column count.");
            }
            this.\u0102(this._rowHeaderColumnHeaderTable, false);
            this.setCorner("SUB_UPPER_LEFT", this._rowHeaderColumnHeaderTable);
            arrayList.add(this._rowHeaderColumnHeaderTable);
            TableUtils.synchronizeTableColumn(this._rowHeaderTable, this._rowHeaderColumnHeaderTable);
        }
        arrayList.add(this._columnHeaderTable);
        if (MultiTableModelUtils.getColumnCount(tableModel, 2, n2) != 0) {
            this._rowFooterColumnHeaderTable = this.\u0101(tableModel, 2, n2, true, false);
            if (this._rowFooterColumnHeaderTable.getColumnCount() != this._rowFooterTable.getColumnCount()) {
                throw new IllegalArgumentException("tableModel and headerTableModel must have the same column count.");
            }
            this.\u0102(this._rowFooterColumnHeaderTable, true);
            this.setCorner("SUB_UPPER_RIGHT", this._rowFooterColumnHeaderTable);
            arrayList.add(this._rowFooterColumnHeaderTable);
            TableUtils.synchronizeTableColumn(this._rowFooterTable, this._rowFooterColumnHeaderTable);
        }
        if (!this.isAllowMultiSelectionInDifferentTable()) {
            this.\u0186();
        }
        if (bl && arrayList.size() > 1) {
            TableUtils.synchronizeTables(arrayList.toArray(new JTable[arrayList.size()]));
        }
        for (JTable jTable : arrayList) {
            this.customizeTable(jTable);
        }
    }

    protected void customizeTable(JTable jTable) {
    }

    public JTable getMainTable() {
        return this._mainTable;
    }

    public JTable getRowHeaderTable() {
        return this._rowHeaderTable;
    }

    public JTable getRowFooterTable() {
        return this._rowFooterTable;
    }

    public JTable getColumnFooterTable() {
        return this._columnFooterTable;
    }

    public JTable getRowHeaderColumnFooterTable() {
        return this._rowHeaderColumnFooterTable;
    }

    public JTable getRowFooterColumnFooterTable() {
        return this._rowFooterColumnFooterTable;
    }

    public JTable getColumnHeaderTable() {
        return this._columnHeaderTable;
    }

    public JTable getRowHeaderColumnHeaderTable() {
        return this._rowHeaderColumnHeaderTable;
    }

    public JTable getRowFooterColumnHeaderTable() {
        return this._rowFooterColumnHeaderTable;
    }

    @Deprecated
    protected JTable createTable(TableModel tableModel, boolean bl, int n2, int n3) {
        return this.createTable(tableModel, bl, n2, false, n3);
    }

    protected JTable createTable(TableModel tableModel, boolean bl, int n2, boolean bl2, int n3) {
        JTable jTable = this.createTable(tableModel, bl, n2);
        String string = null;
        switch (n2) {
            case 0: {
                string = bl2 ? (tableModel == this._originalFooterTableModel ? COLUMNFOOTER_TABLE : COLUMNHEADER_TABLE) : MAIN_TABLE;
                break;
            }
            case 1: {
                string = bl2 ? (tableModel == this._originalFooterTableModel ? ROWHEADER_COLUMNFOOTER_TABLE : ROWHEADER_COLUMNHEADER_TABLE) : ROWHEADER_TABLE;
                break;
            }
            case 2: {
                string = bl2 ? (tableModel == this._originalFooterTableModel ? ROWFOOTER_COLUMNFOOTER_TABLE : ROWFOOTER_COLUMNHEADER_TABLE) : ROWFOOTER_TABLE;
            }
        }
        jTable.putClientProperty(TABLE_KEY, string);
        jTable.putClientProperty("TableSplitPane.index", n3);
        jTable.putClientProperty(TABLESCROLLPANE_KEY, this);
        jTable.setAutoResizeMode(256);
        if (jTable instanceof SortableTable) {
            ((SortableTable)jTable).setSortable(bl);
        }
        return jTable;
    }

    protected JTable createTable(TableModel tableModel, boolean bl, int n2) {
        return this.createTable(tableModel, bl);
    }

    protected JTable createTable(TableModel tableModel, boolean bl) {
        return new SortableTable(tableModel);
    }

    public boolean isEditing() {
        if (this.getMainTable() != null && this.getMainTable().isEditing()) {
            return true;
        }
        if (this.getRowHeaderTable() != null && this.getRowHeaderTable().isEditing()) {
            return true;
        }
        if (this.getRowFooterTable() != null && this.getRowFooterTable().isEditing()) {
            return true;
        }
        if (this.getColumnFooterTable() != null && this.getColumnFooterTable().isEditing()) {
            return true;
        }
        if (this.getRowHeaderColumnFooterTable() != null && this.getRowHeaderColumnFooterTable().isEditing()) {
            return true;
        }
        if (this.getRowFooterColumnFooterTable() != null && this.getRowFooterColumnFooterTable().isEditing()) {
            return true;
        }
        if (this.getColumnHeaderTable() != null && this.getColumnHeaderTable().isEditing()) {
            return true;
        }
        if (this.getRowHeaderColumnHeaderTable() != null && this.getRowHeaderColumnHeaderTable().isEditing()) {
            return true;
        }
        return this.getRowFooterColumnHeaderTable() != null && this.getRowFooterColumnHeaderTable().isEditing();
    }

    public JTable getEditingTable() {
        if (this.getMainTable() != null && this.getMainTable().isEditing()) {
            return this.getMainTable();
        }
        if (this.getRowHeaderTable() != null && this.getRowHeaderTable().isEditing()) {
            return this.getRowHeaderTable();
        }
        if (this.getRowFooterTable() != null && this.getRowFooterTable().isEditing()) {
            return this.getRowFooterTable();
        }
        if (this.getColumnFooterTable() != null && this.getColumnFooterTable().isEditing()) {
            return this.getColumnFooterTable();
        }
        if (this.getRowHeaderColumnFooterTable() != null && this.getRowHeaderColumnFooterTable().isEditing()) {
            return this.getRowHeaderColumnFooterTable();
        }
        if (this.getRowFooterColumnFooterTable() != null && this.getRowFooterColumnFooterTable().isEditing()) {
            return this.getRowFooterColumnFooterTable();
        }
        return null;
    }

    public JTable[] getAllChildTables() {
        List<JTable> list = this.\u018c();
        if (list.size() > 0) {
            return list.toArray(new JTable[list.size()]);
        }
        return new JTable[0];
    }

    JTable[] \u0102(JTable jTable) {
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        if (jTable == this.getMainTable()) {
            if (this.getColumnFooterTable() != null) {
                arrayList.add(this.getColumnFooterTable());
            }
            if (this.getColumnHeaderTable() != null) {
                arrayList.add(this.getColumnHeaderTable());
            }
        } else if (jTable == this.getColumnHeaderTable()) {
            if (this.getMainTable() != null) {
                arrayList.add(this.getMainTable());
            }
            if (this.getColumnFooterTable() != null) {
                arrayList.add(this.getColumnFooterTable());
            }
        } else if (jTable == this.getColumnFooterTable()) {
            if (this.getMainTable() != null) {
                arrayList.add(this.getMainTable());
            }
            if (this.getColumnHeaderTable() != null) {
                arrayList.add(this.getColumnHeaderTable());
            }
        } else if (jTable == this.getRowHeaderTable()) {
            if (this.getRowHeaderColumnFooterTable() != null) {
                arrayList.add(this.getRowHeaderColumnFooterTable());
            }
            if (this.getRowHeaderColumnHeaderTable() != null) {
                arrayList.add(this.getRowHeaderColumnHeaderTable());
            }
        } else if (jTable == this.getRowHeaderColumnHeaderTable()) {
            if (this.getRowHeaderTable() != null) {
                arrayList.add(this.getRowHeaderTable());
            }
            if (this.getRowHeaderColumnFooterTable() != null) {
                arrayList.add(this.getRowHeaderColumnFooterTable());
            }
        } else if (jTable == this.getRowHeaderColumnFooterTable()) {
            if (this.getRowHeaderTable() != null) {
                arrayList.add(this.getRowHeaderTable());
            }
            if (this.getRowHeaderColumnHeaderTable() != null) {
                arrayList.add(this.getRowHeaderColumnHeaderTable());
            }
        } else if (jTable == this.getRowFooterTable()) {
            if (this.getRowFooterColumnFooterTable() != null) {
                arrayList.add(this.getRowFooterColumnFooterTable());
            }
            if (this.getRowFooterColumnHeaderTable() != null) {
                arrayList.add(this.getRowFooterColumnHeaderTable());
            }
        } else if (jTable == this.getRowFooterColumnHeaderTable()) {
            if (this.getRowFooterTable() != null) {
                arrayList.add(this.getRowFooterTable());
            }
            if (this.getRowFooterColumnFooterTable() != null) {
                arrayList.add(this.getRowFooterColumnFooterTable());
            }
        } else if (jTable == this.getRowFooterColumnFooterTable()) {
            if (this.getRowFooterTable() != null) {
                arrayList.add(this.getRowFooterTable());
            }
            if (this.getRowFooterColumnHeaderTable() != null) {
                arrayList.add(this.getRowFooterColumnHeaderTable());
            }
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new JTable[arrayList.size()]);
        }
        return new JTable[0];
    }

    List<JTable> \u018c() {
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        if (this.getMainTable() != null) {
            arrayList.add(this.getMainTable());
        }
        if (this.getRowHeaderTable() != null) {
            arrayList.add(this.getRowHeaderTable());
        }
        if (this.getRowFooterTable() != null) {
            arrayList.add(this.getRowFooterTable());
        }
        if (this.getColumnFooterTable() != null) {
            arrayList.add(this.getColumnFooterTable());
        }
        if (this.getRowHeaderColumnFooterTable() != null) {
            arrayList.add(this.getRowHeaderColumnFooterTable());
        }
        if (this.getRowFooterColumnFooterTable() != null) {
            arrayList.add(this.getRowFooterColumnFooterTable());
        }
        if (this.getColumnHeaderTable() != null) {
            arrayList.add(this.getColumnHeaderTable());
        }
        if (this.getRowHeaderColumnHeaderTable() != null) {
            arrayList.add(this.getRowHeaderColumnHeaderTable());
        }
        if (this.getRowFooterColumnHeaderTable() != null) {
            arrayList.add(this.getRowFooterColumnHeaderTable());
        }
        return arrayList;
    }

    public TableCellEditor getCellEditor() {
        JTable jTable = this.getEditingTable();
        if (jTable != null) {
            return jTable.getCellEditor();
        }
        return null;
    }

    private JTable \u0101(TableModel tableModel, int n2, int n3, boolean bl, boolean bl2) {
        JTable jTable = this.createTable(tableModel, bl2, n2, bl, n3);
        TransferHandler transferHandler = jTable.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource || transferHandler instanceof JideTableTransferHandler) {
            jTable.setTransferHandler(new TableUtils.H());
        }
        this.removeExtraColumns(jTable, n2, n3);
        TableCustomizer tableCustomizer = this.getTableCustomizer();
        if (tableCustomizer != null) {
            tableCustomizer.customize(jTable);
        }
        return jTable;
    }

    protected void removeExtraColumns(final JTable jTable, final int n2, final int n3) {
        jTable.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MultiTableModelUtils.removeExtraColumns(jTable, n2, n3);
            }
        });
        final TableColumnModelListener tableColumnModelListener = new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                MultiTableModelUtils.removeExtraColumns(jTable, n2, n3, tableColumnModelEvent.getToIndex());
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        };
        jTable.getColumnModel().addColumnModelListener(tableColumnModelListener);
        jTable.addPropertyChangeListener("columnModel", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((TableColumnModel)propertyChangeEvent.getOldValue()).removeColumnModelListener(tableColumnModelListener);
                ((TableColumnModel)propertyChangeEvent.getNewValue()).addColumnModelListener(tableColumnModelListener);
            }
        });
        MultiTableModelUtils.removeExtraColumns(jTable, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshColumns() {
        Object object;
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        if (this.getRowHeaderTable() != null) {
            arrayList.add(this.getRowHeaderTable());
            this.getRowHeaderTable().setFocusable(this.getRowHeaderTable().getColumnCount() != 0);
        }
        if (this.getMainTable() != null) {
            arrayList.add(this.getMainTable());
            this.getMainTable().setFocusable(this.getMainTable().getColumnCount() != 0);
        }
        if (this.getRowFooterTable() != null) {
            arrayList.add(this.getRowFooterTable());
            this.getRowFooterTable().setFocusable(this.getRowFooterTable().getColumnCount() != 0);
        }
        try {
            int n2 = 0;
            Object object22 = this.getClientProperty("TableSplitPane.index");
            if (object22 instanceof Integer) {
                n2 = (Integer)object22;
            }
            MultiTableModelUtils.refreshColumns(arrayList.toArray(new JTable[arrayList.size()]), n2);
        }
        finally {
            for (JTable jTable : arrayList) {
                this.\u0101(jTable, true);
            }
        }
        arrayList.clear();
        if (this.getRowHeaderColumnFooterTable() != null) {
            arrayList.add(this.getRowHeaderColumnFooterTable());
            this.getRowHeaderColumnFooterTable().setFocusable(this.getRowHeaderColumnFooterTable().getColumnCount() != 0);
        }
        if (this.getColumnFooterTable() != null) {
            arrayList.add(this.getColumnFooterTable());
            this.getColumnFooterTable().setFocusable(this.getColumnFooterTable().getColumnCount() != 0);
        }
        if (this.getRowFooterColumnFooterTable() != null) {
            arrayList.add(this.getRowFooterColumnFooterTable());
            this.getRowFooterColumnFooterTable().setFocusable(this.getRowFooterColumnFooterTable().getColumnCount() != 0);
        }
        try {
            int n3 = 0;
            Object object2 = this.getClientProperty("TableSplitPane.index");
            if (object2 instanceof Integer) {
                n3 = (Integer)object2;
            }
            MultiTableModelUtils.refreshColumns(arrayList.toArray(new JTable[arrayList.size()]), n3);
        }
        finally {
            for (JTable jTable : arrayList) {
                this.\u0101(jTable, false);
            }
        }
        if (this.getMainTable() != null && this.getColumnFooterTable() != null) {
            object = this.getMainTable();
            JTable jTable = this.getColumnFooterTable();
            TableUtils.synchronizeTableAndColumnsWidth((JTable)object, jTable);
        }
        if (this.getRowHeaderTable() != null && this.getRowHeaderColumnFooterTable() != null) {
            object = this.getRowHeaderTable();
            JTable jTable = this.getRowHeaderColumnFooterTable();
            TableUtils.synchronizeTableAndColumnsWidth((JTable)object, jTable);
        }
        if (this.getRowFooterTable() != null && this.getRowFooterColumnFooterTable() != null) {
            object = this.getRowFooterTable();
            JTable jTable = this.getRowFooterColumnFooterTable();
            TableUtils.synchronizeTableAndColumnsWidth((JTable)object, jTable);
        }
    }

    private void \u0102(final JTable jTable, final boolean bl) {
        jTable.setPreferredScrollableViewportSize(jTable.getPreferredSize());
        jTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
                TableScrollPane.this.\u0101(jTable, bl);
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                if (!TableScrollPane.this.\u0180()) {
                    jTable.setPreferredScrollableViewportSize(jTable.getPreferredSize());
                    TableScrollPane.this.\u0101(jTable, bl);
                }
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                if (!TableScrollPane.this.\u0180()) {
                    jTable.setPreferredScrollableViewportSize(jTable.getPreferredSize());
                    TableScrollPane.this.\u0101(jTable, bl);
                }
            }
        });
    }

    void \u0101(JTable jTable, boolean bl) {
        Dimension dimension = jTable.getPreferredScrollableViewportSize();
        Dimension dimension2 = jTable.getPreferredSize();
        if (!JideSwingUtilities.equals(dimension2, dimension)) {
            jTable.setPreferredScrollableViewportSize(dimension2);
        }
        Container container = jTable.getParent();
        if (bl && container instanceof JViewport) {
            container.setPreferredSize(dimension2);
            container.invalidate();
        }
    }

    public void resizeRowHeaderTableToFit() {
        JTable jTable = this.getRowHeaderTable();
        if (jTable != null) {
            Dimension dimension = jTable.getPreferredSize();
            jTable.setPreferredScrollableViewportSize(dimension);
            if (jTable.getParent() instanceof JViewport) {
                Container container = jTable.getParent();
                if (container instanceof JComponent) {
                    container.setPreferredSize(dimension);
                }
                container.invalidate();
            }
        }
    }

    public TableCustomizer getTableCustomizer() {
        return this.\u068d;
    }

    public void setTableCustomizer(TableCustomizer tableCustomizer) {
        this.\u068d = tableCustomizer;
    }

    @Override
    public void setRowSelectionAllowed(boolean bl) {
        boolean bl2 = this._rowSelectionAllowed;
        this._rowSelectionAllowed = bl;
        if (bl2 != bl) {
            this.repaint();
            this.firePropertyChange("rowSelectionAllowed", bl2, bl);
            this.resynchronizeTablesSelection();
        }
    }

    @Override
    public boolean getRowSelectionAllowed() {
        return this._rowSelectionAllowed || this.isNonContiguousCellSelectionAllowed();
    }

    @Override
    public void setColumnSelectionAllowed(boolean bl) {
        boolean bl2 = this._columnSelectionAllowed;
        this._columnSelectionAllowed = bl;
        if (bl2 != bl) {
            this.repaint();
            this.firePropertyChange("columnSelectionAllowed", bl2, bl);
            this.resynchronizeTablesSelection();
        }
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this._columnSelectionAllowed || this.isNonContiguousCellSelectionAllowed();
    }

    @Override
    public void setCellSelectionEnabled(boolean bl) {
        boolean bl2 = this.getCellSelectionEnabled();
        this.setRowSelectionAllowed(bl);
        this.setColumnSelectionAllowed(bl);
        this.firePropertyChange("cellSelectionEnabled", bl2, bl);
        this.resynchronizeTablesSelection();
    }

    @Override
    public boolean getCellSelectionEnabled() {
        return this.getRowSelectionAllowed() && this.getColumnSelectionAllowed();
    }

    public void setNonContiguousCellSelectionAllowed(boolean bl) {
        boolean bl2 = this._nonContiguousCellSelectionAllowed;
        this._nonContiguousCellSelectionAllowed = bl;
        if (bl2 != bl) {
            this.repaint();
            this.firePropertyChange("nonContiguousCellSelectionAllowed", bl2, bl);
            this.resynchronizeTablesSelection();
        }
    }

    public boolean isNonContiguousCellSelectionAllowed() {
        return this._nonContiguousCellSelectionAllowed;
    }

    protected void resynchronizeTablesSelection() {
        JTable[] jTableArray = this.getAllChildTables();
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        if (this.getRowHeaderTable() != null) {
            arrayList.add(this.getRowHeaderTable());
        }
        if (this.getMainTable() != null) {
            arrayList.add(this.getMainTable());
        }
        if (this.getRowFooterTable() != null) {
            arrayList.add(this.getRowFooterTable());
        }
        JTable[] jTableArray2 = arrayList.toArray(new JTable[arrayList.size()]);
        for (JTable jTable : jTableArray) {
            if (jTable instanceof JideTable) {
                ((JideTable)jTable).setNonContiguousCellSelection(this.isNonContiguousCellSelectionAllowed());
            }
            jTable.setColumnSelectionAllowed(this.getColumnSelectionAllowed());
            jTable.setRowSelectionAllowed(this.getRowSelectionAllowed());
        }
        if (this.isNonContiguousCellSelectionAllowed()) {
            TableUtils.unifyTableNonContiguousCellSelection(jTableArray);
            TableUtils.ununifyTableColumnSelection(jTableArray2);
            TableUtils.unsynchronizeTableRowSelection(jTableArray2);
        } else {
            TableUtils.ununifyTableNonContiguousCellSelection(jTableArray);
            TableUtils.unifyTableColumnSelection(jTableArray2);
            if (this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed()) {
                TableUtils.synchronizeTableRowSelection(jTableArray2);
                TableUtils.ununifyTableRowSelection(jTableArray);
            } else if (!this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed()) {
                TableUtils.unsynchronizeTableRowSelection(jTableArray2);
                TableUtils.unifyTableRowSelection(jTableArray);
            } else {
                TableUtils.unsynchronizeTableRowSelection(jTableArray2);
            }
        }
    }

    @Override
    public int getRowCount() {
        int n2 = 0;
        if (this.getColumnHeaderTable() != null) {
            n2 += this.getColumnHeaderTable().getRowCount();
        }
        if (this.getMainTable() != null) {
            n2 += this.getMainTable().getRowCount();
        }
        if (this.getColumnFooterTable() != null) {
            n2 += this.getColumnFooterTable().getRowCount();
        }
        return n2;
    }

    int \u0112(int n2) {
        if (this.getColumnHeaderTable() != null) {
            if (n2 < this.getColumnHeaderTable().getRowCount()) {
                return this.getColumnHeaderTable().getRowHeight(n2);
            }
            n2 -= this.getColumnHeaderTable().getRowCount();
        }
        if (this.getMainTable() != null) {
            if (n2 < this.getMainTable().getRowCount()) {
                return this.getMainTable().getRowHeight(n2);
            }
            n2 -= this.getMainTable().getRowCount();
        }
        if (this.getColumnFooterTable() != null) {
            if (n2 < this.getColumnFooterTable().getRowCount()) {
                return this.getColumnFooterTable().getRowHeight(n2);
            }
            n2 -= this.getColumnFooterTable().getRowCount();
        }
        return this.getMainTable().getRowHeight();
    }

    int \u0111(int n2) {
        if (this.getRowHeaderTable() != null) {
            if (n2 < this.getRowHeaderTable().getColumnCount()) {
                return this.getRowHeaderTable().getColumnModel().getColumn(n2).getWidth();
            }
            n2 -= this.getRowHeaderTable().getColumnCount();
        }
        if (this.getMainTable() != null) {
            if (n2 < this.getMainTable().getColumnCount()) {
                return this.getMainTable().getColumnModel().getColumn(n2).getWidth();
            }
            n2 -= this.getMainTable().getColumnCount();
        }
        if (this.getColumnFooterTable() != null) {
            if (n2 < this.getColumnFooterTable().getColumnCount()) {
                return this.getColumnFooterTable().getColumnModel().getColumn(n2).getWidth();
            }
            n2 -= this.getColumnFooterTable().getColumnCount();
        }
        return -1;
    }

    @Override
    public int getColumnCount() {
        int n2 = 0;
        if (this.getRowHeaderTable() != null) {
            n2 += this.getRowHeaderTable().getColumnCount();
        }
        if (this.getMainTable() != null) {
            n2 += this.getMainTable().getColumnCount();
        }
        if (this.getRowFooterTable() != null) {
            n2 += this.getRowFooterTable().getColumnCount();
        }
        return n2;
    }

    public boolean isAllowMultiSelectionInDifferentTable() {
        return this.\u0693;
    }

    public void setAllowMultiSelectionInDifferentTable(boolean bl) {
        if (this.\u0693 != bl) {
            this.\u0693 = bl;
            if (this.isAllowMultiSelectionInDifferentTable()) {
                this.\u0183();
            } else {
                this.\u0186();
            }
        }
    }

    private void \u0183() {
        if (this.\u0694 != null) {
            if (this._mainTable != null) {
                this.\u0694.remove(this._mainTable.getSelectionModel());
            }
            if (this._columnHeaderTable != null) {
                this.\u0694.remove(this._columnHeaderTable.getSelectionModel());
            }
            if (this._columnFooterTable != null) {
                this.\u0694.remove(this._columnFooterTable.getSelectionModel());
            }
            this.\u0694 = null;
        }
        if (this.\u0695 != null) {
            if (this._rowHeaderTable != null) {
                this.\u0695.remove(this._rowHeaderTable.getSelectionModel());
            }
            if (this._rowHeaderColumnFooterTable != null) {
                this.\u0695.remove(this._rowHeaderColumnFooterTable.getSelectionModel());
            }
            if (this._rowHeaderColumnHeaderTable != null) {
                this.\u0695.remove(this._rowHeaderColumnHeaderTable.getSelectionModel());
            }
            this.\u0695 = null;
        }
        if (this.\u068f != null) {
            if (this._rowFooterTable != null) {
                this.\u068f.remove(this._rowFooterTable.getSelectionModel());
            }
            if (this._rowFooterColumnFooterTable != null) {
                this.\u068f.remove(this._rowFooterColumnFooterTable.getSelectionModel());
            }
            if (this._rowFooterColumnHeaderTable != null) {
                this.\u068f.remove(this._rowFooterColumnHeaderTable.getSelectionModel());
            }
            this.\u068f = null;
        }
    }

    private void \u0186() {
        int n2 = 0;
        if (this._mainTable != null) {
            ++n2;
        }
        if (this._columnFooterTable != null) {
            ++n2;
        }
        if (this._columnHeaderTable != null) {
            ++n2;
        }
        if (n2 >= 2 && this.\u0694 == null) {
            this.\u0694 = new ListSelectionModelGroup();
            if (this._mainTable != null) {
                this.\u0694.add(this._mainTable.getSelectionModel());
            }
            if (this._columnFooterTable != null) {
                this.\u0694.add(this._columnFooterTable.getSelectionModel());
            }
            if (this._columnHeaderTable != null) {
                this.\u0694.add(this._columnHeaderTable.getSelectionModel());
            }
        }
        n2 = 0;
        if (this._rowHeaderTable != null) {
            ++n2;
        }
        if (this._rowHeaderColumnFooterTable != null) {
            ++n2;
        }
        if (this._rowHeaderColumnHeaderTable != null) {
            ++n2;
        }
        if (n2 >= 2 && this.\u0695 == null) {
            this.\u0695 = new ListSelectionModelGroup();
            if (this._rowHeaderTable != null) {
                this.\u0695.add(this._rowHeaderTable.getSelectionModel());
            }
            if (this._rowHeaderColumnFooterTable != null) {
                this.\u0695.add(this._rowHeaderColumnFooterTable.getSelectionModel());
            }
            if (this._rowHeaderColumnHeaderTable != null) {
                this.\u0695.add(this._rowHeaderColumnHeaderTable.getSelectionModel());
            }
        }
        n2 = 0;
        if (this._rowFooterTable != null) {
            ++n2;
        }
        if (this._rowFooterColumnFooterTable != null) {
            ++n2;
        }
        if (this._rowFooterColumnHeaderTable != null) {
            ++n2;
        }
        if (n2 >= 2 && this.\u068f == null) {
            this.\u068f = new ListSelectionModelGroup();
            if (this._rowFooterTable != null) {
                this.\u068f.add(this._rowFooterTable.getSelectionModel());
            }
            if (this._rowFooterColumnFooterTable != null) {
                this.\u068f.add(this._rowFooterColumnFooterTable.getSelectionModel());
            }
            if (this._rowFooterColumnHeaderTable != null) {
                this.\u068f.add(this._rowFooterColumnHeaderTable.getSelectionModel());
            }
        }
    }

    public TablePosition getTableAtColumn(int n2) {
        if (this.getRowHeaderTable() != null) {
            if (n2 < this.getRowHeaderTable().getColumnCount()) {
                return new TablePosition(this.getRowHeaderTable(), -1, n2);
            }
            n2 -= this.getRowHeaderTable().getColumnCount();
        }
        if (this.getMainTable() != null) {
            if (n2 < this.getMainTable().getColumnCount()) {
                return new TablePosition(this.getMainTable(), -1, n2);
            }
            n2 -= this.getMainTable().getColumnCount();
        }
        if (this.getRowFooterTable() != null && n2 < this.getRowFooterTable().getColumnCount()) {
            return new TablePosition(this.getRowFooterTable(), -1, n2);
        }
        return null;
    }

    public TablePosition getTableAtRow(int n2) {
        if (this.getColumnHeaderTable() != null) {
            if (n2 < this.getColumnHeaderTable().getRowCount()) {
                return new TablePosition(this.getColumnHeaderTable(), n2, -1);
            }
            n2 -= this.getColumnHeaderTable().getRowCount();
        }
        if (this.getMainTable() != null) {
            if (n2 < this.getMainTable().getRowCount()) {
                return new TablePosition(this.getMainTable(), n2, -1);
            }
            n2 -= this.getMainTable().getRowCount();
        }
        if (this.getColumnFooterTable() != null && n2 < this.getColumnFooterTable().getRowCount()) {
            return new TablePosition(this.getColumnFooterTable(), n2, -1);
        }
        return null;
    }

    public TablePosition getTableAtCell(int n2, int n3) {
        TablePosition tablePosition = this.getTableAtColumn(n3);
        TablePosition tablePosition2 = this.getTableAtRow(n2);
        if (tablePosition.\u0102 == tablePosition2.\u0102) {
            return new TablePosition(tablePosition.\u0102, tablePosition2.\u0103, tablePosition.\u0101);
        }
        if (tablePosition.\u0102 == this.getMainTable() && tablePosition2.\u0102 == this.getColumnFooterTable()) {
            return new TablePosition(this.getColumnFooterTable(), tablePosition2.\u0103, tablePosition.\u0101);
        }
        if (tablePosition.\u0102 == this.getMainTable() && tablePosition2.\u0102 == this.getColumnHeaderTable()) {
            return new TablePosition(this.getColumnHeaderTable(), tablePosition2.\u0103, tablePosition.\u0101);
        }
        if (tablePosition.\u0102 == this.getRowHeaderTable() && tablePosition2.\u0102 == this.getMainTable()) {
            return new TablePosition(this.getRowHeaderTable(), tablePosition2.\u0103, tablePosition.\u0101);
        }
        if (tablePosition.\u0102 == this.getRowHeaderTable() && tablePosition2.\u0102 == this.getColumnFooterTable() && this.getRowHeaderColumnFooterTable() != null) {
            return new TablePosition(this.getRowHeaderColumnFooterTable(), tablePosition2.\u0103, tablePosition.\u0101);
        }
        if (tablePosition.\u0102 == this.getRowHeaderTable() && tablePosition2.\u0102 == this.getColumnHeaderTable() && this.getRowHeaderColumnHeaderTable() != null) {
            return new TablePosition(this.getRowHeaderColumnHeaderTable(), tablePosition2.\u0103, tablePosition.\u0101);
        }
        if (tablePosition.\u0102 == this.getRowFooterTable() && tablePosition2.\u0102 == this.getMainTable()) {
            return new TablePosition(this.getRowFooterTable(), tablePosition2.\u0103, tablePosition.\u0101);
        }
        if (tablePosition.\u0102 == this.getRowFooterTable() && tablePosition2.\u0102 == this.getColumnFooterTable() && this.getRowFooterColumnFooterTable() != null) {
            return new TablePosition(this.getRowFooterColumnFooterTable(), tablePosition2.\u0103, tablePosition.\u0101);
        }
        if (tablePosition.\u0102 == this.getRowFooterTable() && tablePosition2.\u0102 == this.getColumnHeaderTable() && this.getRowFooterColumnHeaderTable() != null) {
            return new TablePosition(this.getRowFooterColumnHeaderTable(), tablePosition2.\u0103, tablePosition.\u0101);
        }
        return null;
    }

    @Override
    public String getColumnName(int n2) {
        TablePosition tablePosition = this.getTableAtColumn(n2);
        return tablePosition != null ? tablePosition.\u0102.getColumnName(tablePosition.\u0101) : "";
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        TablePosition tablePosition = this.getTableAtColumn(n2);
        return tablePosition != null ? tablePosition.\u0102.getColumnClass(tablePosition.\u0101) : null;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        TablePosition tablePosition = this.getTableAtCell(n2, n3);
        return tablePosition != null ? tablePosition.\u0102.getValueAt(tablePosition.\u0103, tablePosition.\u0101) : null;
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        TablePosition tablePosition = this.getTableAtCell(n2, n3);
        if (tablePosition != null) {
            tablePosition.\u0102.setValueAt(object, tablePosition.\u0103, tablePosition.\u0101);
        }
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        TablePosition tablePosition = this.getTableAtCell(n2, n3);
        return tablePosition != null ? Boolean.valueOf(tablePosition.\u0102.isCellEditable(tablePosition.\u0103, tablePosition.\u0101)) : null;
    }

    @Override
    public int getSelectedRow() {
        int n2;
        int n3 = 0;
        if (this.getColumnHeaderTable() != null && (n2 = this.getColumnHeaderTable().getSelectedRow()) != -1) {
            return n2;
        }
        if (this.getRowHeaderColumnHeaderTable() != null && (n2 = this.getRowHeaderColumnHeaderTable().getSelectedRow()) != -1) {
            return n2;
        }
        if (this.getRowFooterColumnHeaderTable() != null && (n2 = this.getRowFooterColumnHeaderTable().getSelectedRow()) != -1) {
            return n2;
        }
        if (this.getColumnHeaderTable() != null) {
            n3 += this.getColumnHeaderTable().getRowCount();
        } else if (this.getRowHeaderColumnHeaderTable() != null) {
            n3 += this.getRowHeaderColumnHeaderTable().getRowCount();
        } else if (this.getRowFooterColumnHeaderTable() != null) {
            n3 += this.getRowFooterColumnHeaderTable().getRowCount();
        }
        if (this.getMainTable() != null && (n2 = this.getMainTable().getSelectedRow()) != -1) {
            return n2 + n3;
        }
        if (this.getRowHeaderTable() != null && (n2 = this.getRowHeaderTable().getSelectedRow()) != -1) {
            return n2 + n3;
        }
        if (this.getRowFooterTable() != null && (n2 = this.getRowFooterTable().getSelectedRow()) != -1) {
            return n2 + n3;
        }
        if (this.getMainTable() != null) {
            n3 += this.getMainTable().getRowCount();
        } else if (this.getRowHeaderTable() != null) {
            n3 += this.getRowHeaderTable().getRowCount();
        } else if (this.getRowFooterTable() != null) {
            n3 += this.getRowFooterTable().getRowCount();
        }
        if (this.getColumnFooterTable() != null && (n2 = this.getColumnFooterTable().getSelectedRow()) != -1) {
            return n2 + n3;
        }
        if (this.getRowHeaderColumnFooterTable() != null && (n2 = this.getRowHeaderColumnFooterTable().getSelectedRow()) != -1) {
            return n2 + n3;
        }
        if (this.getRowFooterColumnFooterTable() != null && (n2 = this.getRowFooterColumnFooterTable().getSelectedRow()) != -1) {
            return n2 + n3;
        }
        return -1;
    }

    @Override
    public int getSelectedColumn() {
        int n2;
        int n3 = 0;
        if (this.getRowHeaderTable() != null && (n2 = this.getRowHeaderTable().getSelectedColumn()) != -1) {
            return n2;
        }
        if (this.getRowHeaderColumnHeaderTable() != null && (n2 = this.getRowHeaderColumnHeaderTable().getSelectedColumn()) != -1) {
            return n2;
        }
        if (this.getRowHeaderColumnFooterTable() != null && (n2 = this.getRowHeaderColumnFooterTable().getSelectedColumn()) != -1) {
            return n2;
        }
        if (this.getRowHeaderTable() != null) {
            n3 += this.getRowHeaderTable().getColumnCount();
        } else if (this.getRowHeaderColumnHeaderTable() != null) {
            n3 += this.getRowHeaderColumnHeaderTable().getColumnCount();
        } else if (this.getRowHeaderColumnFooterTable() != null) {
            n3 += this.getRowHeaderColumnFooterTable().getColumnCount();
        }
        if (this.getMainTable() != null && (n2 = this.getMainTable().getSelectedColumn()) != -1) {
            return n3 + n2;
        }
        if (this.getColumnFooterTable() != null && (n2 = this.getColumnFooterTable().getSelectedColumn()) != -1) {
            return n3 + n2;
        }
        if (this.getColumnHeaderTable() != null && (n2 = this.getColumnHeaderTable().getSelectedColumn()) != -1) {
            return n3 + n2;
        }
        if (this.getMainTable() != null) {
            n3 += this.getMainTable().getColumnCount();
        } else if (this.getColumnFooterTable() != null) {
            n3 += this.getColumnFooterTable().getColumnCount();
        } else if (this.getColumnHeaderTable() != null) {
            n3 += this.getColumnHeaderTable().getColumnCount();
        }
        if (this.getRowFooterTable() != null && (n2 = this.getRowFooterTable().getSelectedColumn()) != -1) {
            return n3 + n2;
        }
        if (this.getRowFooterColumnFooterTable() != null && (n2 = this.getRowFooterColumnFooterTable().getSelectedColumn()) != -1) {
            return n3 + n2;
        }
        if (this.getRowFooterColumnHeaderTable() != null && (n2 = this.getRowFooterColumnHeaderTable().getSelectedColumn()) != -1) {
            return n3 + n2;
        }
        return -1;
    }

    @Override
    public int[] getSelectedRows() {
        int n2;
        int n3;
        int n4 = 0;
        int[] nArray = new int[]{};
        int[] nArray2 = new int[]{};
        int[] nArray3 = new int[]{};
        if (this.getColumnHeaderTable() != null) {
            nArray = this.getColumnHeaderTable().getSelectedRows();
            n4 += this.getColumnHeaderTable().getRowCount();
        }
        if (this.getRowHeaderColumnHeaderTable() != null) {
            nArray2 = this.getRowHeaderColumnHeaderTable().getSelectedRows();
            if (this.getColumnHeaderTable() == null) {
                n4 += this.getRowHeaderColumnHeaderTable().getRowCount();
            }
        }
        if (this.getRowFooterColumnHeaderTable() != null) {
            nArray3 = this.getRowFooterColumnHeaderTable().getSelectedRows();
            if (this.getColumnHeaderTable() == null && this.getRowHeaderColumnHeaderTable() == null) {
                n4 += this.getRowFooterColumnHeaderTable().getRowCount();
            }
        }
        int[] nArray4 = TableScrollPane.\u0104(nArray, nArray2, nArray3);
        if (this.getMainTable() != null) {
            nArray = this.getMainTable().getSelectedRows();
            n3 = 0;
            while (n3 < nArray.length) {
                int n5 = n3++;
                nArray[n5] = nArray[n5] + n4;
            }
        }
        if (this.getRowHeaderTable() != null) {
            nArray2 = this.getRowHeaderTable().getSelectedRows();
            n3 = 0;
            while (n3 < nArray2.length) {
                int n6 = n3++;
                nArray2[n6] = nArray2[n6] + n4;
            }
        }
        if (this.getRowFooterTable() != null) {
            nArray3 = this.getRowFooterTable().getSelectedRows();
            n3 = 0;
            while (n3 < nArray3.length) {
                int n7 = n3++;
                nArray3[n7] = nArray3[n7] + n4;
            }
        }
        if (this.getMainTable() != null) {
            n4 += this.getMainTable().getRowCount();
        }
        if (this.getRowHeaderTable() != null && this.getMainTable() == null) {
            n4 += this.getRowHeaderTable().getRowCount();
        }
        if (this.getRowFooterTable() != null && this.getMainTable() == null && this.getRowHeaderTable() == null) {
            n4 += this.getRowFooterTable().getRowCount();
        }
        int[] nArray5 = TableScrollPane.\u0104(nArray, nArray2, nArray3);
        nArray = new int[]{};
        nArray2 = new int[]{};
        nArray3 = new int[]{};
        if (this.getColumnFooterTable() != null) {
            nArray = this.getColumnFooterTable().getSelectedRows();
            n2 = 0;
            while (n2 < nArray.length) {
                int n8 = n2++;
                nArray[n8] = nArray[n8] + n4;
            }
        }
        if (this.getRowHeaderColumnFooterTable() != null) {
            nArray2 = this.getRowHeaderColumnFooterTable().getSelectedRows();
            n2 = 0;
            while (n2 < nArray2.length) {
                int n9 = n2++;
                nArray2[n9] = nArray2[n9] + n4;
            }
        }
        if (this.getRowFooterColumnFooterTable() != null) {
            nArray3 = this.getRowFooterColumnFooterTable().getSelectedRows();
            n2 = 0;
            while (n2 < nArray3.length) {
                int n10 = n2++;
                nArray3[n10] = nArray3[n10] + n4;
            }
        }
        int[] nArray6 = TableScrollPane.\u0104(nArray, nArray2, nArray3);
        return TableScrollPane.\u0103(nArray4, nArray5, nArray6);
    }

    @Override
    public int convertColumnIndexToView(int n2) {
        if (n2 < 0 || n2 >= this.getModel().getColumnCount()) {
            return -1;
        }
        int n3 = this.getModel().getColumnType(n2);
        int n4 = 0;
        if (this.getRowHeaderTable() != null) {
            if (n3 == 1) {
                return this.getRowHeaderTable().convertColumnIndexToView(n2);
            }
            n4 += this.getRowHeaderTable().getColumnCount();
        }
        if (this.getMainTable() != null) {
            if (n3 == 0) {
                return n4 + this.getMainTable().convertColumnIndexToView(n2);
            }
            n4 += this.getMainTable().getColumnCount();
        }
        if (this.getRowFooterTable() != null && n3 == 2) {
            return n4 + this.getRowFooterTable().convertColumnIndexToView(n2);
        }
        return -1;
    }

    @Override
    public int convertColumnIndexToModel(int n2) {
        int n3;
        if (n2 < 0 || n2 >= this.getColumnCount()) {
            return -1;
        }
        if (this.getRowHeaderTable() != null) {
            n3 = this.getRowHeaderTable().getColumnCount();
            if (n2 < n3) {
                return this.getRowHeaderTable().convertColumnIndexToModel(n2);
            }
            n2 -= n3;
        }
        if (this.getMainTable() != null) {
            n3 = this.getMainTable().getColumnCount();
            if (n2 < n3) {
                return this.getMainTable().convertColumnIndexToModel(n2);
            }
            n2 -= n3;
        }
        if (this.getRowFooterTable() != null && n2 < (n3 = this.getRowFooterTable().getColumnCount())) {
            return this.getRowFooterTable().convertColumnIndexToModel(n2);
        }
        return -1;
    }

    static int[] \u0103(int[] ... nArray) {
        int n2 = 0;
        for (int[] nArray2 : nArray) {
            n2 += nArray2.length;
        }
        int[] nArray3 = new int[n2];
        int n3 = 0;
        for (int[] nArray4 : nArray) {
            System.arraycopy(nArray4, 0, nArray3, n3, nArray4.length);
            n3 += nArray4.length;
        }
        return nArray3;
    }

    static int[] \u0104(int[] ... nArray) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int[][] object = nArray;
        int n2 = object.length;
        for (int iterator = 0; iterator < n2; ++iterator) {
            int[] nArray2;
            for (int n3 : nArray2 = object[iterator]) {
                treeSet.add(n3);
            }
        }
        int[] nArray3 = new int[treeSet.size()];
        n2 = 0;
        for (Integer n4 : treeSet) {
            nArray3[n2] = n4;
            ++n2;
        }
        return nArray3;
    }

    @Override
    public int[] getSelectedColumns() {
        int n2;
        int n3 = 0;
        int[] nArray = new int[]{};
        int[] nArray2 = new int[]{};
        int[] nArray3 = new int[]{};
        if (this.getRowHeaderTable() != null) {
            nArray = this.getRowHeaderTable().getSelectedColumns();
            n3 += this.getRowHeaderTable().getColumnCount();
        }
        if (this.getMainTable() != null) {
            nArray2 = this.getMainTable().getSelectedColumns();
            n2 = 0;
            while (n2 < nArray2.length) {
                int n4 = n2++;
                nArray2[n4] = nArray2[n4] + n3;
            }
            n3 += this.getMainTable().getColumnCount();
        }
        if (this.getRowFooterTable() != null) {
            nArray3 = this.getRowFooterTable().getSelectedColumns();
            n2 = 0;
            while (n2 < nArray3.length) {
                int n5 = n2++;
                nArray3[n5] = nArray3[n5] + n3;
            }
        }
        int[] nArray4 = new int[nArray.length + nArray2.length + nArray3.length];
        System.arraycopy(nArray, 0, nArray4, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray4, nArray.length, nArray2.length);
        System.arraycopy(nArray3, 0, nArray4, nArray.length + nArray2.length, nArray3.length);
        return nArray4;
    }

    @Override
    public int getSelectedRowCount() {
        return this.getSelectedRows().length;
    }

    @Override
    public int getSelectedColumnCount() {
        return this.getSelectedColumns().length;
    }

    @Override
    public boolean isRowSelected(int n2) {
        if (this.getMainTable() != null) {
            if (n2 < this.getMainTable().getRowCount()) {
                return this.getMainTable().isRowSelected(n2) || this.getRowHeaderTable() != null && this.getRowHeaderTable().isRowSelected(n2) || this.getRowFooterTable() != null && this.getRowFooterTable().isRowSelected(n2);
            }
            n2 -= this.getMainTable().getRowCount();
        }
        if (this.getColumnFooterTable() != null && n2 < this.getColumnFooterTable().getRowCount()) {
            return this.getColumnFooterTable().isRowSelected(n2) || this.getRowHeaderColumnFooterTable() != null && this.getRowHeaderColumnFooterTable().isRowSelected(n2) || this.getRowFooterColumnFooterTable() != null && this.getRowFooterColumnFooterTable().isRowSelected(n2);
        }
        return false;
    }

    @Override
    public boolean isColumnSelected(int n2) {
        TablePosition tablePosition = this.getTableAtColumn(n2);
        return tablePosition != null && tablePosition.\u0102.isColumnSelected(tablePosition.\u0101);
    }

    @Override
    public boolean isCellSelected(int n2, int n3) {
        TablePosition tablePosition = this.getTableAtCell(n2, n3);
        return tablePosition != null && tablePosition.\u0102 != null && tablePosition.\u0102.isCellSelected(tablePosition.\u0103, tablePosition.\u0101);
    }

    @Override
    public void clearSelection() {
        if (this.getRowHeaderTable() != null) {
            this.getRowHeaderTable().clearSelection();
        }
        if (this.getMainTable() != null) {
            this.getMainTable().clearSelection();
        }
        if (this.getColumnFooterTable() != null) {
            this.getColumnFooterTable().clearSelection();
        }
        if (this.getRowFooterTable() != null) {
            this.getRowFooterTable().clearSelection();
        }
        if (this.getRowFooterColumnFooterTable() != null) {
            this.getRowFooterColumnFooterTable().clearSelection();
        }
        if (this.getRowHeaderColumnFooterTable() != null) {
            this.getRowHeaderColumnFooterTable().clearSelection();
        }
    }

    @Override
    public void changeSelection(int n2, int n3, boolean bl, boolean bl2) {
        TablePosition tablePosition = this.getTableAtCell(n2, n3);
        if (this.isAncestorOf(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner())) {
            tablePosition.\u0102.requestFocus();
        }
        tablePosition.\u0102.changeSelection(tablePosition.\u0103, tablePosition.\u0101, bl, bl2);
    }

    public boolean print() throws PrinterException {
        return this.print(JTable.PrintMode.FIT_WIDTH);
    }

    public boolean print(JTable.PrintMode printMode) throws PrinterException {
        return this.print(printMode, null, null);
    }

    public boolean print(JTable.PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2) throws PrinterException {
        boolean bl = !GraphicsEnvironment.isHeadless();
        return this.print(printMode, messageFormat, messageFormat2, bl, null, bl);
    }

    public boolean print(JTable.PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2, boolean bl, PrintRequestAttributeSet printRequestAttributeSet, boolean bl2) throws PrinterException, HeadlessException {
        return this.print(printMode, messageFormat, messageFormat2, bl, printRequestAttributeSet, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean print(JTable.PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2, boolean bl, PrintRequestAttributeSet printRequestAttributeSet, boolean bl2, PrintService printService) throws PrinterException, HeadlessException {
        Throwable throwable;
        PrintingStatus printingStatus;
        boolean bl3 = GraphicsEnvironment.isHeadless();
        if (bl3) {
            if (bl) {
                throw new HeadlessException("Can't show print dialog.");
            }
            if (bl2) {
                throw new HeadlessException("Can't run interactively.");
            }
        }
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.isEditing() && !this.getCellEditor().stopCellEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
        }
        Printable printable = this.getPrintable(printMode, messageFormat, messageFormat2);
        if (bl2) {
            printable = new A(printable);
            printingStatus = PrintingStatus.createPrintingStatus(this, printerJob);
            printable = printingStatus.createNotificationPrintable(printable);
        } else {
            printingStatus = null;
        }
        printerJob.setPrintable(printable);
        if (printService != null) {
            printerJob.setPrintService(printService);
        }
        if (bl && !printerJob.printDialog(printRequestAttributeSet)) {
            return false;
        }
        if (!bl2) {
            printerJob.print(printRequestAttributeSet);
            return true;
        }
        this.\u0691 = null;
        final Object object = new Object();
        final PrintRequestAttributeSet printRequestAttributeSet2 = printRequestAttributeSet;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    printerJob.print(printRequestAttributeSet2);
                }
                catch (Throwable throwable) {
                    Object object2 = object;
                    synchronized (object2) {
                        TableScrollPane.this.\u0691 = throwable;
                    }
                }
                finally {
                    printingStatus.dispose();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        printingStatus.showModal(true);
        Object object2 = object;
        synchronized (object2) {
            throwable = this.\u0691;
            this.\u0691 = null;
        }
        if (throwable != null) {
            if (throwable instanceof PrinterAbortException) {
                return false;
            }
            if (throwable instanceof PrinterException) {
                throw (PrinterException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new AssertionError((Object)throwable);
        }
        return true;
    }

    public Printable getPrintable(JTable.PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2) {
        return new TableScrollPanePrintable(this, printMode, messageFormat, messageFormat2);
    }

    int \u017c() {
        int n2 = 0;
        JTableHeader jTableHeader = this.\u0189();
        if (jTableHeader != null) {
            n2 = Math.max(n2, jTableHeader.getHeight());
        }
        if ((jTableHeader = this.\u0185()) != null) {
            n2 = Math.max(n2, jTableHeader.getHeight());
        }
        if ((jTableHeader = this.\u017f()) != null) {
            n2 = Math.max(n2, jTableHeader.getHeight());
        }
        return n2;
    }

    JTableHeader \u0189() {
        JTable jTable = this.getRowHeaderTable();
        if (!(jTable != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible() || (jTable = this.getRowHeaderColumnHeaderTable()) != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible())) {
            jTable = this.getRowHeaderColumnFooterTable();
        }
        if (jTable != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible()) {
            return jTable.getTableHeader();
        }
        return null;
    }

    JTableHeader \u0185() {
        JTable jTable = this.getMainTable();
        if (!(jTable != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible() || (jTable = this.getColumnHeaderTable()) != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible())) {
            jTable = this.getColumnFooterTable();
        }
        if (jTable != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible()) {
            return jTable.getTableHeader();
        }
        return null;
    }

    JTableHeader \u017f() {
        JTable jTable = this.getRowFooterTable();
        if (!(jTable != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible() || (jTable = this.getRowFooterColumnHeaderTable()) != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible())) {
            jTable = this.getRowFooterColumnFooterTable();
        }
        if (jTable != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible()) {
            return jTable.getTableHeader();
        }
        return null;
    }

    int \u018a() {
        int n2 = 0;
        n2 += this.\u0184();
        n2 += this.\u018b();
        return n2 += this.\u0187();
    }

    int \u0184() {
        int n2 = 0;
        JTable jTable = this.getRowHeaderTable();
        if (jTable == null && (jTable = this.getRowHeaderColumnHeaderTable()) == null) {
            jTable = this.getRowHeaderColumnFooterTable();
        }
        if (jTable != null) {
            n2 = jTable.getColumnModel().getTotalColumnWidth();
        }
        return n2;
    }

    int \u018b() {
        int n2 = 0;
        JTable jTable = this.getMainTable();
        if (jTable == null && (jTable = this.getColumnHeaderTable()) == null) {
            jTable = this.getColumnFooterTable();
        }
        if (jTable != null) {
            n2 = jTable.getColumnModel().getTotalColumnWidth();
        }
        return n2;
    }

    int \u0187() {
        int n2 = 0;
        JTable jTable = this.getRowFooterTable();
        if (jTable == null && (jTable = this.getRowFooterColumnHeaderTable()) == null) {
            jTable = this.getRowFooterColumnFooterTable();
        }
        if (jTable != null) {
            n2 = jTable.getColumnModel().getTotalColumnWidth();
        }
        return n2;
    }

    int \u0181() {
        int n2 = 0;
        JTable jTable = this.getColumnHeaderTable();
        if (jTable == null && (jTable = this.getRowHeaderColumnHeaderTable()) == null) {
            jTable = this.getRowFooterColumnHeaderTable();
        }
        if (jTable != null) {
            n2 = jTable.getHeight();
        }
        return n2;
    }

    int \u017e() {
        int n2 = 0;
        JTable jTable = this.getMainTable();
        if (jTable == null && (jTable = this.getRowHeaderTable()) == null) {
            jTable = this.getRowFooterTable();
        }
        if (jTable != null) {
            n2 = jTable.getHeight();
        }
        return n2;
    }

    int \u0182() {
        int n2 = 0;
        JTable jTable = this.getColumnFooterTable();
        if (jTable == null && (jTable = this.getRowHeaderColumnFooterTable()) == null) {
            jTable = this.getRowFooterColumnFooterTable();
        }
        if (jTable != null) {
            n2 = jTable.getHeight();
        }
        return n2;
    }

    boolean \u018d() {
        return this.\u068a;
    }

    void \u0109(boolean bl) {
        this.\u068a = bl;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(TableScrollPane.class.getName(), 4);
        }
        \u068b = Logger.getLogger(TableScrollPane.class.getName());
    }

    private class A
    implements Printable {
        private Printable \u0102;
        private int \u0104;
        private Throwable \u0103;

        public A(Printable printable) {
            this.\u0102 = printable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int print(final Graphics graphics, final PageFormat pageFormat, final int n2) throws PrinterException {
            Runnable runnable;
            Runnable runnable2 = runnable = new Runnable(){

                @Override
                public synchronized void run() {
                    try {
                        A.this.\u0104 = A.this.\u0102.print(graphics, pageFormat, n2);
                    }
                    catch (Throwable throwable) {
                        A.this.\u0103 = throwable;
                    }
                    finally {
                        this.notifyAll();
                    }
                }
            };
            synchronized (runnable2) {
                this.\u0104 = -1;
                this.\u0103 = null;
                SwingUtilities.invokeLater(runnable);
                while (this.\u0104 == -1 && this.\u0103 == null) {
                    try {
                        runnable.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.\u0103 != null) {
                    if (this.\u0103 instanceof PrinterException) {
                        throw (PrinterException)this.\u0103;
                    }
                    if (this.\u0103 instanceof RuntimeException) {
                        throw (RuntimeException)this.\u0103;
                    }
                    if (this.\u0103 instanceof Error) {
                        throw (Error)this.\u0103;
                    }
                    throw new AssertionError((Object)this.\u0103);
                }
                return this.\u0104;
            }
        }
    }

    public static class TablePosition {
        JTable \u0102;
        int \u0103 = -1;
        int \u0101 = 1;

        public TablePosition(JTable jTable, int n2, int n3) {
            this.\u0102 = jTable;
            this.\u0103 = n2;
            this.\u0101 = n3;
        }

        public JTable getTable() {
            return this.\u0102;
        }

        public int getRow() {
            return this.\u0103;
        }

        public int getColumn() {
            return this.\u0101;
        }
    }
}

